/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.directaccess.client;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.cloudbilling.Cloudbilling;
import com.google.api.services.cloudbilling.model.ProjectBillingInfo;
import com.google.api.services.cloudresourcemanager.v3.CloudResourceManager;
import com.google.api.services.monitoring.v3.Monitoring;
import com.google.api.services.monitoring.v3.model.PointData;
import com.google.api.services.monitoring.v3.model.QueryTimeSeriesRequest;
import com.google.api.services.monitoring.v3.model.QueryTimeSeriesResponse;
import com.google.api.services.monitoring.v3.model.TimeSeriesData;
import com.google.api.services.monitoring.v3.model.TypedValue;
import com.google.api.services.serviceusage.v1.ServiceUsage;
import com.google.api.services.serviceusage.v1.model.EnableServiceRequest;
import com.google.api.services.serviceusage.v1.model.GoogleApiServiceusageV1Service;
import com.google.api.services.testing.Testing;
import com.google.api.services.testing.model.AndroidDeviceCatalog;
import com.google.api.services.testing.model.AndroidModel;
import com.google.api.services.testing.model.PerAndroidVersionInfo;
import com.google.api.services.testing.model.TestEnvironmentCatalog;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B7\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010*\u001a\u00020\b2\b\u0010,\u001a\u0004\u0018\u00010\u001bH\u0002J\u0018\u0010-\u001a\u00020.2\u0006\u0010,\u001a\u00020\u001b2\b\u0010/\u001a\u0004\u0018\u00010\u001bJ \u00100\u001a\u0002012\u0006\u0010,\u001a\u00020\u001b2\u0006\u00102\u001a\u00020\u001b2\u0006\u00103\u001a\u00020\u001bH\u0002J\u0012\u00104\u001a\u00020\n2\b\u0010,\u001a\u0004\u0018\u00010\u001bH\u0002J\u000e\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u001bJ,\u00108\u001a\u0010\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020:\u0018\u0001092\u0006\u0010,\u001a\u00020\u001b2\u0006\u0010;\u001a\u00020\u001b2\u0006\u00102\u001a\u00020\u001bJ\u0010\u0010=\u001a\u00020\u001b2\u0006\u0010>\u001a\u00020\u001bH\u0002J\u0010\u0010?\u001a\u00020:2\u0006\u0010@\u001a\u000201H\u0002J\u0010\u0010A\u001a\u00020:2\u0006\u0010B\u001a\u00020CH\u0007J*\u0010D\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020G090E2\u0006\u0010,\u001a\u00020\u001b2\b\u00107\u001a\u0004\u0018\u00010\u001bJ\u0016\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\u001b2\u0006\u0010K\u001a\u00020\u001bJ\u0016\u0010L\u001a\u0002062\u0006\u0010J\u001a\u00020\u001b2\u0006\u0010K\u001a\u00020\u001bJ\b\u0010M\u001a\u000206H\u0002R\u0016\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00108\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00128B@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u000e\u0010<\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/google/services/firebase/directaccess/client/CloudClient;", "", "credential", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/google/api/client/auth/oauth2/Credential;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "overrideTest", "Lcom/google/api/services/testing/Testing;", "overrideMonitoring", "Lcom/google/api/services/monitoring/v3/Monitoring;", "<init>", "(Lkotlinx/coroutines/flow/StateFlow;Lkotlinx/coroutines/CoroutineScope;Lcom/google/api/services/testing/Testing;Lcom/google/api/services/monitoring/v3/Monitoring;)V", "myCloudResourceManager", "Lcom/google/api/services/cloudresourcemanager/v3/CloudResourceManager;", "myCloudbilling", "Lcom/google/api/services/cloudbilling/Cloudbilling;", "myHttpTransport", "Lcom/google/api/client/http/HttpTransport;", "getMyHttpTransport", "()Lcom/google/api/client/http/HttpTransport;", "myServiceUsage", "Lcom/google/api/services/serviceusage/v1/ServiceUsage;", "myTest", "myMonitoring", "_errorFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "errorFlow", "Lkotlinx/coroutines/flow/Flow;", "getErrorFlow", "()Lkotlinx/coroutines/flow/Flow;", "serviceUsage", "getServiceUsage", "()Lcom/google/api/services/serviceusage/v1/ServiceUsage;", "cloudResourceManager", "getCloudResourceManager", "()Lcom/google/api/services/cloudresourcemanager/v3/CloudResourceManager;", "cloudbilling", "getCloudbilling", "()Lcom/google/api/services/cloudbilling/Cloudbilling;", "test", "getTest", "()Lcom/google/api/services/testing/Testing;", "endpoint", "getAndroidDeviceCatalogForEnvironment", "Lcom/google/api/services/testing/model/AndroidDeviceCatalog;", "gcpProject", "queryMonitoring", "Lcom/google/api/services/monitoring/v3/model/QueryTimeSeriesResponse;", "project", "queryString", "getMonitoring", "isBillingEnabled", "", "cloudProject", "getQuotaUsageAndLimit", "Lkotlin/Pair;", "", "serviceFilter", "queryFilterWithMonthlyQuotaMetric", "queryFilterWithResourceService", "service", "findNumber", "item", "getTimestampAtMonthStartMidnightInPT", "instant", "Ljava/time/Instant;", "getAvailableDevices", "", "Lcom/google/api/services/testing/model/AndroidModel;", "Lcom/google/api/services/testing/model/PerAndroidVersionInfo;", "enableDeviceStreamingService", "", "projectName", "serviceEndpoint", "isDeviceStreamingServiceEnabled", "isUnfilteredDevices", "directaccess-client"})
@SourceDebugExtension(value={"SMAP\nCloudClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudClient.kt\ncom/google/services/firebase/directaccess/client/CloudClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,334:1\n1#2:335\n1#2:355\n774#3:336\n865#3,2:337\n1374#3:339\n1460#3,2:340\n774#3:342\n865#3,2:343\n1617#3,9:345\n1869#3:354\n1870#3:356\n1626#3:357\n1462#3,3:358\n*S KotlinDebug\n*F\n+ 1 CloudClient.kt\ncom/google/services/firebase/directaccess/client/CloudClient\n*L\n313#1:355\n304#1:336\n304#1:337,2\n305#1:339\n305#1:340,2\n307#1:342\n307#1:343,2\n313#1:345,9\n313#1:354\n313#1:356\n313#1:357\n305#1:358,3\n*E\n"})
public final class CloudClient {
    @NotNull
    private final StateFlow<Credential> credential;
    @Nullable
    private final Testing overrideTest;
    @Nullable
    private final Monitoring overrideMonitoring;
    @Nullable
    private CloudResourceManager myCloudResourceManager;
    @TestOnly
    @Nullable
    private Cloudbilling myCloudbilling;
    @TestOnly
    @Nullable
    private HttpTransport myHttpTransport;
    @Nullable
    private ServiceUsage myServiceUsage;
    @Nullable
    private Testing myTest;
    @Nullable
    private Monitoring myMonitoring;
    @NotNull
    private final MutableStateFlow<String> _errorFlow;
    @NotNull
    private final Flow<String> errorFlow;
    @NotNull
    private final String queryFilterWithMonthlyQuotaMetric;

    /*
     * WARNING - void declaration
     */
    public CloudClient(@NotNull StateFlow<? extends Credential> credential, @NotNull CoroutineScope scope, @Nullable Testing overrideTest, @Nullable Monitoring overrideMonitoring) {
        void prefix;
        Intrinsics.checkNotNullParameter(credential, (String)"credential");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.credential = credential;
        this.overrideTest = overrideTest;
        this.overrideMonitoring = overrideMonitoring;
        this._errorFlow = StateFlowKt.MutableStateFlow(null);
        this.errorFlow = (Flow)this._errorFlow;
        BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ CloudClient this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.credential.collect(new FlowCollector(){

                            public final Object emit(Credential it, Continuation<? super Unit> $completion) {
                                this$0.myServiceUsage = null;
                                this$0.myCloudResourceManager = null;
                                this$0.myCloudbilling = null;
                                this$0.myHttpTransport = null;
                                this$0.myTest = null;
                                this$0.myMonitoring = null;
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        String string = "testing.googleapis.com/device_streaming";
        CloudClient cloudClient = this;
        boolean bl = false;
        cloudClient.queryFilterWithMonthlyQuotaMetric = "\n            filter metric.quota_metric==\"" + (String)prefix + "/monthly_blaze_physical_minutes\"\n                || metric.quota_metric==\"" + (String)prefix + "/monthly_spark_physical_minutes\"\n            ";
    }

    public /* synthetic */ CloudClient(StateFlow stateFlow2, CoroutineScope coroutineScope, Testing testing, Monitoring monitoring, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            testing = null;
        }
        if ((n & 8) != 0) {
            monitoring = null;
        }
        this((StateFlow<? extends Credential>)stateFlow2, coroutineScope, testing, monitoring);
    }

    private final HttpTransport getMyHttpTransport() {
        HttpTransport httpTransport = this.myHttpTransport;
        if (httpTransport == null) {
            NetHttpTransport netHttpTransport;
            NetHttpTransport it = netHttpTransport = new NetHttpTransport();
            boolean bl = false;
            this.myHttpTransport = (HttpTransport)it;
            httpTransport = (HttpTransport)netHttpTransport;
        }
        return httpTransport;
    }

    @NotNull
    public final Flow<String> getErrorFlow() {
        return this.errorFlow;
    }

    @NotNull
    public final ServiceUsage getServiceUsage() {
        ServiceUsage serviceUsage = this.myServiceUsage;
        if (serviceUsage == null) {
            ServiceUsage serviceUsage2;
            ServiceUsage it = serviceUsage2 = new ServiceUsage.Builder(this.getMyHttpTransport(), (JsonFactory)GsonFactory.getDefaultInstance(), (HttpRequestInitializer)this.credential.getValue()).setApplicationName("Android Studio").build();
            boolean bl = false;
            this.myServiceUsage = it;
            ServiceUsage serviceUsage3 = serviceUsage2;
            serviceUsage = serviceUsage3;
            Intrinsics.checkNotNullExpressionValue((Object)serviceUsage3, (String)"also(...)");
        }
        return serviceUsage;
    }

    @NotNull
    public final CloudResourceManager getCloudResourceManager() {
        CloudResourceManager cloudResourceManager = this.myCloudResourceManager;
        if (cloudResourceManager == null) {
            CloudResourceManager cloudResourceManager2;
            CloudResourceManager it = cloudResourceManager2 = new CloudResourceManager.Builder(this.getMyHttpTransport(), (JsonFactory)GsonFactory.getDefaultInstance(), (HttpRequestInitializer)this.credential.getValue()).setApplicationName("Android Studio").build();
            boolean bl = false;
            this.myCloudResourceManager = it;
            CloudResourceManager cloudResourceManager3 = cloudResourceManager2;
            cloudResourceManager = cloudResourceManager3;
            Intrinsics.checkNotNullExpressionValue((Object)cloudResourceManager3, (String)"also(...)");
        }
        return cloudResourceManager;
    }

    @NotNull
    public final Cloudbilling getCloudbilling() {
        Cloudbilling cloudbilling = this.myCloudbilling;
        if (cloudbilling == null) {
            Cloudbilling cloudbilling2;
            Cloudbilling it = cloudbilling2 = new Cloudbilling.Builder(this.getMyHttpTransport(), (JsonFactory)GsonFactory.getDefaultInstance(), (HttpRequestInitializer)this.credential.getValue()).setApplicationName("Android Studio").build();
            boolean bl = false;
            this.myCloudbilling = it;
            Cloudbilling cloudbilling3 = cloudbilling2;
            cloudbilling = cloudbilling3;
            Intrinsics.checkNotNullExpressionValue((Object)cloudbilling3, (String)"also(...)");
        }
        return cloudbilling;
    }

    @NotNull
    public final Testing getTest() {
        return this.getTest(null);
    }

    private final Testing getTest(String endpoint) {
        Testing testing = this.overrideTest;
        if (testing == null && (testing = this.myTest) == null) {
            Testing.Builder builder;
            Testing.Builder $this$getTest_u24lambda_u244 = builder = new Testing.Builder(this.getMyHttpTransport(), (JsonFactory)GsonFactory.getDefaultInstance(), (HttpRequestInitializer)this.credential.getValue()).setApplicationName("Android Studio");
            boolean bl = false;
            if (endpoint != null) {
                $this$getTest_u24lambda_u244.setRootUrl(endpoint);
            }
            Testing.Builder it = builder = builder.build();
            boolean bl2 = false;
            this.myTest = it;
            Testing.Builder builder2 = builder;
            testing = builder2;
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"also(...)");
        }
        return testing;
    }

    @NotNull
    public final AndroidDeviceCatalog getAndroidDeviceCatalogForEnvironment(@NotNull String endpoint, @Nullable String gcpProject) throws IOException {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Testing.TestEnvironmentCatalog.Get getter = this.getTest(endpoint).testEnvironmentCatalog().get("ANDROID");
        getter.setProjectId(gcpProject);
        getter.setIncludeViewableModels(Boolean.valueOf(true));
        if (this.credential.getValue() == null || gcpProject == null) {
            getter.setKey("AIzaSyAjidSpCP9kwpg9ZnfVe0RBYu2PC6daDzk");
        } else {
            getter.getRequestHeaders().set("X-Goog-User-Project", (Object)gcpProject);
        }
        AndroidDeviceCatalog catalog = ((TestEnvironmentCatalog)getter.execute()).getAndroidDeviceCatalog();
        if (catalog.getVersions().isEmpty() || catalog.getModels().isEmpty() || catalog.getRuntimeConfiguration().getLocales().isEmpty() || catalog.getRuntimeConfiguration().getOrientations().isEmpty()) {
            this._errorFlow.setValue((Object)"Android device catalog is empty for some dimensions");
        }
        Intrinsics.checkNotNull((Object)catalog);
        return catalog;
    }

    private final QueryTimeSeriesResponse queryMonitoring(String endpoint, String project, String queryString) throws IOException {
        Monitoring monitoring = this.getMonitoring(endpoint);
        QueryTimeSeriesRequest request = new QueryTimeSeriesRequest().setQuery(queryString).setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        Object object = monitoring.projects().timeSeries().query(project, request).execute();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"execute(...)");
        return (QueryTimeSeriesResponse)object;
    }

    private final Monitoring getMonitoring(String endpoint) {
        Monitoring monitoring = this.overrideMonitoring;
        if (monitoring == null && (monitoring = this.myMonitoring) == null) {
            Monitoring.Builder builder;
            Monitoring.Builder $this$getMonitoring_u24lambda_u246 = builder = new Monitoring.Builder(this.getMyHttpTransport(), (JsonFactory)GsonFactory.getDefaultInstance(), (HttpRequestInitializer)this.credential.getValue()).setApplicationName("Android Studio");
            boolean bl = false;
            if (endpoint != null) {
                $this$getMonitoring_u24lambda_u246.setRootUrl(endpoint);
            }
            Monitoring.Builder it = builder = builder.build();
            boolean bl2 = false;
            this.myMonitoring = it;
            Monitoring.Builder builder2 = builder;
            monitoring = builder2;
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"also(...)");
        }
        return monitoring;
    }

    public final boolean isBillingEnabled(@NotNull String cloudProject) {
        Intrinsics.checkNotNullParameter((Object)cloudProject, (String)"cloudProject");
        Boolean bl = ((ProjectBillingInfo)this.getCloudbilling().projects().getBillingInfo("projects/" + cloudProject).execute()).getBillingEnabled();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getBillingEnabled(...)");
        return bl;
    }

    @Nullable
    public final Pair<Long, Long> getQuotaUsageAndLimit(@NotNull String endpoint, @NotNull String serviceFilter, @NotNull String project) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)serviceFilter, (String)"serviceFilter");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        calendar.setTimeInMillis(this.getTimestampAtMonthStartMidnightInPT(instant));
        Locale locale = Locale.US;
        String string = "d'%d/%d/%d %d:00'";
        Object[] objectArray = new Object[]{calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(10)};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String date = string2;
        try {
            QueryTimeSeriesResponse usageResponse = this.queryMonitoring(endpoint, project, "\n              fetch consumer_quota | metric 'serviceruntime.googleapis.com/quota/allocation/usage'\n              | " + this.queryFilterWithMonthlyQuotaMetric + "\n              | " + this.queryFilterWithResourceService(serviceFilter) + "\n              | top 1, scale(end(), 'ms')\n              | within " + date + "\n              ");
            if (usageResponse.size() < 2) {
                return null;
            }
            long usageNumber = this.findNumber(usageResponse);
            QueryTimeSeriesResponse limitResponse = this.queryMonitoring(endpoint, project, StringsKt.trimIndent((String)("\n              fetch consumer_quota\n              | metric 'serviceruntime.googleapis.com/quota/limit'\n              | " + this.queryFilterWithMonthlyQuotaMetric + "\n              | " + this.queryFilterWithResourceService(serviceFilter) + "\n              | top 1, scale(end(), 'ms')\n              | within " + date + "\n              ")));
            if (limitResponse.size() < 2) {
                return null;
            }
            long limitNumber = this.findNumber(limitResponse);
            return new Pair((Object)usageNumber, (Object)limitNumber);
        }
        catch (Exception e) {
            return null;
        }
    }

    private final String queryFilterWithResourceService(String service) {
        return "filter resource.service==\"" + service + "\"";
    }

    private final long findNumber(QueryTimeSeriesResponse item) {
        List list = item.getTimeSeriesData();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTimeSeriesData(...)");
        TimeSeriesData timeSeriesData = (TimeSeriesData)CollectionsKt.first((List)list);
        List list2 = timeSeriesData.getPointData();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getPointData(...)");
        PointData pointData = (PointData)CollectionsKt.first((List)list2);
        List list3 = pointData.getValues();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getValues(...)");
        Long l = ((TypedValue)CollectionsKt.first((List)list3)).getInt64Value();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getInt64Value(...)");
        return ((Number)l).longValue();
    }

    @VisibleForTesting
    public final long getTimestampAtMonthStartMidnightInPT(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        return ZonedDateTime.ofInstant(instant, ZoneId.of("America/Los_Angeles")).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0).toInstant().toEpochMilli();
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final List<Pair<AndroidModel, PerAndroidVersionInfo>> getAvailableDevices(@NotNull String endpoint, @Nullable String cloudProject) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        catalog = this.getAndroidDeviceCatalogForEnvironment(endpoint, cloudProject);
        v0 = catalog.getModels();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getModels(...)");
        var4_4 = v0;
        $i$f$filter = false;
        var6_6 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (AndroidModel)element$iv$iv;
            $i$a$-filter-CloudClient$getAvailableDevices$1 = false;
            if (!Intrinsics.areEqual((Object)it.getForm(), (Object)"PHYSICAL")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
            block9: {
                block8: {
                    model = (AndroidModel)element$iv$iv;
                    $i$a$-flatMap-CloudClient$getAvailableDevices$2 = false;
                    var13_13 = model.getPerVersionInfo();
                    if (var13_13 == null) break block8;
                    var14_14 = var13_13;
                    $i$f$filter = false;
                    var16_18 = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        perVersionInfo = (PerAndroidVersionInfo)element$iv$iv;
                        $i$a$-filter-CloudClient$getAvailableDevices$2$1 = false;
                        v1 = perVersionInfo.getVersionId();
                        if (v1 != null && (v1 = StringsKt.toIntOrNull((String)v1)) != null) {
                            it = ((Number)v1).intValue();
                            $i$a$-let-CloudClient$getAvailableDevices$2$1$1 = false;
                            v2 = it >= 26;
                        } else {
                            v2 = false;
                        }
                        if (!v2) ** GOTO lbl-1000
                        if (this.isUnfilteredDevices()) ** GOTO lbl-1000
                        v3 = perVersionInfo.getDirectAccessVersionInfo();
                        if ((v3 != null ? Intrinsics.areEqual((Object)v3.getDirectAccessSupported(), (Object)true) : false) && !Intrinsics.areEqual((Object)perVersionInfo.getDeviceCapacity(), (Object)"DEVICE_CAPACITY_NONE")) lbl-1000:
                        // 2 sources

                        {
                            v4 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v4 = false;
                        }
                        if (!v4) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $i$f$filter = (List)destination$iv$iv;
                    $i$f$mapNotNull = false;
                    destination$iv$iv = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$mapNotNullTo = false;
                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    $i$f$forEach = false;
                    var22_27 = $this$forEach$iv$iv$iv.iterator();
                    while (var22_27.hasNext()) {
                        element$iv$iv = element$iv$iv$iv = var22_27.next();
                        $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                        it = (PerAndroidVersionInfo)element$iv$iv;
                        $i$a$-mapNotNull-CloudClient$getAvailableDevices$2$2 = false;
                        if (TuplesKt.to((Object)model, (Object)it) == null) continue;
                        $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    v5 = (List)destination$iv$iv;
                    break block9;
                }
                v5 = CollectionsKt.emptyList();
            }
            list$iv$iv = v5;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void enableDeviceStreamingService(@NotNull String projectName, @NotNull String serviceEndpoint) {
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter((Object)serviceEndpoint, (String)"serviceEndpoint");
        this.getServiceUsage().services().enable("projects/" + projectName + "/services/" + serviceEndpoint, new EnableServiceRequest()).execute();
    }

    public final boolean isDeviceStreamingServiceEnabled(@NotNull String projectName, @NotNull String serviceEndpoint) {
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter((Object)serviceEndpoint, (String)"serviceEndpoint");
        return Intrinsics.areEqual((Object)((GoogleApiServiceusageV1Service)this.getServiceUsage().services().get("projects/" + projectName + "/services/" + serviceEndpoint).execute()).getState(), (Object)"ENABLED");
    }

    private final boolean isUnfilteredDevices() {
        return Boolean.parseBoolean(System.getProperty("da_unfiltered_devices"));
    }
}

