/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.directaccess.provisioner;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.ComposableTarget;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.CompositionLocal;
import androidx.compose.runtime.RecomposeScopeImplKt;
import androidx.compose.runtime.ScopeUpdateScope;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.graphics.painter.Painter;
import androidx.compose.ui.platform.CompositionLocalsKt;
import androidx.compose.ui.unit.Density;
import com.android.annotations.concurrency.Slow;
import com.android.ide.common.repository.IdeNetworkCacheUtils;
import com.android.ide.common.repository.NetworkCache;
import com.google.gct.directaccess.provisioner.OemLabsAssetsRegistryKt;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.icons.CachedImageIcon;
import com.intellij.ui.icons.IconTransform;
import com.intellij.ui.icons.ImageDataLoader;
import com.intellij.ui.icons.ImageDataLoaderDescriptor;
import com.intellij.ui.icons.LoadIconParameters;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.ScaleContext;
import java.awt.Image;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.resources.ImageDecoders_skikoKt;
import org.jetbrains.jewel.foundation.theme.JewelTheme;
import org.jetbrains.jewel.ui.component.IconKt;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 02\u00020\u0001:\u0004-./0B;\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0014J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u001a\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u000f2\u0006\u0010 \u001a\u00020\u0003H\u0007J\u0010\u0010!\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0003H\u0007J\u0018\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010$\u001a\u00020%H\u0007J\u0010\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020%H\u0002J3\u0010(\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u00032!\u0010)\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b+\u0012\b\b,\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00170*H\u0003R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/google/gct/directaccess/provisioner/OemLabsAssetsRegistry;", "Lcom/android/ide/common/repository/NetworkCache;", "baseUrl", "", "cacheDir", "Ljava/nio/file/Path;", "networkTimeoutMs", "", "cacheExpiryHours", "useNetwork", "", "<init>", "(Ljava/lang/String;Ljava/nio/file/Path;IIZ)V", "assetsMap", "", "Lcom/google/gct/directaccess/provisioner/OemLabsAssetsRegistry$OemLabAsset;", "readUrlData", "Lcom/android/ide/common/repository/NetworkCache$ReadUrlDataResult;", "url", "timeout", "lastModified", "", "readDefaultData", "Ljava/io/InputStream;", "relative", "readFallbackUnknownData", "error", "", "throwable", "", "message", "getAssetById", "assetId", "retrieveName", "retrieveIcon", "Lcom/google/gct/directaccess/provisioner/OemLabsAssetsRegistry$OemLabIcon;", "type", "Lcom/google/gct/directaccess/provisioner/OemLabsAssetsRegistry$IconType;", "createUnknownIcon", "iconType", "refreshAssetsMap", "fetcher", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "OemLabIcon", "IconType", "OemLabAsset", "Companion", "directaccess"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nOemLabsAssetsRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OemLabsAssetsRegistry.kt\ncom/google/gct/directaccess/provisioner/OemLabsAssetsRegistry\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,301:1\n24#2:302\n24#2:303\n1#3:304\n*S KotlinDebug\n*F\n+ 1 OemLabsAssetsRegistry.kt\ncom/google/gct/directaccess/provisioner/OemLabsAssetsRegistry\n*L\n109#1:302\n118#1:303\n*E\n"})
public final class OemLabsAssetsRegistry
extends NetworkCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, OemLabAsset> assetsMap;
    public static final int $stable = 8;

    public OemLabsAssetsRegistry(@NotNull String baseUrl, @Nullable Path cacheDir, int networkTimeoutMs, int cacheExpiryHours, boolean useNetwork) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        super(baseUrl, "oem.labs.assets", cacheDir, networkTimeoutMs, cacheExpiryHours, useNetwork);
        this.assetsMap = new LinkedHashMap();
        this.refreshAssetsMap("google", (Function1<? super String, ? extends InputStream>)((Function1)arg_0 -> OemLabsAssetsRegistry._init_$lambda$0(this, arg_0)));
    }

    public /* synthetic */ OemLabsAssetsRegistry(String string, Path path, int n, int n2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            string = "https://www.gstatic.com/android-devtools-oem-labs/labs/";
        }
        if ((n3 & 2) != 0) {
            path = OemLabsAssetsRegistryKt.access$getCacheDir();
        }
        if ((n3 & 4) != 0) {
            n = 3000;
        }
        if ((n3 & 8) != 0) {
            n2 = (int)TimeUnit.DAYS.toHours(1L);
        }
        if ((n3 & 0x10) != 0) {
            bl = true;
        }
        this(string, path, n, n2, bl);
    }

    @NotNull
    protected NetworkCache.ReadUrlDataResult readUrlData(@NotNull String url, int timeout, long lastModified) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return IdeNetworkCacheUtils.Companion.readHttpUrlData$default((IdeNetworkCacheUtils.Companion)IdeNetworkCacheUtils.Companion, (String)url, (int)timeout, (long)lastModified, null, (int)8, null);
    }

    @NotNull
    protected InputStream readDefaultData(@NotNull String relative) {
        Intrinsics.checkNotNullParameter((Object)relative, (String)"relative");
        InputStream inputStream = OemLabsAssetsRegistry.class.getResourceAsStream("/oem-labs-assets-offline/" + relative);
        if (inputStream == null) {
            inputStream = this.readFallbackUnknownData(relative);
        }
        return inputStream;
    }

    private final InputStream readFallbackUnknownData(String relative) {
        String relativePath = "unknown/" + StringsKt.substringAfterLast$default((String)relative, (String)"/", null, (int)2, null);
        OemLabsAssetsRegistry $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(OemLabsAssetsRegistry.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("Unknown assets (" + relative + "), fallback to default data at " + relativePath + ".");
        InputStream inputStream = OemLabsAssetsRegistry.class.getResourceAsStream("/oem-labs-assets-offline/" + relativePath);
        if (inputStream == null) {
            throw new IllegalStateException(("Resource not found: /oem-labs-assets-offline/" + relativePath).toString());
        }
        return inputStream;
    }

    public void error(@NotNull Throwable throwable, @Nullable String message) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        OemLabsAssetsRegistry $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(OemLabsAssetsRegistry.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn(message, throwable);
    }

    @Slow
    @Nullable
    public final OemLabAsset getAssetById(@NotNull String assetId) {
        Intrinsics.checkNotNullParameter((Object)assetId, (String)"assetId");
        if (this.assetsMap.get(assetId) == null) {
            this.refreshAssetsMap(assetId, (Function1<? super String, ? extends InputStream>)((Function1)arg_0 -> OemLabsAssetsRegistry.getAssetById$lambda$1(this, arg_0)));
        }
        return this.assetsMap.get(assetId);
    }

    @Slow
    @NotNull
    public final String retrieveName(@NotNull String assetId) {
        Intrinsics.checkNotNullParameter((Object)assetId, (String)"assetId");
        Object object = this.getAssetById(assetId);
        if (object == null || (object = ((OemLabAsset)object).getName()) == null) {
            object = "Unknown";
        }
        return object;
    }

    @Slow
    @NotNull
    public final OemLabIcon retrieveIcon(@NotNull String assetId, @NotNull IconType type) {
        Intrinsics.checkNotNullParameter((Object)assetId, (String)"assetId");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Object object = this.getAssetById(assetId);
        if (object == null || (object = ((OemLabAsset)object).getIcons()) == null || (object = (OemLabIcon)((Object)object.get((Object)type))) == null) {
            object = this.createUnknownIcon(type);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final OemLabIcon createUnknownIcon(IconType iconType) {
        byte[] byArray;
        byte[] byArray2;
        Object it;
        Closeable closeable = this.readFallbackUnknownData(iconType.getType() + ".svg");
        String string = "unknown_" + iconType.getType();
        Throwable throwable = null;
        try {
            it = (InputStream)closeable;
            boolean bl = false;
            it = ByteStreamsKt.readBytes((InputStream)it);
        }
        catch (Throwable bl) {
            throwable = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        closeable = this.readFallbackUnknownData(iconType.getType() + "_dark.svg");
        Object object = it;
        throwable = null;
        try {
            it = (InputStream)closeable;
            boolean bl = false;
            byArray2 = ByteStreamsKt.readBytes((InputStream)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] byArray3 = byArray = byArray2;
        Object object2 = object;
        String string2 = string;
        return new OemLabIcon(string2, (byte[])object2, byArray3);
    }

    @Slow
    private final void refreshAssetsMap(String assetId, Function1<? super String, ? extends InputStream> fetcher) {
        OemLabAsset oemLabAsset;
        try {
            oemLabAsset = OemLabAsset.Companion.extract(assetId, fetcher);
        }
        catch (Exception exception) {
            Throwable throwable = exception;
            String string = exception.getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            this.error(throwable, string);
            return;
        }
        OemLabAsset asset = oemLabAsset;
        this.assetsMap.put(assetId, asset);
    }

    private static final InputStream _init_$lambda$0(OemLabsAssetsRegistry this$0, String relativeUrl) {
        Intrinsics.checkNotNullParameter((Object)relativeUrl, (String)"relativeUrl");
        return this$0.readDefaultData(relativeUrl);
    }

    private static final InputStream getAssetById$lambda$1(OemLabsAssetsRegistry this$0, String relativeUrl) {
        Intrinsics.checkNotNullParameter((Object)relativeUrl, (String)"relativeUrl");
        InputStream inputStream = NetworkCache.findData$default((NetworkCache)this$0, (String)relativeUrl, (boolean)false, (int)2, null);
        if (inputStream == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return inputStream;
    }

    public OemLabsAssetsRegistry() {
        this(null, null, 0, 0, false, 31, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/google/gct/directaccess/provisioner/OemLabsAssetsRegistry$Companion;", "", "<init>", "()V", "getInstance", "Lcom/google/gct/directaccess/provisioner/OemLabsAssetsRegistry;", "directaccess"})
    @SourceDebugExtension(value={"SMAP\nOemLabsAssetsRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OemLabsAssetsRegistry.kt\ncom/google/gct/directaccess/provisioner/OemLabsAssetsRegistry$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,301:1\n40#2,3:302\n*S KotlinDebug\n*F\n+ 1 OemLabsAssetsRegistry.kt\ncom/google/gct/directaccess/provisioner/OemLabsAssetsRegistry$Companion\n*L\n282#1:302,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OemLabsAssetsRegistry getInstance() {
            boolean $i$f$service = false;
            Class<OemLabsAssetsRegistry> serviceClass$iv = OemLabsAssetsRegistry.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (OemLabsAssetsRegistry)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\u0081\u0002\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000eB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000f"}, d2={"Lcom/google/gct/directaccess/provisioner/OemLabsAssetsRegistry$IconType;", "", "type", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getType", "()Ljava/lang/String;", "CAR", "PHONE", "TV", "WEAR", "XR_HEADSET", "AI_GLASSES", "Companion", "directaccess"})
    public static final class IconType
    extends Enum<IconType> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String type;
        public static final /* enum */ IconType CAR;
        public static final /* enum */ IconType PHONE;
        public static final /* enum */ IconType TV;
        public static final /* enum */ IconType WEAR;
        public static final /* enum */ IconType XR_HEADSET;
        public static final /* enum */ IconType AI_GLASSES;
        private static final /* synthetic */ IconType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private IconType(String type) {
            this.type = type;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        public static IconType[] values() {
            return (IconType[])$VALUES.clone();
        }

        public static IconType valueOf(String value) {
            return Enum.valueOf(IconType.class, value);
        }

        @NotNull
        public static EnumEntries<IconType> getEntries() {
            return $ENTRIES;
        }

        static {
            CAR = new IconType("car");
            PHONE = new IconType("phone");
            TV = new IconType("tv");
            WEAR = new IconType("wear");
            XR_HEADSET = new IconType("xr_headset");
            AI_GLASSES = new IconType("ai_glasses");
            $VALUES = iconTypeArray = new IconType[]{IconType.CAR, IconType.PHONE, IconType.TV, IconType.WEAR, IconType.XR_HEADSET, IconType.AI_GLASSES};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/google/gct/directaccess/provisioner/OemLabsAssetsRegistry$IconType$Companion;", "", "<init>", "()V", "fromFormFactorString", "Lcom/google/gct/directaccess/provisioner/OemLabsAssetsRegistry$IconType;", "formFactor", "", "directaccess"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final IconType fromFormFactorString(@NotNull String formFactor) {
                Intrinsics.checkNotNullParameter((Object)formFactor, (String)"formFactor");
                String string = formFactor;
                return Intrinsics.areEqual((Object)string, (Object)CAR.getType()) ? CAR : (Intrinsics.areEqual((Object)string, (Object)PHONE.getType()) ? PHONE : (Intrinsics.areEqual((Object)string, (Object)TV.getType()) ? TV : (Intrinsics.areEqual((Object)string, (Object)WEAR.getType()) ? WEAR : (Intrinsics.areEqual((Object)string, (Object)XR_HEADSET.getType()) ? XR_HEADSET : (Intrinsics.areEqual((Object)string, (Object)AI_GLASSES.getType()) ? AI_GLASSES : PHONE)))));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0087\b\u0018\u0000 \u00172\u00020\u0001:\u0003\u0017\u0018\u0019B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/google/gct/directaccess/provisioner/OemLabsAssetsRegistry$OemLabAsset;", "", "name", "", "icons", "", "Lcom/google/gct/directaccess/provisioner/OemLabsAssetsRegistry$IconType;", "Lcom/google/gct/directaccess/provisioner/OemLabsAssetsRegistry$OemLabIcon;", "<init>", "(Ljava/lang/String;Ljava/util/Map;)V", "getName", "()Ljava/lang/String;", "getIcons", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "Descriptor", "Icon", "directaccess"})
    @StabilityInferred(parameters=0)
    public static final class OemLabAsset {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String name;
        @NotNull
        private final Map<IconType, OemLabIcon> icons;
        public static final int $stable = 8;
        private static final Gson gson = new GsonBuilder().setLenient().create();

        public OemLabAsset(@NotNull String name, @NotNull Map<IconType, OemLabIcon> icons) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(icons, (String)"icons");
            this.name = name;
            this.icons = icons;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Map<IconType, OemLabIcon> getIcons() {
            return this.icons;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final Map<IconType, OemLabIcon> component2() {
            return this.icons;
        }

        @NotNull
        public final OemLabAsset copy(@NotNull String name, @NotNull Map<IconType, OemLabIcon> icons) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(icons, (String)"icons");
            return new OemLabAsset(name, icons);
        }

        public static /* synthetic */ OemLabAsset copy$default(OemLabAsset oemLabAsset, String string, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                string = oemLabAsset.name;
            }
            if ((n & 2) != 0) {
                map2 = oemLabAsset.icons;
            }
            return oemLabAsset.copy(string, map2);
        }

        @NotNull
        public String toString() {
            return "OemLabAsset(name=" + this.name + ", icons=" + this.icons + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + ((Object)this.icons).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OemLabAsset)) {
                return false;
            }
            OemLabAsset oemLabAsset = (OemLabAsset)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)oemLabAsset.name)) {
                return false;
            }
            return Intrinsics.areEqual(this.icons, oemLabAsset.icons);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2!\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\fR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/google/gct/directaccess/provisioner/OemLabsAssetsRegistry$OemLabAsset$Companion;", "", "<init>", "()V", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "extract", "Lcom/google/gct/directaccess/provisioner/OemLabsAssetsRegistry$OemLabAsset;", "assetId", "", "fetcher", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "relative", "Ljava/io/InputStream;", "directaccess"})
        @SourceDebugExtension(value={"SMAP\nOemLabsAssetsRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OemLabsAssetsRegistry.kt\ncom/google/gct/directaccess/provisioner/OemLabsAssetsRegistry$OemLabAsset$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,301:1\n1#2:302\n1193#3,2:303\n1267#3,4:305\n*S KotlinDebug\n*F\n+ 1 OemLabsAssetsRegistry.kt\ncom/google/gct/directaccess/provisioner/OemLabsAssetsRegistry$OemLabAsset$Companion\n*L\n260#1:303,2\n260#1:305,4\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @NotNull
            public final OemLabAsset extract(@NotNull String assetId, @NotNull Function1<? super String, ? extends InputStream> fetcher) {
                void $this$associateTo$iv$iv;
                Object it;
                Intrinsics.checkNotNullParameter((Object)assetId, (String)"assetId");
                Intrinsics.checkNotNullParameter(fetcher, (String)"fetcher");
                Closeable closeable = (InputStream)fetcher.invoke((Object)(assetId + "/descriptor.json"));
                Object object = Charsets.UTF_8;
                closeable = new InputStreamReader((InputStream)closeable, (Charset)object);
                object = null;
                try {
                    it = (InputStreamReader)closeable;
                    boolean bl = false;
                    it = TextStreamsKt.readText((Reader)((Reader)it));
                }
                catch (Throwable bl) {
                    object = bl;
                    throw bl;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                }
                Object jsonString = it;
                Descriptor descriptor = (Descriptor)gson.fromJson((String)jsonString, Descriptor.class);
                Iterable $this$associate$iv = descriptor.getIcons();
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                Iterable iterable = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map2 = destination$iv$iv;
                    Icon icon = (Icon)element$iv$iv;
                    boolean bl = false;
                    IconType type = IconType.Companion.fromFormFactorString(icon.getFormFactor());
                    OemLabIcon populatedIcon = new OemLabIcon(assetId + "_" + type.getType(), ByteStreamsKt.readBytes((InputStream)((InputStream)fetcher.invoke((Object)(assetId + "/" + icon.getPathLight())))), ByteStreamsKt.readBytes((InputStream)((InputStream)fetcher.invoke((Object)(assetId + "/" + icon.getPathDark())))));
                    Pair pair = TuplesKt.to((Object)((Object)type), (Object)((Object)populatedIcon));
                    map2.put(pair.getFirst(), pair.getSecond());
                }
                Map icons = destination$iv$iv;
                return new OemLabAsset(descriptor.getName(), icons);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/google/gct/directaccess/provisioner/OemLabsAssetsRegistry$OemLabAsset$Descriptor;", "", "name", "", "icons", "", "Lcom/google/gct/directaccess/provisioner/OemLabsAssetsRegistry$OemLabAsset$Icon;", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "getIcons", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "directaccess"})
        private static final class Descriptor {
            @NotNull
            private final String name;
            @NotNull
            private final List<Icon> icons;

            public Descriptor(@NotNull String name, @NotNull List<Icon> icons) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter(icons, (String)"icons");
                this.name = name;
                this.icons = icons;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            @NotNull
            public final List<Icon> getIcons() {
                return this.icons;
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            @NotNull
            public final List<Icon> component2() {
                return this.icons;
            }

            @NotNull
            public final Descriptor copy(@NotNull String name, @NotNull List<Icon> icons) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter(icons, (String)"icons");
                return new Descriptor(name, icons);
            }

            public static /* synthetic */ Descriptor copy$default(Descriptor descriptor, String string, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    string = descriptor.name;
                }
                if ((n & 2) != 0) {
                    list = descriptor.icons;
                }
                return descriptor.copy(string, list);
            }

            @NotNull
            public String toString() {
                return "Descriptor(name=" + this.name + ", icons=" + this.icons + ")";
            }

            public int hashCode() {
                int result2 = this.name.hashCode();
                result2 = result2 * 31 + ((Object)this.icons).hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Descriptor)) {
                    return false;
                }
                Descriptor descriptor = (Descriptor)other;
                if (!Intrinsics.areEqual((Object)this.name, (Object)descriptor.name)) {
                    return false;
                }
                return Intrinsics.areEqual(this.icons, descriptor.icons);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/google/gct/directaccess/provisioner/OemLabsAssetsRegistry$OemLabAsset$Icon;", "", "formFactor", "", "pathLight", "pathDark", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getFormFactor", "()Ljava/lang/String;", "getPathLight", "getPathDark", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "directaccess"})
        private static final class Icon {
            @NotNull
            private final String formFactor;
            @NotNull
            private final String pathLight;
            @NotNull
            private final String pathDark;

            public Icon(@NotNull String formFactor, @NotNull String pathLight, @NotNull String pathDark) {
                Intrinsics.checkNotNullParameter((Object)formFactor, (String)"formFactor");
                Intrinsics.checkNotNullParameter((Object)pathLight, (String)"pathLight");
                Intrinsics.checkNotNullParameter((Object)pathDark, (String)"pathDark");
                this.formFactor = formFactor;
                this.pathLight = pathLight;
                this.pathDark = pathDark;
            }

            @NotNull
            public final String getFormFactor() {
                return this.formFactor;
            }

            @NotNull
            public final String getPathLight() {
                return this.pathLight;
            }

            @NotNull
            public final String getPathDark() {
                return this.pathDark;
            }

            @NotNull
            public final String component1() {
                return this.formFactor;
            }

            @NotNull
            public final String component2() {
                return this.pathLight;
            }

            @NotNull
            public final String component3() {
                return this.pathDark;
            }

            @NotNull
            public final Icon copy(@NotNull String formFactor, @NotNull String pathLight, @NotNull String pathDark) {
                Intrinsics.checkNotNullParameter((Object)formFactor, (String)"formFactor");
                Intrinsics.checkNotNullParameter((Object)pathLight, (String)"pathLight");
                Intrinsics.checkNotNullParameter((Object)pathDark, (String)"pathDark");
                return new Icon(formFactor, pathLight, pathDark);
            }

            public static /* synthetic */ Icon copy$default(Icon icon, String string, String string2, String string3, int n, Object object) {
                if ((n & 1) != 0) {
                    string = icon.formFactor;
                }
                if ((n & 2) != 0) {
                    string2 = icon.pathLight;
                }
                if ((n & 4) != 0) {
                    string3 = icon.pathDark;
                }
                return icon.copy(string, string2, string3);
            }

            @NotNull
            public String toString() {
                return "Icon(formFactor=" + this.formFactor + ", pathLight=" + this.pathLight + ", pathDark=" + this.pathDark + ")";
            }

            public int hashCode() {
                int result2 = this.formFactor.hashCode();
                result2 = result2 * 31 + this.pathLight.hashCode();
                result2 = result2 * 31 + this.pathDark.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Icon)) {
                    return false;
                }
                Icon icon = (Icon)other;
                if (!Intrinsics.areEqual((Object)this.formFactor, (Object)icon.formFactor)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.pathLight, (Object)icon.pathLight)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.pathDark, (Object)icon.pathDark);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u001f\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0007\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0017\u001a\u00020\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u001c"}, d2={"Lcom/google/gct/directaccess/provisioner/OemLabsAssetsRegistry$OemLabIcon;", "Lcom/intellij/ui/icons/CachedImageIcon;", "description", "", "lightThemeData", "", "darkThemeData", "<init>", "(Ljava/lang/String;[B[B)V", "getDescription", "()Ljava/lang/String;", "getLightThemeData", "()[B", "getDarkThemeData", "getIcon", "Ljavax/swing/Icon;", "Icon", "", "modifier", "Landroidx/compose/ui/Modifier;", "isDark", "", "(Landroidx/compose/ui/Modifier;ZLandroidx/compose/runtime/Composer;II)V", "equals", "other", "", "hashCode", "", "directaccess"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nOemLabsAssetsRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OemLabsAssetsRegistry.kt\ncom/google/gct/directaccess/provisioner/OemLabsAssetsRegistry$OemLabIcon\n+ 2 CompositionLocal.kt\nandroidx/compose/runtime/CompositionLocal\n*L\n1#1,301:1\n75#2:302\n*S KotlinDebug\n*F\n+ 1 OemLabsAssetsRegistry.kt\ncom/google/gct/directaccess/provisioner/OemLabsAssetsRegistry$OemLabIcon\n*L\n199#1:302\n*E\n"})
    public static final class OemLabIcon
    extends CachedImageIcon {
        @NotNull
        private final String description;
        @NotNull
        private final byte[] lightThemeData;
        @NotNull
        private final byte[] darkThemeData;
        public static final int $stable = 8;

        public OemLabIcon(@NotNull String description, final @NotNull byte[] lightThemeData, final @NotNull byte[] darkThemeData) {
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)lightThemeData, (String)"lightThemeData");
            Intrinsics.checkNotNullParameter((Object)darkThemeData, (String)"darkThemeData");
            super(new ImageDataLoader(){
                private final String path;
                private final URL url;

                public String getPath() {
                    return this.path;
                }

                public URL getUrl() {
                    return this.url;
                }

                public boolean isMyClassLoader(ClassLoader classLoader) {
                    Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
                    return false;
                }

                public ImageDataLoader patch(IconTransform transform) {
                    Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
                    return null;
                }

                public Image loadImage(LoadIconParameters parameters, ScaleContext scaleContext) {
                    Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                    Intrinsics.checkNotNullParameter((Object)scaleContext, (String)"scaleContext");
                    byte[] data = parameters.isDark ? darkThemeData : lightThemeData;
                    float scale = (float)scaleContext.getScale(DerivedScaleType.PIX_SCALE);
                    return OemLabsAssetsRegistryKt.access$renderSvgToImage(data, scale, parameters, scaleContext);
                }

                @ApiStatus.Experimental
                public Pair<String, ClassLoader> getCoords() {
                    return super.getCoords();
                }

                public ImageDataLoaderDescriptor serializeToByteArray() {
                    return super.serializeToByteArray();
                }

                public String getExpUIPath() {
                    return super.getExpUIPath();
                }

                public int getFlags() {
                    return super.getFlags();
                }

                public int getModificationCount() {
                    return super.getModificationCount();
                }
            });
            this.description = description;
            this.lightThemeData = lightThemeData;
            this.darkThemeData = darkThemeData;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        @NotNull
        public final byte[] getLightThemeData() {
            return this.lightThemeData;
        }

        @NotNull
        public final byte[] getDarkThemeData() {
            return this.darkThemeData;
        }

        @NotNull
        public final Icon getIcon() {
            return (Icon)((Object)this);
        }

        /*
         * WARNING - void declaration
         */
        @Composable
        @ComposableTarget(applier="androidx.compose.ui.UiComposable")
        public final void Icon(@NotNull Modifier modifier, boolean isDark, @Nullable Composer $composer, int $changed, int n) {
            block11: {
                Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
                $composer = $composer.startRestartGroup(1230816094);
                int $dirty = $changed;
                if (($changed & 6) == 0) {
                    $dirty |= $composer.changed((Object)modifier) ? 4 : 2;
                }
                if (($changed & 0x30) == 0) {
                    $dirty |= (n & 2) == 0 && $composer.changed(isDark) ? 32 : 16;
                }
                if (($changed & 0x180) == 0) {
                    $dirty |= $composer.changedInstance((Object)this) ? 256 : 128;
                }
                if ($composer.shouldExecute(($dirty & 0x93) != 146, $dirty & 1)) {
                    void this_$iv;
                    void $composer$iv;
                    $composer.startDefaults();
                    if (($changed & 1) == 0 || $composer.getDefaultsInvalid()) {
                        if ((n & 2) != 0) {
                            isDark = JewelTheme.Companion.isDark($composer, 6);
                            $dirty &= 0xFFFFFF8F;
                        }
                    } else {
                        $composer.skipToGroupEnd();
                        if ((n & 2) != 0) {
                            $dirty &= 0xFFFFFF8F;
                        }
                    }
                    $composer.endDefaults();
                    if (ComposerKt.isTraceInProgress()) {
                        ComposerKt.traceEventStart((int)1230816094, (int)$dirty, (int)-1, (String)"com.google.gct.directaccess.provisioner.OemLabsAssetsRegistry.OemLabIcon.Icon (OemLabsAssetsRegistry.kt:196)");
                    }
                    byte[] data = isDark ? this.darkThemeData : this.lightThemeData;
                    CompositionLocal compositionLocal = (CompositionLocal)CompositionLocalsKt.getLocalDensity();
                    Composer composer = $composer;
                    boolean $changed$iv = false;
                    boolean $i$f$getCurrent = false;
                    ComposerKt.sourceInformationMarkerStart((Composer)$composer$iv, (int)2023513938, (String)"CC(<get-current>):CompositionLocal.kt#9igjgp");
                    Object object = $composer$iv.consume((CompositionLocal)this_$iv);
                    ComposerKt.sourceInformationMarkerEnd((Composer)$composer$iv);
                    Painter painter = ImageDecoders_skikoKt.decodeToSvgPainter((byte[])data, (Density)((Density)object));
                    IconKt.Icon-ww6aTOc((Painter)painter, (String)this.description, (Modifier)modifier, (long)0L, (Composer)$composer, (int)(0x380 & $dirty << 6), (int)8);
                    if (ComposerKt.isTraceInProgress()) {
                        ComposerKt.traceEventEnd();
                    }
                } else {
                    $composer.skipToGroupEnd();
                }
                ScopeUpdateScope scopeUpdateScope = $composer.endRestartGroup();
                if (scopeUpdateScope == null) break block11;
                scopeUpdateScope.updateScope((arg_0, arg_1) -> OemLabIcon.Icon$lambda$0(this, modifier, isDark, $changed, n, arg_0, arg_1));
            }
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.google.gct.directaccess.provisioner.OemLabsAssetsRegistry.OemLabIcon");
            OemLabIcon cfr_ignored_0 = (OemLabIcon)((Object)other);
            if (!Intrinsics.areEqual((Object)this.description, (Object)((OemLabIcon)((Object)other)).description)) {
                return false;
            }
            if (!Arrays.equals(this.lightThemeData, ((OemLabIcon)((Object)other)).lightThemeData)) {
                return false;
            }
            return Arrays.equals(this.darkThemeData, ((OemLabIcon)((Object)other)).darkThemeData);
        }

        public int hashCode() {
            int result2 = this.description.hashCode();
            result2 = 31 * result2 + Arrays.hashCode(this.lightThemeData);
            result2 = 31 * result2 + Arrays.hashCode(this.darkThemeData);
            return result2;
        }

        private static final Unit Icon$lambda$0(OemLabIcon $tmp0_rcvr, Modifier $modifier, boolean $isDark, int $$changed, int $$default, Composer $composer, int $force) {
            $tmp0_rcvr.Icon($modifier, $isDark, $composer, RecomposeScopeImplKt.updateChangedFlags((int)($$changed | 1)), $$default);
            return Unit.INSTANCE;
        }
    }
}

