/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.testing;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.testing.TestingRequest;
import com.google.api.services.testing.TestingRequestInitializer;
import com.google.api.services.testing.model.CancelDeviceSessionRequest;
import com.google.api.services.testing.model.CancelTestMatrixResponse;
import com.google.api.services.testing.model.DeviceSession;
import com.google.api.services.testing.model.Empty;
import com.google.api.services.testing.model.FileReference;
import com.google.api.services.testing.model.GetApkDetailsResponse;
import com.google.api.services.testing.model.ListDeviceSessionsResponse;
import com.google.api.services.testing.model.TestMatrix;
import java.io.IOException;
import java.util.regex.Pattern;

public class Testing
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://testing.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://testing.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://testing.googleapis.com/";

    public Testing(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Testing(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public ApplicationDetailService applicationDetailService() {
        return new ApplicationDetailService();
    }

    public Projects projects() {
        return new Projects();
    }

    public TestEnvironmentCatalog testEnvironmentCatalog() {
        return new TestEnvironmentCatalog();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Cloud Testing API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return Testing.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://testing.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), Testing.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Testing.DEFAULT_BATCH_PATH);
        }

        public Testing build() {
            return new Testing(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setTestingRequestInitializer(TestingRequestInitializer testingRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)testingRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }

        public Builder setUniverseDomain(String universeDomain) {
            return (Builder)super.setUniverseDomain(universeDomain);
        }
    }

    public class TestEnvironmentCatalog {
        public Get get(String environmentType) throws IOException {
            Get result = new Get(environmentType);
            Testing.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Get
        extends TestingRequest<com.google.api.services.testing.model.TestEnvironmentCatalog> {
            private static final String REST_PATH = "v1/testEnvironmentCatalog/{environmentType}";
            @Key
            private String environmentType;
            @Key
            private Boolean includeViewableModels;
            @Key
            private String projectId;

            protected Get(String environmentType) {
                super(Testing.this, "GET", REST_PATH, null, com.google.api.services.testing.model.TestEnvironmentCatalog.class);
                this.environmentType = (String)Preconditions.checkNotNull((Object)environmentType, (Object)"Required parameter environmentType must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getEnvironmentType() {
                return this.environmentType;
            }

            public Get setEnvironmentType(String environmentType) {
                this.environmentType = environmentType;
                return this;
            }

            public Boolean getIncludeViewableModels() {
                return this.includeViewableModels;
            }

            public Get setIncludeViewableModels(Boolean includeViewableModels) {
                this.includeViewableModels = includeViewableModels;
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Get setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Projects {
        public DeviceSessions deviceSessions() {
            return new DeviceSessions();
        }

        public TestMatrices testMatrices() {
            return new TestMatrices();
        }

        public class TestMatrices {
            public Cancel cancel(String projectId, String testMatrixId) throws IOException {
                Cancel result = new Cancel(projectId, testMatrixId);
                Testing.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Create create(String projectId, TestMatrix content) throws IOException {
                Create result = new Create(projectId, content);
                Testing.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String projectId, String testMatrixId) throws IOException {
                Get result = new Get(projectId, testMatrixId);
                Testing.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Get
            extends TestingRequest<TestMatrix> {
                private static final String REST_PATH = "v1/projects/{projectId}/testMatrices/{testMatrixId}";
                @Key
                private String projectId;
                @Key
                private String testMatrixId;

                protected Get(String projectId, String testMatrixId) {
                    super(Testing.this, "GET", REST_PATH, null, TestMatrix.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                    this.testMatrixId = (String)Preconditions.checkNotNull((Object)testMatrixId, (Object)"Required parameter testMatrixId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Get setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public String getTestMatrixId() {
                    return this.testMatrixId;
                }

                public Get setTestMatrixId(String testMatrixId) {
                    this.testMatrixId = testMatrixId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Create
            extends TestingRequest<TestMatrix> {
                private static final String REST_PATH = "v1/projects/{projectId}/testMatrices";
                @Key
                private String projectId;
                @Key
                private String requestId;

                protected Create(String projectId, TestMatrix content) {
                    super(Testing.this, "POST", REST_PATH, (Object)content, TestMatrix.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Create setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public String getRequestId() {
                    return this.requestId;
                }

                public Create setRequestId(String requestId) {
                    this.requestId = requestId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }

            public class Cancel
            extends TestingRequest<CancelTestMatrixResponse> {
                private static final String REST_PATH = "v1/projects/{projectId}/testMatrices/{testMatrixId}:cancel";
                @Key
                private String projectId;
                @Key
                private String testMatrixId;

                protected Cancel(String projectId, String testMatrixId) {
                    super(Testing.this, "POST", REST_PATH, null, CancelTestMatrixResponse.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                    this.testMatrixId = (String)Preconditions.checkNotNull((Object)testMatrixId, (Object)"Required parameter testMatrixId must be specified.");
                }

                public Cancel set$Xgafv(String $Xgafv) {
                    return (Cancel)super.set$Xgafv($Xgafv);
                }

                public Cancel setAccessToken(String accessToken) {
                    return (Cancel)super.setAccessToken(accessToken);
                }

                public Cancel setAlt(String alt) {
                    return (Cancel)super.setAlt(alt);
                }

                public Cancel setCallback(String callback) {
                    return (Cancel)super.setCallback(callback);
                }

                public Cancel setFields(String fields) {
                    return (Cancel)super.setFields(fields);
                }

                public Cancel setKey(String key) {
                    return (Cancel)super.setKey(key);
                }

                public Cancel setOauthToken(String oauthToken) {
                    return (Cancel)super.setOauthToken(oauthToken);
                }

                public Cancel setPrettyPrint(Boolean prettyPrint) {
                    return (Cancel)super.setPrettyPrint(prettyPrint);
                }

                public Cancel setQuotaUser(String quotaUser) {
                    return (Cancel)super.setQuotaUser(quotaUser);
                }

                public Cancel setUploadType(String uploadType) {
                    return (Cancel)super.setUploadType(uploadType);
                }

                public Cancel setUploadProtocol(String uploadProtocol) {
                    return (Cancel)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Cancel setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public String getTestMatrixId() {
                    return this.testMatrixId;
                }

                public Cancel setTestMatrixId(String testMatrixId) {
                    this.testMatrixId = testMatrixId;
                    return this;
                }

                @Override
                public Cancel set(String parameterName, Object value) {
                    return (Cancel)super.set(parameterName, value);
                }
            }
        }

        public class DeviceSessions {
            public Cancel cancel(String name, CancelDeviceSessionRequest content) throws IOException {
                Cancel result = new Cancel(name, content);
                Testing.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Create create(String parent, DeviceSession content) throws IOException {
                Create result = new Create(parent, content);
                Testing.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                Testing.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                Testing.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String name, DeviceSession content) throws IOException {
                Patch result = new Patch(name, content);
                Testing.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Patch
            extends TestingRequest<DeviceSession> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String updateMask;

                protected Patch(String name, DeviceSession content) {
                    super(Testing.this, "PATCH", REST_PATH, (Object)content, DeviceSession.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/deviceSessions/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Testing.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/deviceSessions/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String name) {
                    if (!Testing.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/deviceSessions/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends TestingRequest<ListDeviceSessionsResponse> {
                private static final String REST_PATH = "v1/{+parent}/deviceSessions";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String parent) {
                    super(Testing.this, "GET", REST_PATH, null, ListDeviceSessionsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Testing.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!Testing.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends TestingRequest<DeviceSession> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(Testing.this, "GET", REST_PATH, null, DeviceSession.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/deviceSessions/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Testing.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/deviceSessions/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!Testing.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/deviceSessions/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Create
            extends TestingRequest<DeviceSession> {
                private static final String REST_PATH = "v1/{+parent}/deviceSessions";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Create(String parent, DeviceSession content) {
                    super(Testing.this, "POST", REST_PATH, (Object)content, DeviceSession.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Testing.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!Testing.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }

            public class Cancel
            extends TestingRequest<Empty> {
                private static final String REST_PATH = "v1/{+name}:cancel";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Cancel(String name, CancelDeviceSessionRequest content) {
                    super(Testing.this, "POST", REST_PATH, (Object)content, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/deviceSessions/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Testing.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/deviceSessions/[^/]+$");
                    }
                }

                public Cancel set$Xgafv(String $Xgafv) {
                    return (Cancel)super.set$Xgafv($Xgafv);
                }

                public Cancel setAccessToken(String accessToken) {
                    return (Cancel)super.setAccessToken(accessToken);
                }

                public Cancel setAlt(String alt) {
                    return (Cancel)super.setAlt(alt);
                }

                public Cancel setCallback(String callback) {
                    return (Cancel)super.setCallback(callback);
                }

                public Cancel setFields(String fields) {
                    return (Cancel)super.setFields(fields);
                }

                public Cancel setKey(String key) {
                    return (Cancel)super.setKey(key);
                }

                public Cancel setOauthToken(String oauthToken) {
                    return (Cancel)super.setOauthToken(oauthToken);
                }

                public Cancel setPrettyPrint(Boolean prettyPrint) {
                    return (Cancel)super.setPrettyPrint(prettyPrint);
                }

                public Cancel setQuotaUser(String quotaUser) {
                    return (Cancel)super.setQuotaUser(quotaUser);
                }

                public Cancel setUploadType(String uploadType) {
                    return (Cancel)super.setUploadType(uploadType);
                }

                public Cancel setUploadProtocol(String uploadProtocol) {
                    return (Cancel)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Cancel setName(String name) {
                    if (!Testing.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/deviceSessions/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Cancel set(String parameterName, Object value) {
                    return (Cancel)super.set(parameterName, value);
                }
            }
        }
    }

    public class ApplicationDetailService {
        public GetApkDetails getApkDetails(FileReference content) throws IOException {
            GetApkDetails result = new GetApkDetails(content);
            Testing.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class GetApkDetails
        extends TestingRequest<GetApkDetailsResponse> {
            private static final String REST_PATH = "v1/applicationDetailService/getApkDetails";
            @Key(value="bundleLocation.gcsPath")
            private String bundleLocationGcsPath;

            protected GetApkDetails(FileReference content) {
                super(Testing.this, "POST", REST_PATH, (Object)content, GetApkDetailsResponse.class);
            }

            public GetApkDetails set$Xgafv(String $Xgafv) {
                return (GetApkDetails)super.set$Xgafv($Xgafv);
            }

            public GetApkDetails setAccessToken(String accessToken) {
                return (GetApkDetails)super.setAccessToken(accessToken);
            }

            public GetApkDetails setAlt(String alt) {
                return (GetApkDetails)super.setAlt(alt);
            }

            public GetApkDetails setCallback(String callback) {
                return (GetApkDetails)super.setCallback(callback);
            }

            public GetApkDetails setFields(String fields) {
                return (GetApkDetails)super.setFields(fields);
            }

            public GetApkDetails setKey(String key) {
                return (GetApkDetails)super.setKey(key);
            }

            public GetApkDetails setOauthToken(String oauthToken) {
                return (GetApkDetails)super.setOauthToken(oauthToken);
            }

            public GetApkDetails setPrettyPrint(Boolean prettyPrint) {
                return (GetApkDetails)super.setPrettyPrint(prettyPrint);
            }

            public GetApkDetails setQuotaUser(String quotaUser) {
                return (GetApkDetails)super.setQuotaUser(quotaUser);
            }

            public GetApkDetails setUploadType(String uploadType) {
                return (GetApkDetails)super.setUploadType(uploadType);
            }

            public GetApkDetails setUploadProtocol(String uploadProtocol) {
                return (GetApkDetails)super.setUploadProtocol(uploadProtocol);
            }

            public String getBundleLocationGcsPath() {
                return this.bundleLocationGcsPath;
            }

            public GetApkDetails setBundleLocationGcsPath(String bundleLocationGcsPath) {
                this.bundleLocationGcsPath = bundleLocationGcsPath;
                return this;
            }

            @Override
            public GetApkDetails set(String parameterName, Object value) {
                return (GetApkDetails)super.set(parameterName, value);
            }
        }
    }
}

