/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.game;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.tools.game.AdbPath;
import com.android.tools.game.CommonWindowWrapper;
import com.android.tools.game.FakeToolWindow;
import com.android.tools.game.NoopToolWindowWrapper;
import com.android.tools.game.ProfilerService;
import com.android.tools.game.protos.StartProfilingRequest;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.io.grpc.Status;
import com.android.tools.idea.io.grpc.StatusRuntimeException;
import com.android.tools.idea.profilers.AndroidProfilerToolWindow;
import com.android.tools.idea.profilers.PreferredProcessInfo;
import com.android.tools.idea.profilers.ToolWindowWrapper;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.transport.TransportService;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.StudioProfilers;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import icons.StudioIcons;
import java.io.File;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0012H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/game/ProfilerServiceImpl;", "Lcom/android/tools/game/ProfilerService;", "<init>", "()V", "windowWrappers", "", "", "Lcom/android/tools/game/CommonWindowWrapper;", "windows", "Lcom/intellij/openapi/project/Project;", "Lcom/android/tools/idea/profilers/AndroidProfilerToolWindow;", "windowIdToProject", "initialized", "", "createWindow", "windowId", "project", "startProfiler", "", "request", "Lcom/android/tools/game/protos/StartProfilingRequest;", "getDeviceTimeNs", "", "deviceId", "tryInitializeProfilerServices", "android.game-tools.main"})
@SourceDebugExtension(value={"SMAP\nProfilerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfilerService.kt\ncom/android/tools/game/ProfilerServiceImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1#2:140\n*E\n"})
public final class ProfilerServiceImpl
implements ProfilerService {
    @NotNull
    private final Map<String, CommonWindowWrapper> windowWrappers = new LinkedHashMap();
    @NotNull
    private final Map<Project, AndroidProfilerToolWindow> windows = new LinkedHashMap();
    @NotNull
    private final Map<String, Project> windowIdToProject = new LinkedHashMap();
    private boolean initialized;

    @Override
    @NotNull
    public CommonWindowWrapper createWindow(@NotNull String windowId, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)windowId, (String)"windowId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.tryInitializeProfilerServices();
        ApplicationManager.getApplication().invokeAndWait(() -> ProfilerServiceImpl.createWindow$lambda$4(this, project, windowId));
        CommonWindowWrapper commonWindowWrapper = this.windowWrappers.get(windowId);
        Intrinsics.checkNotNull((Object)commonWindowWrapper);
        return commonWindowWrapper;
    }

    @Override
    public void startProfiler(@NotNull StartProfilingRequest request) {
        Object v4;
        StudioProfilers profilers;
        AndroidProfilerToolWindow window;
        block5: {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            this.tryInitializeProfilerServices();
            Project project = this.windowIdToProject.get(request.getWindowId());
            if (project == null) {
                throw Status.INVALID_ARGUMENT.withDescription("Window '" + request.getWindowId() + "' cannot be found.").asRuntimeException();
            }
            Project project2 = project;
            AndroidProfilerToolWindow androidProfilerToolWindow = this.windows.get(project2);
            if (androidProfilerToolWindow == null) {
                throw Status.INVALID_ARGUMENT.withDescription("Project '" + project2 + "' cannot be found.").asRuntimeException();
            }
            window = androidProfilerToolWindow;
            StudioProfilers studioProfilers = window.getProfilers();
            if (studioProfilers == null) {
                throw Status.INTERNAL.withDescription("Cannot initialize profilers.").asRuntimeException();
            }
            profilers = studioProfilers;
            List list = profilers.getDevices();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDevices(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                Common.Device it = (Common.Device)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getSerial(), (Object)request.getSerialNumber())) continue;
                v4 = t;
                break block5;
            }
            v4 = null;
        }
        Common.Device device = v4;
        if (device == null) {
            throw Status.INVALID_ARGUMENT.withDescription("Device " + request.getSerialNumber() + " cannot be found.").asRuntimeException();
        }
        Common.Device device2 = device;
        long deviceTimeNs = this.getDeviceTimeNs(device2.getDeviceId());
        long systemTimeMs = System.currentTimeMillis();
        long processLaunchTimeMinBoundNs = Duration.ofMillis(request.getStartLaterThanMs() - systemTimeMs).toNanos() + deviceTimeNs;
        String string = device2.getManufacturer();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getManufacturer(...)");
        String string2 = device2.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getModel(...)");
        String string3 = device2.getSerial();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getSerial(...)");
        PreferredProcessInfo preferredProcessInfo = new PreferredProcessInfo(AndroidProfilerToolWindow.Companion.getDeviceDisplayName(string, string2, string3), request.getApplicationId(), arg_0 -> ProfilerServiceImpl.startProfiler$lambda$6(processLaunchTimeMinBoundNs, arg_0));
        profilers.getDeviceProcessMap().clear();
        window.profile(preferredProcessInfo);
    }

    private final long getDeviceTimeNs(long deviceId) {
        ProfilerClient client = new ProfilerClient(TransportService.Companion.getChannelName());
        try {
            Transport.TimeResponse timeResponse = client.getTransportClient().getCurrentTime(Transport.TimeRequest.newBuilder().setStreamId(deviceId).build());
            return timeResponse.getTimestampNs();
        }
        catch (StatusRuntimeException exception) {
            throw Status.INTERNAL.withCause((Throwable)exception).asRuntimeException();
        }
    }

    private final void tryInitializeProfilerServices() {
        if (this.initialized) {
            return;
        }
        File adbPath = AdbPath.INSTANCE.get();
        try {
            AndroidDebugBridge cfr_ignored_0 = (AndroidDebugBridge)AdbService.getInstance().getDebugBridge(adbPath).get();
        }
        catch (Exception e) {
            throw Status.UNKNOWN.withDescription("Failed to start profiler: " + e.getMessage()).asRuntimeException();
        }
        this.initialized = true;
    }

    private static final AndroidProfilerToolWindow createWindow$lambda$4$lambda$0(Project $project, Project it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new AndroidProfilerToolWindow((ToolWindowWrapper)new NoopToolWindowWrapper(), $project);
    }

    private static final AndroidProfilerToolWindow createWindow$lambda$4$lambda$1(Function1 $tmp0, Object p0) {
        return (AndroidProfilerToolWindow)$tmp0.invoke(p0);
    }

    private static final Unit createWindow$lambda$4$lambda$3$lambda$2(ProfilerServiceImpl this$0, String $windowId) {
        this$0.windowWrappers.remove($windowId);
        return Unit.INSTANCE;
    }

    private static final void createWindow$lambda$4(ProfilerServiceImpl this$0, Project $project, String $windowId) {
        CommonWindowWrapper commonWindowWrapper;
        AndroidProfilerToolWindow androidProfilerToolWindow = this$0.windows.computeIfAbsent($project, arg_0 -> ProfilerServiceImpl.createWindow$lambda$4$lambda$1(arg_0 -> ProfilerServiceImpl.createWindow$lambda$4$lambda$0($project, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)androidProfilerToolWindow, (String)"computeIfAbsent(...)");
        AndroidProfilerToolWindow window = androidProfilerToolWindow;
        Icon icon = StudioIcons.Shell.Toolbar.PROFILER;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"PROFILER");
        FakeToolWindow frame = new FakeToolWindow($project, "Android Studio Profiler", icon, window.getProfilersPanel());
        CommonWindowWrapper $this$createWindow_u24lambda_u244_u24lambda_u243 = commonWindowWrapper = new CommonWindowWrapper($windowId, frame);
        boolean bl = false;
        $this$createWindow_u24lambda_u244_u24lambda_u243.addWindowCloseListener((Function0<Unit>)((Function0)() -> ProfilerServiceImpl.createWindow$lambda$4$lambda$3$lambda$2(this$0, $windowId)));
        CommonWindowWrapper windowWrapper = commonWindowWrapper;
        AndroidNotification.setFallbackNotificationDestination((Project)$project, (JFrame)frame);
        this$0.windowIdToProject.put($windowId, $project);
        this$0.windowWrappers.put($windowId, windowWrapper);
    }

    private static final boolean startProfiler$lambda$6(long $processLaunchTimeMinBoundNs, Common.Process it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getStartTimestampNs() >= $processLaunchTimeMinBoundNs;
    }
}

