/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.game;

import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.game.ArgumentParser;
import com.android.tools.game.AvdManagerServiceImpl;
import com.android.tools.game.CommonService;
import com.android.tools.game.CommonWindowWrapper;
import com.android.tools.game.DeviceFileExplorerServiceImpl;
import com.android.tools.game.GameToolsServer;
import com.android.tools.game.LogcatServiceImpl;
import com.android.tools.game.ProfilerServiceImpl;
import com.android.tools.game.SdkManagerServiceImpl;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.analytics.AndroidStudioAnalytics;
import com.intellij.ide.CliResult;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.platform.ide.bootstrap.SplashManagerKt;
import java.awt.Font;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\"#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0018\u001a\u00020\u0019X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006$"}, d2={"Lcom/android/tools/game/GameToolsStarter;", "Lcom/intellij/openapi/application/ApplicationStarter;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "commandName", "", "getCommandName", "()Ljava/lang/String;", "main", "", "args", "", "fatalHeadless", "", "message", "fatalDisplay", "startApp", "Lcom/android/tools/game/CommonWindowWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "app", "Lcom/android/tools/game/GameToolsStarter$AppWindow;", "isHeadless", "", "()Z", "requiredModality", "", "getRequiredModality", "()I", "initializeSdk", "sdkPath", "Ljava/io/File;", "Mode", "AppWindow", "android.game-tools.main"})
@SourceDebugExtension(value={"SMAP\nGameToolsStarter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameToolsStarter.kt\ncom/android/tools/game/GameToolsStarter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,280:1\n14#2:281\n37#3:282\n36#3,3:283\n1#4:286\n*S KotlinDebug\n*F\n+ 1 GameToolsStarter.kt\ncom/android/tools/game/GameToolsStarter\n*L\n54#1:281\n84#1:282\n84#1:283,3\n*E\n"})
public final class GameToolsStarter
implements ApplicationStarter {
    @NotNull
    private final Logger logger;
    @NotNull
    private final String commandName;
    private final boolean isHeadless;
    private final int requiredModality;

    public GameToolsStarter() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GameToolsStarter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.commandName = "game-tools";
        this.isHeadless = true;
        this.requiredModality = 2;
    }

    @NotNull
    public String getCommandName() {
        return this.commandName;
    }

    public void main(@NotNull List<String> args) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        ArgumentParser params = new ArgumentParser();
        try {
            Collection $this$toTypedArray$iv = args;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            params.parse(thisCollection$iv.toArray(new String[0]));
        }
        catch (IllegalArgumentException e) {
            this.fatalHeadless("Failed to parse arguments: " + e.getMessage());
            throw new KotlinNothingValueException();
        }
        try {
            String message;
            File sdkPath;
            File file;
            AppWindow appWindow;
            Mode mode;
            Integer port;
            block21: {
                Function0[] sdkPathOptions;
                AppWindow appWindow2;
                Mode mode2;
                Function0[] it;
                String string = params.getPort();
                port = string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
                Function0[] function0Array = params.getMode();
                if (function0Array != null) {
                    it = function0Array;
                    boolean bl = false;
                    mode2 = Mode.valueOf((String)it);
                } else {
                    mode2 = null;
                }
                mode = mode2;
                String string2 = params.getAppWindow();
                if (string2 != null) {
                    String it2 = string2;
                    int n = 0;
                    appWindow2 = AppWindow.valueOf(it2);
                } else {
                    appWindow2 = null;
                }
                appWindow = appWindow2;
                it = new Function0[]{() -> GameToolsStarter.main$lambda$3(params), GameToolsStarter::main$lambda$5, GameToolsStarter::main$lambda$6, GameToolsStarter::main$lambda$7};
                for (Function0 it3 : sdkPathOptions = it) {
                    boolean bl = false;
                    file = (File)it3.invoke();
                    if (file == null) {
                        continue;
                    }
                    break block21;
                }
                file = null;
            }
            if ((sdkPath = file) == null) {
                message = "Cannot find Android SDK on your system. Please install the Android SDK and set the 'ANDROID_SDK_ROOT' environment variable.";
                if (mode == Mode.APP) {
                    this.fatalDisplay(message);
                    throw new KotlinNothingValueException();
                }
                this.fatalHeadless(message);
                throw new KotlinNothingValueException();
            }
            File file2 = sdkPath.getAbsoluteFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAbsoluteFile(...)");
            this.initializeSdk(FilesKt.normalize((File)file2));
            AndroidStudioAnalytics.getInstance().initializeAndroidStudioUsageTrackerAndPublisher();
            Runtime.getRuntime().addShutdownHook(new Thread(GameToolsStarter::main$lambda$9));
            SplashManagerKt.hideSplash();
            String $this$main_u24lambda_u2410 = message = KeymapManager.getInstance().getActiveKeymap();
            boolean bl = false;
            $this$main_u24lambda_u2410.removeAllActionShortcuts("GotoAction");
            $this$main_u24lambda_u2410.removeAllActionShortcuts("ShowSettings");
            AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.GAME_TOOLS_PING).setProductDetails(AndroidStudioUsageTracker.getProductDetails()).setMachineDetails(AndroidStudioUsageTracker.getMachineDetails((File)new File(PathManager.getHomePath()))).setJvmDetails(CommonMetricsData.getJvmDetails());
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setJvmDetails(...)");
            UsageTracker.log((AndroidStudioEvent.Builder)builder);
            Project project = ProjectManagerEx.Companion.getInstanceEx().getDefaultProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getDefaultProject(...)");
            Project project2 = project;
            Mode mode3 = mode;
            switch (mode3 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[mode3.ordinal()]) {
                case 1: {
                    if (port == null) {
                        this.fatalHeadless("You must specify a port with '--port' in SERVER mode.");
                        throw new KotlinNothingValueException();
                    }
                    new GameToolsServer(project2, port, null, null, null, null, null, 124, null).start();
                    break;
                }
                case 2: {
                    String options;
                    if (appWindow == null) {
                        options = ArraysKt.joinToString$default((Object[])AppWindow.values(), (CharSequence)"|", null, null, (int)0, null, GameToolsStarter::main$lambda$11, (int)30, null);
                        this.fatalDisplay("You must specify a valid window to open with '--app-window [" + options + "] in VERIFY mode.");
                        throw new KotlinNothingValueException();
                    }
                    this.startApp(project2, appWindow);
                    break;
                }
                case 3: {
                    String options;
                    if (appWindow == null) {
                        options = ArraysKt.joinToString$default((Object[])AppWindow.values(), (CharSequence)"|", null, null, (int)0, null, GameToolsStarter::main$lambda$12, (int)30, null);
                        this.fatalHeadless("You must specify a valid window to open with '--app-window [" + options + "] in VERIFY mode.");
                        throw new KotlinNothingValueException();
                    }
                    CommonWindowWrapper window = this.startApp(project2, appWindow);
                    window.addWindowOpenListener((Function0<Unit>)((Function0)() -> GameToolsStarter.main$lambda$13(window)));
                    break;
                }
                case 4: {
                    GameToolsServer gameToolsServer = new GameToolsServer(project2, 0, null, null, null, null, null, 124, null);
                    gameToolsServer.start();
                    gameToolsServer.shutdown();
                    System.exit(0);
                    throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                }
                default: {
                    String options = ArraysKt.joinToString$default((Object[])Mode.values(), (CharSequence)"|", null, null, (int)0, null, GameToolsStarter::main$lambda$14, (int)30, null);
                    this.fatalHeadless("You must specify a mode with '--mode " + options + ".");
                    throw new KotlinNothingValueException();
                }
            }
        }
        catch (Throwable e) {
            this.logger.error("GameToolsServer crashed!", e);
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Void fatalHeadless(String message) {
        File ideaLog = new File(PathManager.getLogPath(), "idea.log");
        try {
            this.logger.error(message + " For more details, see " + ideaLog);
        }
        finally {
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Void fatalDisplay(String message) {
        File ideaLog = new File(PathManager.getLogPath(), "idea.log");
        try {
            Font $this$fatalDisplay_u24lambda_u2415 = new JLabel().getFont();
            boolean bl = false;
            String style = StringsKt.trimIndent((String)("\n      font-family:" + $this$fatalDisplay_u24lambda_u2415.getFamily() + ";\n      font-weight:" + ($this$fatalDisplay_u24lambda_u2415.isBold() ? "bold" : "normal") + ";\n      font-size:" + $this$fatalDisplay_u24lambda_u2415.getSize() + "pt;\n    "));
            JEditorPane messagePane = new JEditorPane("text/html", StringsKt.trimIndent((String)("\n      <html>\n        <body style=\"" + style + "\">\n          " + message + "\n          <br>\n          For more details, see the <a href=\"#placeholder\">idea.log</a>.\n        </body>\n      </html>\n      ")));
            messagePane.addHyperlinkListener(arg_0 -> GameToolsStarter.fatalDisplay$lambda$16(ideaLog, arg_0));
            messagePane.setEditable(false);
            messagePane.setBackground(new JLabel().getBackground());
            JOptionPane.showMessageDialog(null, messagePane, "Error", 0);
        }
        finally {
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private final CommonWindowWrapper startApp(Project project, AppWindow app) {
        CommonService service = switch (WhenMappings.$EnumSwitchMapping$1[app.ordinal()]) {
            case 1 -> new ProfilerServiceImpl();
            case 2 -> new SdkManagerServiceImpl();
            case 3 -> new AvdManagerServiceImpl();
            case 4 -> new DeviceFileExplorerServiceImpl();
            case 5 -> new LogcatServiceImpl();
            default -> throw new NoWhenBranchMatchedException();
        };
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String windowId = string;
        CommonWindowWrapper window = service.createWindow(windowId, project);
        window.addWindowCloseListener((Function0<Unit>)((Function0)GameToolsStarter::startApp$lambda$17));
        return window;
    }

    public boolean isHeadless() {
        return this.isHeadless;
    }

    public int getRequiredModality() {
        return this.requiredModality;
    }

    private final void initializeSdk(File sdkPath) {
        block3: {
            block2: {
                new File(sdkPath, "platforms").mkdirs();
                ApplicationManager.getApplication().runWriteAction(() -> GameToolsStarter.initializeSdk$lambda$18(sdkPath));
                if (IdeSdks.getInstance().getAndroidSdkPath() == null) break block2;
                File file = IdeSdks.getInstance().getAndroidSdkPath();
                Intrinsics.checkNotNull((Object)file);
                if (file.exists()) break block3;
            }
            this.fatalHeadless("Cannot set Android SDK path");
            throw new KotlinNothingValueException();
        }
    }

    public void premain(@NotNull List<String> args) {
        super.premain(args);
    }

    public boolean canProcessExternalCommandLine() {
        return super.canProcessExternalCommandLine();
    }

    @Nullable
    public Object processExternalCommandLine(@NotNull List<String> args, @Nullable String currentDirectory, @NotNull Continuation<? super CliResult> $completion) {
        return super.processExternalCommandLine(args, currentDirectory, $completion);
    }

    private static final File main$lambda$3(ArgumentParser $params) {
        File file;
        String string = $params.getSdkPath();
        if (string != null) {
            String it = string;
            boolean bl = false;
            file = new File(it);
        } else {
            file = null;
        }
        return file;
    }

    private static final File main$lambda$5() {
        File file;
        String string = System.getenv("ANDROID_SDK_ROOT");
        if (string != null) {
            String it = string;
            boolean bl = false;
            file = new File(it);
        } else {
            file = null;
        }
        return file;
    }

    private static final File main$lambda$6() {
        return IdeSdks.getInstance().getAndroidSdkPath();
    }

    private static final File main$lambda$7() {
        return AndroidSdkUtils.findValidAndroidSdkPath();
    }

    private static final void main$lambda$9() {
        UsageTracker.deinitialize();
    }

    private static final CharSequence main$lambda$11(AppWindow it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return it.toString();
    }

    private static final CharSequence main$lambda$12(AppWindow it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return it.toString();
    }

    private static final Unit main$lambda$13(CommonWindowWrapper $window) {
        $window.closeWindow();
        return Unit.INSTANCE;
    }

    private static final CharSequence main$lambda$14(Mode it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return it.toString();
    }

    private static final void fatalDisplay$lambda$16(File $ideaLog, HyperlinkEvent e) {
        if (Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            RevealFileAction.openFile((File)$ideaLog);
        }
    }

    private static final Unit startApp$lambda$17() {
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private static final void initializeSdk$lambda$18(File $sdkPath) {
        IdeSdks.getInstance().setAndroidSdkPath($sdkPath);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/android/tools/game/GameToolsStarter$AppWindow;", "", "<init>", "(Ljava/lang/String;I)V", "PROFILER", "SDK_MANAGER", "AVD_MANAGER", "DEVICE_EXPLORER", "LOGCAT", "android.game-tools.main"})
    private static final class AppWindow
    extends Enum<AppWindow> {
        public static final /* enum */ AppWindow PROFILER = new AppWindow();
        public static final /* enum */ AppWindow SDK_MANAGER = new AppWindow();
        public static final /* enum */ AppWindow AVD_MANAGER = new AppWindow();
        public static final /* enum */ AppWindow DEVICE_EXPLORER = new AppWindow();
        public static final /* enum */ AppWindow LOGCAT = new AppWindow();
        private static final /* synthetic */ AppWindow[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AppWindow[] values() {
            return (AppWindow[])$VALUES.clone();
        }

        public static AppWindow valueOf(String value) {
            return Enum.valueOf(AppWindow.class, value);
        }

        @NotNull
        public static EnumEntries<AppWindow> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = appWindowArray = new AppWindow[]{AppWindow.PROFILER, AppWindow.SDK_MANAGER, AppWindow.AVD_MANAGER, AppWindow.DEVICE_EXPLORER, AppWindow.LOGCAT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/game/GameToolsStarter$Mode;", "", "<init>", "(Ljava/lang/String;I)V", "SERVER", "APP", "VERIFY", "VERIFY_SERVER", "android.game-tools.main"})
    private static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode SERVER = new Mode();
        public static final /* enum */ Mode APP = new Mode();
        public static final /* enum */ Mode VERIFY = new Mode();
        public static final /* enum */ Mode VERIFY_SERVER = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        @NotNull
        public static EnumEntries<Mode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.SERVER, Mode.APP, Mode.VERIFY, Mode.VERIFY_SERVER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Mode.values().length];
            try {
                nArray[Mode.SERVER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.APP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.VERIFY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.VERIFY_SERVER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[AppWindow.values().length];
            try {
                nArray[AppWindow.PROFILER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppWindow.SDK_MANAGER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppWindow.AVD_MANAGER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppWindow.DEVICE_EXPLORER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppWindow.LOGCAT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

