/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrTargetRunConfigurationBinder;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationBaseProducer;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationLanguageSupport;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrTestRunConfigurationProducer<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, CONFIGURATION extends CidrRunConfiguration<BC, TARGET>, TEST_OBJECT>
extends CidrTestRunConfigurationBaseProducer<BC, TARGET, CONFIGURATION, TEST_OBJECT> {
    public static final Key<String> TEST_TARGET_NAME_KEY = Key.create((String)"TEST_TARGET_NAME_KEY");

    protected CidrTestRunConfigurationProducer(@NotNull CidrTargetRunConfigurationBinder<BC, TARGET, ? super CONFIGURATION> binder) {
        if (binder == null) {
            CidrTestRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        super(binder);
    }

    @Override
    protected boolean doSetupConfigurationFromContext(@NotNull CONFIGURATION configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        List<CidrBuildTarget> targetsForFile;
        if (configuration == null) {
            CidrTestRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            CidrTestRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (sourceElement == null) {
            CidrTestRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (!super.doSetupConfigurationFromContext(configuration, context, sourceElement)) {
            return false;
        }
        PsiFile containingFile = ((PsiElement)sourceElement.get()).getContainingFile();
        String testTargetName = (String)TEST_TARGET_NAME_KEY.get((UserDataHolder)containingFile);
        if (testTargetName != null) {
            CidrBuildConfigurationHelper helper = configuration.getHelper();
            CidrBuildTarget firstSuitableTarget = helper.findFirstSuitableTarget(testTargetName);
            if (firstSuitableTarget == null) {
                return false;
            }
            targetsForFile = Collections.singletonList(firstSuitableTarget);
        } else {
            targetsForFile = this.getTargetsForFile(containingFile, this::isTestTarget);
        }
        this.setupTarget(configuration, targetsForFile);
        return true;
    }

    protected abstract boolean isTestTarget(@NotNull TARGET var1);

    @Override
    @Nullable
    protected CidrTestScopeElement determineScope(@NotNull List<CidrTestScopeElement> objects) {
        if (objects == null) {
            CidrTestRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        return this.foldScope(ContainerUtil.mapNotNull(objects, e -> this.containingFileCanUseFramework(this.getElement((CidrTestScopeElement)e)) ? this.determineScope((CidrTestScopeElement)e) : null));
    }

    @Override
    @NotNull
    protected List<CidrTestScopeElement> findTestObjects(@NotNull ConfigurationContext context) {
        if (context == null) {
            CidrTestRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        List list = ContainerUtil.mapNotNull(this.getLocations(context), e -> this.containingFileCanUseFramework(e.getPsiElement()) ? this.findTestObject((Location)e) : null);
        if (list == null) {
            CidrTestRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    protected CidrTestScopeElement findTestObject(@NotNull Location location) {
        if (location == null) {
            CidrTestRunConfigurationProducer.$$$reportNull$$$0(7);
        }
        return this.getTestFramework().findTestObject(location.getPsiElement());
    }

    @Contract(value="null -> null")
    @Nullable
    private CidrTestRunConfigurationData getDelegate(CONFIGURATION configuration) {
        return configuration instanceof CidrTestRunConfiguration ? ((CidrTestRunConfiguration)configuration).getTestData() : null;
    }

    @Contract(pure=true)
    protected boolean containingFileCanUseFramework(@NotNull PsiElement context) {
        if (context == null) {
            CidrTestRunConfigurationProducer.$$$reportNull$$$0(8);
        }
        return this.getTestFramework().isAvailable(context.getContainingFile());
    }

    @Override
    @NotNull
    public String getPatternSeparatorInCommandLine() {
        String string = this.getTestFramework().getPatternSeparatorInCommandLine();
        if (string == null) {
            CidrTestRunConfigurationProducer.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    protected abstract CidrTestRunConfigurationLanguageSupport getTestFramework();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrTestRunConfigurationProducer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestRunConfigurationProducer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findTestObjects";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternSeparatorInCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doSetupConfigurationFromContext";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "determineScope";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findTestObjects";
                break;
            }
            case 6: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findTestObject";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "containingFileCanUseFramework";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 9 -> new IllegalStateException(string);
        };
    }
}

