/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.editor;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.ndk.run.editor.ChooseSymbolDirectoryPanel;
import com.android.tools.ndk.run.editor.StringListEntryPanel;
import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class NativeAndroidDebuggerPanel {
    private final Project myProject;
    private JPanel myPanel;
    private ChooseSymbolDirectoryPanel mySymDirsPanel;
    private JTextField myLoggingTargetChannelsField;
    private JBTabbedPane myOptionListsPane;
    private JCheckBox myShowStaticVarsCheckBox;
    private JCheckBox myShowOptimizedWarningCheckBox;
    private JCheckBox myAttachOnWaitForDebugger;
    private JCheckBox myDebugSandboxSdkCheckBox;
    private StringListEntryPanel myLldbStartupCommandsPanel;
    private StringListEntryPanel myLldbPostAttachCommandsPanel;

    public NativeAndroidDebuggerPanel(@NotNull Project project, boolean showAttachOnWaitForDebugger, boolean showDebugSandboxSdk) {
        this.myProject = project;
        this.setupUI();
        this.myLldbStartupCommandsPanel = this.buildOptionListTabPane("LLDB Startup Commands");
        this.myLldbPostAttachCommandsPanel = this.buildOptionListTabPane("LLDB Post Attach Commands");
        if (!((Boolean)StudioFlags.ATTACH_ON_WAIT_FOR_DEBUGGER.get()).booleanValue() || !showAttachOnWaitForDebugger) {
            this.myAttachOnWaitForDebugger.setEnabled(false);
            this.myAttachOnWaitForDebugger.setVisible(false);
        }
        if (!((Boolean)StudioFlags.LAUNCH_SANDBOX_SDK_PROCESS_WITH_DEBUGGER_ATTACHED_ON_DEBUG.get()).booleanValue() || !showDebugSandboxSdk) {
            this.myDebugSandboxSdkCheckBox.setEnabled(false);
            this.myDebugSandboxSdkCheckBox.setVisible(false);
        }
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public boolean showStaticVars() {
        return this.myShowStaticVarsCheckBox.isSelected();
    }

    public void setShowStaticVars(boolean showStaticVars) {
        this.myShowStaticVarsCheckBox.setSelected(showStaticVars);
    }

    public boolean attachOnWaitForDebugger() {
        return this.myAttachOnWaitForDebugger.isSelected();
    }

    public void setAttachOnWaitForDebugger(boolean attachOnWaitForDebugger) {
        this.myAttachOnWaitForDebugger.setSelected(attachOnWaitForDebugger);
    }

    public boolean debugSandboxSdk() {
        return this.myDebugSandboxSdkCheckBox.isSelected();
    }

    public void setDebugSandboxSdk(boolean debugSandboxSdk) {
        this.myDebugSandboxSdkCheckBox.setSelected(debugSandboxSdk);
    }

    public boolean showOptimizedWarning() {
        return this.myShowOptimizedWarningCheckBox.isSelected();
    }

    public void setShowOptimizedWarning(boolean value) {
        this.myShowOptimizedWarningCheckBox.setSelected(value);
    }

    @NotNull
    public ChooseSymbolDirectoryPanel getSymbolDirectoryPanel() {
        return this.mySymDirsPanel;
    }

    @NotNull
    public String getTargetLoggingChannels() {
        String logChannels = this.myLoggingTargetChannelsField.getText().trim();
        return logChannels.replaceAll("[^a-z\\-\\s:]", "");
    }

    public void setTargetLoggingChannels(@NotNull String targetLoggingChannels) {
        this.myLoggingTargetChannelsField.setText(targetLoggingChannels);
    }

    @NotNull
    public List<String> getUserStartupCommands() {
        return this.myLldbStartupCommandsPanel.getEntries();
    }

    public void setUserStartupCommands(@NotNull List<String> userStartupCommands) {
        this.myLldbStartupCommandsPanel.setEntries(userStartupCommands);
    }

    @NotNull
    public List<String> getUserPostAttachCommands() {
        return this.myLldbPostAttachCommandsPanel.getEntries();
    }

    public void setUserPostAttachCommands(@NotNull List<String> userPostAttachCommands) {
        this.myLldbPostAttachCommandsPanel.setEntries(userPostAttachCommands);
    }

    @NotNull
    private StringListEntryPanel buildOptionListTabPane(String tabName) {
        StringListEntryPanel panel = new StringListEntryPanel();
        this.myOptionListsPane.add(tabName, (Component)panel);
        return panel;
    }

    private void createUIComponents() {
        this.mySymDirsPanel = new ChooseSymbolDirectoryPanel(this.myProject);
    }

    private void setupUI() {
        this.createUIComponents();
        this.myPanel = new JPanel();
        this.myPanel.setLayout((LayoutManager)new GridLayoutManager(8, 3, new Insets(0, 0, 0, 0), -1, -1));
        Spacer spacer1 = new Spacer();
        this.myPanel.add((Component)spacer1, new GridConstraints(4, 2, 4, 1, 0, 2, 1, 4, null, null, null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.myPanel.add((Component)panel1, new GridConstraints(6, 0, 1, 2, 1, 1, 3, 3, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        panel1.add((Component)spacer2, new GridConstraints(0, 0, 1, 3, 0, 2, 1, 4, null, null, null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myPanel.add((Component)panel2, new GridConstraints(7, 0, 1, 2, 0, 3, 3, 5, null, null, null, 0, false));
        panel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Logging", (int)0, (int)0, null, null));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setText("Target channels:");
        panel2.add((Component)jBLabel1, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer3 = new Spacer();
        panel2.add((Component)spacer3, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.myLoggingTargetChannelsField = new JTextField();
        panel2.add((Component)this.myLoggingTargetChannelsField, new GridConstraints(0, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.myOptionListsPane = new JBTabbedPane();
        this.myPanel.add((Component)this.myOptionListsPane, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null, 0, false));
        JPanel panel3 = new JPanel();
        panel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myOptionListsPane.addTab("Symbol Directories", (Component)panel3);
        panel3.add((Component)this.mySymDirsPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 2, new Dimension(-1, 60), new Dimension(-1, 60), null, 0, false));
        this.myShowStaticVarsCheckBox = new JCheckBox();
        this.myShowStaticVarsCheckBox.setText("Show static/global variables in the Variables Pane");
        this.myPanel.add((Component)this.myShowStaticVarsCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myShowOptimizedWarningCheckBox = new JCheckBox();
        this.myShowOptimizedWarningCheckBox.setText("Warn when debugging optimized code");
        this.myPanel.add((Component)this.myShowOptimizedWarningCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myAttachOnWaitForDebugger = new JCheckBox();
        this.myAttachOnWaitForDebugger.setText("Automatically attach on Debug.waitForDebugger()");
        this.myPanel.add((Component)this.myAttachOnWaitForDebugger, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myDebugSandboxSdkCheckBox = new JCheckBox();
        this.myDebugSandboxSdkCheckBox.setText("Launch and attach debugger to Sandbox SDK process on start-up");
        this.myPanel.add((Component)this.myDebugSandboxSdkCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
    }
}

