/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run;

import com.android.ddmlib.Client;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientShellHelper {
    public static final String RUNAS = "run-as";
    public static final String USER_ARG = "--user";
    @NotNull
    private final Client myClient;
    @Nullable
    private final String myPackageNameOverride;

    public ClientShellHelper(@NotNull Client client, @NotNull String applicationId) {
        this.myClient = client;
        this.myPackageNameOverride = applicationId.equals(this.myClient.getClientData().getPackageName()) ? null : applicationId;
    }

    @NotNull
    public String getRunAsCommand(@NotNull String command) {
        String prefix = String.format("%s %s", RUNAS, this.getPackageName());
        if (this.isRestrictedUser()) {
            prefix = String.format("%s %s %d", prefix, USER_ARG, this.myClient.getClientData().getUserId());
        }
        return prefix + " " + command;
    }

    @NotNull
    public String getDataDir() {
        if (this.myPackageNameOverride == null) {
            return this.myClient.getClientData().getDataDir();
        }
        String clientDataDir = this.myClient.getClientData().getDataDir();
        if (this.myClient.getClientData().getPackageName() == null) {
            return clientDataDir;
        }
        return clientDataDir.replace(this.myClient.getClientData().getPackageName(), this.myPackageNameOverride);
    }

    @Nullable
    public String getPackageName() {
        return this.myPackageNameOverride != null ? this.myPackageNameOverride : this.myClient.getClientData().getPackageName();
    }

    public boolean isRestrictedUser() {
        return this.myClient.getClientData().isValidUserId() && this.myClient.getClientData().getUserId() > 0;
    }
}

