/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.completion;

import com.android.tools.ndk.jni.model.JvmMethodInfo;
import com.android.tools.ndk.jni.model.NativeMethodInfo;
import com.android.tools.ndk.jni.service.JniMethodResolver;
import com.android.tools.ndk.jni.utils.JniUsageEventReporter;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.google.wireless.android.sdk.stats.JniInspectionEvent;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\r"}, d2={"Lcom/android/tools/ndk/jni/completion/UnimplementedJniMethodStubProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "<init>", "()V", "addCompletions", "", "parameters", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "Companion", "android-ndk"})
@SourceDebugExtension(value={"SMAP\nUnimplementedJniMethodStubProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnimplementedJniMethodStubProvider.kt\ncom/android/tools/ndk/jni/completion/UnimplementedJniMethodStubProvider\n+ 2 JniUtils.kt\ncom/android/tools/ndk/jni/utils/JniUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n513#2,7:99\n522#2,9:116\n774#3:106\n865#3:107\n2746#3,3:108\n866#3:111\n1563#3:112\n1634#3,3:113\n*S KotlinDebug\n*F\n+ 1 UnimplementedJniMethodStubProvider.kt\ncom/android/tools/ndk/jni/completion/UnimplementedJniMethodStubProvider\n*L\n38#1:99,7\n38#1:116,9\n45#1:106\n45#1:107\n45#1:108,3\n45#1:111\n46#1:112\n46#1:113,3\n*E\n"})
public final class UnimplementedJniMethodStubProvider
extends CompletionProvider<CompletionParameters> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        void inspectionType$iv;
        void $this$reportJniPerf_u24default$iv;
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        LanguageUtils languageUtils = LanguageUtils.Companion.getInstance();
        Project project = parameters.getPosition().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (languageUtils.isCppSupportDisabled(project)) {
            return;
        }
        Project project2 = parameters.getPosition().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        JniInspectionEvent.JniInspectionType jniInspectionType = JniInspectionEvent.JniInspectionType.JNI_FUNCTION_STUB_COMPLETION_EVENT;
        int inverseSampleRate$iv = 1;
        boolean $i$f$reportJniPerf = false;
        JniUsageEventReporter reporter$iv = new JniUsageEventReporter((Project)$this$reportJniPerf_u24default$iv, (JniInspectionEvent.JniInspectionType)inspectionType$iv);
        Instant startTime$iv = Instant.now();
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            JvmMethodInfo it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            JniUsageEventReporter $this$addCompletions_u24lambda_u244 = reporter$iv;
            boolean bl = false;
            Project project4 = parameters.getPosition().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
            Project project5 = project4;
            JniMethodResolver jniMethodResolver = JniMethodResolver.Companion.getInstance(project5);
            Iterable iterable = jniMethodResolver.getAllJavaOrKotlinNativeMethods();
            CompletionResultSet completionResultSet = result;
            boolean $i$f$filter = false;
            void var17_20 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl2;
                block10: {
                    it = (JvmMethodInfo)element$iv$iv;
                    boolean bl3 = false;
                    Iterable $this$none$iv = jniMethodResolver.resolveJavaOrKotlinMethod(it);
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            NativeMethodInfo it2 = (NativeMethodInfo)element$iv;
                            boolean bl4 = false;
                            if (!it2.isDefinition()) continue;
                            bl2 = false;
                            break block10;
                        }
                        bl2 = true;
                    }
                }
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (JvmMethodInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl5 = false;
                collection.add(LookupElementBuilder.create((String)(it.getClassName().getShortName() + "." + it.getDescription())).withBoldness(true).withCaseSensitivity(false).withLookupString("jniexport").withLookupString(JvmMethodInfo.toJniNativeMethodId$default(it, false, 1, null).getFunctionName()).withTailText(" JNI function definition").withIcon(PlatformIcons.FUNCTION_ICON).withInsertHandler((arg_0, arg_1) -> UnimplementedJniMethodStubProvider.addCompletions$lambda$4$lambda$3$lambda$2($this$addCompletions_u24lambda_u244, it, project5, arg_0, arg_1)));
            }
            completionResultSet.addAllElements((Iterable)((List)destination$iv$iv));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (JniUtilsKt.access$getRandom$p().nextInt(inverseSampleRate$iv) == 0) {
                Instant endTime$iv = Instant.now();
                JniUtilsKt.access$sendJniEvent((Project)$this$reportJniPerf_u24default$iv, JniInspectionEvent.newBuilder().setType((JniInspectionEvent.JniInspectionType)inspectionType$iv).setEventCategory(JniInspectionEvent.EventCategory.PERFORMANCE_EVENT).setPerformanceEvent(JniInspectionEvent.PerformanceEvent.newBuilder().setDelayMs((int)Duration.between(startTime$iv, endTime$iv).toMillis())));
            }
        }
    }

    private static final void addCompletions$lambda$4$lambda$3$lambda$2(JniUsageEventReporter $this_reportJniPerf, JvmMethodInfo $it, Project $project, InsertionContext context, LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        $this_reportJniPerf.reportJniUsage();
        PsiFile psiFile = context.getFile();
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.jetbrains.cidr.lang.psi.OCFile");
        OCFile ocFile = (OCFile)psiFile;
        int startOffset = context.getStartOffset();
        int replacementLength = context.getTailOffset() - context.getStartOffset();
        int insertedHeaderLength = Companion.insertJniHeaderIfNeeded(ocFile);
        PsiFile psiFile2 = context.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getFile(...)");
        String skeletonImpl = JvmMethodInfo.generateNativeMethod$default($it, JniUtilsKt.isCpp(psiFile2), false, 2, null);
        OCChangeUtil.changeText((Project)$project, (PsiFile)((PsiFile)ocFile), (int)(startOffset + insertedHeaderLength), (int)replacementLength, (String)skeletonImpl, (boolean)true);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/ndk/jni/completion/UnimplementedJniMethodStubProvider$Companion;", "", "<init>", "()V", "insertJniHeaderIfNeeded", "", "ocFile", "Lcom/jetbrains/cidr/lang/psi/OCFile;", "android-ndk"})
    public static final class Companion {
        private Companion() {
        }

        public final int insertJniHeaderIfNeeded(@NotNull OCFile ocFile) {
            int n;
            Intrinsics.checkNotNullParameter((Object)ocFile, (String)"ocFile");
            if (JniUtilsKt.hasJniHeader(ocFile)) {
                n = 0;
            } else {
                List list = ocFile.findIncludeDirectives();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findIncludeDirectives(...)");
                OCIncludeDirective lastInclude = (OCIncludeDirective)CollectionsKt.lastOrNull((List)list);
                OCIncludeDirective oCIncludeDirective = lastInclude;
                int insertIncludeLocation = oCIncludeDirective != null && (oCIncludeDirective = oCIncludeDirective.getTextRange()) != null ? oCIncludeDirective.getEndOffset() : 0;
                String insertedHeader = insertIncludeLocation == 0 ? "#include <jni.h>\n\n" : "\n#include <jni.h>";
                OCChangeUtil.changeText((Project)ocFile.getProject(), (PsiFile)((PsiFile)ocFile), (int)insertIncludeLocation, (int)0, (String)insertedHeader, (boolean)true);
                n = insertedHeader.length();
            }
            return n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

