/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.android.utils.Pair;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MemoryRegionMap {
    private static final Pattern MAPS_RECORD_PATTERN = Pattern.compile("^(\\p{XDigit}+)-(\\p{XDigit}+)\\s+(r|-)(w|-)(x|-)(p|s)\\s+(\\p{XDigit}+)\\s+(\\p{XDigit}+):(\\p{XDigit}+)\\s+(\\d+)\\s+(.*)$", 2);
    private final NavigableMap<Long, Region> myAddress2Region = new TreeMap<Long, Region>();
    private final List<Pattern> myFileNamePatterns;

    public MemoryRegionMap(List<String> fileNameFilters) {
        this.myFileNamePatterns = new ArrayList<Pattern>(fileNameFilters.size());
        for (String fileNameFilter : fileNameFilters) {
            this.myFileNamePatterns.add(Pattern.compile(fileNameFilter));
        }
    }

    public void addMapEntries(String[] maps) {
        for (String mapRegion : maps) {
            this.processSingleRegion(mapRegion);
        }
    }

    public void clear() {
        this.myAddress2Region.clear();
    }

    public Region getRegionByAddress(long address) {
        Map.Entry<Long, Region> entry = this.myAddress2Region.floorEntry(address);
        if (entry == null) {
            return null;
        }
        Region region = entry.getValue();
        if ((Long)region.getAddressMapRange().upperEndpoint() <= address) {
            return null;
        }
        return region;
    }

    private void processSingleRegion(String mapRegion) {
        Matcher matcher = MAPS_RECORD_PATTERN.matcher(mapRegion);
        if (!matcher.matches() || matcher.groupCount() != 11) {
            return;
        }
        Range addressRange = Range.closedOpen((Comparable)Long.valueOf(Long.parseUnsignedLong(matcher.group(1), 16)), (Comparable)Long.valueOf(Long.parseUnsignedLong(matcher.group(2), 16)));
        String fileName = matcher.group(11);
        boolean matchFound = this.myFileNamePatterns.isEmpty();
        for (Pattern fileNamePattern : this.myFileNamePatterns) {
            if (!fileNamePattern.matcher(fileName).matches()) continue;
            matchFound = true;
            break;
        }
        if (!matchFound) {
            return;
        }
        Region region = new Region();
        region.setAddressMapRange((Range<Long>)addressRange);
        region.setReadable(matcher.group(3).equals("r"));
        region.setWritable(matcher.group(4).equals("w"));
        region.setExecutable(matcher.group(5).equals("x"));
        region.setShared(matcher.group(6).equals("s"));
        region.setFileOffset(Long.parseUnsignedLong(matcher.group(7), 16));
        region.setDevice((Pair<Long, Long>)Pair.of((Object)Long.parseUnsignedLong(matcher.group(8), 16), (Object)Long.parseUnsignedLong(matcher.group(9), 16)));
        region.setInode(Long.parseUnsignedLong(matcher.group(10)));
        region.setFileName(fileName);
        this.myAddress2Region.put((Long)addressRange.lowerEndpoint(), region);
    }

    public static class Region {
        private String myFileName;
        private Range<Long> myAddressMapRange;
        private boolean myReadable = false;
        private boolean myWritable = false;
        private boolean myExecutable = false;
        private boolean myShared = false;
        private long myFileOffset = 0L;
        private Pair<Long, Long> myDevice;
        private long myInode = 0L;

        public String getFileName() {
            return this.myFileName;
        }

        public void setFileName(String fileName) {
            this.myFileName = fileName;
        }

        public Range<Long> getAddressMapRange() {
            return this.myAddressMapRange;
        }

        public void setAddressMapRange(Range<Long> addressMapRange) {
            this.myAddressMapRange = addressMapRange;
        }

        public boolean isReadable() {
            return this.myReadable;
        }

        public void setReadable(boolean readable) {
            this.myReadable = readable;
        }

        public boolean isWritable() {
            return this.myWritable;
        }

        public void setWritable(boolean writable) {
            this.myWritable = writable;
        }

        public boolean isExecutable() {
            return this.myExecutable;
        }

        public void setExecutable(boolean executable) {
            this.myExecutable = executable;
        }

        public boolean isShared() {
            return this.myShared;
        }

        public void setShared(boolean shared) {
            this.myShared = shared;
        }

        public long getFileOffset() {
            return this.myFileOffset;
        }

        public void setFileOffset(long fileOffset) {
            this.myFileOffset = fileOffset;
        }

        public Pair<Long, Long> getDevice() {
            return this.myDevice;
        }

        public void setDevice(Pair<Long, Long> device) {
            this.myDevice = device;
        }

        public long getInode() {
            return this.myInode;
        }

        public void setInode(long inode) {
            this.myInode = inode;
        }
    }
}

