/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.util;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Lists;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiStatement;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class StatementFilter
extends JavaRecursiveElementVisitor {
    private final String myFilterString;
    private final List<PsiStatement> myStatements = Lists.newArrayList();

    public StatementFilter(@NotNull String filterString) {
        this.myFilterString = CharMatcher.whitespace().removeFrom((CharSequence)filterString);
    }

    @NotNull
    public List<PsiStatement> getStatements() {
        return this.myStatements;
    }

    public void visitExpressionStatement(PsiExpressionStatement statement) {
        if (CharMatcher.whitespace().removeFrom((CharSequence)statement.getText()).contains(this.myFilterString)) {
            this.myStatements.add((PsiStatement)statement);
        }
    }

    public void visitDeclarationStatement(PsiDeclarationStatement statement) {
        if (CharMatcher.whitespace().removeFrom((CharSequence)statement.getText()).contains(this.myFilterString)) {
            this.myStatements.add((PsiStatement)statement);
        }
    }

    @NotNull
    public static List<PsiStatement> filterCodeBlock(@NotNull String filterString, @NotNull PsiCodeBlock codeBlock) {
        StatementFilter filter = new StatementFilter(filterString);
        codeBlock.accept((PsiElementVisitor)filter);
        return filter.getStatements();
    }

    @NotNull
    public static List<PsiStatement> filterStatements(@NotNull String filterString, @NotNull List<PsiStatement> statements) {
        StatementFilter filter = new StatementFilter(filterString);
        for (PsiStatement statement : statements) {
            statement.accept((PsiElementVisitor)filter);
        }
        return filter.getStatements();
    }
}

