/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.util;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.StringResourceWriter;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.google.urlassistant.PathData;
import com.google.urlassistant.PathType;
import com.google.urlassistant.datalayer.feature.LinkInfoUtilsKt;
import com.google.urlassistant.datalayer.model.HostAndPort;
import com.google.urlassistant.util.IntentFilterFixOutcome;
import com.google.urlassistant.util.ManifestUtils;
import com.google.urlassistant.util.UsageTrackerUtils;
import com.google.wireless.android.sdk.stats.AppLinksAssistantEvent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J[\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007\u00a2\u0006\u0002\u0010\u0011J\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007JT\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\bH\u0003J\u001f\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u000bH\u0001\u00a2\u0006\u0002\b\u001d\u00a8\u0006\u001e"}, d2={"Lcom/google/urlassistant/util/IntentFilterUtils;", "", "<init>", "()V", "createAndInsertDeepLinkIntentFilter", "Lcom/intellij/psi/xml/XmlTag;", "activityTag", "pathDataList", "", "Lcom/google/urlassistant/PathData;", "schemes", "", "hostPortPairs", "Lcom/google/urlassistant/datalayer/model/HostAndPort;", "mimeTypes", "order", "", "(Lcom/intellij/psi/xml/XmlTag;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/lang/Integer;)Lcom/intellij/psi/xml/XmlTag;", "fixSingleDeepLinkIntentFilter", "Lcom/google/urlassistant/util/IntentFilterFixOutcome;", "intentFilterTag", "eventSource", "Lcom/google/wireless/android/sdk/stats/AppLinksAssistantEvent$EventSource;", "createDeepLinkIntentFilter", "Lkotlin/Pair;", "", "getResourceItem", "Lcom/android/ide/common/resources/ResourceItem;", "stringReference", "getResourceItem$url_assistant", "url-assistant"})
@SourceDebugExtension(value={"SMAP\nIntentFilterUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntentFilterUtils.kt\ncom/google/urlassistant/util/IntentFilterUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,367:1\n1761#2,3:368\n1761#2,3:371\n1740#2,3:374\n1761#2,3:377\n1761#2,3:380\n1761#2,3:383\n1740#2,3:386\n1056#2:389\n1761#2,3:390\n1761#2,3:393\n1563#2:396\n1634#2,3:397\n1563#2:400\n1634#2,3:401\n1563#2:404\n1634#2,3:405\n*S KotlinDebug\n*F\n+ 1 IntentFilterUtils.kt\ncom/google/urlassistant/util/IntentFilterUtils\n*L\n104#1:368,3\n179#1:371,3\n180#1:374,3\n188#1:377,3\n189#1:380,3\n190#1:383,3\n195#1:386,3\n222#1:389\n348#1:390,3\n349#1:393,3\n253#1:396\n253#1:397,3\n254#1:400\n254#1:401,3\n255#1:404\n255#1:405,3\n*E\n"})
public final class IntentFilterUtils {
    @NotNull
    public static final IntentFilterUtils INSTANCE = new IntentFilterUtils();

    private IntentFilterUtils() {
    }

    @RequiresWriteLock
    @NotNull
    public final XmlTag createAndInsertDeepLinkIntentFilter(@NotNull XmlTag activityTag, @NotNull List<? extends PathData> pathDataList, @NotNull List<String> schemes, @NotNull List<HostAndPort> hostPortPairs, @NotNull List<String> mimeTypes, @Nullable Integer order) {
        boolean bl;
        String prefix;
        XmlTag intentFilter;
        block5: {
            Intrinsics.checkNotNullParameter((Object)activityTag, (String)"activityTag");
            Intrinsics.checkNotNullParameter(pathDataList, (String)"pathDataList");
            Intrinsics.checkNotNullParameter(schemes, (String)"schemes");
            Intrinsics.checkNotNullParameter(hostPortPairs, (String)"hostPortPairs");
            Intrinsics.checkNotNullParameter(mimeTypes, (String)"mimeTypes");
            Pair<String, Boolean> pair = this.createDeepLinkIntentFilter(activityTag, pathDataList, schemes, hostPortPairs, mimeTypes);
            String xmlString = (String)pair.component1();
            boolean fixedSuccessfully = (Boolean)pair.component2();
            intentFilter = activityTag.createChildTag("intent-filter", null, xmlString, false);
            prefix = activityTag.getPrefixByNamespace("http://schemas.android.com/apk/res/android");
            Iterable $this$any$iv = schemes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String p0 = (String)element$iv;
                    boolean bl2 = false;
                    if (!LinkInfoUtilsKt.isWebScheme(p0)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            intentFilter.setAttribute(prefix + ":autoVerify", "true");
        }
        if (order != null) {
            intentFilter.setAttribute(prefix + ":order", order.toString());
        }
        XmlTag res = activityTag.addSubTag(intentFilter, false);
        CodeStyleManager.getInstance((Project)activityTag.getProject()).reformat((PsiElement)activityTag);
        Intrinsics.checkNotNull((Object)res);
        return res;
    }

    public static /* synthetic */ XmlTag createAndInsertDeepLinkIntentFilter$default(IntentFilterUtils intentFilterUtils, XmlTag xmlTag, List list, List list2, List list3, List list4, Integer n, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            list4 = CollectionsKt.emptyList();
        }
        if ((n2 & 0x20) != 0) {
            n = null;
        }
        return intentFilterUtils.createAndInsertDeepLinkIntentFilter(xmlTag, list, list2, list3, list4, n);
    }

    @RequiresWriteLock
    @NotNull
    public final IntentFilterFixOutcome fixSingleDeepLinkIntentFilter(@NotNull XmlTag intentFilterTag, @Nullable AppLinksAssistantEvent.EventSource eventSource) {
        XmlTag it;
        boolean bl;
        boolean $i$f$any;
        Iterable $this$any$iv;
        List categories;
        XmlTag parentTag;
        String order;
        Set pathDataList;
        Set hostPortPairs;
        Set schemes;
        block54: {
            block61: {
                block58: {
                    block60: {
                        boolean bl2;
                        block53: {
                            Iterator it2;
                            block59: {
                                boolean bl3;
                                block52: {
                                    boolean bl4;
                                    boolean $i$f$any2;
                                    Iterable $this$any$iv2;
                                    block51: {
                                        Intrinsics.checkNotNullParameter((Object)intentFilterTag, (String)"intentFilterTag");
                                        List dataList = ManifestUtils.searchXmlTagsByName$default(intentFilterTag, "data", null, 4, null);
                                        schemes = new LinkedHashSet();
                                        hostPortPairs = new LinkedHashSet();
                                        pathDataList = new LinkedHashSet();
                                        order = intentFilterTag.getAttributeValue("order", "http://schemas.android.com/apk/res/android");
                                        if (!LinkInfoUtilsKt.isNullOrNumeric(order)) {
                                            return IntentFilterFixOutcome.NEEDS_MANUAL_FIX;
                                        }
                                        for (XmlTag data : dataList) {
                                            Iterator scheme;
                                            String mimeType;
                                            String string = mimeType = data.getAttributeValue("mimeType", "http://schemas.android.com/apk/res/android");
                                            boolean bl5 = string != null ? ((CharSequence)string).length() > 0 : false;
                                            if (bl5) {
                                                return IntentFilterFixOutcome.NOT_A_DEEPLINK;
                                            }
                                            Iterator iterator2 = scheme = data.getAttributeValue("scheme", "http://schemas.android.com/apk/res/android");
                                            boolean bl6 = iterator2 != null ? !StringsKt.isBlank((CharSequence)((CharSequence)((Object)iterator2))) : false;
                                            if (bl6) {
                                                schemes.add(scheme);
                                            }
                                            String host = data.getAttributeValue("host", "http://schemas.android.com/apk/res/android");
                                            String port = data.getAttributeValue("port", "http://schemas.android.com/apk/res/android");
                                            if (!LinkInfoUtilsKt.isNullOrNumeric(port)) {
                                                return IntentFilterFixOutcome.NEEDS_MANUAL_FIX;
                                            }
                                            if (host != null || port != null) {
                                                hostPortPairs.add(new HostAndPort(host, port));
                                            }
                                            String path = data.getAttributeValue("path", "http://schemas.android.com/apk/res/android");
                                            String pathPattern = data.getAttributeValue("pathPattern", "http://schemas.android.com/apk/res/android");
                                            String pathPrefix = data.getAttributeValue("pathPrefix", "http://schemas.android.com/apk/res/android");
                                            String pathAdvancedPattern = data.getAttributeValue("pathAdvancedPattern", "http://schemas.android.com/apk/res/android");
                                            String pathSuffix = data.getAttributeValue("pathSuffix", "http://schemas.android.com/apk/res/android");
                                            String string2 = path;
                                            boolean bl7 = string2 != null ? ((CharSequence)string2).length() > 0 : false;
                                            if (bl7) {
                                                pathDataList.add(new PathData(PathType.Path, path));
                                            }
                                            String string3 = pathPattern;
                                            boolean bl8 = string3 != null ? ((CharSequence)string3).length() > 0 : false;
                                            if (bl8) {
                                                pathDataList.add(new PathData(PathType.PathPattern, pathPattern));
                                            }
                                            String string4 = pathPrefix;
                                            boolean bl9 = string4 != null ? ((CharSequence)string4).length() > 0 : false;
                                            if (bl9) {
                                                pathDataList.add(new PathData(PathType.PathPrefix, pathPrefix));
                                            }
                                            String string5 = pathAdvancedPattern;
                                            boolean bl10 = string5 != null ? ((CharSequence)string5).length() > 0 : false;
                                            if (bl10) {
                                                pathDataList.add(new PathData(PathType.PathAdvancedPattern, pathAdvancedPattern));
                                            }
                                            String string6 = pathSuffix;
                                            boolean bl11 = string6 != null ? ((CharSequence)string6).length() > 0 : false;
                                            if (!bl11) continue;
                                            pathDataList.add(new PathData(PathType.PathSuffix, pathSuffix));
                                        }
                                        parentTag = intentFilterTag.getParentTag();
                                        if (schemes.isEmpty()) break block58;
                                        $this$any$iv2 = schemes;
                                        $i$f$any2 = false;
                                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                            bl4 = false;
                                        } else {
                                            for (Object element$iv : $this$any$iv2) {
                                                it2 = (String)element$iv;
                                                boolean bl12 = false;
                                                if (!LinkInfoUtilsKt.isWebScheme((String)((Object)it2))) continue;
                                                bl4 = true;
                                                break block51;
                                            }
                                            bl4 = false;
                                        }
                                    }
                                    if (!bl4) break block59;
                                    $this$any$iv2 = schemes;
                                    $i$f$any2 = false;
                                    if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                        bl3 = false;
                                    } else {
                                        for (Object element$iv : $this$any$iv2) {
                                            it2 = (String)element$iv;
                                            boolean bl13 = false;
                                            if (!(!LinkInfoUtilsKt.isWebScheme((String)((Object)it2)))) continue;
                                            bl3 = true;
                                            break block52;
                                        }
                                        bl3 = false;
                                    }
                                }
                                if (bl3) break block58;
                            }
                            if (!schemes.contains("http") && !schemes.contains("https")) break block60;
                            Iterable $this$all$iv = hostPortPairs;
                            boolean $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl2 = true;
                            } else {
                                for (Object element$iv : $this$all$iv) {
                                    it2 = (HostAndPort)element$iv;
                                    boolean bl14 = false;
                                    if (((HostAndPort)((Object)it2)).getHost() == null) continue;
                                    bl2 = false;
                                    break block53;
                                }
                                bl2 = true;
                            }
                        }
                        if (bl2) break block58;
                    }
                    if (parentTag != null) break block61;
                }
                return IntentFilterFixOutcome.NEEDS_MANUAL_FIX;
            }
            List actions = ManifestUtils.searchXmlTagsByName$default(intentFilterTag, "action", null, 4, null);
            categories = ManifestUtils.searchXmlTagsByName$default(intentFilterTag, "category", null, 4, null);
            $this$any$iv = actions;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (XmlTag)element$iv;
                    boolean bl15 = false;
                    if (!Intrinsics.areEqual((Object)it.getAttributeValue("name", "http://schemas.android.com/apk/res/android"), (Object)"android.intent.action.VIEW")) continue;
                    bl = true;
                    break block54;
                }
                bl = false;
            }
        }
        if (bl) {
            boolean bl16;
            block55: {
                $this$any$iv = categories;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl16 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (XmlTag)element$iv;
                        boolean bl17 = false;
                        if (!Intrinsics.areEqual((Object)it.getAttributeValue("name", "http://schemas.android.com/apk/res/android"), (Object)"android.intent.category.DEFAULT")) continue;
                        bl16 = true;
                        break block55;
                    }
                    bl16 = false;
                }
            }
            if (bl16) {
                boolean bl18;
                block56: {
                    $this$any$iv = categories;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl18 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (XmlTag)element$iv;
                            boolean bl19 = false;
                            if (!Intrinsics.areEqual((Object)it.getAttributeValue("name", "http://schemas.android.com/apk/res/android"), (Object)"android.intent.category.BROWSABLE")) continue;
                            bl18 = true;
                            break block56;
                        }
                        bl18 = false;
                    }
                }
                if (bl18 && (schemes.contains("http") || schemes.contains("https")) && Intrinsics.areEqual((Object)intentFilterTag.getAttributeValue("autoVerify", "http://schemas.android.com/apk/res/android"), (Object)"true")) {
                    boolean bl20;
                    block57: {
                        Iterable $this$all$iv = pathDataList;
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl20 = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                boolean bl21;
                                PathData pathData = (PathData)element$iv;
                                boolean bl22 = false;
                                if (pathData.getPathValue() != null) {
                                    boolean bl23;
                                    String it3;
                                    boolean bl24 = false;
                                    Intrinsics.checkNotNullExpressionValue((Object)XmlUtil.escape((String)it3), (String)"escape(...)");
                                    switch (WhenMappings.$EnumSwitchMapping$0[pathData.getPathType().ordinal()]) {
                                        case 1: 
                                        case 2: {
                                            String value;
                                            String escapedString;
                                            ResourceItem resolvedResourceItem = INSTANCE.getResourceItem$url_assistant(parentTag, escapedString);
                                            ResourceItem resourceItem = resolvedResourceItem;
                                            String string = resourceItem != null && (resourceItem = resourceItem.getResourceValue()) != null ? resourceItem.getValue() : (value = null);
                                            if (StringsKt.startsWith$default((CharSequence)escapedString, (char)'/', (boolean)false, (int)2, null) || value != null && StringsKt.startsWith$default((CharSequence)value, (char)'/', (boolean)false, (int)2, null)) {
                                                bl23 = true;
                                                break;
                                            }
                                            bl23 = false;
                                            break;
                                        }
                                        case 3: {
                                            Object pathPatternValue;
                                            String escapedString;
                                            Object object = INSTANCE.getResourceItem$url_assistant(parentTag, escapedString);
                                            if (object == null || (object = object.getResourceValue()) == null || (object = object.getValue()) == null) {
                                                object = escapedString;
                                            }
                                            if (StringsKt.startsWith$default((CharSequence)((CharSequence)(pathPatternValue = object)), (char)'/', (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)pathPatternValue, (String)".*", (boolean)false, (int)2, null)) {
                                                bl23 = true;
                                                break;
                                            }
                                            bl23 = false;
                                            break;
                                        }
                                        default: {
                                            bl23 = true;
                                        }
                                    }
                                    bl21 = bl23;
                                } else {
                                    bl21 = false;
                                }
                                if (bl21) continue;
                                bl20 = false;
                                break block57;
                            }
                            bl20 = true;
                        }
                    }
                    if (bl20) {
                        return IntentFilterFixOutcome.ALREADY_VALID;
                    }
                }
            }
        }
        Iterable $this$sortedBy$iv = hostPortPairs;
        boolean $i$f$sortedBy = false;
        Pair<String, Boolean> pair = this.createDeepLinkIntentFilter(parentTag, CollectionsKt.sortedWith((Iterable)pathDataList, (Comparator)new PathData.PathDataComparator()), CollectionsKt.sorted((Iterable)schemes), CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                HostAndPort it = (HostAndPort)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getHost());
                it = (HostAndPort)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getHost())));
            }
        }), CollectionsKt.emptyList());
        String newFilterXmlString = (String)pair.component1();
        boolean fixedSuccessfully = (Boolean)pair.component2();
        XmlTag newFilter = parentTag.createChildTag("intent-filter", null, newFilterXmlString, false);
        String prefix = parentTag.getPrefixByNamespace("http://schemas.android.com/apk/res/android");
        if (schemes.contains("http") || schemes.contains("https")) {
            newFilter.setAttribute(prefix + ":autoVerify", "http://schemas.android.com/apk/res/android", "true");
        }
        if (order != null) {
            newFilter.setAttribute(prefix + ":order", order.toString());
        }
        intentFilterTag.replace((PsiElement)newFilter);
        if (fixedSuccessfully) {
            Project project = intentFilterTag.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            UsageTrackerUtils.INSTANCE.log(project, (Function1<? super AppLinksAssistantEvent.Builder, AppLinksAssistantEvent.Builder>)((Function1)arg_0 -> IntentFilterUtils.fixSingleDeepLinkIntentFilter$lambda$12(eventSource, schemes, hostPortPairs, pathDataList, arg_0)));
            return IntentFilterFixOutcome.FIXED;
        }
        return IntentFilterFixOutcome.NEEDS_MANUAL_FIX;
    }

    public static /* synthetic */ IntentFilterFixOutcome fixSingleDeepLinkIntentFilter$default(IntentFilterUtils intentFilterUtils, XmlTag xmlTag, AppLinksAssistantEvent.EventSource eventSource, int n, Object object) {
        if ((n & 2) != 0) {
            eventSource = null;
        }
        return intentFilterUtils.fixSingleDeepLinkIntentFilter(xmlTag, eventSource);
    }

    @RequiresWriteLock
    private final Pair<String, Boolean> createDeepLinkIntentFilter(XmlTag activityTag, List<? extends PathData> pathDataList, List<String> schemes, List<HostAndPort> hostPortPairs, List<String> mimeTypes) {
        boolean bl;
        boolean bl2;
        boolean pathPatternViolationExists;
        Object xmlString;
        block18: {
            boolean bl3;
            block17: {
                String prefix = activityTag.getPrefixByNamespace("http://schemas.android.com/apk/res/android");
                xmlString = null;
                xmlString = StringsKt.trimIndent((String)("\n\n      <action " + prefix + ":name=\"android.intent.action.VIEW\"/>\n      <category " + prefix + ":name=\"android.intent.category.DEFAULT\"/>\n      <category " + prefix + ":name=\"android.intent.category.BROWSABLE\"/>\n      "));
                for (String string : schemes) {
                    xmlString = xmlString + "<data " + prefix + ":scheme=\"" + string + "\"/>";
                }
                for (HostAndPort hostAndPort : hostPortPairs) {
                    String port;
                    String string = hostAndPort.component1();
                    String string2 = port = hostAndPort.component2();
                    xmlString = xmlString + "<data " + prefix + ":host=\"" + string + "\"" + (String)(string2 != null ? " " + prefix + ":port=\"" + string2 + "\"" : "") + "/>";
                }
                for (String string : mimeTypes) {
                    if (!(((CharSequence)string).length() > 0)) continue;
                    xmlString = xmlString + "<data " + prefix + ":mimeType=\"" + string + "\"/>";
                }
                pathPatternViolationExists = false;
                block7: for (PathData pathData : pathDataList) {
                    String it;
                    if (pathData.getPathValue() == null) continue;
                    boolean bl32 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)XmlUtil.escape((String)it), (String)"escape(...)");
                    switch (WhenMappings.$EnumSwitchMapping$0[pathData.getPathType().ordinal()]) {
                        case 1: 
                        case 2: {
                            String value;
                            String escapedString;
                            ResourceItem resolvedResourceItem = INSTANCE.getResourceItem$url_assistant(activityTag, escapedString);
                            ResourceItem resourceItem = resolvedResourceItem;
                            String string = resourceItem != null && (resourceItem = resourceItem.getResourceValue()) != null ? resourceItem.getValue() : (value = null);
                            if (value == null) {
                                Object escapedStringWithSlash = StringsKt.startsWith$default((CharSequence)escapedString, (char)'/', (boolean)false, (int)2, null) ? escapedString : "/" + escapedString;
                                xmlString = xmlString + "<data " + prefix + ":" + pathData.getPathType() + "=\"" + (String)escapedStringWithSlash + "\"/>";
                                break;
                            }
                            if (StringsKt.startsWith$default((CharSequence)value, (char)'/', (boolean)false, (int)2, null)) continue block7;
                            Project project = activityTag.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                            StringResourceWriter.INSTANCE.setItemText(project, resolvedResourceItem, "/" + value);
                            xmlString = xmlString + "<data " + prefix + ":" + pathData.getPathType() + "=\"" + escapedString + "\"/>";
                            break;
                        }
                        case 3: {
                            Object pathPatternValue;
                            String escapedString;
                            Object object = INSTANCE.getResourceItem$url_assistant(activityTag, escapedString);
                            if (object == null || (object = object.getResourceValue()) == null || (object = object.getValue()) == null) {
                                object = escapedString;
                            }
                            if (!StringsKt.startsWith$default((CharSequence)((CharSequence)(pathPatternValue = object)), (char)'/', (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)pathPatternValue, (String)".*", (boolean)false, (int)2, null)) {
                                pathPatternViolationExists = true;
                            }
                            xmlString = xmlString + "<data " + prefix + ":" + pathData.getPathType() + "=\"" + escapedString + "\"/>";
                            break;
                        }
                        default: {
                            String escapedString;
                            xmlString = xmlString + "<data " + prefix + ":" + pathData.getPathType() + "=\"" + escapedString + "\"/>";
                        }
                    }
                }
                Iterable iterable = schemes;
                boolean $i$f$any = false;
                if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : iterable) {
                        String it = (String)element$iv;
                        boolean bl4 = false;
                        if (!LinkInfoUtilsKt.isWebScheme(it)) continue;
                        bl3 = true;
                        break block17;
                    }
                    bl3 = false;
                }
            }
            bl2 = bl3;
            Iterable $this$any$iv = schemes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl5 = false;
                    if (!(!LinkInfoUtilsKt.isWebScheme(it))) continue;
                    bl = true;
                    break block18;
                }
                bl = false;
            }
        }
        boolean bl4 = bl;
        return new Pair(xmlString, (Object)(!pathPatternViolationExists && (!bl2 || !bl4) ? 1 : 0));
    }

    @RequiresReadLock
    @Nullable
    public final ResourceItem getResourceItem$url_assistant(@NotNull XmlTag activityTag, @NotNull String stringReference) {
        Intrinsics.checkNotNullParameter((Object)activityTag, (String)"activityTag");
        Intrinsics.checkNotNullParameter((Object)stringReference, (String)"stringReference");
        if (!StringsKt.startsWith$default((CharSequence)stringReference, (char)'@', (boolean)false, (int)2, null)) {
            return null;
        }
        ResourceNamespace resourceNamespace = IdeResourcesUtil.getResourceNamespace((PsiElement)((PsiElement)activityTag));
        if (resourceNamespace == null) {
            return null;
        }
        ResourceNamespace namespace = resourceNamespace;
        StudioResourceRepositoryManager studioResourceRepositoryManager = StudioResourceRepositoryManager.getInstance((PsiElement)((PsiElement)activityTag));
        if (studioResourceRepositoryManager == null) {
            return null;
        }
        StudioResourceRepositoryManager manager = studioResourceRepositoryManager;
        ResourceRepository resourceRepository = manager.getResourcesForNamespace(namespace);
        if (resourceRepository == null) {
            return null;
        }
        ResourceRepository repository = resourceRepository;
        ResourceUrl resourceUrl = ResourceUrl.parse((String)stringReference);
        if (resourceUrl == null) {
            return null;
        }
        ResourceUrl parsedResourceUrl = resourceUrl;
        List list = repository.getResources(new ResourceReference(namespace, ResourceType.STRING, parsedResourceUrl.name));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getResources(...)");
        return (ResourceItem)CollectionsKt.firstOrNull((List)list);
    }

    private static final AppLinksAssistantEvent.Builder fixSingleDeepLinkIntentFilter$lambda$12(AppLinksAssistantEvent.EventSource $eventSource, Set $schemes, Set $hostPortPairs, Set $pathDataList, AppLinksAssistantEvent.Builder it) {
        Collection<AppLinksAssistantEvent.LinksRecord.PathType> collection;
        PathData pathData;
        Collection<String> collection2;
        Collection<String> collection3;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($eventSource != null) {
            it.setEventSource($eventSource);
        }
        Iterable iterable = $hostPortPairs;
        Collection collection4 = $schemes;
        UsageTrackerUtils usageTrackerUtils = UsageTrackerUtils.INSTANCE;
        AppLinksAssistantEvent.Builder builder = it;
        boolean $i$f$map = false;
        void var7_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            object = (HostAndPort)item$iv$iv;
            collection3 = destination$iv$iv;
            boolean bl = false;
            String host = ((HostAndPort)object).component1();
            collection3.add(host);
        }
        collection3 = (List)destination$iv$iv;
        $this$map$iv = $pathDataList;
        collection3 = collection3;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            object = (PathData)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(pathData.getPathValue());
        }
        collection2 = (List)destination$iv$iv;
        $this$map$iv = $pathDataList;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            pathData = (PathData)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(pathData.getPathType().asLinksRecordPathType());
        }
        collection = (List)destination$iv$iv;
        AppLinksAssistantEvent.Builder builder2 = builder.setLinksRecord(usageTrackerUtils.createLinksRecord(collection4, collection3, (List<String>)collection2, (List<? extends AppLinksAssistantEvent.LinksRecord.PathType>)collection).setInteractionType(AppLinksAssistantEvent.LinksRecord.InteractionType.BROKEN_LINK_AUTO_FIXED));
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"setLinksRecord(...)");
        return builder2;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PathType.values().length];
            try {
                nArray[PathType.Path.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathType.PathPrefix.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathType.PathPattern.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

