/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.ui.tables;

import com.android.annotations.concurrency.UiThread;
import com.google.urlassistant.datalayer.feature.listlinks.LinkInfo;
import com.google.urlassistant.ui.AppLinkOverview;
import com.google.urlassistant.ui.UrlAssistantSidePanel;
import com.google.urlassistant.ui.actions.UrlAssistantActions;
import com.google.urlassistant.ui.models.AppLinkColumnConfig;
import com.google.urlassistant.ui.models.AppLinkOverviewModel;
import com.google.urlassistant.ui.models.AppLinkOverviewTableModel;
import com.google.urlassistant.ui.models.BaseTableColumnOption;
import com.google.urlassistant.ui.tables.AppLinkTableExpandableItemsHandler;
import com.google.urlassistant.ui.tables.BaseOverviewTable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.TableCell;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.table.TableColumn;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@UiThread
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B9\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0014H\u0016J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0014J\b\u0010#\u001a\u00020\u001aH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006$"}, d2={"Lcom/google/urlassistant/ui/tables/AppLinkOverviewTable;", "Lcom/google/urlassistant/ui/tables/BaseOverviewTable;", "Lcom/google/urlassistant/ui/models/AppLinkColumnConfig;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "overviewModel", "Lcom/google/urlassistant/ui/models/AppLinkOverviewModel;", "tableModel", "Lcom/google/urlassistant/ui/models/AppLinkOverviewTableModel;", "sidePanelParent", "Lcom/google/urlassistant/ui/UrlAssistantSidePanel;", "appLinkOverviewParent", "Lcom/google/urlassistant/ui/AppLinkOverview;", "actions", "Lcom/google/urlassistant/ui/actions/UrlAssistantActions;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/google/urlassistant/ui/models/AppLinkOverviewModel;Lcom/google/urlassistant/ui/models/AppLinkOverviewTableModel;Lcom/google/urlassistant/ui/UrlAssistantSidePanel;Lcom/google/urlassistant/ui/AppLinkOverview;Lcom/google/urlassistant/ui/actions/UrlAssistantActions;)V", "hiddenColumns", "", "", "Ljavax/swing/table/TableColumn;", "actionColumnIndex", "getActionColumnIndex", "()I", "performAction", "", "rowIndex", "onColumnSelection", "column", "Lcom/google/urlassistant/ui/models/BaseTableColumnOption;", "hideColumn", "createExpandableItemsHandler", "Lcom/intellij/ui/ExpandableItemsHandler;", "Lcom/intellij/ui/TableCell;", "dispose", "url-assistant"})
@SourceDebugExtension(value={"SMAP\nAppLinkOverviewTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppLinkOverviewTable.kt\ncom/google/urlassistant/ui/tables/AppLinkOverviewTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n1869#2,2:150\n*S KotlinDebug\n*F\n+ 1 AppLinkOverviewTable.kt\ncom/google/urlassistant/ui/tables/AppLinkOverviewTable\n*L\n64#1:150,2\n*E\n"})
public final class AppLinkOverviewTable
extends BaseOverviewTable<AppLinkColumnConfig>
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final AppLinkOverviewModel overviewModel;
    @NotNull
    private final AppLinkOverviewTableModel tableModel;
    @NotNull
    private final UrlAssistantSidePanel sidePanelParent;
    @NotNull
    private final AppLinkOverview appLinkOverviewParent;
    @NotNull
    private final UrlAssistantActions actions;
    @NotNull
    private final Map<Integer, TableColumn> hiddenColumns;
    private final int actionColumnIndex;

    public AppLinkOverviewTable(@NotNull Project project, @NotNull AppLinkOverviewModel overviewModel, @NotNull AppLinkOverviewTableModel tableModel, @NotNull UrlAssistantSidePanel sidePanelParent, @NotNull AppLinkOverview appLinkOverviewParent, @NotNull UrlAssistantActions actions) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)overviewModel, (String)"overviewModel");
        Intrinsics.checkNotNullParameter((Object)tableModel, (String)"tableModel");
        Intrinsics.checkNotNullParameter((Object)sidePanelParent, (String)"sidePanelParent");
        Intrinsics.checkNotNullParameter((Object)appLinkOverviewParent, (String)"appLinkOverviewParent");
        Intrinsics.checkNotNullParameter((Object)actions, (String)"actions");
        super(tableModel, overviewModel, AppLinkColumnConfig.class);
        this.project = project;
        this.overviewModel = overviewModel;
        this.tableModel = tableModel;
        this.sidePanelParent = sidePanelParent;
        this.appLinkOverviewParent = appLinkOverviewParent;
        this.actions = actions;
        this.hiddenColumns = new LinkedHashMap();
        Disposer.register((Disposable)this.appLinkOverviewParent, (Disposable)this);
        Iterable $this$forEach$iv = this.tableModel.getColumnOptions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BaseTableColumnOption it = (BaseTableColumnOption)element$iv;
            boolean bl = false;
            if (it.getSelected()) continue;
            this.hideColumn(it);
        }
        this.tableModel.addColumnSelectionListener(arg_0 -> AppLinkOverviewTable._init_$lambda$1(this, arg_0));
        this.actionColumnIndex = AppLinkColumnConfig.ARROW_BUTTON.ordinal();
    }

    public /* synthetic */ AppLinkOverviewTable(Project project, AppLinkOverviewModel appLinkOverviewModel, AppLinkOverviewTableModel appLinkOverviewTableModel, UrlAssistantSidePanel urlAssistantSidePanel, AppLinkOverview appLinkOverview, UrlAssistantActions urlAssistantActions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            urlAssistantActions = UrlAssistantActions.Companion.getInstance();
        }
        this(project, appLinkOverviewModel, appLinkOverviewTableModel, urlAssistantSidePanel, appLinkOverview, urlAssistantActions);
    }

    @Override
    public int getActionColumnIndex() {
        return this.actionColumnIndex;
    }

    @Override
    public void performAction(int rowIndex) {
        LinkInfo linkInfo = (LinkInfo)CollectionsKt.getOrNull(this.tableModel.getLinkInfos(), (int)rowIndex);
        if (linkInfo == null) {
            return;
        }
        LinkInfo linkInfo2 = linkInfo;
        this.actions.openLinkDetails(this.project, this.sidePanelParent, linkInfo2);
    }

    private final void onColumnSelection(BaseTableColumnOption column) {
        if (column.getSelected()) {
            TableColumn tableColumn = this.hiddenColumns.get(column.getConfig().getOrdinal());
            if (tableColumn == null) {
                return;
            }
            TableColumn hiddenColumn = tableColumn;
            this.hiddenColumns.remove(hiddenColumn.getModelIndex());
            this.addColumn(hiddenColumn);
            int correctPosition = hiddenColumn.getModelIndex();
            int n = hiddenColumn.getModelIndex();
            for (int i = 0; i < n; ++i) {
                if (!this.hiddenColumns.containsKey(i)) continue;
                --correctPosition;
            }
            this.moveColumn(this.tableModel.getColumnCount() - this.hiddenColumns.size() - 1, correctPosition);
        } else {
            this.hideColumn(column);
        }
    }

    private final void hideColumn(BaseTableColumnOption column) {
        TableColumn tableColumn = this.getColumn(column.getConfig().getDisplayName());
        if (tableColumn == null) {
            return;
        }
        TableColumn columnToHide = tableColumn;
        this.hiddenColumns.put(columnToHide.getModelIndex(), columnToHide);
        this.removeColumn(columnToHide);
    }

    @NotNull
    protected ExpandableItemsHandler<TableCell> createExpandableItemsHandler() {
        return (ExpandableItemsHandler)new AppLinkTableExpandableItemsHandler(this);
    }

    public void dispose() {
        this.setDefaultRenderer(String.class, null);
        this.setDefaultRenderer(Integer.TYPE, null);
    }

    private static final void _init_$lambda$1(AppLinkOverviewTable this$0, BaseTableColumnOption column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        this$0.onColumnSelection(column);
    }
}

