/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.ui;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.google.urlassistant.ActivityData;
import com.google.urlassistant.AppLinksAnalyticsProvider;
import com.google.urlassistant.DeepLink;
import com.google.urlassistant.Order;
import com.google.urlassistant.PathData;
import com.google.urlassistant.PathType;
import com.google.urlassistant.UrlPrefix;
import com.google.urlassistant.ui.UrlAssistantWindow;
import com.google.urlassistant.util.ManifestUtils;
import com.google.urlassistant.util.UrlAssistUtils;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.google.urlassistant.util.UsageTrackerUtils;
import com.google.wireless.android.sdk.stats.AppLinksAssistantEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import kotlin.jvm.functions.Function1;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
public class AddUrlDialog
extends DialogWrapper {
    private JPanel myPane;
    private JBTextField myPathTextField;
    private UrlAssistantWindow myUrlAssistantWindow;
    private JComboBox<ActivityData> myActivityListComboBox;
    private JComboBox<PathType> myPathTypeComboBox;
    private ActivityComboBoxModel myActivityComboBoxModel;
    private JBRadioButton myHttpRadioButton;
    private JBRadioButton myHttpsRadioButton;
    private JPanel myBasicPanel;
    private JPanel myAdvancedPanel;
    private JBTextField myUrlPrefixTextField;
    private JBTextField myHostTextField;
    private JBTextField myPortTextField;
    private JPanel myCardPanel;
    private JBLabel myTitleTextField;
    private JBTextField myMimeTypeTextField;
    private JBLabel myMimeTypeLabel;
    private HyperlinkLabel myHowItWorksHyperLink;
    private JBTextField myOrderField;
    private JBLabel myOrderLabel;
    private ActivityData myActivityData;
    private final Project myProject;
    private PathType myOldPathType;
    private SwitchAdvancedAction mySwitchAdvancedAction;
    private XmlTag myCurrentIntentFilter;
    private int myCurrentRow = -1;
    private boolean myIsEdit = false;
    private boolean myIsAdvancedDialog = false;
    private final boolean mySupportOrder;
    private static UrlPrefix ourPreviousUrl = null;
    KeyAdapter myKeyAdapter = new KeyAdapter(){

        @Override
        public void keyReleased(KeyEvent e) {
            AddUrlDialog.this.setOKActionEnabled(StringUtil.isNotEmpty((String)((JTextField)e.getComponent()).getText()));
        }
    };

    public AddUrlDialog(@NotNull Project project, @NotNull UrlAssistantWindow urlAssistantWindow, @NotNull List<Activity> activityList) {
        super(project);
        this.setupUI();
        FormScalingUtil.scaleComponentTree(((Object)((Object)this)).getClass(), (JComponent)this.myPane);
        this.init();
        this.myProject = project;
        this.myUrlAssistantWindow = urlAssistantWindow;
        this.mySupportOrder = Order.isSupportedFor(project);
        ButtonGroup group = new ButtonGroup();
        group.add((AbstractButton)this.myHttpRadioButton);
        group.add((AbstractButton)this.myHttpsRadioButton);
        this.myHttpRadioButton.setSelected(true);
        this.setTitle(UrlAssistantBundle.message("add.url.dialog.title", new Object[0]));
        this.setUpComboBox(activityList);
        if (ourPreviousUrl != null) {
            this.populateUrl(ourPreviousUrl);
        }
        this.myUrlPrefixTextField.addKeyListener((KeyListener)this.myKeyAdapter);
        this.myUrlPrefixTextField.getEmptyText().setText(UrlAssistantBundle.message("add.url.host.hint", new Object[0]));
        this.myUrlPrefixTextField.setText("https://");
        this.myHostTextField.addKeyListener((KeyListener)this.myKeyAdapter);
        this.myHostTextField.getEmptyText().setText(UrlAssistantBundle.message("add.url.host.hint", new Object[0]));
        this.myMimeTypeTextField.getEmptyText().setText(UrlAssistantBundle.message("add.url.mimetype.hint", new Object[0]));
        this.myHowItWorksHyperLink.setHyperlinkText(UrlAssistantBundle.message("add.url.how.it.works.text", new Object[0]));
        this.myHowItWorksHyperLink.setHyperlinkTarget(UrlAssistantBundle.message("add.url.how.it.works.url", new Object[0]));
        this.myHowItWorksHyperLink.setBackground(this.myPane.getBackground());
        this.myPathTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (AddUrlDialog.this.myPathTextField.getText().isEmpty()) {
                    AddUrlDialog.this.myPathTextField.setText("/");
                }
                AddUrlDialog.this.myPathTextField.removeFocusListener((FocusListener)this);
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.setMode();
        this.validate();
    }

    public JComboBox<PathType> getPathTypeComboBox() {
        return this.myPathTypeComboBox;
    }

    public JBTextField getPathTextField() {
        return this.myPathTextField;
    }

    public JComboBox<ActivityData> getActivityListComboBox() {
        return this.myActivityListComboBox;
    }

    public void setValue(@NotNull Order order, @NotNull UrlPrefix urlPrefix, @NotNull PathData path, @Nullable ActivityData activityData, int currentRow) {
        this.populateUrl(urlPrefix);
        this.myUrlPrefixTextField.setText(urlPrefix.toString());
        this.myOrderField.setText(order.getInteger() != null ? order.getInteger().toString() : "");
        this.myOldPathType = path.getPathType();
        String pathValue = path.getPathValue();
        if (StringUtil.isNotEmpty((String)pathValue)) {
            this.myPathTextField.setText(pathValue);
        }
        this.myPathTypeComboBox.setSelectedItem((Object)this.myOldPathType);
        if ((order.getInteger() != null || urlPrefix.getPort() >= 0 || StringUtil.isNotEmpty((String)urlPrefix.getMimeType())) && !this.myIsAdvancedDialog) {
            this.mySwitchAdvancedAction.doAction(null);
        }
        if (activityData != null) {
            this.myIsEdit = true;
            this.myCurrentRow = currentRow;
            this.myActivityData = activityData;
            this.myCurrentIntentFilter = activityData.getIntentFilterTag();
            for (int i = 0; i < this.myActivityListComboBox.getItemCount(); ++i) {
                ActivityData theActivityData = this.myActivityComboBoxModel.getElementAt(i);
                if (theActivityData == null || theActivityData.getModule() != activityData.getModule() || !theActivityData.getActivityName().equals(activityData.getActivityName())) continue;
                this.myActivityListComboBox.setSelectedIndex(i);
                break;
            }
        }
        if (this.myIsAdvancedDialog) {
            AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.URL_MAPPING_APP_LINK_ADD_ADVANCED_DIALOG, AppLinksAssistantEvent.EventState.OPENED, this.myProject);
        }
    }

    public void setValue(@NotNull DeepLink deepLink, int currentRow) {
        this.setValue(deepLink.getOrder(), deepLink.getUrl(), deepLink.getPath(), deepLink.getActivityData(), currentRow);
    }

    private void populateUrl(@NotNull UrlPrefix urlPrefix) {
        this.myHttpRadioButton.setSelected("http".equals(urlPrefix.getScheme()));
        this.myUrlPrefixTextField.setText(urlPrefix.toString());
        this.myPortTextField.setText(urlPrefix.getPortText());
        this.myHostTextField.setText(urlPrefix.getHost());
        this.myMimeTypeTextField.setText(urlPrefix.getMimeType());
        this.setOKActionEnabled(StringUtil.isNotEmpty((String)urlPrefix.getHost()));
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        return new Action[]{this.getCancelAction()};
    }

    @NotNull
    protected Action[] createActions() {
        return new Action[]{this.mySwitchAdvancedAction, this.getOKAction()};
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.mySwitchAdvancedAction = new SwitchAdvancedAction();
    }

    private void setMode() {
        CardLayout cl = (CardLayout)this.myCardPanel.getLayout();
        if (this.myIsAdvancedDialog) {
            cl.last(this.myCardPanel);
        } else {
            cl.first(this.myCardPanel);
        }
        this.myMimeTypeTextField.setVisible(this.myIsAdvancedDialog);
        this.myMimeTypeLabel.setVisible(this.myIsAdvancedDialog);
        this.myOrderLabel.setVisible(this.mySupportOrder && this.myIsAdvancedDialog);
        this.myOrderField.setVisible(this.mySupportOrder && this.myIsAdvancedDialog);
        try {
            if (this.myIsAdvancedDialog) {
                UrlPrefix urlPrefix = new UrlPrefix(this.myUrlPrefixTextField.getText());
                if ("http".equals(urlPrefix.getScheme())) {
                    this.myHttpRadioButton.setSelected(true);
                } else {
                    this.myHttpsRadioButton.setSelected(true);
                }
                this.myHostTextField.setText(urlPrefix.getHost());
                this.myPortTextField.setText(urlPrefix.getPortText());
            } else {
                String scheme = this.myHttpRadioButton.isSelected() ? "http" : "https";
                String urlPrefix = scheme + "://" + this.myHostTextField.getText() + (String)(StringUtil.isEmpty((String)this.myPortTextField.getText()) ? "" : ":" + this.myPortTextField.getText());
                this.myUrlPrefixTextField.setText(urlPrefix);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myIsAdvancedDialog ? this.myHostTextField : this.myUrlPrefixTextField;
    }

    private void setUpComboBox(List<Activity> activityList) {
        this.myActivityComboBoxModel = new ActivityComboBoxModel(activityList);
        this.myActivityListComboBox.setModel(this.myActivityComboBoxModel);
        this.myActivityListComboBox.setRenderer((ListCellRenderer<ActivityData>)((Object)new MyActivityListRender()));
        this.myPathTypeComboBox.setModel(new DefaultComboBoxModel<PathType>(PathType.values()));
        this.myPathTypeComboBox.setSelectedItem((Object)PathType.PathPattern);
        this.myPathTextField.getEmptyText().setText(UrlAssistantBundle.message("add.url.path.hint", new Object[0]));
        this.myPathTypeComboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                PathType item = (PathType)((Object)((Object)e.getItem()));
                String messageKey = item.equals((Object)PathType.Path) ? "add.url.path.hint" : (item.equals((Object)PathType.PathPrefix) ? "add.url.path.prefix.hint" : "add.url.path.pattern.hint");
                this.myPathTextField.getEmptyText().setText(UrlAssistantBundle.message(messageKey, new Object[0]));
            }
        });
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPane;
    }

    public boolean isInputValid(@NotNull UrlPrefix urlPrefix) {
        boolean isUnitTest = ApplicationManager.getApplication().isUnitTestMode();
        if ((this.myPathTypeComboBox.getSelectedItem() == PathType.Path || this.myPathTypeComboBox.getSelectedItem() == PathType.PathPrefix) && StringUtil.isNotEmpty((String)this.myPathTextField.getText()) && !StringUtil.startsWith((CharSequence)this.myPathTextField.getText(), (CharSequence)"/")) {
            if (!isUnitTest) {
                this.showInvalidInputMessage(UrlAssistantBundle.message("add.url.path.start.with.slash", this.myPathTypeComboBox.getSelectedItem().toString()));
            }
            return false;
        }
        if (!urlPrefix.getScheme().equals("http") && !urlPrefix.getScheme().equals("https")) {
            if (!isUnitTest) {
                this.showInvalidInputMessage(UrlAssistantBundle.message("add.url.invalid.input.scheme", new Object[0]));
            }
            return false;
        }
        if (StringUtil.isEmpty((String)urlPrefix.getHost())) {
            if (!isUnitTest) {
                this.showInvalidInputMessage(UrlAssistantBundle.message("add.url.invalid.input.host", new Object[0]));
            }
            return false;
        }
        if (urlPrefix.isPortSet() && (urlPrefix.getPort() < 0 || urlPrefix.getPort() > 65535)) {
            if (!isUnitTest) {
                this.showInvalidInputMessage(UrlAssistantBundle.message("add.url.invalid.input.port", new Object[0]));
            }
            return false;
        }
        try {
            if (this.mySupportOrder && StringUtil.isNotEmpty((String)this.myOrderField.getText())) {
                Integer.parseInt(this.myOrderField.getText());
            }
        }
        catch (NumberFormatException e) {
            this.showInvalidInputMessage(UrlAssistantBundle.message("add.url.invalid.input.order", new Object[0]));
            return false;
        }
        return true;
    }

    protected void doOKAction() {
        try {
            if (this.doAddOrEditUrl()) {
                this.close(0);
            }
        }
        catch (MalformedURLException e) {
            this.showInvalidInputMessage(UrlAssistantBundle.message("url.malformed", new Object[0]));
        }
        catch (Exception e2) {
            AddUrlDialog.getLog().debug(e2.getMessage());
            this.close(1);
        }
    }

    public boolean doAddOrEditUrl() throws MalformedURLException {
        Object urlPrefixString;
        if (this.myIsAdvancedDialog) {
            String scheme = this.myHttpRadioButton.isSelected() ? "http" : "https";
            urlPrefixString = scheme + "://" + this.myHostTextField.getText() + ":" + this.myPortTextField.getText();
        } else {
            urlPrefixString = this.myUrlPrefixTextField.getText();
        }
        UrlPrefix urlPrefix = new UrlPrefix((String)urlPrefixString);
        if (this.myIsAdvancedDialog) {
            urlPrefix.setMimeType(this.myMimeTypeTextField.getText());
        }
        if (!this.isInputValid(urlPrefix)) {
            return false;
        }
        Order order = new Order(this.myIsAdvancedDialog && StringUtil.isNotEmpty((String)this.myOrderField.getText()) ? Integer.valueOf(this.myOrderField.getText()) : null);
        ourPreviousUrl = urlPrefix;
        PathData pathData = new PathData((PathType)((Object)this.myPathTypeComboBox.getSelectedItem()), this.myPathTextField.getText());
        WriteCommandAction.writeCommandAction((Project)this.myProject).run(() -> {
            int rowIndex;
            JBTable table = this.myUrlAssistantWindow.getTable();
            if (this.myIsEdit) {
                this.editIntentFilter(urlPrefix, pathData, order);
                rowIndex = this.myUrlAssistantWindow.getTableModel().updateRow(order, urlPrefix, pathData, this.myActivityData, this.mySupportOrder, this.myCurrentRow);
            } else {
                this.myActivityData = this.myActivityComboBoxModel.getSelectedItem();
                this.createIntentFilter(urlPrefix, this.myActivityData, pathData, order);
                rowIndex = this.myUrlAssistantWindow.getTableModel().addRow(order, urlPrefix, pathData, this.myActivityData, this.mySupportOrder);
            }
            table.setRowSelectionInterval(rowIndex, rowIndex);
            this.myUrlAssistantWindow.handleTableSelection();
        });
        AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.URL_MAPPING_APP_LINK_ADD_DIALOG, AppLinksAssistantEvent.EventState.COMPLETED, this.myProject);
        return true;
    }

    private void showInvalidInputMessage(@NotNull String message) {
        Messages.showMessageDialog((Project)this.myProject, (String)message, (String)UrlAssistantBundle.message("add.url.invalid.input.dialog.title", new Object[0]), null);
        AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.URL_MAPPING_APP_LINK_ADD_DIALOG, AppLinksAssistantEvent.EventState.FAILED, this.myProject);
    }

    private void createIntentFilter(@NotNull UrlPrefix urlPrefix, @NotNull ActivityData activityData, @NotNull PathData pathData, @NotNull Order order) {
        XmlTag root;
        XmlFile manifestPsiFile = ManifestUtils.getAndroidManifestPsi(activityData.getModule());
        if (manifestPsiFile != null && (root = manifestPsiFile.getRootTag()) != null) {
            List<XmlTag> activities = ManifestUtils.searchXmlTagsByName(root, "activity");
            for (XmlTag activityTag : activities) {
                String activityName = activityTag.getAttributeValue("name", "http://schemas.android.com/apk/res/android");
                if (activityName == null || !activityName.equals(activityData.getActivityName())) continue;
                this.myActivityData.setIntentFilterTag(UrlAssistUtils.createDeepLinkIntentFilter(order, activityTag, urlPrefix, pathData));
                UsageTrackerUtils.INSTANCE.log(this.myProject, (Function1<? super AppLinksAssistantEvent.Builder, AppLinksAssistantEvent.Builder>)((Function1)builder -> {
                    builder.setEventSource(AppLinksAssistantEvent.EventSource.URL_MAPPING_APP_LINK_ADD_DIALOG).setEventState(AppLinksAssistantEvent.EventState.COMPLETED).setLinksRecord(UsageTrackerUtils.INSTANCE.createLinksRecord(urlPrefix.getScheme(), urlPrefix.getHost(), pathData.getPathValue(), pathData.getPathType().asLinksRecordPathType()).setInteractionType(AppLinksAssistantEvent.LinksRecord.InteractionType.NEW_LINK_CREATED));
                    return builder;
                }));
                break;
            }
        }
        this.myUrlAssistantWindow.updateAndroidManifestPreview(this.myActivityData.getModule());
    }

    private void editIntentFilter(@NotNull UrlPrefix urlPrefix, @NotNull PathData pathData, @NotNull Order order) {
        String oldActivityName = this.myActivityData.getActivityName();
        this.myActivityData = this.myActivityComboBoxModel.getSelectedItem();
        if (!oldActivityName.equals(this.myActivityData.getActivityName())) {
            this.myCurrentIntentFilter.delete();
            this.createIntentFilter(urlPrefix, this.myActivityData, pathData, order);
        } else {
            this.myCurrentIntentFilter.delete();
            this.createIntentFilter(urlPrefix, this.myActivityData, pathData, order);
            this.myUrlAssistantWindow.updateAndroidManifestPreview(this.myActivityData.getModule());
        }
    }

    protected void dispose() {
        super.dispose();
        this.myUrlAssistantWindow = null;
    }

    private void setupUI() {
        this.myPane = new JPanel();
        this.myPane.setLayout((LayoutManager)new GridLayoutManager(11, 5, new Insets(10, 10, 10, 10), -1, -1));
        this.myPane.setMinimumSize(new Dimension(650, -1));
        this.myPane.setPreferredSize(new Dimension(550, 280));
        JBLabel jBLabel1 = new JBLabel();
        Font jBLabel1Font = this.getFont(null, 1, -1, jBLabel1.getFont());
        if (jBLabel1Font != null) {
            jBLabel1.setFont(jBLabel1Font);
        }
        jBLabel1.setText("Activity");
        this.myPane.add((Component)jBLabel1, new GridConstraints(8, 0, 1, 3, 8, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myPane.add((Component)spacer1, new GridConstraints(10, 3, 1, 2, 0, 2, 5, 2, null, null, null, 0, false));
        this.myTitleTextField = new JBLabel();
        Font myTitleTextFieldFont = this.getFont(null, 1, -1, this.myTitleTextField.getFont());
        if (myTitleTextFieldFont != null) {
            this.myTitleTextField.setFont(myTitleTextFieldFont);
        }
        this.myTitleTextField.setText("Basic URL Mapping");
        this.myPane.add((Component)this.myTitleTextField, new GridConstraints(0, 0, 1, 5, 8, 0, 0, 0, null, null, null, 0, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("You can add or edit your URL mapping here");
        this.myPane.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 5, 8, 0, 0, 0, null, null, null, 0, false));
        this.myCardPanel = new JPanel();
        this.myCardPanel.setLayout(new CardLayout(0, 0));
        this.myPane.add((Component)this.myCardPanel, new GridConstraints(3, 0, 1, 5, 0, 3, 5, 0, null, null, null, 0, false));
        this.myBasicPanel = new JPanel();
        this.myBasicPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myCardPanel.add((Component)this.myBasicPanel, "Card1");
        JBLabel jBLabel3 = new JBLabel();
        Font jBLabel3Font = this.getFont(null, 1, -1, jBLabel3.getFont());
        if (jBLabel3Font != null) {
            jBLabel3.setFont(jBLabel3Font);
        }
        jBLabel3.setText("Host");
        this.myBasicPanel.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myUrlPrefixTextField = new JBTextField();
        this.myBasicPanel.add((Component)this.myUrlPrefixTextField, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null, 0, false));
        this.myAdvancedPanel = new JPanel();
        this.myAdvancedPanel.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1));
        this.myAdvancedPanel.setMinimumSize(new Dimension(100, 57));
        this.myAdvancedPanel.setPreferredSize(new Dimension(650, 57));
        this.myCardPanel.add((Component)this.myAdvancedPanel, "Card2");
        this.myHttpRadioButton = new JBRadioButton();
        this.myHttpRadioButton.setText("http");
        this.myAdvancedPanel.add((Component)this.myHttpRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 1, null, null, null, 0, false));
        JBLabel jBLabel4 = new JBLabel();
        Font jBLabel4Font = this.getFont(null, 1, -1, jBLabel4.getFont());
        if (jBLabel4Font != null) {
            jBLabel4.setFont(jBLabel4Font);
        }
        jBLabel4.setText("Scheme");
        this.myAdvancedPanel.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 2, 8, 2, 0, 0, null, new Dimension(125, 15), null, 0, false));
        JBLabel jBLabel5 = new JBLabel();
        Font jBLabel5Font = this.getFont(null, 1, -1, jBLabel5.getFont());
        if (jBLabel5Font != null) {
            jBLabel5.setFont(jBLabel5Font);
        }
        jBLabel5.setText("Host");
        this.myAdvancedPanel.add((Component)jBLabel5, new GridConstraints(0, 2, 1, 1, 8, 0, 5, 0, null, new Dimension(-1, 15), null, 0, false));
        this.myHttpsRadioButton = new JBRadioButton();
        this.myHttpsRadioButton.setText("https");
        this.myAdvancedPanel.add((Component)this.myHttpsRadioButton, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 1, null, null, null, 0, false));
        this.myPortTextField = new JBTextField();
        this.myAdvancedPanel.add((Component)this.myPortTextField, new GridConstraints(1, 3, 1, 1, 4, 0, 0, 0, null, new Dimension(80, -1), null, 0, false));
        JBLabel jBLabel6 = new JBLabel();
        Font jBLabel6Font = this.getFont(null, 1, -1, jBLabel6.getFont());
        if (jBLabel6Font != null) {
            jBLabel6.setFont(jBLabel6Font);
        }
        jBLabel6.setText("Port");
        this.myAdvancedPanel.add((Component)jBLabel6, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myHostTextField = new JBTextField();
        this.myAdvancedPanel.add((Component)this.myHostTextField, new GridConstraints(1, 2, 1, 1, 0, 1, 5, 3, null, null, null, 0, false));
        this.myActivityListComboBox = new JComboBox();
        this.myPane.add(this.myActivityListComboBox, new GridConstraints(9, 0, 1, 4, 1, 1, 2, 0, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        this.myPane.add((Component)spacer2, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 10), new Dimension(-1, 10), 0, false));
        Spacer spacer3 = new Spacer();
        this.myPane.add((Component)spacer3, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 10), new Dimension(-1, 10), 0, false));
        this.myMimeTypeLabel = new JBLabel();
        Font myMimeTypeLabelFont = this.getFont(null, 1, -1, this.myMimeTypeLabel.getFont());
        if (myMimeTypeLabelFont != null) {
            this.myMimeTypeLabel.setFont(myMimeTypeLabelFont);
        }
        this.myMimeTypeLabel.setText("Mime Type");
        this.myPane.add((Component)this.myMimeTypeLabel, new GridConstraints(8, 4, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myMimeTypeTextField = new JBTextField();
        this.myPane.add((Component)this.myMimeTypeTextField, new GridConstraints(9, 4, 1, 1, 1, 1, 4, 3, null, null, null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myPane.add((Component)panel1, new GridConstraints(6, 2, 1, 3, 0, 1, 3, 0, null, null, null, 0, false));
        this.myPathTextField = new JBTextField();
        panel1.add((Component)this.myPathTextField, new GridConstraints(0, 0, 1, 1, 0, 3, 4, 0, null, null, null, 0, false));
        this.myHowItWorksHyperLink = new HyperlinkLabel();
        this.myHowItWorksHyperLink.setFocusable(false);
        Font myHowItWorksHyperLinkFont = UIManager.getFont("Label.font");
        if (myHowItWorksHyperLinkFont != null) {
            this.myHowItWorksHyperLink.setFont(myHowItWorksHyperLinkFont);
        }
        panel1.add((Component)this.myHowItWorksHyperLink, new GridConstraints(0, 1, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        this.myPathTypeComboBox = new JComboBox();
        this.myPane.add(this.myPathTypeComboBox, new GridConstraints(6, 1, 1, 1, 0, 1, 0, 0, null, null, null, 0, false));
        this.myOrderField = new JBTextField();
        this.myPane.add((Component)this.myOrderField, new GridConstraints(6, 0, 1, 1, 0, 1, 3, 0, null, new Dimension(60, -1), null, 0, false));
        JBLabel jBLabel7 = new JBLabel();
        Font jBLabel7Font = this.getFont(null, 1, -1, jBLabel7.getFont());
        if (jBLabel7Font != null) {
            jBLabel7.setFont(jBLabel7Font);
        }
        jBLabel7.setText("Path");
        this.myPane.add((Component)jBLabel7, new GridConstraints(5, 1, 1, 3, 8, 0, 0, 0, null, new Dimension(24, 15), null, 0, false));
        this.myOrderLabel = new JBLabel();
        Font myOrderLabelFont = this.getFont(null, 1, -1, this.myOrderLabel.getFont());
        if (myOrderLabelFont != null) {
            this.myOrderLabel.setFont(myOrderLabelFont);
        }
        this.myOrderLabel.setText("Order");
        this.myPane.add((Component)this.myOrderLabel, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer4 = new Spacer();
        this.myPane.add((Component)spacer4, new GridConstraints(2, 4, 1, 1, 0, 0, 1, 0, null, new Dimension(-1, 5), new Dimension(-1, 5), 0, false));
        Spacer spacer5 = new Spacer();
        this.myPane.add((Component)spacer5, new GridConstraints(7, 4, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        Spacer spacer6 = new Spacer();
        this.myPane.add((Component)spacer6, new GridConstraints(7, 3, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        Spacer spacer7 = new Spacer();
        this.myPane.add((Component)spacer7, new GridConstraints(7, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
    }

    private Font getFont(String fontName, int style, int size, Font currentFont) {
        Font testFont;
        if (currentFont == null) {
            return null;
        }
        String resultName = fontName == null ? currentFont.getName() : ((testFont = new Font(fontName, 0, 10)).canDisplay('a') && testFont.canDisplay('1') ? fontName : currentFont.getName());
        Font font = new Font(resultName, style >= 0 ? style : currentFont.getStyle(), size >= 0 ? size : currentFont.getSize());
        boolean isMac = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font fontWithFallback = isMac ? new Font(font.getFamily(), font.getStyle(), font.getSize()) : new StyleContext().getFont(font.getFamily(), font.getStyle(), font.getSize());
        return fontWithFallback instanceof FontUIResource ? fontWithFallback : new FontUIResource(fontWithFallback);
    }

    private static Logger getLog() {
        return Logger.getInstance(AddUrlDialog.class);
    }

    class SwitchAdvancedAction
    extends DialogWrapper.DialogWrapperAction {
        public SwitchAdvancedAction() {
            super((DialogWrapper)AddUrlDialog.this, UrlAssistantBundle.message("add.url.dialog.show.advanced", new Object[0]));
        }

        protected void doAction(ActionEvent e) {
            AddUrlDialog.this.myIsAdvancedDialog = !AddUrlDialog.this.myIsAdvancedDialog;
            this.putValue("Name", UrlAssistantBundle.message(AddUrlDialog.this.myIsAdvancedDialog ? "add.url.dialog.hide.advanced" : "add.url.dialog.show.advanced", new Object[0]));
            AddUrlDialog.this.setMode();
        }
    }

    static class ActivityComboBoxModel
    implements ComboBoxModel<ActivityData> {
        private final List<ActivityData> myActivityList = new ArrayList<ActivityData>();
        private int selectedIndex = 0;

        public ActivityComboBoxModel(@NotNull List<Activity> activityList) {
            for (Activity activity : activityList) {
                if (activity == null) continue;
                Module mainModule = activity.getModule();
                String activityName = activity.getActivityClass().getStringValue();
                if (mainModule == null || !StringUtil.isNotEmpty((String)activityName)) continue;
                this.myActivityList.add(new ActivityData(ProjectSystemUtil.getModuleSystem((Module)mainModule).getHolderModule(), activityName, null, null));
            }
        }

        @Override
        public void setSelectedItem(@NotNull Object anItem) {
            for (int i = 0; i < this.myActivityList.size(); ++i) {
                if (!this.getElementAt(i).equals(anItem)) continue;
                this.selectedIndex = i;
                return;
            }
        }

        @Override
        public ActivityData getSelectedItem() {
            if (this.selectedIndex >= 0 && this.selectedIndex < this.myActivityList.size()) {
                return this.myActivityList.get(this.selectedIndex);
            }
            return null;
        }

        @Override
        public int getSize() {
            return this.myActivityList.size();
        }

        @Override
        public ActivityData getElementAt(int index) {
            if (index >= 0 && index < this.myActivityList.size()) {
                return this.myActivityList.get(index);
            }
            return null;
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }
    }

    static class MyActivityListRender
    extends ListCellRendererWrapper<ActivityData> {
        MyActivityListRender() {
        }

        public void customize(JList list, ActivityData value, int index, boolean selected, boolean hasFocus) {
            this.setText(value == null ? "" : value.getHtmlText(selected));
        }
    }
}

