/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.datalayer.model.intentfilter;

import com.google.gson.Gson;
import com.google.urlassistant.datalayer.model.HostAndPort;
import com.google.urlassistant.datalayer.model.intentfilter.PathsConfig;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 !2\u00020\u0001:\u0001!B9\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0012\u001a\u00020\u0004J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\bH\u00c6\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003JC\u0010\u001b\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\""}, d2={"Lcom/google/urlassistant/datalayer/model/intentfilter/DataTagsConfig;", "", "schemes", "", "", "hostAndPorts", "Lcom/google/urlassistant/datalayer/model/HostAndPort;", "paths", "Lcom/google/urlassistant/datalayer/model/intentfilter/PathsConfig;", "mimeTypes", "<init>", "(Ljava/util/Set;Ljava/util/Set;Lcom/google/urlassistant/datalayer/model/intentfilter/PathsConfig;Ljava/util/Set;)V", "getSchemes", "()Ljava/util/Set;", "getHostAndPorts", "getPaths", "()Lcom/google/urlassistant/datalayer/model/intentfilter/PathsConfig;", "getMimeTypes", "toJson", "hasDeeplink", "", "getHasDeeplink", "()Z", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "url-assistant"})
public final class DataTagsConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> schemes;
    @NotNull
    private final Set<HostAndPort> hostAndPorts;
    @NotNull
    private final PathsConfig paths;
    @NotNull
    private final Set<String> mimeTypes;

    public DataTagsConfig(@NotNull Set<String> schemes, @NotNull Set<HostAndPort> hostAndPorts, @NotNull PathsConfig paths, @NotNull Set<String> mimeTypes) {
        Intrinsics.checkNotNullParameter(schemes, (String)"schemes");
        Intrinsics.checkNotNullParameter(hostAndPorts, (String)"hostAndPorts");
        Intrinsics.checkNotNullParameter((Object)paths, (String)"paths");
        Intrinsics.checkNotNullParameter(mimeTypes, (String)"mimeTypes");
        this.schemes = schemes;
        this.hostAndPorts = hostAndPorts;
        this.paths = paths;
        this.mimeTypes = mimeTypes;
    }

    @NotNull
    public final Set<String> getSchemes() {
        return this.schemes;
    }

    @NotNull
    public final Set<HostAndPort> getHostAndPorts() {
        return this.hostAndPorts;
    }

    @NotNull
    public final PathsConfig getPaths() {
        return this.paths;
    }

    @NotNull
    public final Set<String> getMimeTypes() {
        return this.mimeTypes;
    }

    @NotNull
    public final String toJson() {
        String string = new Gson().toJson((Object)this);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        return string;
    }

    public final boolean getHasDeeplink() {
        return this.mimeTypes.isEmpty() && (!this.schemes.isEmpty() || !this.hostAndPorts.isEmpty() || !this.paths.isEmpty());
    }

    @NotNull
    public final Set<String> component1() {
        return this.schemes;
    }

    @NotNull
    public final Set<HostAndPort> component2() {
        return this.hostAndPorts;
    }

    @NotNull
    public final PathsConfig component3() {
        return this.paths;
    }

    @NotNull
    public final Set<String> component4() {
        return this.mimeTypes;
    }

    @NotNull
    public final DataTagsConfig copy(@NotNull Set<String> schemes, @NotNull Set<HostAndPort> hostAndPorts, @NotNull PathsConfig paths, @NotNull Set<String> mimeTypes) {
        Intrinsics.checkNotNullParameter(schemes, (String)"schemes");
        Intrinsics.checkNotNullParameter(hostAndPorts, (String)"hostAndPorts");
        Intrinsics.checkNotNullParameter((Object)paths, (String)"paths");
        Intrinsics.checkNotNullParameter(mimeTypes, (String)"mimeTypes");
        return new DataTagsConfig(schemes, hostAndPorts, paths, mimeTypes);
    }

    public static /* synthetic */ DataTagsConfig copy$default(DataTagsConfig dataTagsConfig, Set set, Set set2, PathsConfig pathsConfig, Set set3, int n, Object object) {
        if ((n & 1) != 0) {
            set = dataTagsConfig.schemes;
        }
        if ((n & 2) != 0) {
            set2 = dataTagsConfig.hostAndPorts;
        }
        if ((n & 4) != 0) {
            pathsConfig = dataTagsConfig.paths;
        }
        if ((n & 8) != 0) {
            set3 = dataTagsConfig.mimeTypes;
        }
        return dataTagsConfig.copy(set, set2, pathsConfig, set3);
    }

    @NotNull
    public String toString() {
        return "DataTagsConfig(schemes=" + this.schemes + ", hostAndPorts=" + this.hostAndPorts + ", paths=" + this.paths + ", mimeTypes=" + this.mimeTypes + ")";
    }

    public int hashCode() {
        int result = ((Object)this.schemes).hashCode();
        result = result * 31 + ((Object)this.hostAndPorts).hashCode();
        result = result * 31 + this.paths.hashCode();
        result = result * 31 + ((Object)this.mimeTypes).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DataTagsConfig)) {
            return false;
        }
        DataTagsConfig dataTagsConfig = (DataTagsConfig)other;
        if (!Intrinsics.areEqual(this.schemes, dataTagsConfig.schemes)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.hostAndPorts, dataTagsConfig.hostAndPorts)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.paths, (Object)dataTagsConfig.paths)) {
            return false;
        }
        return Intrinsics.areEqual(this.mimeTypes, dataTagsConfig.mimeTypes);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/google/urlassistant/datalayer/model/intentfilter/DataTagsConfig$Companion;", "", "<init>", "()V", "fromJson", "Lcom/google/urlassistant/datalayer/model/intentfilter/DataTagsConfig;", "jsonString", "", "url-assistant"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataTagsConfig fromJson(@NotNull String jsonString) {
            Intrinsics.checkNotNullParameter((Object)jsonString, (String)"jsonString");
            Object object = new Gson().fromJson(jsonString, DataTagsConfig.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
            return (DataTagsConfig)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

