/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.agent.tools;

import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.ToolIcon;
import com.google.aiplugin.agents.tools.ToolArgument;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.google.urlassistant.agent.tools.UrlBriefSummarizerArgs;
import com.google.urlassistant.agent.tools.UrlPurposeSummarizerHandler;
import com.intellij.openapi.project.Project;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KParameter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ToolDescription(summary="Summarize the contents of the given URL briefly and conclude its general purpose.", examples={})
@ToolResult(description="A brief summary of the URL's content and one-sentence of its general purpose")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/google/urlassistant/agent/tools/UrlBriefSummarizerTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/google/urlassistant/agent/tools/UrlBriefSummarizerArgs;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "getRunningDisplayText", "args", "getCompletedDisplayText", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "url-assistant"})
public final class UrlBriefSummarizerTool
implements Tool<UrlBriefSummarizerArgs> {
    @NotNull
    private final String name;

    public UrlBriefSummarizerTool() {
        this.name = "url_brief_summarizer";
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getRunningDisplayText(@NotNull UrlBriefSummarizerArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Summarizing content from URL: " + args.getUrl();
    }

    @NotNull
    public String getCompletedDisplayText(@NotNull UrlBriefSummarizerArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Summarized content from URL: " + args.getUrl();
    }

    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context, @NotNull UrlBriefSummarizerArgs args) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new UrlPurposeSummarizerHandler(context, args);
    }

    @Nullable
    public String getStatusMessage() {
        return super.getStatusMessage();
    }

    @Nullable
    public Map<KParameter, ToolArgument> getToolArguments() {
        return super.getToolArguments();
    }

    @NotNull
    public ToolDescription getToolDescription() {
        return super.getToolDescription();
    }

    @Nullable
    public ToolResult getToolResult() {
        return super.getToolResult();
    }

    @Nullable
    public ToolHandler restoreHandler(@NotNull Project project, @NotNull UrlBriefSummarizerArgs args, @NotNull Response response) {
        return super.restoreHandler(project, (Object)args, response);
    }

    @NotNull
    public String getDescription() {
        return super.getDescription();
    }

    @Nullable
    public ToolIcon getIcon() {
        return super.getIcon();
    }
}

