/*
 * Decompiled with CFR 0.152.
 */
package trebuchet.importers.ftrace;

import java.util.Collection;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import trebuchet.importers.ftrace.FunctionHandlerRegistry;
import trebuchet.importers.ftrace.ImportData;
import trebuchet.io.DataSlice;
import trebuchet.model.fragments.SliceGroupBuilder;
import trebuchet.model.fragments.ThreadModelFragment;
import trebuchet.util.BufferReader;
import trebuchet.util.BufferReaderState;
import trebuchet.util.MatchResult;
import trebuchet.util.PreviewReader;
import trebuchet.util.StringCache;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\u0012\u001a\u00020\t*\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\u0014\u001a\u00020\t*\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\u0016\u001a\u00020\t*\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0017"}, d2={"Ltrebuchet/importers/ftrace/TracingMarkerWrite;", "Ltrebuchet/importers/ftrace/FunctionHandlerRegistry;", "<init>", "()V", "Begin", "", "End", "Counter", "handle", "", "data", "Ltrebuchet/importers/ftrace/ImportData;", "parentTsMatcher", "Ljava/util/regex/Matcher;", "getParentTsMatcher", "()Ljava/util/regex/Matcher;", "realtimeTsMatcher", "getRealtimeTsMatcher", "handleClockSyncMarker", "Ltrebuchet/util/BufferReader;", "handleBegin", "handleEnd", "handleCounter", "intellij.android.profilers.atrace"})
@SourceDebugExtension(value={"SMAP\nTracingMarkerWrite.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TracingMarkerWrite.kt\ntrebuchet/importers/ftrace/TracingMarkerWrite\n+ 2 ImportData.kt\ntrebuchet/importers/ftrace/ImportData\n+ 3 BufferReader.kt\ntrebuchet/util/BufferReaderState\n+ 4 BufferReader.kt\ntrebuchet/util/BufferReader\n+ 5 SliceGroupBuilder.kt\ntrebuchet/model/fragments/SliceGroupBuilder\n*L\n1#1,98:1\n34#2:99\n29#3:100\n38#3,2:101\n34#3,2:103\n53#3:114\n38#3,2:133\n34#3,2:135\n50#3:146\n29#3:147\n51#3:148\n34#3,2:153\n198#4,9:105\n207#4,3:115\n198#4,9:137\n207#4,3:149\n199#4:152\n30#5,4:118\n36#5,11:122\n*S KotlinDebug\n*F\n+ 1 TracingMarkerWrite.kt\ntrebuchet/importers/ftrace/TracingMarkerWrite\n*L\n30#1:99\n31#1:100\n67#1:101,2\n69#1:103,2\n71#1:114\n89#1:133,2\n91#1:135,2\n92#1:146\n92#1:147\n92#1:148\n93#1:153,2\n71#1:105,9\n71#1:115,3\n92#1:137,9\n92#1:149,3\n92#1:152\n72#1:118,4\n81#1:122,11\n*E\n"})
public final class TracingMarkerWrite
extends FunctionHandlerRegistry {
    @NotNull
    public static final TracingMarkerWrite INSTANCE = new TracingMarkerWrite();
    public static final byte Begin = 66;
    public static final byte End = 69;
    public static final byte Counter = 67;
    @NotNull
    private static final Matcher parentTsMatcher;
    @NotNull
    private static final Matcher realtimeTsMatcher;

    private TracingMarkerWrite() {
        super(null, 1, null);
    }

    public final void handle(@NotNull ImportData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ImportData this_$iv = data;
        boolean $i$f$readDetails = false;
        BufferReader $this$handle_u24lambda_u240 = this_$iv.getLine().getFunctionDetailsReader();
        boolean bl = false;
        BufferReaderState this_$iv2 = $this$handle_u24lambda_u240;
        boolean $i$f$peek = false;
        byte by = this_$iv2.getBuffer()[this_$iv2.getIndex()];
        if (by == 66) {
            INSTANCE.handleBegin($this$handle_u24lambda_u240, data);
        } else if (by == 69) {
            INSTANCE.handleEnd(data);
        } else if (by == 67) {
            INSTANCE.handleCounter($this$handle_u24lambda_u240, data);
        } else {
            INSTANCE.handleClockSyncMarker($this$handle_u24lambda_u240, data);
        }
    }

    @NotNull
    public final Matcher getParentTsMatcher() {
        return parentTsMatcher;
    }

    @NotNull
    public final Matcher getRealtimeTsMatcher() {
        return realtimeTsMatcher;
    }

    public final void handleClockSyncMarker(@NotNull BufferReader $this$handleClockSyncMarker, @NotNull ImportData data) {
        Intrinsics.checkNotNullParameter((Object)$this$handleClockSyncMarker, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        $this$handleClockSyncMarker.tryMatch(parentTsMatcher, (Function1<? super MatchResult, Unit>)((Function1)arg_0 -> TracingMarkerWrite.handleClockSyncMarker$lambda$1(data, arg_0)));
        $this$handleClockSyncMarker.tryMatch(realtimeTsMatcher, (Function1<? super MatchResult, Unit>)((Function1)arg_0 -> TracingMarkerWrite.handleClockSyncMarker$lambda$2(data, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    public final void handleBegin(@NotNull BufferReader $this$handleBegin, @NotNull ImportData data) {
        SliceGroupBuilder.MutableSliceGroup builder$iv;
        void this_$iv$iv;
        BufferReaderState this_$iv;
        Intrinsics.checkNotNullParameter((Object)$this$handleBegin, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        BufferReaderState bufferReaderState = $this$handleBegin;
        int count$iv = 2;
        int $i$f$skipCount = 0;
        this_$iv.setIndex(this_$iv.getIndex() + count$iv);
        data.getLine().setTgid($this$handleBegin.readInt());
        this_$iv = $this$handleBegin;
        boolean $i$f$skip = false;
        $i$f$skipCount = this_$iv.getIndex();
        this_$iv.setIndex($i$f$skipCount + 1);
        ThreadModelFragment thread = data.getImporter().threadFor(data.getLine());
        Object this_$iv2 = $this$handleBegin;
        boolean $i$f$stringTo = false;
        BufferReader bufferReader = this_$iv2;
        DataSlice slice$iv$iv = ((BufferReader)this_$iv2).getTempSlice();
        boolean $i$f$sliceTo = false;
        this_$iv$iv.getTempPreview().setBuffer(this_$iv$iv.getBuffer());
        this_$iv$iv.getTempPreview().setIndex(this_$iv$iv.getIndex());
        this_$iv$iv.getTempPreview().setEndIndexExclusive(this_$iv$iv.getEndIndexExclusive());
        PreviewReader $this$handleBegin_u24lambda_u243 = this_$iv$iv.getTempPreview();
        boolean bl = false;
        BufferReaderState this_$iv3 = $this$handleBegin_u24lambda_u243;
        boolean $i$f$end = false;
        this_$iv3.setIndex(this_$iv3.getEndIndexExclusive());
        slice$iv$iv.set(this_$iv$iv.getBuffer(), this_$iv$iv.getIndex(), this_$iv$iv.getTempPreview().getIndex());
        this_$iv$iv.setIndex(this_$iv$iv.getTempPreview().getIndex());
        DataSlice slice$iv = slice$iv$iv;
        Object object = ((BufferReader)this_$iv2).getStringCache();
        if (object == null || (object = ((StringCache)object).stringFor(slice$iv)) == null) {
            object = slice$iv.toString();
        }
        Object name = object;
        this_$iv2 = thread.getSlicesBuilder();
        boolean $i$f$beginSlice = false;
        SliceGroupBuilder.MutableSliceGroup it = builder$iv = new SliceGroupBuilder.MutableSliceGroup(0.0, 0.0, false, 0.0, null, null, null, 127, null);
        boolean bl2 = false;
        it.setStartTime(data.getLine().getTimestamp());
        it.setName((String)name);
        ((SliceGroupBuilder)this_$iv2).getOpenSlices().add(builder$iv);
    }

    public final void handleEnd(@NotNull ImportData data) {
        SliceGroupBuilder slices;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        SliceGroupBuilder this_$iv = slices = data.getThread().getSlicesBuilder();
        boolean $i$f$endSlice = false;
        if (this_$iv.hasOpenSlices()) {
            SliceGroupBuilder.MutableSliceGroup builder$iv;
            SliceGroupBuilder.MutableSliceGroup it = builder$iv = this_$iv.getOpenSlices().remove(CollectionsKt.getLastIndex(this_$iv.getOpenSlices()));
            boolean bl = false;
            it.setEndTime(data.getLine().getTimestamp());
            it.populateScheduledSlices(data.getThread().getSchedulingStateBuilder().getSlices());
            builder$iv.validate();
            if (!((Collection)this_$iv.getOpenSlices()).isEmpty()) {
                ((SliceGroupBuilder.MutableSliceGroup)CollectionsKt.last(this_$iv.getOpenSlices())).add(builder$iv);
            } else {
                this_$iv.getSlices().add(builder$iv);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void handleCounter(@NotNull BufferReader $this$handleCounter, @NotNull ImportData data) {
        void this_$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)$this$handleCounter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        BufferReaderState bufferReaderState = $this$handleCounter;
        int count$iv = 2;
        boolean $i$f$skipCount = false;
        this_$iv.setIndex(this_$iv.getIndex() + count$iv);
        int tgid = $this$handleCounter.readInt();
        BufferReaderState this_$iv2 = $this$handleCounter;
        boolean $i$f$skip = false;
        int n = this_$iv2.getIndex();
        this_$iv2.setIndex(n + 1);
        BufferReaderState this_$iv3 = $this$handleCounter;
        boolean $i$f$stringTo = false;
        BufferReader bufferReader = this_$iv3;
        DataSlice slice$iv$iv = ((BufferReader)this_$iv3).getTempSlice();
        boolean $i$f$sliceTo = false;
        this_$iv$iv.getTempPreview().setBuffer(this_$iv$iv.getBuffer());
        this_$iv$iv.getTempPreview().setIndex(this_$iv$iv.getIndex());
        this_$iv$iv.getTempPreview().setEndIndexExclusive(this_$iv$iv.getEndIndexExclusive());
        PreviewReader $this$handleCounter_u24lambda_u247 = this_$iv$iv.getTempPreview();
        boolean bl = false;
        BufferReaderState this_$iv4 = $this$handleCounter_u24lambda_u247;
        boolean $i$f$skipUntil = false;
        while (this_$iv4.getIndex() < this_$iv4.getEndIndexExclusive()) {
            BufferReaderState this_$iv$iv2 = this_$iv4;
            boolean $i$f$peek = false;
            byte it = this_$iv$iv2.getBuffer()[this_$iv$iv2.getIndex()];
            boolean bl2 = false;
            if (it == 124) break;
            int n2 = this_$iv4.getIndex();
            this_$iv4.setIndex(n2 + 1);
        }
        slice$iv$iv.set(this_$iv$iv.getBuffer(), this_$iv$iv.getIndex(), this_$iv$iv.getTempPreview().getIndex());
        this_$iv$iv.setIndex(this_$iv$iv.getTempPreview().getIndex());
        DataSlice slice$iv = slice$iv$iv;
        Object object = ((BufferReader)this_$iv3).getStringCache();
        if (object == null || (object = ((StringCache)object).stringFor(slice$iv)) == null) {
            object = slice$iv.toString();
        }
        Object name = object;
        this_$iv3 = $this$handleCounter;
        boolean $i$f$skip2 = false;
        int n3 = this_$iv3.getIndex();
        this_$iv3.setIndex(n3 + 1);
        int value = $this$handleCounter.readInt();
        data.getLine().setTgid(tgid);
        data.getImporter().threadFor(data.getLine()).getProcess().addCounterSample((String)name, data.getLine().getTimestamp(), value);
    }

    private static final Unit handleClockSyncMarker$lambda$1(ImportData $data, MatchResult $this$tryMatch) {
        Intrinsics.checkNotNullParameter((Object)$this$tryMatch, (String)"$this$tryMatch");
        double timestamp = $this$tryMatch.double(1);
        $data.getImporter().getModelFragment().setParentTimestamp(timestamp);
        $data.getImporter().getModelFragment().setParentTimestampBootTime($data.getLine().getTimestamp());
        return Unit.INSTANCE;
    }

    private static final Unit handleClockSyncMarker$lambda$2(ImportData $data, MatchResult $this$tryMatch) {
        Intrinsics.checkNotNullParameter((Object)$this$tryMatch, (String)"$this$tryMatch");
        long timestamp = $this$tryMatch.long(1);
        $data.getImporter().getModelFragment().setRealtimeTimestamp(timestamp);
        return Unit.INSTANCE;
    }

    static {
        INSTANCE.handleWith("tracing_mark_write", (Function1<? super ImportData, Unit>)((Function1)new Function1<ImportData, Unit>((Object)INSTANCE){

            public final void invoke(ImportData p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((TracingMarkerWrite)this.receiver).handle(p0);
            }
        }));
        parentTsMatcher = INSTANCE.matcher("trace_event_clock_sync: parent_ts=(.*)");
        realtimeTsMatcher = INSTANCE.matcher("trace_event_clock_sync: realtime_ts=(.*)");
    }
}

