/*
 * Decompiled with CFR 0.152.
 */
package trebuchet.collections;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0012\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 )*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001)B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u000f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0010\u001a\u00020\u0004H\u0086\u0002\u00a2\u0006\u0002\u0010\u0011J\"\u0010\u000f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0010\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00018\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0004J\u0016\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004J\b\u0010\u001b\u001a\u00020\u0015H\u0002J\u001b\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001eJ\u0006\u0010\u001a\u001a\u00020\u0004J\u000e\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004J\u0013\u0010 \u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0011J\u001b\u0010!\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001eJ\u000e\u0010\"\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004J\u0013\u0010#\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00028\u0000\u00a2\u0006\u0002\u0010$J\u0006\u0010%\u001a\u00020\u0015J\u001b\u0010&\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001eJ\b\u0010'\u001a\u00020(H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Ltrebuchet/collections/SparseArray;", "E", "", "initialCapacity", "", "<init>", "(I)V", "mGarbage", "", "mKeys", "", "mValues", "", "[Ljava/lang/Object;", "mSize", "get", "key", "(I)Ljava/lang/Object;", "valueIfKeyNotFound", "(ILjava/lang/Object;)Ljava/lang/Object;", "delete", "", "remove", "removeAt", "index", "removeAtRange", "size", "gc", "put", "value", "(ILjava/lang/Object;)V", "keyAt", "valueAt", "setValueAt", "indexOfKey", "indexOfValue", "(Ljava/lang/Object;)I", "clear", "append", "toString", "", "Companion", "intellij.android.profilers.atrace"})
public final class SparseArray<E> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean mGarbage;
    @NotNull
    private int[] mKeys;
    @NotNull
    private Object[] mValues;
    private int mSize;
    @NotNull
    private static final Object DELETED = new Object();
    @NotNull
    private static final int[] EMPTY_INTS = new int[0];
    @NotNull
    private static final Object[] EMPTY_OBJECTS = new Object[0];

    public SparseArray(int initialCapacity) {
        if (initialCapacity == 0) {
            this.mKeys = EMPTY_INTS;
            this.mValues = EMPTY_OBJECTS;
        } else {
            int idealSize = Companion.idealIntArraySize(initialCapacity);
            this.mKeys = new int[idealSize];
            this.mValues = new Object[idealSize];
        }
    }

    public /* synthetic */ SparseArray(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        this(n);
    }

    @Nullable
    public final E get(int key) {
        return this.get(key, null);
    }

    @Nullable
    public final E get(int key, @Nullable E valueIfKeyNotFound) {
        int i = Companion.binarySearch(this.mKeys, this.mSize, key);
        if (i < 0 || this.mValues[i] == DELETED) {
            return valueIfKeyNotFound;
        }
        return (E)this.mValues[i];
    }

    public final void delete(int key) {
        int i = Companion.binarySearch(this.mKeys, this.mSize, key);
        if (i >= 0 && this.mValues[i] != DELETED) {
            this.mValues[i] = DELETED;
            this.mGarbage = true;
        }
    }

    public final void remove(int key) {
        this.delete(key);
    }

    public final void removeAt(int index) {
        if (this.mValues[index] != DELETED) {
            this.mValues[index] = DELETED;
            this.mGarbage = true;
        }
    }

    public final void removeAtRange(int index, int size) {
        int i = index;
        int end = Math.min(this.mSize, index + size);
        int n = end - 1;
        if (i <= n) {
            while (true) {
                this.removeAt(i);
                if (i == n) break;
                ++i;
            }
        }
    }

    private final void gc() {
        int n = this.mSize;
        int o = 0;
        int[] keys = this.mKeys;
        Object[] values = this.mValues;
        int i = 0;
        int n2 = n - 1;
        if (i <= n2) {
            while (true) {
                Object val;
                if ((val = values[i]) != DELETED) {
                    if (i != o) {
                        keys[o] = keys[i];
                        values[o] = val;
                        values[i] = null;
                    }
                    ++o;
                }
                if (i == n2) break;
                ++i;
            }
        }
        this.mGarbage = false;
        this.mSize = o;
    }

    public final void put(int key, E value) {
        int i = Companion.binarySearch(this.mKeys, this.mSize, key);
        if (i >= 0) {
            this.mValues[i] = value;
        } else {
            if ((i ^= 0xFFFFFFFF) < this.mSize && this.mValues[i] == DELETED) {
                this.mKeys[i] = key;
                this.mValues[i] = value;
                return;
            }
            if (this.mGarbage && this.mSize >= this.mKeys.length) {
                this.gc();
                i = ~Companion.binarySearch(this.mKeys, this.mSize, key);
            }
            if (this.mSize >= this.mKeys.length) {
                int n = Companion.idealIntArraySize(this.mSize + 1);
                int[] nkeys = new int[n];
                Object[] nvalues = new Object[n];
                System.arraycopy(this.mKeys, 0, nkeys, 0, this.mKeys.length);
                System.arraycopy(this.mValues, 0, nvalues, 0, this.mValues.length);
                this.mKeys = nkeys;
                this.mValues = nvalues;
            }
            if (this.mSize - i != 0) {
                System.arraycopy(this.mKeys, i, this.mKeys, i + 1, this.mSize - i);
                System.arraycopy(this.mValues, i, this.mValues, i + 1, this.mSize - i);
            }
            this.mKeys[i] = key;
            this.mValues[i] = value;
            int n = this.mSize;
            this.mSize = n + 1;
        }
    }

    public final int size() {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mSize;
    }

    public final int keyAt(int index) {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mKeys[index];
    }

    public final E valueAt(int index) {
        if (this.mGarbage) {
            this.gc();
        }
        return (E)this.mValues[index];
    }

    public final void setValueAt(int index, E value) {
        if (this.mGarbage) {
            this.gc();
        }
        this.mValues[index] = value;
    }

    public final int indexOfKey(int key) {
        if (this.mGarbage) {
            this.gc();
        }
        return Companion.binarySearch(this.mKeys, this.mSize, key);
    }

    public final int indexOfValue(E value) {
        int n;
        int i;
        if (this.mGarbage) {
            this.gc();
        }
        if ((i = 0) <= (n = this.mSize - 1)) {
            while (true) {
                if (this.mValues[i] == value) {
                    return i;
                }
                if (i == n) break;
                ++i;
            }
        }
        return -1;
    }

    public final void clear() {
        int n = this.mSize;
        Object[] values = this.mValues;
        int i = 0;
        int n2 = n - 1;
        if (i <= n2) {
            while (true) {
                values[i] = null;
                if (i == n2) break;
                ++i;
            }
        }
        this.mSize = 0;
        this.mGarbage = false;
    }

    public final void append(int key, E value) {
        int pos;
        if (this.mSize != 0 && key <= this.mKeys[this.mSize - 1]) {
            this.put(key, value);
            return;
        }
        if (this.mGarbage && this.mSize >= this.mKeys.length) {
            this.gc();
        }
        if ((pos = this.mSize) >= this.mKeys.length) {
            int n = Companion.idealIntArraySize(pos + 1);
            int[] nkeys = new int[n];
            Object[] nvalues = new Object[n];
            System.arraycopy(this.mKeys, 0, nkeys, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, nvalues, 0, this.mValues.length);
            this.mKeys = nkeys;
            this.mValues = nvalues;
        }
        this.mKeys[pos] = key;
        this.mValues[pos] = value;
        this.mSize = pos + 1;
    }

    @NotNull
    public String toString() {
        if (this.size() <= 0) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(this.mSize * 28);
        buffer.append('{');
        int i = 0;
        int n = this.mSize - 1;
        if (i <= n) {
            while (true) {
                if (i > 0) {
                    buffer.append(", ");
                }
                int key = this.keyAt(i);
                buffer.append(key);
                buffer.append('=');
                E value = this.valueAt(i);
                StringBuilder stringBuilder = value != this ? buffer.append(value) : buffer.append("(this Map)");
                if (i == n) break;
                ++i;
            }
        }
        buffer.append('}');
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public SparseArray() {
        this(0, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\u001e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\n\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Ltrebuchet/collections/SparseArray$Companion;", "", "<init>", "()V", "DELETED", "EMPTY_INTS", "", "getEMPTY_INTS", "()[I", "EMPTY_OBJECTS", "", "getEMPTY_OBJECTS", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "idealIntArraySize", "", "need", "idealByteArraySize", "binarySearch", "array", "size", "value", "intellij.android.profilers.atrace"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final int[] getEMPTY_INTS() {
            return EMPTY_INTS;
        }

        @NotNull
        public final Object[] getEMPTY_OBJECTS() {
            return EMPTY_OBJECTS;
        }

        public final int idealIntArraySize(int need) {
            return this.idealByteArraySize(need * 4) / 4;
        }

        public final int idealByteArraySize(int need) {
            for (int i = 4; i < 32; ++i) {
                if (need > (1 << i) - 12) continue;
                return (1 << i) - 12;
            }
            return need;
        }

        public final int binarySearch(@NotNull int[] array, int size, int value) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            int lo = 0;
            int hi = size - 1;
            while (lo <= hi) {
                int mid = lo + hi >>> 1;
                int midVal = array[mid];
                if (midVal < value) {
                    lo = mid + 1;
                    continue;
                }
                if (midVal > value) {
                    hi = mid - 1;
                    continue;
                }
                return mid;
            }
            return ~lo;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

