/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.tasks;

import com.android.tools.profilers.sessions.SessionArtifact;
import com.android.tools.profilers.sessions.SessionItem;
import com.android.tools.profilers.tasks.ProfilerTaskType;
import com.android.tools.profilers.tasks.taskhandlers.ProfilerTaskHandler;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/profilers/tasks/TaskSupportUtils;", "", "<init>", "()V", "isTaskSupportedByRecording", "", "taskHandler", "Lcom/android/tools/profilers/tasks/taskhandlers/ProfilerTaskHandler;", "selectedRecording", "Lcom/android/tools/profilers/sessions/SessionItem;", "doesDeviceSupportProfilingTaskFromProcessStart", "taskType", "Lcom/android/tools/profilers/tasks/ProfilerTaskType;", "featureLevel", "", "getProcessStartMinApi", "intellij.android.profilers"})
public final class TaskSupportUtils {
    @NotNull
    public static final TaskSupportUtils INSTANCE = new TaskSupportUtils();

    private TaskSupportUtils() {
    }

    public final boolean isTaskSupportedByRecording(@NotNull ProfilerTaskHandler taskHandler, @NotNull SessionItem selectedRecording) {
        Intrinsics.checkNotNullParameter((Object)taskHandler, (String)"taskHandler");
        Intrinsics.checkNotNullParameter((Object)selectedRecording, (String)"selectedRecording");
        return selectedRecording.containsExactlyOneArtifact() && taskHandler.supportsArtifact((SessionArtifact)CollectionsKt.first(selectedRecording.getChildArtifacts()));
    }

    public final boolean doesDeviceSupportProfilingTaskFromProcessStart(@NotNull ProfilerTaskType taskType, int featureLevel) {
        Intrinsics.checkNotNullParameter((Object)((Object)taskType), (String)"taskType");
        return featureLevel >= this.getProcessStartMinApi(taskType);
    }

    public final int getProcessStartMinApi(@NotNull ProfilerTaskType taskType) {
        Intrinsics.checkNotNullParameter((Object)((Object)taskType), (String)"taskType");
        return switch (WhenMappings.$EnumSwitchMapping$0[taskType.ordinal()]) {
            case 1, 2, 3 -> 26;
            case 4 -> 29;
            default -> Integer.MAX_VALUE;
        };
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProfilerTaskType.values().length];
            try {
                nArray[ProfilerTaskType.SYSTEM_TRACE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProfilerTaskType.CALLSTACK_SAMPLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProfilerTaskType.JAVA_KOTLIN_METHOD_RECORDING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProfilerTaskType.NATIVE_ALLOCATIONS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

