/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.chart;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipView;
import com.android.tools.adtui.chart.hchart.HTreeChart;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.profilers.ChartTooltipViewBase;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet;
import com.android.tools.profilers.memory.adapters.classifiers.NativeCallStackSet;
import com.android.tools.profilers.memory.chart.ClassifierSetHNode;
import com.android.tools.profilers.memory.chart.VisualizationTooltipModel;
import java.awt.Component;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/profilers/memory/chart/MemoryVisualizationTooltipView;", "Lcom/android/tools/profilers/ChartTooltipViewBase;", "Lcom/android/tools/profilers/memory/chart/ClassifierSetHNode;", "chart", "Lcom/android/tools/adtui/chart/hchart/HTreeChart;", "tooltipRoot", "Ljavax/swing/JComponent;", "model", "Lcom/android/tools/profilers/memory/chart/VisualizationTooltipModel;", "<init>", "(Lcom/android/tools/adtui/chart/hchart/HTreeChart;Ljavax/swing/JComponent;Lcom/android/tools/profilers/memory/chart/VisualizationTooltipModel;)V", "showTooltip", "", "node", "intellij.android.profilers.ui"})
@StabilityInferred(parameters=0)
public final class MemoryVisualizationTooltipView
extends ChartTooltipViewBase<ClassifierSetHNode> {
    @NotNull
    private final VisualizationTooltipModel model;
    public static final int $stable = 8;

    public MemoryVisualizationTooltipView(@NotNull HTreeChart<ClassifierSetHNode> chart, @NotNull JComponent tooltipRoot, @NotNull VisualizationTooltipModel model) {
        Intrinsics.checkNotNullParameter(chart, (String)"chart");
        Intrinsics.checkNotNullParameter((Object)tooltipRoot, (String)"tooltipRoot");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(chart, tooltipRoot);
        this.model = model;
    }

    @Override
    public void showTooltip(@NotNull ClassifierSetHNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.getTooltipContainer().removeAll();
        JLabel nameLabel = new JLabel(node.getName());
        nameLabel.setFont(TooltipView.TOOLTIP_BODY_FONT);
        nameLabel.setForeground(ProfilerColors.TOOLTIP_TEXT);
        String string = this.model.getVisualizationModel().formatter().getFormattedString(this.model.getCaptureRange().getLength(), (double)node.getDuration(), this.model.getVisualizationModel().isSizeAxis());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFormattedString(...)");
        String formattedNumber = string;
        String string2 = "%s: %s";
        Object object = new Object[]{this.model.getVisualizationModel().isSizeAxis() ? "Size" : "Count", formattedNumber};
        String string3 = String.format(string2, Arrays.copyOf(object, ((Object[])object).length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        JLabel totalLabel = new JLabel(string3);
        this.getTooltipContainer().add((Component)nameLabel, new TabularLayout.Constraint(0, 0, 0, 4, null));
        if (node.getData() instanceof NativeCallStackSet) {
            ClassifierSet classifierSet = node.getData();
            Intrinsics.checkNotNull((Object)classifierSet, (String)"null cannot be cast to non-null type com.android.tools.profilers.memory.adapters.classifiers.NativeCallStackSet");
            NativeCallStackSet nativeCallStackSet = (NativeCallStackSet)classifierSet;
            JPanel jPanel = this.getTooltipContainer();
            object = "Module: %s";
            Object[] objectArray = new Object[]{nativeCallStackSet.getModuleName()};
            String string4 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            jPanel.add((Component)new JLabel(string4), new TabularLayout.Constraint(this.getTooltipContainer().getComponentCount(), 0, 0, 4, null));
            String string5 = nativeCallStackSet.getFileName();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getFileName(...)");
            if (((CharSequence)string5).length() > 0) {
                JPanel jPanel2 = this.getTooltipContainer();
                object = "File: %s";
                objectArray = new Object[]{nativeCallStackSet.getFileName()};
                String string6 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(...)");
                jPanel2.add((Component)new JLabel(string6), new TabularLayout.Constraint(this.getTooltipContainer().getComponentCount(), 0, 0, 4, null));
            }
        }
        this.getTooltipContainer().add((Component)AdtUiUtils.createHorizontalSeparator(), new TabularLayout.Constraint(this.getTooltipContainer().getComponentCount(), 0, 0, 4, null));
        this.getTooltipContainer().add((Component)totalLabel, new TabularLayout.Constraint(this.getTooltipContainer().getComponentCount(), 0, 0, 4, null));
    }
}

