/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters.classifiers;

import com.android.tools.inspectors.common.api.stacktrace.ThreadId;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.classifiers.Classifier;
import com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet;
import com.android.tools.profilers.memory.adapters.classifiers.MethodSet;
import org.jetbrains.annotations.NotNull;

public class ThreadSet
extends ClassifierSet {
    @NotNull
    private final CaptureObject myCaptureObject;
    @NotNull
    private final ThreadId myThreadId;

    @NotNull
    public static Classifier createDefaultClassifier(@NotNull CaptureObject captureObject) {
        return ThreadSet.threadClassifier(captureObject);
    }

    public ThreadSet(@NotNull CaptureObject captureObject, @NotNull ThreadId threadId) {
        super(threadId.toString());
        this.myCaptureObject = captureObject;
        this.myThreadId = threadId;
    }

    @NotNull
    public ThreadId getThreadId() {
        return this.myThreadId;
    }

    @Override
    @NotNull
    public Classifier createSubClassifier() {
        return MethodSet.createDefaultClassifier(this.myCaptureObject);
    }

    private static Classifier threadClassifier(CaptureObject captureObject) {
        return new Classifier.Join(inst -> {
            ThreadId threadId = inst.getAllocationThreadId();
            return threadId == ThreadId.INVALID_THREAD_ID ? null : threadId;
        }, id -> new ThreadSet(captureObject, (ThreadId)id), MethodSet.createDefaultClassifier(captureObject));
    }
}

