/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters.classifiers;

import com.android.tools.idea.codenavigation.CodeLocation;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.classifiers.Classifier;
import com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet;
import com.android.tools.profilers.memory.adapters.classifiers.MethodSet;
import com.google.common.base.Strings;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0002\u0012\u0013B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/profilers/memory/adapters/classifiers/MethodSet;", "Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet;", "captureObject", "Lcom/android/tools/profilers/memory/adapters/CaptureObject;", "methodInfo", "Lcom/android/tools/profilers/memory/adapters/classifiers/MethodSet$MethodSetInfo;", "callstackDepth", "", "<init>", "(Lcom/android/tools/profilers/memory/adapters/CaptureObject;Lcom/android/tools/profilers/memory/adapters/classifiers/MethodSet$MethodSetInfo;I)V", "className", "", "getClassName", "()Ljava/lang/String;", "methodName", "getMethodName", "createSubClassifier", "Lcom/android/tools/profilers/memory/adapters/classifiers/Classifier;", "MethodSetInfo", "Companion", "intellij.android.profilers"})
public final class MethodSet
extends ClassifierSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CaptureObject captureObject;
    @NotNull
    private final MethodSetInfo methodInfo;
    private final int callstackDepth;

    public MethodSet(@NotNull CaptureObject captureObject, @NotNull MethodSetInfo methodInfo, int callstackDepth) {
        Intrinsics.checkNotNullParameter((Object)captureObject, (String)"captureObject");
        Intrinsics.checkNotNullParameter((Object)methodInfo, (String)"methodInfo");
        super((Function0<String>)((Function0)() -> MethodSet._init_$lambda$0(methodInfo)));
        this.captureObject = captureObject;
        this.methodInfo = methodInfo;
        this.callstackDepth = callstackDepth;
    }

    @NotNull
    public final String getClassName() {
        return this.methodInfo.getClassName();
    }

    @NotNull
    public final String getMethodName() {
        return this.methodInfo.getMethodName();
    }

    @Override
    @NotNull
    public Classifier createSubClassifier() {
        return MethodSet.Companion.methodClassifier(this.captureObject, this.callstackDepth);
    }

    private static final String _init_$lambda$0(MethodSetInfo $methodInfo) {
        return $methodInfo.getName();
    }

    @JvmStatic
    @NotNull
    public static final Classifier createDefaultClassifier(@NotNull CaptureObject captureObject) {
        return Companion.createDefaultClassifier(captureObject);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J&\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\n0\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/profilers/memory/adapters/classifiers/MethodSet$Companion;", "", "<init>", "()V", "createDefaultClassifier", "Lcom/android/tools/profilers/memory/adapters/classifiers/Classifier;", "captureObject", "Lcom/android/tools/profilers/memory/adapters/CaptureObject;", "methodClassifier", "Lcom/android/tools/profilers/memory/adapters/classifiers/Classifier$Join;", "Lcom/android/tools/profilers/memory/adapters/classifiers/MethodSet$MethodSetInfo;", "depth", "", "getMethodInfo", "Lkotlin/Function1;", "Lcom/android/tools/profilers/memory/adapters/InstanceObject;", "intellij.android.profilers"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Classifier createDefaultClassifier(@NotNull CaptureObject captureObject) {
            Intrinsics.checkNotNullParameter((Object)captureObject, (String)"captureObject");
            return this.methodClassifier(captureObject, 0);
        }

        private final Classifier.Join<MethodSetInfo> methodClassifier(CaptureObject captureObject, int depth) {
            return new Classifier.Join<MethodSetInfo>(this.getMethodInfo(captureObject, depth), arg_0 -> Companion.methodClassifier$lambda$0(captureObject, depth, arg_0), Classifier.Companion.of(methodClassifier.2.INSTANCE, methodClassifier.3.INSTANCE));
        }

        private final Function1<InstanceObject, MethodSetInfo> getMethodInfo(CaptureObject captureObject, int depth) {
            return arg_0 -> Companion.getMethodInfo$lambda$1(depth, captureObject, arg_0);
        }

        private static final ClassifierSet methodClassifier$lambda$0(CaptureObject $captureObject, int $depth, MethodSetInfo it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new MethodSet($captureObject, it, $depth + 1);
        }

        private static final MethodSetInfo getMethodInfo$lambda$1(int $depth, CaptureObject $captureObject, InstanceObject inst) {
            MethodSetInfo methodSetInfo;
            Intrinsics.checkNotNullParameter((Object)inst, (String)"inst");
            int stackDepth = inst.getCallStackDepth();
            if (stackDepth <= 0 || $depth >= stackDepth) {
                methodSetInfo = null;
            } else {
                int frameIndex = stackDepth - $depth - 1;
                Memory.AllocationStack stack = inst.getAllocationCallStack();
                if (stack == null) {
                    CodeLocation location = inst.getAllocationCodeLocations().get(frameIndex);
                    String string = Strings.nullToEmpty((String)location.getClassName());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nullToEmpty(...)");
                    String string2 = Strings.nullToEmpty((String)location.getMethodName());
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nullToEmpty(...)");
                    methodSetInfo = new MethodSetInfo.ByName(string, string2);
                } else if (stack.getFrameCase() == Memory.AllocationStack.FrameCase.FULL_STACK) {
                    Memory.AllocationStack.StackFrame stackFrame = stack.getFullStack().getFrames(frameIndex);
                    String string = stackFrame.getClassName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
                    String string3 = stackFrame.getMethodName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getMethodName(...)");
                    methodSetInfo = new MethodSetInfo.ByName(string, string3);
                } else if (stack.getFrameCase() == Memory.AllocationStack.FrameCase.ENCODED_STACK) {
                    Memory.AllocationStack.EncodedFrame smallFrame = stack.getEncodedStack().getFrames(frameIndex);
                    methodSetInfo = new MethodSetInfo.ById($captureObject, smallFrame.getMethodId());
                } else {
                    throw new UnsupportedOperationException();
                }
            }
            return methodSetInfo;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\f\rB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007\u0082\u0001\u0002\u000e\u000f\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/profilers/memory/adapters/classifiers/MethodSet$MethodSetInfo;", "", "<init>", "()V", "className", "", "getClassName", "()Ljava/lang/String;", "methodName", "getMethodName", "name", "getName", "ByName", "ById", "Lcom/android/tools/profilers/memory/adapters/classifiers/MethodSet$MethodSetInfo$ById;", "Lcom/android/tools/profilers/memory/adapters/classifiers/MethodSet$MethodSetInfo$ByName;", "intellij.android.profilers"})
    public static abstract sealed class MethodSetInfo {
        private MethodSetInfo() {
        }

        @NotNull
        public abstract String getClassName();

        @NotNull
        public abstract String getMethodName();

        @NotNull
        public final String getName() {
            return this.getMethodName() + "()" + (String)(Strings.isNullOrEmpty((String)this.getClassName()) ? "" : " (" + this.getClassName() + ")");
        }

        public /* synthetic */ MethodSetInfo(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u0015\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\tH\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\n \n*\u0004\u0018\u00010\t0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR7\u0010\u000f\u001a\u001e\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/profilers/memory/adapters/classifiers/MethodSet$MethodSetInfo$ById;", "Lcom/android/tools/profilers/memory/adapters/classifiers/MethodSet$MethodSetInfo;", "captureObject", "Lcom/android/tools/profilers/memory/adapters/CaptureObject;", "methodId", "", "<init>", "(Lcom/android/tools/profilers/memory/adapters/CaptureObject;J)V", "className", "", "kotlin.jvm.PlatformType", "getClassName", "()Ljava/lang/String;", "methodName", "getMethodName", "classAndMethodName", "Lkotlin/Pair;", "getClassAndMethodName", "()Lkotlin/Pair;", "classAndMethodName$delegate", "Lkotlin/Lazy;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.android.profilers"})
        public static final class ById
        extends MethodSetInfo {
            @NotNull
            private final CaptureObject captureObject;
            private final long methodId;
            @NotNull
            private final Lazy classAndMethodName$delegate;

            public ById(@NotNull CaptureObject captureObject, long methodId) {
                Intrinsics.checkNotNullParameter((Object)captureObject, (String)"captureObject");
                super(null);
                this.captureObject = captureObject;
                this.methodId = methodId;
                this.classAndMethodName$delegate = LazyKt.lazy(() -> ById.classAndMethodName_delegate$lambda$0(this));
            }

            @Override
            public String getClassName() {
                return (String)this.getClassAndMethodName().getFirst();
            }

            @Override
            public String getMethodName() {
                return (String)this.getClassAndMethodName().getSecond();
            }

            private final Pair<String, String> getClassAndMethodName() {
                Lazy lazy = this.classAndMethodName$delegate;
                return (Pair)lazy.getValue();
            }

            private final CaptureObject component1() {
                return this.captureObject;
            }

            private final long component2() {
                return this.methodId;
            }

            @NotNull
            public final ById copy(@NotNull CaptureObject captureObject, long methodId) {
                Intrinsics.checkNotNullParameter((Object)captureObject, (String)"captureObject");
                return new ById(captureObject, methodId);
            }

            public static /* synthetic */ ById copy$default(ById byId, CaptureObject captureObject, long l, int n, Object object) {
                if ((n & 1) != 0) {
                    captureObject = byId.captureObject;
                }
                if ((n & 2) != 0) {
                    l = byId.methodId;
                }
                return byId.copy(captureObject, l);
            }

            @NotNull
            public String toString() {
                return "ById(captureObject=" + this.captureObject + ", methodId=" + this.methodId + ")";
            }

            public int hashCode() {
                int result = this.captureObject.hashCode();
                result = result * 31 + Long.hashCode(this.methodId);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ById)) {
                    return false;
                }
                ById byId = (ById)other;
                if (!Intrinsics.areEqual((Object)this.captureObject, (Object)byId.captureObject)) {
                    return false;
                }
                return this.methodId == byId.methodId;
            }

            private static final Pair classAndMethodName_delegate$lambda$0(ById this$0) {
                Memory.AllocationStack.StackFrame stackFrame = this$0.captureObject.getStackFrame(this$0.methodId);
                Intrinsics.checkNotNull((Object)stackFrame);
                Memory.AllocationStack.StackFrame frameInfo = stackFrame;
                return TuplesKt.to((Object)frameInfo.getClassName(), (Object)frameInfo.getMethodName());
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/profilers/memory/adapters/classifiers/MethodSet$MethodSetInfo$ByName;", "Lcom/android/tools/profilers/memory/adapters/classifiers/MethodSet$MethodSetInfo;", "className", "", "methodName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getClassName", "()Ljava/lang/String;", "getMethodName", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.android.profilers"})
        public static final class ByName
        extends MethodSetInfo {
            @NotNull
            private final String className;
            @NotNull
            private final String methodName;

            public ByName(@NotNull String className, @NotNull String methodName) {
                Intrinsics.checkNotNullParameter((Object)className, (String)"className");
                Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
                super(null);
                this.className = className;
                this.methodName = methodName;
            }

            @Override
            @NotNull
            public String getClassName() {
                return this.className;
            }

            @Override
            @NotNull
            public String getMethodName() {
                return this.methodName;
            }

            @NotNull
            public final String component1() {
                return this.className;
            }

            @NotNull
            public final String component2() {
                return this.methodName;
            }

            @NotNull
            public final ByName copy(@NotNull String className, @NotNull String methodName) {
                Intrinsics.checkNotNullParameter((Object)className, (String)"className");
                Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
                return new ByName(className, methodName);
            }

            public static /* synthetic */ ByName copy$default(ByName byName, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = byName.className;
                }
                if ((n & 2) != 0) {
                    string2 = byName.methodName;
                }
                return byName.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "ByName(className=" + this.className + ", methodName=" + this.methodName + ")";
            }

            public int hashCode() {
                int result = this.className.hashCode();
                result = result * 31 + this.methodName.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ByName)) {
                    return false;
                }
                ByName byName = (ByName)other;
                if (!Intrinsics.areEqual((Object)this.className, (Object)byName.className)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.methodName, (Object)byName.methodName);
            }
        }
    }
}

