/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters.classifiers;

import com.android.tools.adtui.model.filter.Filter;
import com.android.tools.profilers.CachedFunction;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.MemoryObject;
import com.android.tools.profilers.memory.adapters.classifiers.Classifier;
import com.android.tools.profilers.memory.adapters.instancefilters.CaptureObjectInstanceFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 \u008a\u00012\u00020\u0001:\b\u0087\u0001\u0088\u0001\u0089\u0001\u008a\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\bJ\b\u0010S\u001a\u00020\u0004H\u0016J\b\u0010T\u001a\u00020UH\u0002J\b\u0010V\u001a\u00020\u000fH\u0002J\b\u0010W\u001a\u00020UH\u0004J\u000e\u0010X\u001a\u00020\u00112\u0006\u0010Y\u001a\u000201J\u000e\u0010Z\u001a\u0002032\u0006\u0010[\u001a\u00020BJ\u000e\u0010\\\u001a\u0002032\u0006\u0010[\u001a\u00020BJ\u0018\u0010]\u001a\u0002032\u0006\u0010[\u001a\u00020B2\u0006\u0010^\u001a\u00020_H\u0002J\u000e\u0010`\u001a\u0002032\u0006\u0010[\u001a\u00020BJ\u000e\u0010a\u001a\u0002032\u0006\u0010[\u001a\u00020BJ\u000e\u0010b\u001a\u0002032\u0006\u0010[\u001a\u00020BJ\u000e\u0010c\u001a\u0002032\u0006\u0010[\u001a\u00020BJ \u0010d\u001a\u00020e2\u0006\u0010[\u001a\u00020B2\u0006\u0010f\u001a\u0002032\u0006\u0010^\u001a\u00020_H\u0002J\u0006\u0010g\u001a\u00020UJ<\u0010h\u001a\b\u0012\u0004\u0012\u00020B0A2\u0012\u0010i\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002030j2\u0018\u0010k\u001a\u0014\u0012\u0004\u0012\u00020l\u0012\n\u0012\b\u0012\u0004\u0012\u00020B0A0jH\u0002J\u0006\u0010m\u001a\u000203J\u0010\u0010n\u001a\u0004\u0018\u00010\u00002\u0006\u0010o\u001a\u00020BJ\u001c\u0010p\u001a\u0004\u0018\u00010\u00002\u0012\u0010q\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002030jJ\u0014\u0010r\u001a\u0002032\f\u0010s\u001a\b\u0012\u0004\u0012\u00020B0tJ\u0016\u0010u\u001a\u00020U2\f\u0010v\u001a\b\u0012\u0004\u0012\u00020B0wH\u0002J&\u0010x\u001a\u00020U\"\u0004\b\u0000\u0010y*\b\u0012\u0004\u0012\u0002Hy0w2\f\u0010z\u001a\b\u0012\u0004\u0012\u0002Hy0tH\u0002J\u0014\u0010{\u001a\u0002032\f\u0010s\u001a\b\u0012\u0004\u0012\u00020B0tJ\u0014\u0010|\u001a\u0002032\f\u0010s\u001a\b\u0012\u0004\u0012\u00020B0tJ\b\u0010}\u001a\u00020~H$J\u0018\u0010\u007f\u001a\u00020U2\u0007\u0010Y\u001a\u00030\u0080\u00012\u0007\u0010\u0081\u0001\u001a\u000203J,\u0010\u007f\u001a\u00020U2\u0007\u0010Y\u001a\u00030\u0080\u00012\u0007\u0010\u0082\u0001\u001a\u0002032\u0007\u0010\u0083\u0001\u001a\u0002032\u0007\u0010\u0081\u0001\u001a\u000203H\u0002J\n\u0010\u0084\u0001\u001a\u00030\u0085\u0001H\u0002J\u0011\u0010\u0086\u0001\u001a\u00020\u00112\u0006\u0010Y\u001a\u000201H\u0002R\u001b\u0010\t\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u000e\u0010\u0017\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014R\u001e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0014R\u001e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u001c@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001e\u0010 \u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u001c@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001fR\u001e\u0010\"\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u001c@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001fR\u001e\u0010$\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u001c@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001fR\u0014\u0010&\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u001fR\u001e\u0010(\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u001c@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u001fR\u000e\u0010*\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010+\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0014\"\u0004\b-\u0010.R*\u0010/\u001a\u001e\u0012\f\u0012\n 2*\u0004\u0018\u00010101\u0012\f\u0012\n 2*\u0004\u0018\u00010\u00110\u001100X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u00104\u001a\u0002032\u0006\u0010\u0010\u001a\u000203@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u0012\u00108\u001a\u0002038\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u00109\u001a\u0002038F\u00a2\u0006\u0006\u001a\u0004\b9\u00105R\u0011\u0010:\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b;\u0010\u0014R\u0011\u0010<\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b=\u0010\u001fR\u0011\u0010>\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b?\u0010\u0014R\u0017\u0010@\u001a\b\u0012\u0004\u0012\u00020B0A8F\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR\u001a\u0010E\u001a\b\u0012\u0004\u0012\u00020B0A8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010DR\u001a\u0010G\u001a\b\u0012\u0004\u0012\u00020B0A8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010DR\u0017\u0010I\u001a\b\u0012\u0004\u0012\u00020B0A8F\u00a2\u0006\u0006\u001a\u0004\bJ\u0010DR\u0017\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00000L8F\u00a2\u0006\u0006\u001a\u0004\bM\u0010NR\u0012\u0010O\u001a\u0002038\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010P\u001a\u0002038F\u00a2\u0006\u0006\u001a\u0004\bP\u00105R\u0014\u0010Q\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bR\u0010\u000b\u00a8\u0006\u008b\u0001"}, d2={"Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet;", "Lcom/android/tools/profilers/memory/adapters/MemoryObject;", "supplyName", "Lkotlin/Function0;", "", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "name", "(Ljava/lang/String;)V", "_name", "get_name", "()Ljava/lang/String;", "_name$delegate", "Lkotlin/Lazy;", "state", "Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State;", "value", "", "totalObjectSetCount", "getTotalObjectSetCount", "()I", "filteredObjectSetCount", "getFilteredObjectSetCount", "snapshotObjectCount", "deltaAllocationCount", "getDeltaAllocationCount", "deltaDeallocationCount", "getDeltaDeallocationCount", "", "allocationSize", "getAllocationSize", "()J", "deallocationSize", "getDeallocationSize", "totalNativeSize", "getTotalNativeSize", "totalShallowSize", "getTotalShallowSize", "totalRetainedSize", "getTotalRetainedSize", "deltaShallowSize", "getDeltaShallowSize", "instancesWithStackInfoCount", "filterMatchCount", "getFilterMatchCount", "setFilterMatchCount", "(I)V", "instanceFilterMatchCounter", "Lcom/android/tools/profilers/CachedFunction;", "Lcom/android/tools/profilers/memory/adapters/instancefilters/CaptureObjectInstanceFilter;", "kotlin.jvm.PlatformType", "", "isMatched", "()Z", "setMatched", "(Z)V", "needsRefiltering", "isEmpty", "totalObjectCount", "getTotalObjectCount", "totalRemainingSize", "getTotalRemainingSize", "instancesCount", "getInstancesCount", "instancesStream", "Ljava/util/stream/Stream;", "Lcom/android/tools/profilers/memory/adapters/InstanceObject;", "getInstancesStream", "()Ljava/util/stream/Stream;", "deltaInstanceStream", "getDeltaInstanceStream", "snapshotInstanceStream", "getSnapshotInstanceStream", "filterMatches", "getFilterMatches", "childrenClassifierSets", "", "getChildrenClassifierSets", "()Ljava/util/List;", "myIsFiltered", "isFiltered", "stringForMatching", "getStringForMatching", "getName", "invalidateRetainedSizeCache", "", "ensurePartitioned", "coalesce", "getInstanceFilterMatchCount", "filter", "addSnapshotInstanceObject", "instanceObject", "removeSnapshotInstanceObject", "changeSnapshotInstanceObject", "op", "Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$SetOperation;", "addDeltaInstanceObject", "freeDeltaInstanceObject", "removeAddedDeltaInstanceObject", "removeFreedDeltaInstanceObject", "changeDeltaInstanceInformation", "Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$DeltaChange;", "isAllocation", "clearClassifierSets", "getStreamOf", "condition", "Lkotlin/Function1;", "extract", "Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State$Coalesced;", "hasStackInfo", "findContainingClassifierSet", "target", "findClassifierSet", "test", "isSupersetOf", "targetSet", "", "filterOutInstances", "remainders", "", "removeAllFast", "X", "those", "immediateInstancesOverlapWith", "overlapsWith", "createSubClassifier", "Lcom/android/tools/profilers/memory/adapters/classifiers/Classifier;", "applyFilter", "Lcom/android/tools/adtui/model/filter/Filter;", "filterChanged", "hasMatchedAncestor", "isTopLevel", "initState", "Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State$Coalesced$Delayed;", "countInstanceFilterMatch", "State", "DeltaChange", "SetOperation", "Companion", "intellij.android.profilers"})
@SourceDebugExtension(value={"SMAP\nClassifierSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassifierSet.kt\ncom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,503:1\n1292#2,3:504\n1321#2,2:508\n1255#2,2:510\n1#3:507\n1788#4,4:512\n1788#4,4:516\n*S KotlinDebug\n*F\n+ 1 ClassifierSet.kt\ncom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet\n*L\n105#1:504,3\n377#1:508,2\n411#1:510,2\n485#1:512,4\n486#1:516,4\n*E\n"})
public abstract class ClassifierSet
implements MemoryObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy _name$delegate;
    @NotNull
    private State state;
    private int totalObjectSetCount;
    private int filteredObjectSetCount;
    private int snapshotObjectCount;
    private int deltaAllocationCount;
    private int deltaDeallocationCount;
    private long allocationSize;
    private long deallocationSize;
    private long totalNativeSize;
    private long totalShallowSize;
    private long deltaShallowSize;
    private int instancesWithStackInfoCount;
    private int filterMatchCount;
    @NotNull
    private final CachedFunction<CaptureObjectInstanceFilter, Integer> instanceFilterMatchCounter;
    private boolean isMatched;
    @JvmField
    protected boolean needsRefiltering;
    @JvmField
    protected boolean myIsFiltered;

    public ClassifierSet(@NotNull Function0<String> supplyName) {
        Intrinsics.checkNotNullParameter(supplyName, (String)"supplyName");
        this._name$delegate = LazyKt.lazy(supplyName);
        this.state = this.initState();
        this.instanceFilterMatchCounter = new CachedFunction(new IdentityHashMap(), (Function1)new Function1<CaptureObjectInstanceFilter, Integer>((Object)this){

            public final Integer invoke(CaptureObjectInstanceFilter p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ClassifierSet.access$countInstanceFilterMatch((ClassifierSet)this.receiver, p0);
            }
        });
    }

    public ClassifierSet(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this((Function0<String>)((Function0)() -> ClassifierSet._init_$lambda$0(name)));
    }

    private final String get_name() {
        Lazy lazy = this._name$delegate;
        return (String)lazy.getValue();
    }

    public final int getTotalObjectSetCount() {
        return this.totalObjectSetCount;
    }

    public final int getFilteredObjectSetCount() {
        return this.filteredObjectSetCount;
    }

    public final int getDeltaAllocationCount() {
        return this.deltaAllocationCount;
    }

    public final int getDeltaDeallocationCount() {
        return this.deltaDeallocationCount;
    }

    public final long getAllocationSize() {
        return this.allocationSize;
    }

    public final long getDeallocationSize() {
        return this.deallocationSize;
    }

    public final long getTotalNativeSize() {
        return this.totalNativeSize;
    }

    public final long getTotalShallowSize() {
        return this.totalShallowSize;
    }

    /*
     * WARNING - void declaration
     */
    public long getTotalRetainedSize() {
        long l;
        State s = this.state;
        if (s instanceof State.Coalesced) {
            if (((State.Coalesced)s).getRetainedSize() == -1L) {
                void $this$fold$iv;
                Sequence sequence = SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)((State.Coalesced)s).getSnapshotInstances()), (Sequence)CollectionsKt.asSequence((Iterable)((State.Coalesced)s).getDeltaInstances())), ClassifierSet::_get_totalRetainedSize_$lambda$1));
                long initial$iv = 0L;
                boolean $i$f$fold22 = false;
                long accumulator$iv = initial$iv;
                for (Object element$iv : $this$fold$iv) {
                    void entry2;
                    ClassDb.ClassEntry classEntry = (ClassDb.ClassEntry)element$iv;
                    long sum = accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = entry2.getRetainedSize() == -1L || sum == Long.MAX_VALUE ? Long.MAX_VALUE : sum + entry2.getRetainedSize();
                }
                long maxRetainedSizeByClass = accumulator$iv;
                Sequence $i$f$fold22 = SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)((State.Coalesced)s).getSnapshotInstances()), (Sequence)CollectionsKt.asSequence((Iterable)((State.Coalesced)s).getDeltaInstances()));
                long l2 = 0L;
                for (ClassDb.ClassEntry classEntry : $i$f$fold22) {
                    void it;
                    InstanceObject sum = (InstanceObject)((Object)classEntry);
                    long l3 = l2;
                    boolean bl = false;
                    long l4 = ClassifierSet.Companion.validOrZero(it.getRetainedSize());
                    l2 = l3 + l4;
                }
                long maxRetainedSizeByInstances = l2;
                long maxRetainedSize = Math.min(maxRetainedSizeByClass, maxRetainedSizeByInstances);
                ((State.Coalesced)s).setRetainedSize(maxRetainedSize);
                l = maxRetainedSize;
            } else {
                l = ((State.Coalesced)s).getRetainedSize();
            }
        } else if (s instanceof State.Partitioned) {
            Sequence<ClassifierSet> sequence = ((State.Partitioned)s).getClassifier().getClassifierSetSequence$intellij_android_profilers();
            long l5 = 0L;
            for (Object e : sequence) {
                void it;
                ClassifierSet initial$iv = (ClassifierSet)e;
                long l6 = l5;
                boolean bl = false;
                long l7 = it.getTotalRetainedSize();
                l5 = l6 + l7;
            }
            l = l5;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return l;
    }

    public final long getDeltaShallowSize() {
        return this.deltaShallowSize;
    }

    public final int getFilterMatchCount() {
        return this.filterMatchCount;
    }

    protected final void setFilterMatchCount(int n) {
        this.filterMatchCount = n;
    }

    public final boolean isMatched() {
        return this.isMatched;
    }

    protected final void setMatched(boolean bl) {
        this.isMatched = bl;
    }

    public final boolean isEmpty() {
        return this.snapshotObjectCount == 0 && this.deltaAllocationCount == 0 && this.deltaDeallocationCount == 0;
    }

    public final int getTotalObjectCount() {
        return this.snapshotObjectCount + this.deltaAllocationCount - this.deltaDeallocationCount;
    }

    public final long getTotalRemainingSize() {
        return this.allocationSize - this.deallocationSize;
    }

    public final int getInstancesCount() {
        return (int)this.getInstancesStream().count();
    }

    @NotNull
    public final Stream<InstanceObject> getInstancesStream() {
        return this.getStreamOf((Function1<? super ClassifierSet, Boolean>)((Function1)ClassifierSet::_get_instancesStream_$lambda$5), (Function1<? super State.Coalesced, ? extends Stream<InstanceObject>>)((Function1)ClassifierSet::_get_instancesStream_$lambda$6));
    }

    @NotNull
    protected final Stream<InstanceObject> getDeltaInstanceStream() {
        return this.getStreamOf((Function1<? super ClassifierSet, Boolean>)((Function1)ClassifierSet::_get_deltaInstanceStream_$lambda$7), (Function1<? super State.Coalesced, ? extends Stream<InstanceObject>>)((Function1)ClassifierSet::_get_deltaInstanceStream_$lambda$8));
    }

    @NotNull
    protected final Stream<InstanceObject> getSnapshotInstanceStream() {
        return this.getStreamOf((Function1<? super ClassifierSet, Boolean>)((Function1)ClassifierSet::_get_snapshotInstanceStream_$lambda$9), (Function1<? super State.Coalesced, ? extends Stream<InstanceObject>>)((Function1)ClassifierSet::_get_snapshotInstanceStream_$lambda$10));
    }

    @NotNull
    public final Stream<InstanceObject> getFilterMatches() {
        return this.getStreamOf((Function1<? super ClassifierSet, Boolean>)((Function1)ClassifierSet::_get_filterMatches_$lambda$11), (Function1<? super State.Coalesced, ? extends Stream<InstanceObject>>)((Function1)ClassifierSet::_get_filterMatches_$lambda$12));
    }

    @NotNull
    public final List<ClassifierSet> getChildrenClassifierSets() {
        List<ClassifierSet> list;
        State s = this.ensurePartitioned();
        if (s instanceof State.Coalesced) {
            list = CollectionsKt.emptyList();
        } else if (s instanceof State.Partitioned) {
            list = ((State.Partitioned)s).getClassifier().getFilteredClassifierSets();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    public final boolean isFiltered() {
        return this.isEmpty() || this.myIsFiltered;
    }

    @NotNull
    public String getStringForMatching() {
        return this.get_name();
    }

    @Override
    @NotNull
    public String getName() {
        return this.get_name();
    }

    private final void invalidateRetainedSizeCache() {
        State s = this.state;
        if (s instanceof State.Coalesced) {
            ((State.Coalesced)s).setRetainedSize(-1L);
        }
    }

    private final State ensurePartitioned() {
        State state;
        State it = state = this.state.forced();
        boolean bl = false;
        this.state = it;
        return state;
    }

    protected final void coalesce() {
        this.state = this.state.retracted((Function0<? extends Classifier>)((Function0)new Function0<Classifier>((Object)this){

            public final Classifier invoke() {
                return ((ClassifierSet)this.receiver).createSubClassifier();
            }
        }));
    }

    public final int getInstanceFilterMatchCount(@NotNull CaptureObjectInstanceFilter filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Integer n = this.instanceFilterMatchCounter.invoke(filter);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"invoke(...)");
        return ((Number)n).intValue();
    }

    public final boolean addSnapshotInstanceObject(@NotNull InstanceObject instanceObject) {
        Intrinsics.checkNotNullParameter((Object)instanceObject, (String)"instanceObject");
        return this.changeSnapshotInstanceObject(instanceObject, SetOperation.ADD);
    }

    public final boolean removeSnapshotInstanceObject(@NotNull InstanceObject instanceObject) {
        Intrinsics.checkNotNullParameter((Object)instanceObject, (String)"instanceObject");
        return this.changeSnapshotInstanceObject(instanceObject, SetOperation.REMOVE);
    }

    private final boolean changeSnapshotInstanceObject(InstanceObject instanceObject, SetOperation op) {
        boolean changed = false;
        State s = this.state;
        if (s instanceof State.Partitioned) {
            ClassifierSet classifierSet = ((State.Partitioned)s).getClassifier().getClassifierSet(instanceObject, op == SetOperation.ADD);
            changed = classifierSet != null && classifierSet.changeSnapshotInstanceObject(instanceObject, op);
        } else if (s instanceof State.Coalesced) {
            changed = op == SetOperation.ADD != ((State.Coalesced)s).getSnapshotInstances().contains(instanceObject);
            op.getInvoke().invoke(((State.Coalesced)s).getSnapshotInstances(), (Object)instanceObject);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        if (changed) {
            this.snapshotObjectCount += op.getCountChange();
            this.totalNativeSize += (long)op.getCountChange() * ClassifierSet.Companion.validOrZero(instanceObject.getNativeSize());
            this.totalShallowSize += (long)op.getCountChange() * ClassifierSet.Companion.validOrZero(instanceObject.getShallowSize());
            this.invalidateRetainedSizeCache();
            if (!instanceObject.isCallStackEmpty()) {
                this.instancesWithStackInfoCount += op.getCountChange();
            }
            this.instanceFilterMatchCounter.invalidate();
            this.needsRefiltering = true;
        }
        return changed;
    }

    public final boolean addDeltaInstanceObject(@NotNull InstanceObject instanceObject) {
        Intrinsics.checkNotNullParameter((Object)instanceObject, (String)"instanceObject");
        return this.changeDeltaInstanceInformation(instanceObject, true, SetOperation.ADD).getInstanceChanged();
    }

    public final boolean freeDeltaInstanceObject(@NotNull InstanceObject instanceObject) {
        Intrinsics.checkNotNullParameter((Object)instanceObject, (String)"instanceObject");
        return this.changeDeltaInstanceInformation(instanceObject, false, SetOperation.ADD).getInstanceChanged();
    }

    public final boolean removeAddedDeltaInstanceObject(@NotNull InstanceObject instanceObject) {
        Intrinsics.checkNotNullParameter((Object)instanceObject, (String)"instanceObject");
        return this.changeDeltaInstanceInformation(instanceObject, true, SetOperation.REMOVE).getInstanceChanged();
    }

    public final boolean removeFreedDeltaInstanceObject(@NotNull InstanceObject instanceObject) {
        Intrinsics.checkNotNullParameter((Object)instanceObject, (String)"instanceObject");
        return this.changeDeltaInstanceInformation(instanceObject, false, SetOperation.REMOVE).getInstanceChanged();
    }

    private final DeltaChange changeDeltaInstanceInformation(InstanceObject instanceObject, boolean isAllocation, SetOperation op) {
        DeltaChange change;
        Object object;
        State s = this.state;
        boolean bl = false;
        if (s instanceof State.Partitioned) {
            ClassifierSet classifierSet = ((State.Partitioned)s).getClassifier().getClassifierSet(instanceObject, op == SetOperation.ADD);
            object = classifierSet;
            if (object == null || (object = super.changeDeltaInstanceInformation(instanceObject, isAllocation, op)) == null) {
                object = DeltaChange.UNCHANGED;
            }
        } else if (s instanceof State.Coalesced && (op == SetOperation.ADD || !instanceObject.hasTimeData()) && op == SetOperation.ADD != ((State.Coalesced)s).getDeltaInstances().contains(instanceObject)) {
            op.getInvoke().invoke(((State.Coalesced)s).getDeltaInstances(), (Object)instanceObject);
            object = DeltaChange.INSTANCE_ADDED_OR_REMOVED;
        } else {
            object = DeltaChange.INSTANCE_MODIFIED;
        }
        if ((change = object).getCountsChanged()) {
            if (isAllocation) {
                this.deltaAllocationCount += op.getCountChange() * instanceObject.getInstanceCount();
                this.allocationSize += (long)(op.getCountChange() * instanceObject.getShallowSize());
            } else {
                this.deltaDeallocationCount += op.getCountChange() * instanceObject.getInstanceCount();
                this.deallocationSize += (long)(op.getCountChange() * instanceObject.getShallowSize());
            }
            int factor = op.getCountChange() * (isAllocation ? 1 : -1);
            long deltaNativeSize = (long)factor * ClassifierSet.Companion.validOrZero(instanceObject.getNativeSize());
            long deltaShallowSize = (long)factor * ClassifierSet.Companion.validOrZero(instanceObject.getShallowSize());
            long deltaRetainedSize = (long)factor * ClassifierSet.Companion.validOrZero(instanceObject.getRetainedSize());
            this.totalNativeSize += deltaNativeSize;
            this.deltaShallowSize += deltaShallowSize;
            this.totalShallowSize += deltaShallowSize;
            this.invalidateRetainedSizeCache();
            if (change.getInstanceChanged() && !instanceObject.isCallStackEmpty()) {
                this.instancesWithStackInfoCount += op.getCountChange();
                this.needsRefiltering = true;
            }
            if (change.getInstanceChanged()) {
                this.instanceFilterMatchCounter.invalidate();
            }
        }
        return change;
    }

    public final void clearClassifierSets() {
        this.state = this.initState().forced();
        this.snapshotObjectCount = 0;
        this.deltaAllocationCount = 0;
        this.deltaDeallocationCount = 0;
        this.allocationSize = 0L;
        this.deallocationSize = 0L;
        this.totalShallowSize = 0L;
        this.totalNativeSize = 0L;
        this.invalidateRetainedSizeCache();
        this.deltaShallowSize = 0L;
        this.instancesWithStackInfoCount = 0;
        this.totalObjectSetCount = 0;
        this.filteredObjectSetCount = 0;
        this.filterMatchCount = 0;
    }

    private final Stream<InstanceObject> getStreamOf(Function1<? super ClassifierSet, Boolean> condition, Function1<? super State.Coalesced, ? extends Stream<InstanceObject>> extract) {
        Stream stream;
        State s = this.state;
        boolean bl = false;
        if (!((Boolean)condition.invoke((Object)this)).booleanValue()) {
            Stream stream2 = Stream.empty();
            stream = stream2;
            Intrinsics.checkNotNullExpressionValue(stream2, (String)"empty(...)");
        } else if (s instanceof State.Coalesced) {
            stream = (Stream)extract.invoke((Object)s);
        } else {
            Intrinsics.checkNotNull((Object)s, (String)"null cannot be cast to non-null type com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet.State.Partitioned");
            Stream stream3 = StreamsKt.asStream(((State.Partitioned)s).getClassifier().getClassifierSetSequence$intellij_android_profilers()).flatMap(arg_0 -> ClassifierSet.getStreamOf$lambda$17$lambda$16(arg_0 -> ClassifierSet.getStreamOf$lambda$17$lambda$15(condition, extract, arg_0), arg_0));
            stream = stream3;
            Intrinsics.checkNotNullExpressionValue(stream3, (String)"flatMap(...)");
        }
        return stream;
    }

    public final boolean hasStackInfo() {
        return this.instancesWithStackInfoCount > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final ClassifierSet findContainingClassifierSet(@NotNull InstanceObject target) {
        ClassifierSet classifierSet;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        State s = this.state;
        boolean bl = false;
        if (s instanceof State.Coalesced && (((State.Coalesced)s).getSnapshotInstances().contains(target) || ((State.Coalesced)s).getDeltaInstances().contains(target))) {
            State forcedState = this.ensurePartitioned();
            if (forcedState instanceof State.Coalesced) {
                classifierSet = this;
                return classifierSet;
            }
            if (!(forcedState instanceof State.Partitioned)) throw new NoWhenBranchMatchedException();
            for (ClassifierSet it : ((State.Partitioned)forcedState).getClassifier().getClassifierSetSequence$intellij_android_profilers()) {
                boolean bl2 = false;
                if ((it = it.findContainingClassifierSet(target)) == null) continue;
                classifierSet = it;
                return classifierSet;
            }
            classifierSet = null;
            return classifierSet;
        }
        if (s instanceof State.Partitioned) {
            for (ClassifierSet it : ((State.Partitioned)s).getClassifier().getClassifierSetSequence$intellij_android_profilers()) {
                boolean bl3 = false;
                ClassifierSet classifierSet2 = it.findContainingClassifierSet(target);
                if (classifierSet2 == null) continue;
                classifierSet = classifierSet2;
                return classifierSet;
            }
            classifierSet = null;
            return classifierSet;
        }
        classifierSet = null;
        return classifierSet;
    }

    @Nullable
    public final ClassifierSet findClassifierSet(@NotNull Function1<? super ClassifierSet, Boolean> test) {
        ClassifierSet classifierSet;
        block3: {
            Intrinsics.checkNotNullParameter(test, (String)"test");
            if (((Boolean)test.invoke((Object)this)).booleanValue()) {
                classifierSet = this;
            } else {
                for (ClassifierSet it : (Iterable)this.getChildrenClassifierSets()) {
                    boolean bl = false;
                    ClassifierSet classifierSet2 = it.findClassifierSet(test);
                    if (classifierSet2 == null) continue;
                    classifierSet = classifierSet2;
                    break block3;
                }
                classifierSet = null;
            }
        }
        return classifierSet;
    }

    public final boolean isSupersetOf(@NotNull Set<? extends InstanceObject> targetSet) {
        Set<InstanceObject> set;
        Intrinsics.checkNotNullParameter(targetSet, (String)"targetSet");
        Set<InstanceObject> $this$isSupersetOf_u24lambda_u2422 = set = Collections.newSetFromMap(new IdentityHashMap());
        boolean bl = false;
        $this$isSupersetOf_u24lambda_u2422.addAll((Collection)targetSet);
        Set<InstanceObject> clone = set;
        Intrinsics.checkNotNull(clone);
        this.filterOutInstances(clone);
        return clone.isEmpty();
    }

    private final void filterOutInstances(Set<InstanceObject> remainders) {
        State s = this.state;
        if (remainders.isEmpty()) {
            return;
        }
        if (s instanceof State.Coalesced) {
            this.removeAllFast(remainders, ((State.Coalesced)s).getDeltaInstances());
            this.removeAllFast(remainders, ((State.Coalesced)s).getSnapshotInstances());
        } else if (s instanceof State.Partitioned) {
            Sequence<ClassifierSet> $this$forEach$iv = ((State.Partitioned)s).getClassifier().getClassifierSetSequence$intellij_android_profilers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ClassifierSet child = (ClassifierSet)element$iv;
                boolean bl = false;
                child.filterOutInstances(remainders);
                if (!remainders.isEmpty()) continue;
                return;
            }
        }
    }

    private final <X> void removeAllFast(Set<X> $this$removeAllFast, Set<? extends X> those) {
        if ($this$removeAllFast.size() < those.size()) {
            $this$removeAllFast.removeAll((Collection)those);
        } else {
            for (X that : those) {
                $this$removeAllFast.remove(that);
            }
        }
    }

    public final boolean immediateInstancesOverlapWith(@NotNull Set<? extends InstanceObject> targetSet) {
        Intrinsics.checkNotNullParameter(targetSet, (String)"targetSet");
        State s = this.state;
        boolean bl = false;
        return s instanceof State.Coalesced && (ClassifierSet.Companion.overlaps(((State.Coalesced)s).getDeltaInstances(), targetSet) || ClassifierSet.Companion.overlaps(((State.Coalesced)s).getSnapshotInstances(), targetSet));
    }

    public final boolean overlapsWith(@NotNull Set<? extends InstanceObject> targetSet) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(targetSet, (String)"targetSet");
            State s = this.state;
            if (s instanceof State.Coalesced) {
                bl = this.immediateInstancesOverlapWith(targetSet);
            } else if (s instanceof State.Partitioned) {
                Sequence<ClassifierSet> $this$any$iv = ((State.Partitioned)s).getClassifier().getClassifierSetSequence$intellij_android_profilers();
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    ClassifierSet it = (ClassifierSet)element$iv;
                    boolean bl2 = false;
                    if (!it.overlapsWith(targetSet)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @NotNull
    protected abstract Classifier createSubClassifier();

    public final void applyFilter(@NotNull Filter filter, boolean filterChanged) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        this.applyFilter(filter, false, true, filterChanged);
    }

    private final void applyFilter(Filter filter, boolean hasMatchedAncestor, boolean isTopLevel, boolean filterChanged) {
        if (!filterChanged && !this.needsRefiltering) {
            return;
        }
        this.isMatched = !isTopLevel && filter.matches(this.getStringForMatching());
        this.filterMatchCount = this.isMatched ? 1 : 0;
        State s = this.ensurePartitioned();
        if (s instanceof State.Coalesced.Leaf) {
            this.myIsFiltered = !this.isMatched && !hasMatchedAncestor;
            this.needsRefiltering = false;
        } else if (s instanceof State.Partitioned) {
            this.myIsFiltered = true;
            this.snapshotObjectCount = 0;
            this.deltaAllocationCount = 0;
            this.deltaDeallocationCount = 0;
            this.allocationSize = 0L;
            this.deallocationSize = 0L;
            this.totalShallowSize = 0L;
            this.totalNativeSize = 0L;
            this.instancesWithStackInfoCount = 0;
            this.totalObjectSetCount = SequencesKt.count(((State.Partitioned)s).getClassifier().getClassifierSetSequence$intellij_android_profilers());
            this.filteredObjectSetCount = 0;
            for (Object e : ((State.Partitioned)s).getClassifier().getClassifierSetSequence$intellij_android_profilers()) {
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                ClassifierSet classifierSet = (ClassifierSet)e;
                classifierSet.applyFilter(filter, hasMatchedAncestor || this.isMatched, false, filterChanged);
                this.totalObjectSetCount += classifierSet.totalObjectSetCount;
                if (classifierSet.isFiltered()) continue;
                this.myIsFiltered = false;
                this.snapshotObjectCount += classifierSet.snapshotObjectCount;
                this.deltaAllocationCount += classifierSet.deltaAllocationCount;
                this.deltaDeallocationCount += classifierSet.deltaDeallocationCount;
                this.allocationSize += classifierSet.allocationSize;
                this.deallocationSize += classifierSet.deallocationSize;
                this.totalShallowSize += classifierSet.totalShallowSize;
                this.totalNativeSize += classifierSet.totalNativeSize;
                this.deltaShallowSize += classifierSet.deltaShallowSize;
                this.instancesWithStackInfoCount += classifierSet.instancesWithStackInfoCount;
                this.filterMatchCount += classifierSet.filterMatchCount;
                int n = this.filteredObjectSetCount;
                this.filteredObjectSetCount = n + 1;
            }
        } else {
            throw new IllegalStateException();
        }
        this.needsRefiltering = false;
    }

    private final State.Coalesced.Delayed initState() {
        return new State.Coalesced.Delayed((Function0<? extends Classifier>)((Function0)new Function0<Classifier>((Object)this){

            public final Classifier invoke() {
                return ((ClassifierSet)this.receiver).createSubClassifier();
            }
        }), (Set<InstanceObject>)new LinkedHashSet(0), new LinkedHashSet(0));
    }

    /*
     * WARNING - void declaration
     */
    private final int countInstanceFilterMatch(CaptureObjectInstanceFilter filter) {
        int n;
        State s = this.state;
        if (s instanceof State.Partitioned) {
            Sequence<ClassifierSet> sequence = ((State.Partitioned)s).getClassifier().getClassifierSetSequence$intellij_android_profilers();
            int n2 = 0;
            for (Object e : sequence) {
                void it;
                ClassifierSet classifierSet = (ClassifierSet)e;
                int n3 = n2;
                boolean bl = false;
                int n4 = it.getInstanceFilterMatchCount(filter);
                n2 = n3 + n4;
            }
            n = n2;
        } else if (s instanceof State.Coalesced) {
            int n5;
            int n6;
            Iterable $this$count$iv;
            Iterable iterable = ((State.Coalesced)s).getDeltaInstances();
            Function1<InstanceObject, Boolean> predicate$iv = filter.getInstanceTest();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n6 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    if (!((Boolean)predicate$iv.invoke(element$iv)).booleanValue() || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n6 = count$iv;
            }
            $this$count$iv = ((State.Coalesced)s).getSnapshotInstances();
            int n7 = n6;
            boolean $i$f$count2 = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n5 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    InstanceObject it = (InstanceObject)element$iv;
                    boolean bl = false;
                    if (!(!((State.Coalesced)s).getDeltaInstances().contains(it) && (Boolean)filter.getInstanceTest().invoke((Object)it) != false) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n5 = count$iv;
            }
            int n8 = n5;
            n = n7 + n8;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    private static final String _init_$lambda$0(String $name) {
        return $name;
    }

    private static final ClassDb.ClassEntry _get_totalRetainedSize_$lambda$1(InstanceObject it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getClassEntry();
    }

    private static final boolean _get_instancesStream_$lambda$5(ClassifierSet it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final Stream _get_instancesStream_$lambda$6(State.Coalesced it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Stream stream = Stream.concat(it.getSnapshotInstances().stream(), it.getDeltaInstances().stream()).distinct();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"distinct(...)");
        return stream;
    }

    private static final boolean _get_deltaInstanceStream_$lambda$7(ClassifierSet it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final Stream _get_deltaInstanceStream_$lambda$8(State.Coalesced it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Stream stream = it.getDeltaInstances().stream();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"stream(...)");
        return stream;
    }

    private static final boolean _get_snapshotInstanceStream_$lambda$9(ClassifierSet it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final Stream _get_snapshotInstanceStream_$lambda$10(State.Coalesced it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Stream stream = it.getSnapshotInstances().stream();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"stream(...)");
        return stream;
    }

    private static final boolean _get_filterMatches_$lambda$11(ClassifierSet it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isMatched;
    }

    private static final Stream _get_filterMatches_$lambda$12(State.Coalesced it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Stream stream = Stream.concat(it.getSnapshotInstances().stream(), it.getDeltaInstances().stream());
        Intrinsics.checkNotNullExpressionValue(stream, (String)"concat(...)");
        return stream;
    }

    private static final Stream getStreamOf$lambda$17$lambda$15(Function1 $condition, Function1 $extract, ClassifierSet it) {
        return it.getStreamOf((Function1<? super ClassifierSet, Boolean>)$condition, (Function1<? super State.Coalesced, ? extends Stream<InstanceObject>>)$extract);
    }

    private static final Stream getStreamOf$lambda$17$lambda$16(Function1 $tmp0, Object p0) {
        return (Stream)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ int access$countInstanceFilterMatch(ClassifierSet $this, CaptureObjectInstanceFilter filter) {
        return $this.countInstanceFilterMatch(filter);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\f\u0010\n\u001a\u00020\u000b*\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$Companion;", "", "<init>", "()V", "overlaps", "", "set1", "", "Lcom/android/tools/profilers/memory/adapters/InstanceObject;", "set2", "validOrZero", "", "intellij.android.profilers"})
    @SourceDebugExtension(value={"SMAP\nClassifierSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassifierSet.kt\ncom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,503:1\n1761#2,3:504\n*S KotlinDebug\n*F\n+ 1 ClassifierSet.kt\ncom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$Companion\n*L\n498#1:504,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean overlaps(Set<? extends InstanceObject> set1, Set<? extends InstanceObject> set2) {
            boolean bl;
            block3: {
                Set<? extends InstanceObject> iter = set1.size() < set2.size() ? set1 : set2;
                Set<? extends InstanceObject> test = iter == set1 ? set2 : set1;
                Iterable $this$any$iv = iter;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        InstanceObject p0 = (InstanceObject)element$iv;
                        boolean bl2 = false;
                        if (!test.contains(p0)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final long validOrZero(long $this$validOrZero) {
            return $this$validOrZero == -1L ? 0L : $this$validOrZero;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$DeltaChange;", "", "countsChanged", "", "instanceChanged", "<init>", "(Ljava/lang/String;IZZ)V", "getCountsChanged", "()Z", "getInstanceChanged", "UNCHANGED", "INSTANCE_MODIFIED", "INSTANCE_ADDED_OR_REMOVED", "intellij.android.profilers"})
    private static final class DeltaChange
    extends Enum<DeltaChange> {
        private final boolean countsChanged;
        private final boolean instanceChanged;
        public static final /* enum */ DeltaChange UNCHANGED = new DeltaChange(false, false);
        public static final /* enum */ DeltaChange INSTANCE_MODIFIED = new DeltaChange(true, false);
        public static final /* enum */ DeltaChange INSTANCE_ADDED_OR_REMOVED = new DeltaChange(true, true);
        private static final /* synthetic */ DeltaChange[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private DeltaChange(boolean countsChanged, boolean instanceChanged) {
            this.countsChanged = countsChanged;
            this.instanceChanged = instanceChanged;
        }

        public final boolean getCountsChanged() {
            return this.countsChanged;
        }

        public final boolean getInstanceChanged() {
            return this.instanceChanged;
        }

        public static DeltaChange[] values() {
            return (DeltaChange[])$VALUES.clone();
        }

        public static DeltaChange valueOf(String value) {
            return Enum.valueOf(DeltaChange.class, value);
        }

        @NotNull
        public static EnumEntries<DeltaChange> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = deltaChangeArray = new DeltaChange[]{DeltaChange.UNCHANGED, DeltaChange.INSTANCE_MODIFIED, DeltaChange.INSTANCE_ADDED_OR_REMOVED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B1\b\u0002\u0012\u001e\u0010\u0002\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nR)\u0010\u0002\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$SetOperation;", "", "invoke", "Lkotlin/Function2;", "", "Lcom/android/tools/profilers/memory/adapters/InstanceObject;", "", "countChange", "", "<init>", "(Ljava/lang/String;ILkotlin/jvm/functions/Function2;I)V", "getInvoke", "()Lkotlin/jvm/functions/Function2;", "getCountChange", "()I", "ADD", "REMOVE", "intellij.android.profilers"})
    private static final class SetOperation
    extends Enum<SetOperation> {
        @NotNull
        private final Function2<Set<InstanceObject>, InstanceObject, Unit> invoke;
        private final int countChange;
        public static final /* enum */ SetOperation ADD = new SetOperation((Function2<? super Set<InstanceObject>, ? super InstanceObject, Unit>)((Function2)1.INSTANCE), 1);
        public static final /* enum */ SetOperation REMOVE = new SetOperation((Function2<? super Set<InstanceObject>, ? super InstanceObject, Unit>)((Function2)2.INSTANCE), -1);
        private static final /* synthetic */ SetOperation[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private SetOperation(Function2<? super Set<InstanceObject>, ? super InstanceObject, Unit> invoke, int countChange) {
            this.invoke = invoke;
            this.countChange = countChange;
        }

        @NotNull
        public final Function2<Set<InstanceObject>, InstanceObject, Unit> getInvoke() {
            return this.invoke;
        }

        public final int getCountChange() {
            return this.countChange;
        }

        public static SetOperation[] values() {
            return (SetOperation[])$VALUES.clone();
        }

        public static SetOperation valueOf(String value) {
            return Enum.valueOf(SetOperation.class, value);
        }

        @NotNull
        public static EnumEntries<SetOperation> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = setOperationArray = new SetOperation[]{SetOperation.ADD, SetOperation.REMOVE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\n\u000bB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0006\u0010\t\u001a\u00020\u0000\u0082\u0001\u0002\u0005\f\u00a8\u0006\r"}, d2={"Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State;", "", "<init>", "()V", "retracted", "Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State$Coalesced;", "makeClassifier", "Lkotlin/Function0;", "Lcom/android/tools/profilers/memory/adapters/classifiers/Classifier;", "forced", "Coalesced", "Partitioned", "Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State$Partitioned;", "intellij.android.profilers"})
    @SourceDebugExtension(value={"SMAP\nClassifierSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassifierSet.kt\ncom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,503:1\n1#2:504\n978#3,5:505\n*S KotlinDebug\n*F\n+ 1 ClassifierSet.kt\ncom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State\n*L\n58#1:505,5\n*E\n"})
    private static abstract sealed class State {
        private State() {
        }

        @NotNull
        public final Coalesced retracted(@NotNull Function0<? extends Classifier> makeClassifier) {
            Coalesced coalesced;
            Intrinsics.checkNotNullParameter(makeClassifier, (String)"makeClassifier");
            State state = this;
            if (state instanceof Coalesced) {
                coalesced = (Coalesced)this;
            } else if (state instanceof Partitioned) {
                Sequence<ClassifierSet> subs = ((Partitioned)this).getClassifier().getClassifierSetSequence$intellij_android_profilers();
                boolean bl = false;
                coalesced = new Coalesced.Delayed(makeClassifier, State.retracted$lambda$3$instances(subs, (Function1<? super ClassifierSet, ? extends Stream<InstanceObject>>)((Function1)State::retracted$lambda$3$lambda$1)), State.retracted$lambda$3$instances(subs, (Function1<? super ClassifierSet, ? extends Stream<InstanceObject>>)((Function1)State::retracted$lambda$3$lambda$2)));
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return coalesced;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NotNull
        public final State forced() {
            State state;
            State state2 = this;
            if (state2 instanceof Partitioned || state2 instanceof Coalesced.Leaf) {
                state = this;
                return state;
            } else {
                if (!(state2 instanceof Coalesced.Delayed)) throw new NoWhenBranchMatchedException();
                Classifier c = (Classifier)((Coalesced.Delayed)this).getMakeClassifier().invoke();
                if (c instanceof Classifier.Id) {
                    state = new Coalesced.Leaf(((Coalesced.Delayed)this).getSnapshotInstances(), ((Coalesced.Delayed)this).getDeltaInstances());
                    return state;
                } else {
                    if (!(c instanceof Classifier.Join)) throw new NoWhenBranchMatchedException();
                    Classifier classifier = c;
                    Classifier.Join it = (Classifier.Join)classifier;
                    boolean bl = false;
                    it.partition((Collection<? extends InstanceObject>)((Coalesced.Delayed)this).getSnapshotInstances(), (Collection<? extends InstanceObject>)((Coalesced.Delayed)this).getDeltaInstances());
                    Classifier classifier2 = classifier;
                    state = new Partitioned(classifier2);
                }
            }
            return state;
        }

        /*
         * WARNING - void declaration
         */
        private static final Set<InstanceObject> retracted$lambda$3$instances(Sequence<? extends ClassifierSet> $subs, Function1<? super ClassifierSet, ? extends Stream<InstanceObject>> extract) {
            void var3_3;
            void $this$flatMapTo$iv;
            Sequence<? extends ClassifierSet> sequence = $subs;
            Collection destination$iv = new LinkedHashSet();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                ClassifierSet it = (ClassifierSet)element$iv;
                boolean bl = false;
                Sequence list$iv = StreamsKt.asSequence((Stream)((Stream)extract.invoke((Object)it)));
                CollectionsKt.addAll((Collection)destination$iv, (Sequence)list$iv);
            }
            return (Set)var3_3;
        }

        private static final Stream retracted$lambda$3$lambda$1(ClassifierSet it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getSnapshotInstanceStream();
        }

        private static final Stream retracted$lambda$3$lambda$2(ClassifierSet it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getDeltaInstanceStream();
        }

        public /* synthetic */ State(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B%\b\u0004\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u0082\u0001\u0002\u0013\u0014\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State$Coalesced;", "Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State;", "snapshotInstances", "", "Lcom/android/tools/profilers/memory/adapters/InstanceObject;", "deltaInstances", "<init>", "(Ljava/util/Set;Ljava/util/Set;)V", "getSnapshotInstances", "()Ljava/util/Set;", "getDeltaInstances", "retainedSize", "", "getRetainedSize", "()J", "setRetainedSize", "(J)V", "Leaf", "Delayed", "Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State$Coalesced$Delayed;", "Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State$Coalesced$Leaf;", "intellij.android.profilers"})
        public static abstract sealed class Coalesced
        extends State {
            @NotNull
            private final Set<InstanceObject> snapshotInstances;
            @NotNull
            private final Set<InstanceObject> deltaInstances;
            private long retainedSize;

            private Coalesced(Set<InstanceObject> snapshotInstances, Set<InstanceObject> deltaInstances) {
                super(null);
                this.snapshotInstances = snapshotInstances;
                this.deltaInstances = deltaInstances;
                this.retainedSize = -1L;
            }

            @NotNull
            public final Set<InstanceObject> getSnapshotInstances() {
                return this.snapshotInstances;
            }

            @NotNull
            public final Set<InstanceObject> getDeltaInstances() {
                return this.deltaInstances;
            }

            public final long getRetainedSize() {
                return this.retainedSize;
            }

            public final void setRetainedSize(long l) {
                this.retainedSize = l;
            }

            public /* synthetic */ Coalesced(Set snapshotInstances, Set deltaInstances, DefaultConstructorMarker $constructor_marker) {
                this(snapshotInstances, deltaInstances);
            }

            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State$Coalesced$Delayed;", "Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State$Coalesced;", "makeClassifier", "Lkotlin/Function0;", "Lcom/android/tools/profilers/memory/adapters/classifiers/Classifier;", "snapshotInstances", "", "Lcom/android/tools/profilers/memory/adapters/InstanceObject;", "deltaInstances", "<init>", "(Lkotlin/jvm/functions/Function0;Ljava/util/Set;Ljava/util/Set;)V", "getMakeClassifier", "()Lkotlin/jvm/functions/Function0;", "intellij.android.profilers"})
            public static final class Delayed
            extends Coalesced {
                @NotNull
                private final Function0<Classifier> makeClassifier;

                public Delayed(@NotNull Function0<? extends Classifier> makeClassifier, @NotNull Set<InstanceObject> snapshotInstances, @NotNull Set<InstanceObject> deltaInstances) {
                    Intrinsics.checkNotNullParameter(makeClassifier, (String)"makeClassifier");
                    Intrinsics.checkNotNullParameter(snapshotInstances, (String)"snapshotInstances");
                    Intrinsics.checkNotNullParameter(deltaInstances, (String)"deltaInstances");
                    super(snapshotInstances, deltaInstances, null);
                    this.makeClassifier = makeClassifier;
                }

                @NotNull
                public final Function0<Classifier> getMakeClassifier() {
                    return this.makeClassifier;
                }
            }

            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State$Coalesced$Leaf;", "Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State$Coalesced;", "snapshotInstances", "", "Lcom/android/tools/profilers/memory/adapters/InstanceObject;", "deltaInstances", "<init>", "(Ljava/util/Set;Ljava/util/Set;)V", "intellij.android.profilers"})
            public static final class Leaf
            extends Coalesced {
                public Leaf(@NotNull Set<InstanceObject> snapshotInstances, @NotNull Set<InstanceObject> deltaInstances) {
                    Intrinsics.checkNotNullParameter(snapshotInstances, (String)"snapshotInstances");
                    Intrinsics.checkNotNullParameter(deltaInstances, (String)"deltaInstances");
                    super(snapshotInstances, deltaInstances, null);
                }
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State$Partitioned;", "Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State;", "classifier", "Lcom/android/tools/profilers/memory/adapters/classifiers/Classifier;", "<init>", "(Lcom/android/tools/profilers/memory/adapters/classifiers/Classifier;)V", "getClassifier", "()Lcom/android/tools/profilers/memory/adapters/classifiers/Classifier;", "intellij.android.profilers"})
        public static final class Partitioned
        extends State {
            @NotNull
            private final Classifier classifier;

            public Partitioned(@NotNull Classifier classifier) {
                Intrinsics.checkNotNullParameter((Object)classifier, (String)"classifier");
                super(null);
                this.classifier = classifier;
            }

            @NotNull
            public final Classifier getClassifier() {
                return this.classifier;
            }
        }
    }
}

