/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DurationData;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.adtui.model.axis.ClampedAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.MemoryAxisFormatter;
import com.android.tools.adtui.model.formatter.SingleUnitAxisFormatter;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.UnifiedEventDataSeries;
import com.android.tools.profilers.memory.AllocationSamplingRateDataSeries;
import com.android.tools.profilers.memory.AllocationSamplingRateDurationData;
import com.android.tools.profilers.memory.DetailedMemoryUsage;
import com.android.tools.profilers.memory.GcDurationData;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.MemoryStageLegends;
import com.android.tools.profilers.memory.adapters.MemoryDataProviderKt;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 <2\u00020\u0001:\u0001<B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u00103\u001a\u000204J.\u00105\u001a\u0010\u0012\f\u0012\n \u0016*\u0004\u0018\u0001H6H60\u0014\"\b\b\u0000\u00106*\u0002072\f\u00108\u001a\b\u0012\u0004\u0012\u0002H609H\u0002J\u0016\u0010:\u001a\u0010\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00150\u00150;H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0013\u001a\u0010\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00150\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001f\u0010 \u001a\u0010\u0012\f\u0012\n \u0016*\u0004\u0018\u00010!0!0\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0018R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0016\u0010'\u001a\u00070(\u00a2\u0006\u0002\b\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0016\u0010+\u001a\u00070(\u00a2\u0006\u0002\b\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010*R\u0011\u0010-\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u00101\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00100\u00a8\u0006="}, d2={"Lcom/android/tools/profilers/memory/adapters/MemoryDataProvider;", "", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "timeline", "Lcom/android/tools/adtui/model/StreamingTimeline;", "<init>", "(Lcom/android/tools/profilers/StudioProfilers;Lcom/android/tools/adtui/model/StreamingTimeline;)V", "getProfilers", "()Lcom/android/tools/profilers/StudioProfilers;", "getTimeline", "()Lcom/android/tools/adtui/model/StreamingTimeline;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "sessionData", "Lcom/android/tools/profiler/proto/Common$Session;", "gcStatsModel", "Lcom/android/tools/adtui/model/DurationDataModel;", "Lcom/android/tools/profilers/memory/GcDurationData;", "kotlin.jvm.PlatformType", "getGcStatsModel", "()Lcom/android/tools/adtui/model/DurationDataModel;", "isLiveAllocationTrackingReady", "", "()Z", "allocationSamplingRateDataSeries", "Lcom/android/tools/profilers/memory/AllocationSamplingRateDataSeries;", "getAllocationSamplingRateDataSeries", "()Lcom/android/tools/profilers/memory/AllocationSamplingRateDataSeries;", "allocationSamplingRateDurations", "Lcom/android/tools/profilers/memory/AllocationSamplingRateDurationData;", "getAllocationSamplingRateDurations", "detailedMemoryUsage", "Lcom/android/tools/profilers/memory/DetailedMemoryUsage;", "getDetailedMemoryUsage", "()Lcom/android/tools/profilers/memory/DetailedMemoryUsage;", "memoryAxis", "Lcom/android/tools/adtui/model/axis/ClampedAxisComponentModel;", "getMemoryAxis", "()Lcom/android/tools/adtui/model/axis/ClampedAxisComponentModel;", "objectsAxis", "getObjectsAxis", "legends", "Lcom/android/tools/profilers/memory/MemoryStageLegends;", "getLegends", "()Lcom/android/tools/profilers/memory/MemoryStageLegends;", "tooltipLegends", "getTooltipLegends", "forceGarbageCollection", "", "makeModel", "T", "Lcom/android/tools/adtui/model/DurationData;", "series", "Lcom/android/tools/adtui/model/DataSeries;", "makeGcSeries", "Lcom/android/tools/profilers/UnifiedEventDataSeries;", "Companion", "intellij.android.profilers"})
@SourceDebugExtension(value={"SMAP\nMemoryDataProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryDataProvider.kt\ncom/android/tools/profilers/memory/adapters/MemoryDataProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1563#2:98\n1634#2,3:99\n*S KotlinDebug\n*F\n+ 1 MemoryDataProvider.kt\ncom/android/tools/profilers/memory/adapters/MemoryDataProvider\n*L\n78#1:98\n78#1:99,3\n*E\n"})
public class MemoryDataProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StudioProfilers profilers;
    @NotNull
    private final StreamingTimeline timeline;
    @NotNull
    private final Common.Session sessionData;
    @NotNull
    private final DurationDataModel<GcDurationData> gcStatsModel;
    @NotNull
    private final AllocationSamplingRateDataSeries allocationSamplingRateDataSeries;
    @NotNull
    private final DurationDataModel<AllocationSamplingRateDurationData> allocationSamplingRateDurations;
    @NotNull
    private final DetailedMemoryUsage detailedMemoryUsage;
    @NotNull
    private final ClampedAxisComponentModel memoryAxis;
    @NotNull
    private final ClampedAxisComponentModel objectsAxis;
    @NotNull
    private final MemoryStageLegends legends;
    @NotNull
    private final MemoryStageLegends tooltipLegends;
    @NotNull
    private static final BaseAxisFormatter MEMORY_AXIS_FORMATTER = (BaseAxisFormatter)new MemoryAxisFormatter(1, 5, 5);
    @NotNull
    private static final BaseAxisFormatter OBJECT_COUNT_AXIS_FORMATTER = (BaseAxisFormatter)new SingleUnitAxisFormatter(1, 5, 5, "");

    public MemoryDataProvider(@NotNull StudioProfilers profilers, @NotNull StreamingTimeline timeline) {
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        Intrinsics.checkNotNullParameter((Object)timeline, (String)"timeline");
        this.profilers = profilers;
        this.timeline = timeline;
        Common.Session session = this.profilers.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)session, (String)"getSession(...)");
        this.sessionData = session;
        this.gcStatsModel = this.makeModel(this.makeGcSeries());
        this.allocationSamplingRateDataSeries = new AllocationSamplingRateDataSeries(this.profilers.getClient(), this.sessionData);
        this.allocationSamplingRateDurations = this.makeModel(this.allocationSamplingRateDataSeries);
        this.detailedMemoryUsage = new DetailedMemoryUsage(this.profilers, this.gcStatsModel, this.allocationSamplingRateDurations);
        ClampedAxisComponentModel clampedAxisComponentModel = new ClampedAxisComponentModel.Builder(this.detailedMemoryUsage.getMemoryRange(), MEMORY_AXIS_FORMATTER).build();
        Intrinsics.checkNotNullExpressionValue((Object)clampedAxisComponentModel, (String)"build(...)");
        this.memoryAxis = clampedAxisComponentModel;
        ClampedAxisComponentModel clampedAxisComponentModel2 = new ClampedAxisComponentModel.Builder(this.detailedMemoryUsage.getObjectsRange(), OBJECT_COUNT_AXIS_FORMATTER).build();
        Intrinsics.checkNotNullExpressionValue((Object)clampedAxisComponentModel2, (String)"build(...)");
        this.objectsAxis = clampedAxisComponentModel2;
        Range range = this.timeline.getDataRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getDataRange(...)");
        this.legends = new MemoryStageLegends(this.detailedMemoryUsage, range, false, (Function0<Boolean>)((Function0)new PropertyReference0Impl(this){

            public Object get() {
                return ((MemoryDataProvider)this.receiver).isLiveAllocationTrackingReady();
            }
        }));
        Range range2 = this.timeline.getTooltipRange();
        Intrinsics.checkNotNullExpressionValue((Object)range2, (String)"getTooltipRange(...)");
        this.tooltipLegends = new MemoryStageLegends(this.detailedMemoryUsage, range2, true, (Function0<Boolean>)((Function0)new PropertyReference0Impl(this){

            public Object get() {
                return ((MemoryDataProvider)this.receiver).isLiveAllocationTrackingReady();
            }
        }));
    }

    @NotNull
    public final StudioProfilers getProfilers() {
        return this.profilers;
    }

    @NotNull
    public final StreamingTimeline getTimeline() {
        return this.timeline;
    }

    @NotNull
    protected final Logger getLogger() {
        Logger logger = Logger.getInstance(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    @NotNull
    public final DurationDataModel<GcDurationData> getGcStatsModel() {
        return this.gcStatsModel;
    }

    public final boolean isLiveAllocationTrackingReady() {
        return MemoryProfiler.Companion.isUsingLiveAllocation(this.profilers, this.sessionData);
    }

    @NotNull
    public final AllocationSamplingRateDataSeries getAllocationSamplingRateDataSeries() {
        return this.allocationSamplingRateDataSeries;
    }

    @NotNull
    public final DurationDataModel<AllocationSamplingRateDurationData> getAllocationSamplingRateDurations() {
        return this.allocationSamplingRateDurations;
    }

    @NotNull
    public final DetailedMemoryUsage getDetailedMemoryUsage() {
        return this.detailedMemoryUsage;
    }

    @NotNull
    public final ClampedAxisComponentModel getMemoryAxis() {
        return this.memoryAxis;
    }

    @NotNull
    public final ClampedAxisComponentModel getObjectsAxis() {
        return this.objectsAxis;
    }

    @NotNull
    public final MemoryStageLegends getLegends() {
        return this.legends;
    }

    @NotNull
    public final MemoryStageLegends getTooltipLegends() {
        return this.tooltipLegends;
    }

    public final void forceGarbageCollection() {
        this.profilers.getClient().getTransportClient().execute(Transport.ExecuteRequest.newBuilder().setCommand(Commands.Command.newBuilder().setStreamId(this.sessionData.getStreamId()).setPid(this.sessionData.getPid()).setType(Commands.Command.CommandType.GC)).build());
    }

    private final <T extends DurationData> DurationDataModel<T> makeModel(DataSeries<T> series) {
        Range range = this.timeline.getViewRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getViewRange(...)");
        return new DurationDataModel(new RangedSeries(range, series, null, 4, null));
    }

    private final UnifiedEventDataSeries<GcDurationData> makeGcSeries() {
        return new UnifiedEventDataSeries<GcDurationData>(this.profilers.getClient().getTransportClient(), this.sessionData.getStreamId(), this.sessionData.getPid(), Common.Event.Kind.MEMORY_GC, 0, MemoryDataProvider::makeGcSeries$lambda$1);
    }

    /*
     * WARNING - void declaration
     */
    private static final List makeGcSeries$lambda$1(List events) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNull((Object)events);
        Iterable $this$map$iv = events;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Common.Event event = (Common.Event)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SeriesData(MemoryDataProviderKt.access$nanosToMicros(it.getTimestamp()), (Object)new GcDurationData(MemoryDataProviderKt.access$nanosToMicros(it.getMemoryGc().getDuration()))));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/profilers/memory/adapters/MemoryDataProvider$Companion;", "", "<init>", "()V", "MEMORY_AXIS_FORMATTER", "Lcom/android/tools/adtui/model/formatter/BaseAxisFormatter;", "getMEMORY_AXIS_FORMATTER", "()Lcom/android/tools/adtui/model/formatter/BaseAxisFormatter;", "OBJECT_COUNT_AXIS_FORMATTER", "getOBJECT_COUNT_AXIS_FORMATTER", "getIsLiveAllocationTrackingSupported", "", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "getDeviceForSelectedSession", "Lcom/android/tools/profiler/proto/Common$Device;", "intellij.android.profilers"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BaseAxisFormatter getMEMORY_AXIS_FORMATTER() {
            return MEMORY_AXIS_FORMATTER;
        }

        @NotNull
        public final BaseAxisFormatter getOBJECT_COUNT_AXIS_FORMATTER() {
            return OBJECT_COUNT_AXIS_FORMATTER;
        }

        public final boolean getIsLiveAllocationTrackingSupported(@NotNull StudioProfilers profilers) {
            Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
            Common.Device $this$getIsLiveAllocationTrackingSupported_u24lambda_u240 = this.getDeviceForSelectedSession(profilers);
            boolean bl = false;
            return $this$getIsLiveAllocationTrackingSupported_u24lambda_u240 != null && $this$getIsLiveAllocationTrackingSupported_u24lambda_u240.getFeatureLevel() >= 26;
        }

        @Nullable
        public final Common.Device getDeviceForSelectedSession(@NotNull StudioProfilers profilers) {
            Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
            Common.Stream stream = profilers.getStream(profilers.getSession().getStreamId());
            boolean bl = false;
            return stream.getType() == Common.Stream.Type.DEVICE ? stream.getDevice() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

