/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.TooltipModel;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ClampedAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.MemoryAxisFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.memory.MainMemoryProfilerStage;
import com.android.tools.profilers.memory.MemoryMonitorTooltip;
import com.android.tools.profilers.memory.MemoryUsage;
import org.jetbrains.annotations.NotNull;

public class MemoryMonitor
extends ProfilerMonitor {
    @NotNull
    private final ClampedAxisComponentModel myMemoryAxis;
    private static final BaseAxisFormatter MEMORY_AXIS_FORMATTER = new MemoryAxisFormatter(1, 2, 5);
    private final MemoryUsage myMemoryUsage;
    private final MemoryLegend myMemoryLegend;
    private MemoryLegend myTooltipLegend;

    public MemoryMonitor(@NotNull StudioProfilers profilers) {
        super(profilers);
        this.myMemoryUsage = new MemoryUsage(profilers);
        this.myMemoryAxis = new ClampedAxisComponentModel.Builder(this.myMemoryUsage.getMemoryRange(), MEMORY_AXIS_FORMATTER).build();
        this.myMemoryLegend = new MemoryLegend(this.myMemoryUsage, this.getTimeline().getDataRange());
        this.myTooltipLegend = new MemoryLegend(this.myMemoryUsage, this.getTimeline().getTooltipRange());
    }

    @Override
    public String getName() {
        return "MEMORY";
    }

    @Override
    public TooltipModel buildTooltip() {
        return new MemoryMonitorTooltip(this);
    }

    @Override
    public void enter() {
        this.myProfilers.getUpdater().register((Updatable)this.myMemoryUsage);
        this.myProfilers.getUpdater().register((Updatable)this.myMemoryAxis);
    }

    @Override
    public void exit() {
        this.myProfilers.getUpdater().unregister((Updatable)this.myMemoryUsage);
        this.myProfilers.getUpdater().unregister((Updatable)this.myMemoryAxis);
        this.myProfilers.removeDependencies((AspectObserver)this);
    }

    @Override
    public void expand() {
        this.myProfilers.setStage(new MainMemoryProfilerStage(this.myProfilers));
    }

    @NotNull
    public AxisComponentModel getMemoryAxis() {
        return this.myMemoryAxis;
    }

    public MemoryUsage getMemoryUsage() {
        return this.myMemoryUsage;
    }

    public MemoryLegend getMemoryLegend() {
        return this.myMemoryLegend;
    }

    public MemoryLegend getTooltipLegend() {
        return this.myTooltipLegend;
    }

    public static class MemoryLegend
    extends LegendComponentModel {
        @NotNull
        private final SeriesLegend myTotalLegend;

        public MemoryLegend(@NotNull MemoryUsage usage, @NotNull Range range) {
            super(range);
            this.myTotalLegend = new SeriesLegend(usage.getTotalMemorySeries(), MEMORY_AXIS_FORMATTER, range);
            this.add((Legend)this.myTotalLegend);
        }

        @NotNull
        public Legend getTotalLegend() {
            return this.myTotalLegend;
        }
    }
}

