/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.StudioProfilers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public final class AllocStatsDataSeries
implements DataSeries<Long> {
    @NotNull
    private final StudioProfilers myProfilers;
    @NotNull
    private final ProfilerClient myClient;
    @NotNull
    private final Common.Session mySession;
    @NotNull
    private final AspectObserver myObserver;
    private boolean myIsAgentAttached = false;
    @NotNull
    private Function<Memory.MemoryAllocStatsData, Long> myFilter;

    public AllocStatsDataSeries(@NotNull StudioProfilers profilers, @NotNull Function<Memory.MemoryAllocStatsData, Long> filter) {
        this.myProfilers = profilers;
        this.myClient = profilers.getClient();
        this.mySession = this.myProfilers.getSession();
        this.myFilter = filter;
        this.myObserver = new AspectObserver();
        this.myProfilers.addDependency(this.myObserver).onChange((Enum)ProfilerAspect.AGENT, this::agentStatusChanged);
        this.agentStatusChanged();
    }

    public List<SeriesData<Long>> getDataForRange(@NotNull Range rangeUs) {
        if (!this.myIsAgentAttached) {
            return Collections.emptyList();
        }
        Transport.GetEventGroupsRequest request = Transport.GetEventGroupsRequest.newBuilder().setStreamId(this.mySession.getStreamId()).setPid(this.mySession.getPid()).setKind(Common.Event.Kind.MEMORY_ALLOC_STATS).setFromTimestamp(TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMin())).setToTimestamp(TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMax())).build();
        Transport.GetEventGroupsResponse response = this.myClient.getTransportClient().getEventGroups(request);
        assert (response.getGroupsCount() <= 1);
        ArrayList<SeriesData<Long>> seriesData = new ArrayList<SeriesData<Long>>();
        if (response.getGroupsCount() > 0) {
            response.getGroups(0).getEventsList().forEach(event -> {
                long dataTimestamp = TimeUnit.NANOSECONDS.toMicros(event.getTimestamp());
                seriesData.add(new SeriesData(dataTimestamp, (Object)this.myFilter.apply(event.getMemoryAllocStats())));
            });
        }
        return seriesData;
    }

    private void agentStatusChanged() {
        this.myIsAgentAttached = this.myProfilers.isAgentAttached();
    }
}

