/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.customevent;

import com.android.tools.adtui.chart.statechart.DefaultStateChartReducer;
import com.android.tools.adtui.chart.statechart.StateChart;
import com.android.tools.adtui.chart.statechart.StateChartColorProvider;
import com.android.tools.adtui.chart.statechart.StateChartConfig;
import com.android.tools.adtui.chart.statechart.StateChartReducer;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.adtui.model.formatter.UserCounterAxisFormatter;
import com.android.tools.profilers.ProfilerColors;
import com.google.common.annotations.VisibleForTesting;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class UserCounterStateChartFactory {
    private static final StateChartColorProvider<Long> DURATION_STATE_COLOR_PROVIDER = new StateChartColorProvider<Long>(){

        @NotNull
        public Color getColor(boolean isMouseOver, @NotNull Long value) {
            String weight;
            switch (weight = UserCounterAxisFormatter.DEFAULT.getFormattedString(0.0, (double)value.longValue(), false)) {
                case "None": {
                    return ProfilerColors.USER_COUNTER_EVENT_NONE;
                }
                case "Light": {
                    return ProfilerColors.USER_COUNTER_EVENT_LIGHT;
                }
                case "Medium": {
                    return ProfilerColors.USER_COUNTER_EVENT_MED;
                }
            }
            return ProfilerColors.USER_COUNTER_EVENT_DARK;
        }
    };

    @NotNull
    public static StateChart<Long> create(@NotNull StateChartModel<Long> model) {
        return new StateChart(model, DURATION_STATE_COLOR_PROVIDER, Object::toString, new StateChartConfig((StateChartReducer)new DefaultStateChartReducer(), 0.33, 1.0, 0.33f));
    }

    @VisibleForTesting
    static StateChartColorProvider<Long> getDurationStateColorProvider() {
        return DURATION_STATE_COLOR_PROVIDER;
    }
}

