/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.customevent;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.TooltipModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.UserCounterAxisFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.customevent.CustomEventMonitorTooltip;
import com.android.tools.profilers.customevent.CustomEventProfilerStage;
import com.android.tools.profilers.customevent.UserCounterDataSeries;
import org.jetbrains.annotations.NotNull;

public class CustomEventMonitor
extends ProfilerMonitor {
    @NotNull
    private final StateChartModel<Long> myEventModel;
    @NotNull
    private final CustomEventMonitorLegend myLegend;

    public CustomEventMonitor(@NotNull StudioProfilers profilers) {
        super(profilers);
        UserCounterDataSeries myDataSeries = new UserCounterDataSeries(profilers.getClient().getTransportClient(), profilers);
        this.myEventModel = CustomEventMonitor.createEventChartModel(this.getTimeline(), myDataSeries);
        this.myLegend = new CustomEventMonitorLegend(this.getTimeline().getDataRange(), this.getTimeline().getViewRange(), myDataSeries);
    }

    @Override
    @NotNull
    public String getName() {
        return "CUSTOM EVENTS";
    }

    @Override
    public TooltipModel buildTooltip() {
        return new CustomEventMonitorTooltip(this);
    }

    @Override
    public void exit() {
    }

    @Override
    public void enter() {
    }

    @Override
    public void expand() {
        this.myProfilers.setStage(new CustomEventProfilerStage(this.myProfilers));
    }

    @NotNull
    public StateChartModel<Long> getEventModel() {
        return this.myEventModel;
    }

    @NotNull
    public CustomEventMonitorLegend getLegend() {
        return this.myLegend;
    }

    private static StateChartModel<Long> createEventChartModel(Timeline timeline, UserCounterDataSeries dataSeries) {
        StateChartModel stateChartModel = new StateChartModel();
        stateChartModel.addSeries(new RangedSeries(timeline.getViewRange(), (DataSeries)dataSeries, timeline.getDataRange()));
        return stateChartModel;
    }

    public static final class CustomEventMonitorLegend
    extends LegendComponentModel {
        @NotNull
        private final SeriesLegend myUsageLegend;

        public CustomEventMonitorLegend(@NotNull Range dataRange, @NotNull Range viewRange, UserCounterDataSeries dataSeries) {
            super(dataRange);
            RangedContinuousSeries rangedContinuousSeries = new RangedContinuousSeries("", viewRange, new Range(0.0, 0.0), (DataSeries)dataSeries, dataRange);
            this.myUsageLegend = new SeriesLegend(rangedContinuousSeries, (BaseAxisFormatter)UserCounterAxisFormatter.DEFAULT, dataRange);
            this.add((Legend)this.myUsageLegend);
        }

        @NotNull
        public SeriesLegend getUsageLegend() {
            return this.myUsageLegend;
        }
    }
}

