/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.ui.HideablePanel;
import com.android.tools.profilers.StringFormattingUtils;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.analysis.CustomBorderTableCellRenderer;
import com.android.tools.profilers.cpu.analysis.PowerRailRow;
import com.android.tools.profilers.cpu.analysis.PowerRailTableUtils;
import com.android.tools.profilers.cpu.analysis.SummaryDetailsViewBase;
import com.android.tools.profilers.cpu.systemtrace.PowerCounterData;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001:\u0002#$B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\u00a8\u0006%"}, d2={"Lcom/android/tools/profilers/cpu/analysis/PowerRailTable;", "", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "powerRailCounters", "", "", "Lcom/android/tools/profilers/cpu/systemtrace/PowerCounterData;", "selectionRange", "Lcom/android/tools/adtui/model/Range;", "captureRange", "title", "<init>", "(Lcom/android/tools/profilers/StudioProfilers;Ljava/util/Map;Lcom/android/tools/adtui/model/Range;Lcom/android/tools/adtui/model/Range;Ljava/lang/String;)V", "getProfilers", "()Lcom/android/tools/profilers/StudioProfilers;", "getPowerRailCounters", "()Ljava/util/Map;", "getSelectionRange", "()Lcom/android/tools/adtui/model/Range;", "getCaptureRange", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "observer", "Lcom/android/tools/adtui/model/AspectObserver;", "getObserver", "()Lcom/android/tools/adtui/model/AspectObserver;", "table", "Ljavax/swing/JTable;", "getTable$annotations", "()V", "getTable", "()Ljavax/swing/JTable;", "PowerRailTableModel", "Column", "intellij.android.profilers.ui"})
@StabilityInferred(parameters=0)
public final class PowerRailTable {
    @NotNull
    private final StudioProfilers profilers;
    @NotNull
    private final Map<String, PowerCounterData> powerRailCounters;
    @NotNull
    private final Range selectionRange;
    @NotNull
    private final Range captureRange;
    @NotNull
    private final JComponent component;
    @NotNull
    private final AspectObserver observer;
    @NotNull
    private final JTable table;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public PowerRailTable(@NotNull StudioProfilers profilers, @NotNull Map<String, PowerCounterData> powerRailCounters, @NotNull Range selectionRange, @NotNull Range captureRange, @NotNull String title) {
        void $this$_init__u24lambda_u244;
        HideablePanel hideablePanel;
        void $this$_init__u24lambda_u240;
        JBTable jBTable;
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        Intrinsics.checkNotNullParameter(powerRailCounters, (String)"powerRailCounters");
        Intrinsics.checkNotNullParameter((Object)selectionRange, (String)"selectionRange");
        Intrinsics.checkNotNullParameter((Object)captureRange, (String)"captureRange");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this.profilers = profilers;
        this.powerRailCounters = powerRailCounters;
        this.selectionRange = selectionRange;
        this.captureRange = captureRange;
        this.observer = new AspectObserver();
        JBTable jBTable2 = jBTable = new JBTable((TableModel)new PowerRailTableModel());
        PowerRailTable powerRailTable = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.setAutoCreateRowSorter(true);
        $this$_init__u24lambda_u240.setShowVerticalLines(true);
        $this$_init__u24lambda_u240.setShowHorizontalLines(false);
        $this$_init__u24lambda_u240.getColumnModel().getColumn(Column.RAIL_NAME.ordinal()).setCellRenderer(new CustomBorderTableCellRenderer(null, 1, null));
        CustomBorderTableCellRenderer avgPowerColumnRenderer2 = new CustomBorderTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                DecimalFormat decimalFormat = new DecimalFormat("#.##");
                String newValue = decimalFormat.format(value);
                return super.getTableCellRendererComponent(table, newValue, isSelected, hasFocus, row, column);
            }
        };
        $this$_init__u24lambda_u240.getColumnModel().getColumn(Column.AVERAGE.ordinal()).setCellRenderer(avgPowerColumnRenderer2);
        CustomBorderTableCellRenderer cumulativeColumnRenderer2 = new CustomBorderTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Object newValue = value instanceof Long && column == Column.CONSUMPTION.ordinal() ? StringFormattingUtils.formatLongValueWithCommas(((Number)value).longValue()) : value;
                return super.getTableCellRendererComponent(table, newValue, isSelected, hasFocus, row, column);
            }
        };
        $this$_init__u24lambda_u240.getColumnModel().getColumn(Column.CONSUMPTION.ordinal()).setCellRenderer(cumulativeColumnRenderer2);
        powerRailTable.table = (JTable)jBTable;
        ((JBTable)this.table).getTableHeader().getColumnModel().getColumn(Column.CONSUMPTION.ordinal()).setHeaderRenderer(PowerRailTable::_init_$lambda$2);
        this.table.setRowSorter((RowSorter<? extends TableModel>)new TableRowSorter<TableModel>(this.table.getModel()));
        int consumptionRowIndex = Column.CONSUMPTION.ordinal();
        ((JBTable)this.table).getRowSorter().toggleSortOrder(consumptionRowIndex);
        ((JBTable)this.table).getRowSorter().toggleSortOrder(consumptionRowIndex);
        JPanel $this$_init__u24lambda_u243 = bl = new JPanel((LayoutManager)new TabularLayout("*", "Fit,Fit"));
        boolean bl2 = false;
        $this$_init__u24lambda_u243.setBorder(JBUI.Borders.customLine((Color)((Color)StudioColorsKt.getBorder()), (int)2));
        $this$_init__u24lambda_u243.setOpaque(false);
        $this$_init__u24lambda_u243.add((Component)((JBTable)this.table).getTableHeader(), new TabularLayout.Constraint(0, 0, 0, 4, null));
        $this$_init__u24lambda_u243.add((Component)this.table, new TabularLayout.Constraint(1, 0, 0, 4, null));
        JPanel tableContainer = bl;
        Border border = JBUI.Borders.merge((Border)JBUI.Borders.customLine((Color)((Color)StudioColorsKt.getBorder()), (int)1), (Border)((Border)JBUI.Borders.emptyTop((int)8)), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)border, (String)"merge(...)");
        Border contentBorder = border;
        String timeRange = SummaryDetailsViewBase.Companion.formatTimeRangeAsString(this.selectionRange, (long)this.captureRange.getMin(), '\u2192');
        String titleWithTimeRange = "<b>" + title + "</b> (Range: " + timeRange + ")";
        HideablePanel hideablePanel2 = hideablePanel = new HideablePanel.Builder(titleWithTimeRange, (JComponent)tableContainer).setPanelBorder((Border)JBUI.Borders.empty()).setContentBorder(contentBorder).build();
        powerRailTable = this;
        boolean bl3 = false;
        $this$_init__u24lambda_u244.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
        HideablePanel hideablePanel3 = hideablePanel;
        Intrinsics.checkNotNullExpressionValue((Object)hideablePanel3, (String)"apply(...)");
        powerRailTable.component = (JComponent)hideablePanel3;
        this.selectionRange.addDependency(this.observer).onChange((Enum)Range.Aspect.RANGE, () -> PowerRailTable._init_$lambda$5(this, title));
    }

    public /* synthetic */ PowerRailTable(StudioProfilers studioProfilers, Map map, Range range, Range range2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            string = "Power Rails";
        }
        this(studioProfilers, map, range, range2, string);
    }

    @NotNull
    public final StudioProfilers getProfilers() {
        return this.profilers;
    }

    @NotNull
    public final Map<String, PowerCounterData> getPowerRailCounters() {
        return this.powerRailCounters;
    }

    @NotNull
    public final Range getSelectionRange() {
        return this.selectionRange;
    }

    @NotNull
    public final Range getCaptureRange() {
        return this.captureRange;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    @NotNull
    public final AspectObserver getObserver() {
        return this.observer;
    }

    @NotNull
    public final JTable getTable() {
        return this.table;
    }

    @VisibleForTesting
    public static /* synthetic */ void getTable$annotations() {
    }

    private static final Component _init_$lambda$2(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel jLabel;
        Component component = table.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getTableCellRendererComponent(...)");
        Component headerComponent = component;
        JLabel $this$lambda_u242_u24lambda_u241 = jLabel = new JLabel();
        boolean bl = false;
        $this$lambda_u242_u24lambda_u241.setLayout(new FlowLayout(0));
        $this$lambda_u242_u24lambda_u241.setBorder((Border)JBUI.Borders.empty());
        if (headerComponent instanceof JComponent) {
            ((JComponent)headerComponent).setBorder((Border)JBUI.Borders.emptyLeft((int)2));
        }
        $this$lambda_u242_u24lambda_u241.add(headerComponent);
        JLabel iconComp = new JLabel();
        iconComp.setIcon(StudioIcons.Common.INFO_INLINE);
        iconComp.setBorder((Border)JBUI.Borders.empty());
        $this$lambda_u242_u24lambda_u241.add(iconComp);
        $this$lambda_u242_u24lambda_u241.setToolTipText("Power data is sampled in 250ms intervals.<br><br>The total energy number represented<br>contains an <b><i>error margin of up to +/- 0.5<br>seconds (500ms)</i></b> of power data due to the<br>sampling interval.");
        return jLabel;
    }

    private static final void _init_$lambda$5(PowerRailTable this$0, String $title) {
        String updatedTimeRange = SummaryDetailsViewBase.Companion.formatTimeRangeAsString(this$0.selectionRange, (long)this$0.captureRange.getMin(), '\u2192');
        String updatedTitleWithTimeRange = "<b>" + $title + "</b> (Range: " + updatedTimeRange + ")";
        ((HideablePanel)this$0.component).setTitle(updatedTitleWithTimeRange);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001d\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/profilers/cpu/analysis/PowerRailTable$Column;", "", "displayName", "", "type", "Ljava/lang/Class;", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/Class;)V", "getDisplayName", "()Ljava/lang/String;", "getType", "()Ljava/lang/Class;", "RAIL_NAME", "AVERAGE", "CONSUMPTION", "getValueFrom", "", "data", "Lcom/android/tools/profilers/cpu/analysis/PowerRailRow;", "intellij.android.profilers.ui"})
    private static final abstract class Column
    extends Enum<Column> {
        @NotNull
        private final String displayName;
        @NotNull
        private final Class<?> type;
        public static final /* enum */ Column RAIL_NAME = new RAIL_NAME("RAIL_NAME", 0);
        public static final /* enum */ Column AVERAGE = new AVERAGE("AVERAGE", 1);
        public static final /* enum */ Column CONSUMPTION = new CONSUMPTION("CONSUMPTION", 2);
        private static final /* synthetic */ Column[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Column(String displayName, Class<?> type) {
            this.displayName = displayName;
            this.type = type;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        @NotNull
        public final Class<?> getType() {
            return this.type;
        }

        @NotNull
        public abstract Object getValueFrom(@NotNull PowerRailRow var1);

        public static Column[] values() {
            return (Column[])$VALUES.clone();
        }

        public static Column valueOf(String value) {
            return Enum.valueOf(Column.class, value);
        }

        @NotNull
        public static EnumEntries<Column> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ Column(String $enum$name, int $enum$ordinal, String displayName, Class type, DefaultConstructorMarker $constructor_marker) {
            this(displayName, type);
        }

        static {
            $VALUES = columnArray = new Column[]{Column.RAIL_NAME, Column.AVERAGE, Column.CONSUMPTION};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"com/android/tools/profilers/cpu/analysis/PowerRailTable.Column.AVERAGE", "Lcom/android/tools/profilers/cpu/analysis/PowerRailTable$Column;", "getValueFrom", "", "data", "Lcom/android/tools/profilers/cpu/analysis/PowerRailRow;", "(Lcom/android/tools/profilers/cpu/analysis/PowerRailRow;)Ljava/lang/Double;", "intellij.android.profilers.ui"})
        static final class AVERAGE
        extends Column {
            /*
             * WARNING - void declaration
             */
            AVERAGE() {
                void var1_1;
            }

            @Override
            @NotNull
            public Double getValueFrom(@NotNull PowerRailRow data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                return data.getAverage();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"com/android/tools/profilers/cpu/analysis/PowerRailTable.Column.CONSUMPTION", "Lcom/android/tools/profilers/cpu/analysis/PowerRailTable$Column;", "getValueFrom", "", "data", "Lcom/android/tools/profilers/cpu/analysis/PowerRailRow;", "(Lcom/android/tools/profilers/cpu/analysis/PowerRailRow;)Ljava/lang/Long;", "intellij.android.profilers.ui"})
        static final class CONSUMPTION
        extends Column {
            /*
             * WARNING - void declaration
             */
            CONSUMPTION() {
                void var1_1;
            }

            @Override
            @NotNull
            public Long getValueFrom(@NotNull PowerRailRow data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                return data.getConsumption();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/android/tools/profilers/cpu/analysis/PowerRailTable.Column.RAIL_NAME", "Lcom/android/tools/profilers/cpu/analysis/PowerRailTable$Column;", "getValueFrom", "", "data", "Lcom/android/tools/profilers/cpu/analysis/PowerRailRow;", "intellij.android.profilers.ui"})
        static final class RAIL_NAME
        extends Column {
            /*
             * WARNING - void declaration
             */
            RAIL_NAME() {
                void var1_1;
            }

            @Override
            @NotNull
            public String getValueFrom(@NotNull PowerRailRow data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                return data.getName();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0014\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/profilers/cpu/analysis/PowerRailTable$PowerRailTableModel;", "Ljavax/swing/table/AbstractTableModel;", "<init>", "(Lcom/android/tools/profilers/cpu/analysis/PowerRailTable;)V", "observer", "Lcom/android/tools/adtui/model/AspectObserver;", "dataRows", "", "Lcom/android/tools/profilers/cpu/analysis/PowerRailRow;", "getRowCount", "", "getColumnCount", "getValueAt", "", "rowIndex", "columnIndex", "getColumnClass", "Ljava/lang/Class;", "getColumnName", "", "column", "computePowerSummary", "", "intellij.android.profilers.ui"})
    @SourceDebugExtension(value={"SMAP\nPowerRailTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PowerRailTable.kt\ncom/android/tools/profilers/cpu/analysis/PowerRailTable$PowerRailTableModel\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,253:1\n126#2:254\n153#2,3:255\n*S KotlinDebug\n*F\n+ 1 PowerRailTable.kt\ncom/android/tools/profilers/cpu/analysis/PowerRailTable$PowerRailTableModel\n*L\n201#1:254\n201#1:255,3\n*E\n"})
    private final class PowerRailTableModel
    extends AbstractTableModel {
        @NotNull
        private final AspectObserver observer = new AspectObserver();
        @NotNull
        private List<PowerRailRow> dataRows = CollectionsKt.emptyList();

        public PowerRailTableModel() {
            PowerRailTable.this.getSelectionRange().addDependency(this.observer).onChange((Enum)Range.Aspect.RANGE, () -> PowerRailTableModel._init_$lambda$1(this));
            this.computePowerSummary();
        }

        @Override
        public int getRowCount() {
            return this.dataRows.size();
        }

        @Override
        public int getColumnCount() {
            return Column.values().length;
        }

        @Override
        @NotNull
        public Object getValueAt(int rowIndex, int columnIndex) {
            return Column.values()[columnIndex].getValueFrom(this.dataRows.get(rowIndex));
        }

        @Override
        @NotNull
        public Class<?> getColumnClass(int columnIndex) {
            return Column.values()[columnIndex].getType();
        }

        @Override
        @NotNull
        public String getColumnName(int column) {
            return Column.values()[column].getDisplayName();
        }

        /*
         * WARNING - void declaration
         */
        private final void computePowerSummary() {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map<String, PowerCounterData> map = PowerRailTable.this.getPowerRailCounters();
            PowerRailTable powerRailTable = PowerRailTable.this;
            PowerRailTableModel powerRailTableModel = this;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry2 = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                PowerRailTableUtils.PowerUsageRange powerUsageRange = PowerRailTableUtils.INSTANCE.computePowerUsageRange(((PowerCounterData)it.getValue()).getCumulativeData(), powerRailTable.getSelectionRange());
                long consumption = PowerRailTableUtils.INSTANCE.computeCumulativeEnergyInRange(powerUsageRange);
                double average = PowerRailTableUtils.INSTANCE.computeAveragePowerInRange(powerUsageRange);
                collection.add(new PowerRailRow((String)it.getKey(), consumption, average));
            }
            powerRailTableModel.dataRows = (List)destination$iv$iv;
            this.fireTableDataChanged();
        }

        private static final void _init_$lambda$1(PowerRailTableModel this$0) {
            this$0.computePowerSummary();
        }
    }
}

