/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import com.android.tools.adtui.model.HNode;
import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuThreadTrackModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisSummaryTabModel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class CpuThreadAnalysisSummaryTabModel
extends CpuAnalysisSummaryTabModel<CpuThreadTrackModel> {
    @NotNull
    private final Range mySelectionRange;

    public CpuThreadAnalysisSummaryTabModel(@NotNull Range captureRange, @NotNull Range selectionRange) {
        super(captureRange);
        this.mySelectionRange = selectionRange;
    }

    @NotNull
    public List<CaptureNode> getTopNodesInSelectionRange(int k) {
        if (this.getDataSeries().size() != 1) {
            return new ArrayList<CaptureNode>();
        }
        CaptureNode rootNode = ((CpuThreadTrackModel)this.getDataSeries().get(0)).getCallChartModel().getNode();
        if (rootNode != null) {
            return rootNode.getDescendantsStream().filter(node -> node.getDepth() > 0 && this.mySelectionRange.intersectsWith((double)node.getStartGlobal(), (double)node.getEndGlobal())).sorted(Comparator.comparing(HNode::getDuration).reversed()).limit(k).collect(Collectors.toList());
        }
        return new ArrayList<CaptureNode>();
    }

    @Override
    @NotNull
    public String getLabel() {
        return "Thread";
    }

    @Override
    @NotNull
    public Range getSelectionRange() {
        return this.mySelectionRange;
    }
}

