/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.StatLabel;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.ui.HideablePanel;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.analysis.CaptureNodeAnalysisModel;
import com.android.tools.profilers.cpu.analysis.CaptureNodeAnalysisStats;
import com.android.tools.profilers.cpu.analysis.CaptureNodeAnalysisSummaryTabModel;
import com.android.tools.profilers.cpu.analysis.CaptureNodeDetailTable;
import com.android.tools.profilers.cpu.analysis.CaptureNodeSummaryDetailsView;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisSummaryTabModel;
import com.android.tools.profilers.cpu.analysis.SummaryDetailsViewBase;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002R\u0013\u0010\b\u001a\u00020\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u00020\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/profilers/cpu/analysis/CaptureNodeSummaryDetailsView;", "Lcom/android/tools/profilers/cpu/analysis/SummaryDetailsViewBase;", "Lcom/android/tools/profilers/cpu/analysis/CaptureNodeAnalysisSummaryTabModel;", "profilersView", "Lcom/android/tools/profilers/StudioProfilersView;", "tabModel", "<init>", "(Lcom/android/tools/profilers/StudioProfilersView;Lcom/android/tools/profilers/cpu/analysis/CaptureNodeAnalysisSummaryTabModel;)V", "timeRangeLabel", "Ljavax/swing/JLabel;", "getTimeRangeLabel", "()Ljavax/swing/JLabel;", "dataTypeLabel", "getDataTypeLabel", "buildSelectedNodeTable", "Ljavax/swing/JPanel;", "buildAllOccurrencesSection", "Ljavax/swing/JComponent;", "allOccurrencesStats", "Lcom/android/tools/profilers/cpu/analysis/CaptureNodeAnalysisStats;", "tenLongestRunningOccurrences", "", "Lcom/android/tools/profilers/cpu/CaptureNode;", "intellij.android.profilers.ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nCaptureNodeSummaryDetailsView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CaptureNodeSummaryDetailsView.kt\ncom/android/tools/profilers/cpu/analysis/CaptureNodeSummaryDetailsView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1563#2:131\n1634#2,3:132\n*S KotlinDebug\n*F\n+ 1 CaptureNodeSummaryDetailsView.kt\ncom/android/tools/profilers/cpu/analysis/CaptureNodeSummaryDetailsView\n*L\n70#1:131\n70#1:132,3\n*E\n"})
public final class CaptureNodeSummaryDetailsView
extends SummaryDetailsViewBase<CaptureNodeAnalysisSummaryTabModel> {
    @NotNull
    private final JLabel timeRangeLabel;
    @NotNull
    private final JLabel dataTypeLabel;
    public static final int $stable = 8;

    public CaptureNodeSummaryDetailsView(@NotNull StudioProfilersView profilersView, @NotNull CaptureNodeAnalysisSummaryTabModel tabModel) {
        Intrinsics.checkNotNullParameter((Object)profilersView, (String)"profilersView");
        Intrinsics.checkNotNullParameter((Object)tabModel, (String)"tabModel");
        super(profilersView, (CpuAnalysisSummaryTabModel)tabModel);
        this.timeRangeLabel = new JLabel();
        this.dataTypeLabel = new JLabel();
        Range selectionRange = tabModel.getSelectionRange();
        Range range = tabModel.getCaptureRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getCaptureRange(...)");
        Range captureRange = range;
        this.timeRangeLabel.setText(SummaryDetailsViewBase.Companion.formatTimeRangeAsString$default(SummaryDetailsViewBase.Companion, selectionRange, (long)captureRange.getMin(), '\u0000', 4, null));
        this.dataTypeLabel.setText(tabModel.getLabel());
        this.addRowToCommonSection("Time Range", this.timeRangeLabel);
        this.addRowToCommonSection("Data Type", this.dataTypeLabel);
        this.addSection(this.buildSelectedNodeTable());
        if (tabModel.getDataSeries().size() == 1) {
            profilersView.getStudioProfilers().getIdeServices().getPoolExecutor().execute(() -> CaptureNodeSummaryDetailsView._init_$lambda$1(tabModel, profilersView, this));
        }
    }

    @VisibleForTesting
    @NotNull
    public final JLabel getTimeRangeLabel() {
        return this.timeRangeLabel;
    }

    @VisibleForTesting
    @NotNull
    public final JLabel getDataTypeLabel() {
        return this.dataTypeLabel;
    }

    /*
     * WARNING - void declaration
     */
    private final JPanel buildSelectedNodeTable() {
        String string;
        Object object;
        void $this$mapTo$iv$iv;
        JPanel jPanel;
        JPanel $this$buildSelectedNodeTable_u24lambda_u244 = jPanel = new JPanel((LayoutManager)new TabularLayout("*").setVGap(8));
        boolean bl = false;
        List list = ((CaptureNodeAnalysisSummaryTabModel)this.getTabModel()).getDataSeries();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDataSeries(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CaptureNodeAnalysisModel captureNodeAnalysisModel = (CaptureNodeAnalysisModel)item$iv$iv;
            object = destination$iv$iv;
            boolean bl2 = false;
            object.add(it.getNode());
        }
        List selectedNodes = (List)destination$iv$iv;
        String $i$f$map22 = string = "Selected event";
        object = $this$buildSelectedNodeTable_u24lambda_u244;
        boolean bl3 = false;
        $this$buildSelectedNodeTable_u24lambda_u244.setFont(ProfilerFonts.H3_FONT);
        $this$buildSelectedNodeTable_u24lambda_u244.setOpaque(false);
        String string2 = string;
        ((Container)object).add((Component)new JLabel(string2), new TabularLayout.Constraint(0, 0, 0, 4, null));
        Range range = ((CaptureNodeAnalysisSummaryTabModel)this.getTabModel()).getCaptureRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getCaptureRange(...)");
        $this$buildSelectedNodeTable_u24lambda_u244.add((Component)new CaptureNodeDetailTable(selectedNodes, range, null, 0, 12, null).getComponent(), new TabularLayout.Constraint(1, 0, 0, 4, null));
        return jPanel;
    }

    /*
     * WARNING - void declaration
     */
    private final JComponent buildAllOccurrencesSection(CaptureNodeAnalysisStats allOccurrencesStats, List<? extends CaptureNode> tenLongestRunningOccurrences) {
        JPanel jPanel;
        void $this$buildAllOccurrencesSection_u24lambda_u248_u24lambda_u246_u24lambda_u245;
        StatLabel statLabel;
        void $this$buildAllOccurrencesSection_u24lambda_u248_u24lambda_u246;
        JPanel jPanel2;
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        JComponent $this$buildAllOccurrencesSection_u24lambda_u248 = jPanel3;
        boolean bl = false;
        $this$buildAllOccurrencesSection_u24lambda_u248.setOpaque(false);
        JPanel jPanel4 = jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel5 = $this$buildAllOccurrencesSection_u24lambda_u248;
        boolean bl2 = false;
        $this$buildAllOccurrencesSection_u24lambda_u248_u24lambda_u246.setOpaque(false);
        $this$buildAllOccurrencesSection_u24lambda_u248_u24lambda_u246.setBorder(JBUI.Borders.customLine((Color)((Color)StudioColorsKt.getBorder()), (int)0, (int)0, (int)0, (int)1));
        long l = allOccurrencesStats.getCount();
        Font font = ProfilerFonts.H2_FONT;
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"H2_FONT");
        Font font2 = ProfilerFonts.H4_FONT;
        Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"H4_FONT");
        StatLabel statLabel2 = statLabel = new StatLabel(l, "Count", font, font2, null, null, 48, null);
        void var13_17 = $this$buildAllOccurrencesSection_u24lambda_u248_u24lambda_u246;
        boolean bl3 = false;
        $this$buildAllOccurrencesSection_u24lambda_u248_u24lambda_u246_u24lambda_u245.setOpaque(false);
        var13_17.add((Component)statLabel);
        jPanel5.add(jPanel2);
        $this$buildAllOccurrencesSection_u24lambda_u248.add((Component)CaptureNodeSummaryDetailsView.buildAllOccurrencesSection$lambda$8$buildDurationLabel((long)allOccurrencesStats.getAverage(), "Average"));
        $this$buildAllOccurrencesSection_u24lambda_u248.add((Component)CaptureNodeSummaryDetailsView.buildAllOccurrencesSection$lambda$8$buildDurationLabel(allOccurrencesStats.getMax(), "Max"));
        $this$buildAllOccurrencesSection_u24lambda_u248.add((Component)CaptureNodeSummaryDetailsView.buildAllOccurrencesSection$lambda$8$buildDurationLabel(allOccurrencesStats.getMin(), "Min"));
        $this$buildAllOccurrencesSection_u24lambda_u248.add((Component)CaptureNodeSummaryDetailsView.buildAllOccurrencesSection$lambda$8$buildDurationLabel((long)allOccurrencesStats.getStandardDeviation(), "Std Dev"));
        JPanel statsPanel2 = jPanel3;
        JComponent $this$buildAllOccurrencesSection_u24lambda_u249 = $this$buildAllOccurrencesSection_u24lambda_u248 = new JLabel("Longest running occurrences (select row to navigate)");
        boolean bl4 = false;
        $this$buildAllOccurrencesSection_u24lambda_u249.setOpaque(false);
        $this$buildAllOccurrencesSection_u24lambda_u249.setFont(ProfilerFonts.H3_FONT);
        JComponent topOccurrencesLabel = $this$buildAllOccurrencesSection_u24lambda_u248;
        Range range = ((CaptureNodeAnalysisSummaryTabModel)this.getTabModel()).getCaptureRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getCaptureRange(...)");
        CaptureNodeDetailTable topOccurrencesTable = new CaptureNodeDetailTable(tenLongestRunningOccurrences, range, this.getProfilersView().getStudioProfilers().getStage().getTimeline().getViewRange(), 0, 8, null);
        JPanel $this$buildAllOccurrencesSection_u24lambda_u2410 = jPanel = new JPanel((LayoutManager)new TabularLayout("*", "Fit,Fit,Fit").setVGap(8));
        boolean bl5 = false;
        $this$buildAllOccurrencesSection_u24lambda_u2410.setOpaque(false);
        $this$buildAllOccurrencesSection_u24lambda_u2410.add((Component)statsPanel2, new TabularLayout.Constraint(0, 0, 0, 4, null));
        $this$buildAllOccurrencesSection_u24lambda_u2410.add((Component)topOccurrencesLabel, new TabularLayout.Constraint(1, 0, 0, 4, null));
        $this$buildAllOccurrencesSection_u24lambda_u2410.add((Component)topOccurrencesTable.getComponent(), new TabularLayout.Constraint(2, 0, 0, 4, null));
        JPanel panel = jPanel;
        JPanel $this$buildAllOccurrencesSection_u24lambda_u2411 = jPanel4 = new HideablePanel.Builder("All Occurrences (" + allOccurrencesStats.getCount() + ")", (JComponent)panel).setPanelBorder((Border)JBUI.Borders.empty()).setContentBorder((Border)JBUI.Borders.empty((int)8, (int)0, (int)0, (int)0)).build();
        boolean bl6 = false;
        $this$buildAllOccurrencesSection_u24lambda_u2411.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
        JPanel jPanel6 = jPanel4;
        Intrinsics.checkNotNullExpressionValue((Object)jPanel6, (String)"apply(...)");
        return jPanel6;
    }

    private static final void lambda$1$lambda$0(CaptureNodeSummaryDetailsView this$0, CaptureNodeAnalysisStats $allOccurrencesStats, List $tenLongestRunningOccurrences) {
        this$0.addSection(this$0.buildAllOccurrencesSection($allOccurrencesStats, $tenLongestRunningOccurrences));
    }

    private static final void _init_$lambda$1(CaptureNodeAnalysisSummaryTabModel $tabModel, StudioProfilersView $profilersView, CaptureNodeSummaryDetailsView this$0) {
        CaptureNodeAnalysisModel model = (CaptureNodeAnalysisModel)$tabModel.getDataSeries().get(0);
        CaptureNodeAnalysisStats allOccurrencesStats = model.getAllOccurrenceStats();
        List<CaptureNode> tenLongestRunningOccurrences = model.getLongestRunningOccurrences(10);
        $profilersView.getStudioProfilers().getIdeServices().getMainExecutor().execute(() -> CaptureNodeSummaryDetailsView.lambda$1$lambda$0(this$0, allOccurrencesStats, tenLongestRunningOccurrences));
    }

    private static final StatLabel buildAllOccurrencesSection$lambda$8$buildDurationLabel(long num, String desc) {
        StatLabel statLabel;
        Font font = ProfilerFonts.H2_FONT;
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"H2_FONT");
        Font font2 = ProfilerFonts.H4_FONT;
        Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"H4_FONT");
        StatLabel $this$buildAllOccurrencesSection_u24lambda_u248_u24buildDurationLabel_u24lambda_u247 = statLabel = new StatLabel(num, desc, font, font2, (Function1)buildAllOccurrencesSection.statsPanel.1.buildDurationLabel.1.INSTANCE, null, 32, null);
        boolean bl = false;
        $this$buildAllOccurrencesSection_u24lambda_u248_u24buildDurationLabel_u24lambda_u247.setOpaque(false);
        return statLabel;
    }
}

