/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.chart.statechart.StateChart;
import com.android.tools.adtui.chart.statechart.StateChartColorProvider;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.adtui.model.trackgroup.TrackModel;
import com.android.tools.adtui.trackgroup.TrackRenderer;
import com.android.tools.profilers.DataVisualizationColors;
import com.android.tools.profilers.cpu.VsyncPanel;
import com.android.tools.profilers.cpu.systemtrace.SurfaceflingerEvent;
import com.android.tools.profilers.cpu.systemtrace.SurfaceflingerTrackModel;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.function.BooleanSupplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SurfaceflingerTrackRenderer
implements TrackRenderer<SurfaceflingerTrackModel> {
    private final BooleanSupplier myVsyncEnabler;

    public SurfaceflingerTrackRenderer(BooleanSupplier vsyncEnabler) {
        this.myVsyncEnabler = vsyncEnabler;
    }

    @NotNull
    public JComponent render(@NotNull TrackModel<SurfaceflingerTrackModel, ?> trackModel) {
        return VsyncPanel.of((JComponent)new StateChart((StateChartModel)trackModel.getDataModel(), (StateChartColorProvider)new SurfaceflingerColorProvider()), ((SurfaceflingerTrackModel)((Object)trackModel.getDataModel())).getViewRange(), ((SurfaceflingerTrackModel)((Object)trackModel.getDataModel())).getSystemTraceData().getVsyncCounterValues(), this.myVsyncEnabler);
    }

    private static class SurfaceflingerColorProvider
    extends StateChartColorProvider<SurfaceflingerEvent> {
        private SurfaceflingerColorProvider() {
        }

        @NotNull
        public Color getColor(boolean isMouseOver, @NotNull SurfaceflingerEvent value) {
            switch (value.getType()) {
                case PROCESSING: {
                    return DataVisualizationColors.getPaletteManager().getBackgroundColor("Gray", isMouseOver);
                }
            }
            return UIUtil.TRANSPARENT_COLOR;
        }
    }
}

