/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profilers.cpu.InMemoryDataSeries;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class LazyDataSeries<T>
extends InMemoryDataSeries<T> {
    @NotNull
    private final Supplier<List<SeriesData<T>>> mySeriesDataSupplier;

    public LazyDataSeries(@NotNull Supplier<List<SeriesData<T>>> seriesDataSupplier) {
        Preconditions.checkArgument((seriesDataSupplier != null ? 1 : 0) != 0, (Object)"mySeriesDataSupplier can't be null");
        this.mySeriesDataSupplier = seriesDataSupplier;
    }

    @Override
    @NotNull
    protected List<SeriesData<T>> inMemoryDataList() {
        List<SeriesData<T>> producedList = this.mySeriesDataSupplier.get();
        Preconditions.checkState((producedList != null ? 1 : 0) != 0, (Object)"Supplier in LazyDataSeries can't produce null as result.");
        return producedList;
    }
}

