/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.linechart.AbstractDurationDataRenderer;
import com.android.tools.adtui.chart.linechart.DurationDataRenderer;
import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.chart.linechart.LineChartCustomRenderer;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.chart.linechart.OverlayComponent;
import com.android.tools.adtui.event.DelegateMouseEventHandler;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuTraceInfo;
import com.android.tools.profilers.cpu.DetailedCpuUsage;
import com.intellij.ui.components.JBPanel;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Stroke;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class CpuUsageView
extends JBPanel<CpuUsageView> {
    @NotNull
    protected final OverlayComponent myOverlayComponent;
    @NotNull
    private final AxisComponentModel myCpuUsageAxis;
    @NotNull
    private final AxisComponentModel myThreadCountAxis;
    @NotNull
    private final DetailedCpuUsage myDetailedCpuUsage;
    @NotNull
    private final DurationDataModel<CpuTraceInfo> myTraceDurations;
    @NotNull
    private final CpuProfilerStage.CpuStageLegends myCpuStageLegends;
    @NotNull
    private final String myName;
    @NotNull
    private final Consumer<Long> myStageSetAndSelectCapture;

    public CpuUsageView(@NotNull AxisComponentModel cpuUsageAxis, @NotNull AxisComponentModel threadCountAxis, @NotNull DetailedCpuUsage detailedCpuUsage, @NotNull DurationDataModel<CpuTraceInfo> traceDurations, @NotNull CpuProfilerStage.CpuStageLegends cpuStageLegends, @NotNull String name, @NotNull Consumer<Long> stageSetAndSelectCapture) {
        super((LayoutManager)new TabularLayout("*", "*"));
        this.myCpuUsageAxis = cpuUsageAxis;
        this.myThreadCountAxis = threadCountAxis;
        this.myDetailedCpuUsage = detailedCpuUsage;
        this.myTraceDurations = traceDurations;
        this.myCpuStageLegends = cpuStageLegends;
        this.myName = name;
        this.myStageSetAndSelectCapture = stageSetAndSelectCapture;
        this.myOverlayComponent = new OverlayComponent((Component)new JPanel());
        DelegateMouseEventHandler.delegateTo((Component)((Object)this)).installListenerOn((Component)this.myOverlayComponent).installMotionListenerOn((Component)this.myOverlayComponent);
        this.setBorder(ProfilerLayout.MONITOR_BORDER);
        this.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        this.add(this.createAxisPanel(), new TabularLayout.Constraint(0, 0));
        this.add(this.createLegendPanel(), new TabularLayout.Constraint(0, 0));
        this.add((Component)this.myOverlayComponent, new TabularLayout.Constraint(0, 0));
        this.add(this.createLineChartPanel(), new TabularLayout.Constraint(0, 0));
    }

    @VisibleForTesting
    public CpuUsageView(@NotNull CpuProfilerStage stage) {
        this(stage.getCpuUsageAxis(), stage.getThreadCountAxis(), stage.getCpuUsage(), stage.getTraceDurations(), stage.getLegends(), stage.getName(), stage::setAndSelectCapture);
    }

    @NotNull
    private JComponent createAxisPanel() {
        JBPanel axisPanel = new JBPanel((LayoutManager)new BorderLayout());
        axisPanel.setOpaque(false);
        AxisComponent leftAxis = new AxisComponent(this.myCpuUsageAxis, AxisComponent.AxisOrientation.RIGHT, true);
        leftAxis.setShowAxisLine(false);
        leftAxis.setShowMax(true);
        leftAxis.setOnlyShowUnitAtMax(false);
        leftAxis.setHideTickAtMin(true);
        leftAxis.setMarkerLengths(ProfilerLayout.MARKER_LENGTH, ProfilerLayout.MARKER_LENGTH);
        leftAxis.setMargins(0, ProfilerLayout.Y_AXIS_TOP_MARGIN);
        axisPanel.add((Component)leftAxis, "West");
        AxisComponent rightAxis = new AxisComponent(this.myThreadCountAxis, AxisComponent.AxisOrientation.LEFT, true);
        rightAxis.setShowAxisLine(false);
        rightAxis.setShowMax(true);
        rightAxis.setOnlyShowUnitAtMax(true);
        rightAxis.setHideTickAtMin(true);
        rightAxis.setMarkerLengths(ProfilerLayout.MARKER_LENGTH, ProfilerLayout.MARKER_LENGTH);
        rightAxis.setMargins(0, ProfilerLayout.Y_AXIS_TOP_MARGIN);
        axisPanel.add((Component)rightAxis, "East");
        return axisPanel;
    }

    @NotNull
    private JComponent createLineChartPanel() {
        JBPanel lineChartPanel = new JBPanel((LayoutManager)new BorderLayout());
        lineChartPanel.setOpaque(false);
        DetailedCpuUsage cpuUsage = this.myDetailedCpuUsage;
        LineChart lineChart = new LineChart((LineChartModel)cpuUsage);
        lineChart.configure(cpuUsage.getCpuSeries(), new LineConfig(ProfilerColors.CPU_USAGE).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX));
        lineChart.configure(cpuUsage.getOtherCpuSeries(), new LineConfig(ProfilerColors.CPU_OTHER_USAGE).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX));
        lineChart.configure(cpuUsage.getThreadsCountSeries(), new LineConfig(ProfilerColors.THREADS_COUNT).setStepped(true).setStroke((Stroke)LineConfig.DEFAULT_DASH_STROKE).setLegendIconType(LegendConfig.IconType.DASHED_LINE));
        lineChart.setRenderOffset(0, (int)LineConfig.DEFAULT_DASH_STROKE.getLineWidth() / 2);
        lineChartPanel.add((Component)lineChart, "Center");
        lineChart.setTopPadding(ProfilerLayout.Y_AXIS_TOP_MARGIN);
        lineChart.setFillEndGap(true);
        DurationDataRenderer traceRenderer = new DurationDataRenderer.Builder(this.myTraceDurations, ProfilerColors.CPU_CAPTURE_EVENT).setDurationBg(ProfilerColors.CPU_CAPTURE_BACKGROUND).setIconMapper(info -> info.getDurationUs() != Long.MAX_VALUE ? StudioIcons.Profiler.Toolbar.CAPTURE_CLOCK : null).setLabelProvider(info -> info.getDurationUs() == Long.MAX_VALUE ? "In progress" : "").setLabelColors(ProfilerColors.CPU_DURATION_LABEL_BACKGROUND, Color.BLACK, Color.lightGray, Color.WHITE).setBackgroundClickable(true).setClickHandler(traceInfo -> {
            if (traceInfo.getDurationUs() != Long.MAX_VALUE) {
                this.myStageSetAndSelectCapture.accept(traceInfo.getTraceId());
            }
        }).build();
        traceRenderer.addCustomLineConfig(cpuUsage.getCpuSeries(), new LineConfig(ProfilerColors.CPU_USAGE_CAPTURED).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX));
        traceRenderer.addCustomLineConfig(cpuUsage.getOtherCpuSeries(), new LineConfig(ProfilerColors.CPU_OTHER_USAGE_CAPTURED).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX));
        traceRenderer.addCustomLineConfig(cpuUsage.getThreadsCountSeries(), new LineConfig(ProfilerColors.THREADS_COUNT_CAPTURED).setStepped(true).setStroke((Stroke)LineConfig.DEFAULT_DASH_STROKE).setLegendIconType(LegendConfig.IconType.DASHED_LINE));
        this.myOverlayComponent.addDurationDataRenderer((AbstractDurationDataRenderer)traceRenderer);
        lineChart.addCustomRenderer((LineChartCustomRenderer)traceRenderer);
        return lineChartPanel;
    }

    @NotNull
    private JComponent createLegendPanel() {
        JBPanel legendPanel2 = new JBPanel((LayoutManager)new BorderLayout());
        CpuProfilerStage.CpuStageLegends legends2 = this.myCpuStageLegends;
        LegendComponent legend = new LegendComponent.Builder((LegendComponentModel)legends2).setRightPadding(ProfilerLayout.PROFILER_LEGEND_RIGHT_PADDING).build();
        legend.setForeground(ProfilerColors.MONITORS_HEADER_TEXT);
        legend.configure((Legend)legends2.getCpuLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.CPU_USAGE_CAPTURED));
        legend.configure((Legend)legends2.getOthersLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.CPU_OTHER_USAGE_CAPTURED));
        legend.configure((Legend)legends2.getThreadsLegend(), new LegendConfig(LegendConfig.IconType.DASHED_LINE, ProfilerColors.THREADS_COUNT_CAPTURED));
        JLabel label = new JLabel(this.myName);
        label.setBorder(ProfilerLayout.MONITOR_LABEL_PADDING);
        label.setVerticalAlignment(1);
        label.setForeground(ProfilerColors.MONITORS_HEADER_TEXT);
        legendPanel2.setOpaque(false);
        legendPanel2.add((Component)label, "West");
        legendPanel2.add((Component)legend, "East");
        return legendPanel2;
    }
}

