/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import java.util.Comparator;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

public class CpuThreadComparator {
    public static Comparator<CpuThreadInfo> BASE = ComparisonsKt.compareBy((Function1[])new Function1[]{CpuThreadComparator::relevancyRank, CpuThreadInfo::getName, CpuThreadInfo::getId});

    public static Comparator<CpuThreadInfo> withCaptureInfo(@NotNull CpuCapture capture) {
        return ComparisonsKt.compareBy((Function1[])new Function1[]{CpuThreadComparator::relevancyRank, thread -> Integer.valueOf(-capture.getCaptureNode(thread.getId()).getChildCount()), CpuThreadInfo::getName, CpuThreadInfo::getId});
    }

    private static int relevancyRank(CpuThreadInfo thread) {
        return thread.isMainThread() ? 0 : (thread.isRenderThread() ? 1 : (thread.isGpuThread() ? 2 : 4));
    }
}

