/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuCaptureMetadata;
import com.android.tools.profilers.cpu.CpuCaptureParser;
import com.android.tools.profilers.cpu.StatusPanelModel;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.android.tools.profilers.tasks.TaskFinishedState;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuCaptureHandler
implements Updatable,
StatusPanelModel {
    @NotNull
    private final CpuCaptureParser myCaptureParser;
    @NotNull
    private final Range myParseRange = new Range();
    @NotNull
    private final IdeProfilerServices myServices;
    @NotNull
    private final ProfilingConfiguration myConfiguration;
    @NotNull
    private final File myCaptureFile;
    private final long myTraceId;
    private final int myCaptureProcessIdHint;
    @Nullable
    private final String myCaptureProcessNameHint;
    private boolean myIsParsing = false;

    @VisibleForTesting
    public CpuCaptureHandler(@NotNull StudioProfilers profilers, @NotNull File captureFile, long traceId, @NotNull ProfilingConfiguration configuration, @Nullable String captureProcessNameHint, int captureProcessIdHint) {
        this(profilers, captureFile, traceId, configuration, CpuCaptureMetadata.CpuProfilerEntryPoint.UNKNOWN, captureProcessNameHint, captureProcessIdHint);
    }

    public CpuCaptureHandler(@NotNull StudioProfilers profilers, @NotNull File captureFile, long traceId, @NotNull ProfilingConfiguration configuration, CpuCaptureMetadata.CpuProfilerEntryPoint entryPoint, @Nullable String captureProcessNameHint, int captureProcessIdHint) {
        this.myCaptureParser = new CpuCaptureParser(profilers);
        this.myCaptureFile = captureFile;
        this.myTraceId = traceId;
        this.myServices = profilers.getIdeServices();
        this.myConfiguration = configuration;
        this.myCaptureProcessIdHint = captureProcessIdHint;
        this.myCaptureProcessNameHint = captureProcessNameHint;
        CpuCaptureMetadata metadata = new CpuCaptureMetadata(configuration);
        metadata.setCpuProfilerEntryPoint(entryPoint);
        this.myCaptureParser.trackCaptureMetadata(traceId, metadata);
    }

    @Override
    @NotNull
    public Range getRange() {
        return this.myParseRange;
    }

    @Override
    @NotNull
    public String getConfigurationText() {
        return this.myConfiguration.getName();
    }

    @NotNull
    File getCaptureFile() {
        return this.myCaptureFile;
    }

    @Override
    public void abort() {
        this.myCaptureParser.abortParsing();
    }

    public void update(long elapsedNs) {
        if (this.myIsParsing) {
            this.myParseRange.setMax(this.myParseRange.getMax() + (double)elapsedNs);
        }
    }

    public void parse(Consumer<CpuCapture> captureCompleted, @NotNull Consumer<TaskFinishedState> trackTaskFinished) {
        this.myIsParsing = true;
        this.myParseRange.set(0.0, 0.0);
        CompletableFuture<CpuCapture> capture = this.myCaptureParser.parse(this.myCaptureFile, this.myTraceId, this.myConfiguration.getTraceType(), this.myCaptureProcessIdHint, this.myCaptureProcessNameHint, trackTaskFinished);
        capture.handleAsync((parsedCapture, exception) -> {
            this.myIsParsing = false;
            captureCompleted.accept((CpuCapture)parsedCapture);
            return parsedCapture;
        }, this.myServices.getMainExecutor());
    }
}

