/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.FpsTimer;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.StopwatchTimer;
import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ResizingAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.adtui.model.updater.Updater;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.flags.enums.PowerProfilerDisplayMode;
import com.android.tools.idea.io.grpc.StatusRuntimeException;
import com.android.tools.idea.transport.manager.StreamQueryUtils;
import com.android.tools.idea.transport.poller.TransportEventPoller;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Trace;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.NullMonitorStage;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StreamingStage;
import com.android.tools.profilers.StudioMonitorStage;
import com.android.tools.profilers.StudioProfiler;
import com.android.tools.profilers.SupportLevel;
import com.android.tools.profilers.cpu.CpuCaptureMetadata;
import com.android.tools.profilers.cpu.CpuProfiler;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.event.EventProfiler;
import com.android.tools.profilers.memory.MainMemoryProfilerStage;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.sessions.SessionAspect;
import com.android.tools.profilers.sessions.SessionItem;
import com.android.tools.profilers.sessions.SessionsManager;
import com.android.tools.profilers.taskbased.TaskNotifications;
import com.android.tools.profilers.taskbased.home.TaskHomeTabModel;
import com.android.tools.profilers.taskbased.home.selections.deviceprocesses.ProcessListModel;
import com.android.tools.profilers.taskbased.pastrecordings.PastRecordingsTabModel;
import com.android.tools.profilers.tasks.ProfilerTaskLauncher;
import com.android.tools.profilers.tasks.ProfilerTaskType;
import com.android.tools.profilers.tasks.TaskTypeMappingUtils;
import com.android.tools.profilers.tasks.args.TaskArgs;
import com.android.tools.profilers.tasks.taskhandlers.ProfilerTaskHandler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StudioProfilers
extends AspectModel<ProfilerAspect>
implements Updatable {
    public static final String DAEMON_DEVICE_DIR_PATH = "/data/local/tmp/perfd";
    @VisibleForTesting
    static final int AGENT_STATUS_MAX_RETRY_COUNT = 10;
    public static final int PROFILERS_UPDATE_RATE = 60;
    public static final long TRANSPORT_POLLER_INTERVAL_NS = TimeUnit.MILLISECONDS.toNanos(500L);
    @NotNull
    private final ProfilerClient myClient;
    private final StreamingTimeline myTimeline;
    private final List<StudioProfiler> myProfilers;
    @NotNull
    private final IdeProfilerServices myIdeServices;
    @NotNull
    private final BiConsumer<ProfilerTaskType, TaskArgs> myCreateTaskTab;
    @NotNull
    private final Runnable myOpenTaskTab;
    @NotNull
    private final Function0<List<ProcessListModel.ToolbarDeviceSelection>> myToolbarDeviceSelectionsFetcher;
    @Nullable
    private final Function0<String> myPreferredProcessNameFetcher;
    @Nullable
    private Function0<ProfilerTaskHandler> myCurrentTaskHandlerFetcher;
    @Nullable
    private ProcessListModel.ToolbarDeviceSelection myLastToolbarDeviceSelection = null;
    private Map<Common.Device, List<Common.Process>> myProcesses;
    private Map<Common.Device, Long> myDeviceToStreamIds;
    private Map<Long, Common.Stream> myStreamIdToStreams;
    @NotNull
    private final TaskHomeTabModel myTaskHomeTabModel;
    @NotNull
    private final PastRecordingsTabModel myPastRecordingsTabModel;
    @NotNull
    private final Map<ProfilerTaskType, ProfilerTaskHandler> myTaskHandlers;
    @NotNull
    private final SessionsManager mySessionsManager;
    @Nullable
    private Common.Process myProcess;
    @NotNull
    private Common.AgentData myAgentData;
    @NotNull
    private Preference myPreference = Preference.NONE;
    private Common.Device myDevice;
    @NotNull
    private Common.Session mySelectedSession;
    @NotNull
    private Common.Session myProfilingSession;
    @NotNull
    private Stage myStage;
    private Updater myUpdater;
    private AxisComponentModel myViewAxis;
    private long myRefreshDevicesAndPreferredProcessName;
    private long myEventPollingInternvalNs;
    private final Map<Common.SessionMetaData.SessionType, Runnable> mySessionChangeListener;
    private boolean myAutoProfilingEnabled;
    public final Map<Long, Integer> mySessionIdToAgentStatusRetryMap = new HashMap<Long, Integer>();
    private TransportEventPoller myTransportPoller;

    private static Logger getLogger() {
        return Logger.getInstance(StudioProfilers.class);
    }

    @VisibleForTesting
    public StudioProfilers(@NotNull ProfilerClient client, @NotNull IdeProfilerServices ideServices) {
        this(client, ideServices, (StopwatchTimer)new FpsTimer(60));
    }

    @VisibleForTesting
    public StudioProfilers(@NotNull ProfilerClient client, @NotNull IdeProfilerServices ideServices, @NotNull StopwatchTimer timer) {
        this(client, ideServices, timer, new HashMap<ProfilerTaskType, ProfilerTaskHandler>(), (i, j) -> {}, () -> {}, (Function0<List<ProcessListModel.ToolbarDeviceSelection>>)((Function0)ArrayList::new), null, null);
    }

    public StudioProfilers(@NotNull ProfilerClient client, @NotNull IdeProfilerServices ideServices, @NotNull HashMap<ProfilerTaskType, ProfilerTaskHandler> taskHandlers, @NotNull BiConsumer<ProfilerTaskType, TaskArgs> createTaskTab, @NotNull Runnable openTaskTab, @NotNull Function0<List<ProcessListModel.ToolbarDeviceSelection>> toolbarDeviceSelectionsFetcher, @Nullable Function0<String> preferredProcessNameFetcher, @Nullable Function0<ProfilerTaskHandler> currentTaskHandlerFetcher) {
        this(client, ideServices, (StopwatchTimer)new FpsTimer(60), taskHandlers, createTaskTab, openTaskTab, toolbarDeviceSelectionsFetcher, preferredProcessNameFetcher, currentTaskHandlerFetcher);
    }

    private StudioProfilers(@NotNull ProfilerClient client, @NotNull IdeProfilerServices ideServices, @NotNull StopwatchTimer timer, @NotNull HashMap<ProfilerTaskType, ProfilerTaskHandler> taskHandlers, @NotNull BiConsumer<ProfilerTaskType, TaskArgs> createTaskTab, @NotNull Runnable openTaskTab, @NotNull Function0<List<ProcessListModel.ToolbarDeviceSelection>> toolbarDeviceSelectionsFetcher, @Nullable Function0<String> preferredProcessNameFetcher, @Nullable Function0<ProfilerTaskHandler> currentTaskHandlerFetcher) {
        this.myClient = client;
        this.myIdeServices = ideServices;
        this.myStage = this.createDefaultStage();
        this.mySessionsManager = new SessionsManager(this);
        this.mySessionChangeListener = new HashMap<Common.SessionMetaData.SessionType, Runnable>();
        this.myDeviceToStreamIds = new HashMap<Common.Device, Long>();
        this.myStreamIdToStreams = new HashMap<Long, Common.Stream>();
        this.myTaskHandlers = taskHandlers;
        this.myCreateTaskTab = createTaskTab;
        this.myOpenTaskTab = openTaskTab;
        this.myToolbarDeviceSelectionsFetcher = toolbarDeviceSelectionsFetcher;
        this.myPreferredProcessNameFetcher = preferredProcessNameFetcher;
        this.myCurrentTaskHandlerFetcher = currentTaskHandlerFetcher;
        this.myStage.enter();
        this.myUpdater = new Updater(timer);
        this.myTaskHomeTabModel = new TaskHomeTabModel(this);
        this.myPastRecordingsTabModel = new PastRecordingsTabModel(this);
        ImmutableList.Builder profilersBuilder = new ImmutableList.Builder();
        profilersBuilder.add((Object)new EventProfiler(this));
        profilersBuilder.add((Object)new CpuProfiler(this));
        profilersBuilder.add((Object)new MemoryProfiler(this));
        this.myProfilers = profilersBuilder.build();
        this.myTimeline = new StreamingTimeline(this.myUpdater);
        this.myProcesses = Maps.newHashMap();
        this.myDevice = null;
        this.myProcess = null;
        this.mySelectedSession = this.myProfilingSession = Common.Session.getDefaultInstance();
        this.myAgentData = Common.AgentData.getDefaultInstance();
        this.myTimeline.getSelectionRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, () -> {
            if (!this.myTimeline.getSelectionRange().isEmpty()) {
                this.myTimeline.setStreaming(false);
            }
        });
        this.registerSessionChangeListener(Common.SessionMetaData.SessionType.FULL, () -> {
            if (!ideServices.getFeatureConfig().isTaskBasedUxEnabled()) {
                this.setStage(new StudioMonitorStage(this));
            }
            if (SessionsManager.isSessionAlive(this.mySelectedSession)) {
                Transport.TimeResponse timeResponse = this.myClient.getTransportClient().getCurrentTime(Transport.TimeRequest.newBuilder().setStreamId(this.mySelectedSession.getStreamId()).build());
                this.myTimeline.reset(this.mySelectedSession.getStartTimestamp(), timeResponse.getTimestampNs());
                boolean isTaskBasedUXEnabled = this.getIdeServices().getFeatureConfig().isTaskBasedUxEnabled();
                if (isTaskBasedUXEnabled) {
                    if (this.startupProfilingStarted()) {
                        this.getTaskHomeTabModel().resetSelectionStateAndClearStartupTaskConfigs();
                    }
                } else if (this.startupCpuProfilingStarted()) {
                    this.setStage(new CpuProfilerStage(this, CpuCaptureMetadata.CpuProfilerEntryPoint.STARTUP_PROFILING));
                } else if (this.startupMemoryProfilingStarted()) {
                    this.setStage(new MainMemoryProfilerStage(this));
                }
            } else {
                this.myTimeline.reset(this.mySelectedSession.getStartTimestamp(), this.mySelectedSession.getEndTimestamp());
                this.myTimeline.setIsPaused(true);
                this.myTimeline.setStreaming(false);
                this.myTimeline.getViewRange().set(this.mySessionsManager.getSessionPreferredViewRange(this.mySelectedSession));
            }
        });
        this.mySessionsManager.addDependency((AspectObserver)this).onChange((Enum)SessionAspect.SELECTED_SESSION, this::selectedSessionChanged).onChange((Enum)SessionAspect.PROFILING_SESSION, this::profilingSessionChanged);
        this.myViewAxis = new ResizingAxisComponentModel.Builder(this.myTimeline.getViewRange(), (BaseAxisFormatter)TimeAxisFormatter.DEFAULT).setGlobalRange(this.myTimeline.getDataRange()).build();
        this.myTransportPoller = new TransportEventPoller(this.myClient.getTransportClient(), Comparator.comparing(Common.Event::getTimestamp));
        this.myUpdater.register((Updatable)this);
    }

    public boolean isStopped() {
        return !this.myUpdater.isRunning();
    }

    public void stop() {
        if (this.isStopped()) {
            return;
        }
        this.myUpdater.stop();
        this.setProcess(null, null);
        this.changed(ProfilerAspect.STAGE);
        this.myClient.shutdownChannel();
    }

    @NotNull
    public TransportEventPoller getTransportPoller() {
        return this.myTransportPoller;
    }

    public Map<Common.Device, List<Common.Process>> getDeviceProcessMap() {
        return this.myProcesses;
    }

    public List<Common.Device> getDevices() {
        return Lists.newArrayList(this.myProcesses.keySet());
    }

    @NotNull
    public TaskHomeTabModel getTaskHomeTabModel() {
        return this.myTaskHomeTabModel;
    }

    @NotNull
    public PastRecordingsTabModel getPastRecordingsTabModel() {
        return this.myPastRecordingsTabModel;
    }

    public void setPreferredProcess(@Nullable String deviceName, @Nullable String processName, @Nullable Predicate<Common.Process> processFilter) {
        boolean processNameChanged = !Objects.equals(this.myPreference.processName, processName);
        this.myPreference = new Preference(deviceName, processName, processFilter);
        if (!this.getIdeServices().getFeatureConfig().isTaskBasedUxEnabled()) {
            this.myIdeServices.getFeatureTracker().trackAutoProfilingRequested();
            this.setAutoProfilingEnabled(true);
        }
        this.changed(ProfilerAspect.PREFERRED_PROCESS);
        if (processNameChanged) {
            this.changed(ProfilerAspect.PREFERRED_PROCESS_NAME);
        }
    }

    public void setPreferredProcessName(@Nullable String processName) {
        if (Objects.equals(this.myPreference.processName, processName)) {
            return;
        }
        this.myPreference = new Preference(this.myPreference.deviceName, processName, this.myPreference.processFilter);
        this.changed(ProfilerAspect.PREFERRED_PROCESS_NAME);
    }

    @Nullable
    public String getPreferredProcessName() {
        return this.myPreference.processName;
    }

    public void setAutoProfilingEnabled(boolean enabled) {
        this.myAutoProfilingEnabled = enabled;
        if (enabled && this.getIdeServices().getFeatureConfig().isTaskBasedUxEnabled()) {
            StudioProfilers.getLogger().warn("Auto profiling should not be enabled or used when the Task-Based UX is enabled.");
        }
    }

    public boolean getAutoProfilingEnabled() {
        return this.myAutoProfilingEnabled;
    }

    private List<Common.Device> getUpToDateDevices() {
        return StudioProfilers.getUpToDateDevices(this.myClient, this.myDeviceToStreamIds, this.myStreamIdToStreams);
    }

    @NotNull
    public static List<Common.Device> getUpToDateDevices(@NotNull ProfilerClient client, @Nullable Map<Common.Device, Long> deviceToStreamIds, @Nullable Map<Long, Common.Stream> streamIdToStreams) {
        List streams = StreamQueryUtils.queryForDevices((TransportServiceGrpc.TransportServiceBlockingStub)client.getTransportClient());
        return streams.stream().map(stream -> {
            if (deviceToStreamIds != null && deviceToStreamIds.putIfAbsent(stream.getDevice(), stream.getStreamId()) == null) {
                StudioProfilers.getLogger().info(String.format("Device map updated: %s (Serial: %s), State: %s", StudioProfilers.buildDeviceName(stream.getDevice()), stream.getDevice().getSerial(), stream.getDevice().getState()));
            }
            if (streamIdToStreams != null) {
                streamIdToStreams.putIfAbsent(stream.getStreamId(), (Common.Stream)stream);
            }
            return stream.getDevice();
        }).collect(Collectors.toList());
    }

    private void readMainToolbarDeviceSelection() {
        if (IdeInfo.isGameTool()) {
            return;
        }
        List toolbarDeviceSelections = (List)this.myToolbarDeviceSelectionsFetcher.invoke();
        int toolbarSelectedDevicesCount = toolbarDeviceSelections.size();
        if (toolbarSelectedDevicesCount == 1) {
            ProcessListModel.ToolbarDeviceSelection toolbarDeviceSelection = (ProcessListModel.ToolbarDeviceSelection)toolbarDeviceSelections.get(0);
            ProcessListModel.ProfilerDeviceSelection currentlySelectedDevice = this.myTaskHomeTabModel.getSelectedDevice();
            String toolbarSelectionName = toolbarDeviceSelection.getName();
            String toolbarSelectionSerial = toolbarDeviceSelection.getSerial();
            if (!(currentlySelectedDevice != null && currentlySelectedDevice.getName().equals(toolbarSelectionName) && currentlySelectedDevice.getDevice().getSerial().equals(toolbarSelectionSerial) && Objects.equals(this.myLastToolbarDeviceSelection, toolbarDeviceSelection))) {
                this.myTaskHomeTabModel.getProcessListModel().onDeviceSelection(toolbarDeviceSelection);
                this.myLastToolbarDeviceSelection = toolbarDeviceSelection;
            }
        } else {
            this.myTaskHomeTabModel.getProcessListModel().setSelectedDevicesCount(toolbarSelectedDevicesCount);
            this.myTaskHomeTabModel.getProcessListModel().resetDeviceSelection();
        }
    }

    private void startProfileableDiscoveryIfApplicable(Collection<Common.Device> previousDevices, Collection<Common.Device> currentDevices) {
        Sets.SetView newDevices = Sets.difference(StudioProfilers.filterOnlineDevices(currentDevices), StudioProfilers.filterOnlineDevices(previousDevices));
        for (Common.Device device : newDevices) {
            int level = device.getFeatureLevel();
            if (level != 29 && level != 30) continue;
            this.myClient.executeAsync(Commands.Command.newBuilder().setStreamId(this.myDeviceToStreamIds.get(device).longValue()).setType(Commands.Command.CommandType.DISCOVER_PROFILEABLE).build(), this.getIdeServices().getPoolExecutor());
        }
    }

    @NotNull
    public Common.Stream getStream(long streamId) {
        return this.myStreamIdToStreams.getOrDefault(streamId, Common.Stream.getDefaultInstance());
    }

    public void update(long elapsedNs) {
        this.myEventPollingInternvalNs += elapsedNs;
        if (this.myEventPollingInternvalNs >= TRANSPORT_POLLER_INTERVAL_NS) {
            this.myTransportPoller.poll();
            this.myEventPollingInternvalNs = 0L;
        }
        this.myRefreshDevicesAndPreferredProcessName += elapsedNs;
        if (this.myRefreshDevicesAndPreferredProcessName < TimeUnit.SECONDS.toNanos(1L)) {
            return;
        }
        this.myRefreshDevicesAndPreferredProcessName = 0L;
        if (this.getIdeServices().getFeatureConfig().isTaskBasedUxEnabled() && this.myPreferredProcessNameFetcher != null) {
            String preferredProcessName = (String)this.myPreferredProcessNameFetcher.invoke();
            this.setPreferredProcessName(preferredProcessName);
        }
        try {
            this.readMainToolbarDeviceSelection();
            HashMap<Common.Device, List<Common.Process>> newProcesses = new HashMap<Common.Device, List<Common.Process>>();
            List<Common.Device> devices = this.getUpToDateDevices();
            this.startProfileableDiscoveryIfApplicable(this.myProcesses.keySet(), devices);
            for (Common.Device device : devices) {
                List processList = StreamQueryUtils.queryForProcesses((TransportServiceGrpc.TransportServiceBlockingStub)this.myClient.getTransportClient(), (long)this.myDeviceToStreamIds.get(device), (isProcessAlive, process) -> {
                    int lastProcessId = this.myProcess == null ? 0 : this.myProcess.getPid();
                    return !(isProcessAlive == false && process.getPid() != lastProcessId || !process.getExposureLevel().equals((Object)Common.Process.ExposureLevel.DEBUGGABLE) && !process.getExposureLevel().equals((Object)Common.Process.ExposureLevel.PROFILEABLE));
                });
                newProcesses.put(device, processList);
            }
            if (!newProcesses.equals(this.myProcesses)) {
                TaskHomeTabModel.SelectionStateOnTaskEnter selectionStateOnTaskEnter;
                this.myProcesses = newProcesses;
                boolean isTaskBasedUXEnabled = this.getIdeServices().getFeatureConfig().isTaskBasedUxEnabled();
                if (!isTaskBasedUXEnabled) {
                    this.setProcess(this.findPreferredDevice(), null);
                }
                if (isTaskBasedUXEnabled && (selectionStateOnTaskEnter = this.getTaskHomeTabModel().getSelectionStateOnTaskEnter()) != null) {
                    boolean isProfilingFromProcessStart = selectionStateOnTaskEnter.getProfilingProcessStartingPoint() == TaskHomeTabModel.ProfilingProcessStartingPoint.PROCESS_START;
                    ProfilerTaskType selectedTaskType = selectionStateOnTaskEnter.getSelectedStartupTaskType();
                    if (this.findPreferredDevice() != null && isProfilingFromProcessStart && selectedTaskType != ProfilerTaskType.UNSPECIFIED) {
                        this.setProcess(this.findPreferredDevice(), null, TaskTypeMappingUtils.convertTaskType(selectedTaskType), true);
                    }
                }
                this.changed(ProfilerAspect.PROCESSES);
            }
            this.mySessionsManager.update();
            if (SessionsManager.isSessionAlive(this.mySelectedSession)) {
                Common.AgentData agentData = this.getAgentData(this.mySelectedSession);
                int agentStatusRetryCount = this.mySessionIdToAgentStatusRetryMap.getOrDefault(this.mySelectedSession.getSessionId(), 0) + 1;
                if (agentData.getStatus() == Common.AgentData.Status.UNSPECIFIED && agentStatusRetryCount >= 10) {
                    agentData = Common.AgentData.newBuilder().setStatus(Common.AgentData.Status.UNATTACHABLE).build();
                }
                this.mySessionIdToAgentStatusRetryMap.put(this.mySelectedSession.getSessionId(), agentStatusRetryCount);
                if (!this.myAgentData.equals((Object)agentData)) {
                    if (this.myAgentData.getStatus() != Common.AgentData.Status.ATTACHED && agentData.getStatus() == Common.AgentData.Status.ATTACHED) {
                        this.getIdeServices().getFeatureTracker().trackAdvancedProfilingStarted();
                    }
                    this.myAgentData = agentData;
                    this.changed(ProfilerAspect.AGENT);
                }
            }
        }
        catch (StatusRuntimeException e) {
            System.err.println("Cannot find profiler service, retrying...");
        }
    }

    private static Set<Common.Device> filterOnlineDevices(Collection<Common.Device> devices) {
        return devices.stream().filter(device -> device.getState().equals((Object)Common.Device.State.ONLINE)).collect(Collectors.toSet());
    }

    @Nullable
    private Common.Device findPreferredDevice() {
        Set<Common.Device> devices = this.myProcesses.keySet();
        Set<Common.Device> onlineDevices = StudioProfilers.filterOnlineDevices(devices);
        if ((this.getIdeServices().getFeatureConfig().isTaskBasedUxEnabled() || this.myAutoProfilingEnabled) && this.myPreference.deviceName != null) {
            for (Common.Device device : onlineDevices) {
                if (!this.myPreference.deviceName.equals(StudioProfilers.buildDeviceName(device))) continue;
                return device;
            }
        }
        if (this.myDevice != null) {
            for (Common.Device device : devices) {
                if (this.myDevice.getDeviceId() != device.getDeviceId()) continue;
                return device;
            }
        }
        return null;
    }

    public void setDefaultStage() {
        this.setStage(this.createDefaultStage());
    }

    public void setMonitoringStage() {
        this.setStage(new StudioMonitorStage(this));
    }

    public void setProcess(@Nullable Common.Device device, @Nullable Common.Process process) {
        this.setProcess(device, process, Common.ProfilerTaskType.UNSPECIFIED_TASK, false);
    }

    public void setProcess(@Nullable Common.Device device, @Nullable Common.Process process, @NotNull Common.ProfilerTaskType taskType, boolean isStartupTask) {
        if (device != null) {
            this.myPreference = new Preference(null, this.myPreference.processName, this.myPreference.processFilter);
            if (!device.getUnsupportedReason().isEmpty()) {
                this.setStage(new NullMonitorStage(this, device.getUnsupportedReason()));
            }
        }
        if (!Objects.equals(device, this.myDevice)) {
            this.mySessionsManager.endCurrentSession();
            this.myDevice = device;
            this.myIdeServices.getFeatureTracker().trackChangeDevice(this.myDevice);
        }
        List<Common.Process> processes = this.myProcesses.get(this.myDevice);
        if (process == null || processes == null || !processes.contains(process)) {
            process = this.getPreferredProcess(processes);
        } else {
            this.setAutoProfilingEnabled(false);
        }
        if (!Objects.equals(process, this.myProcess) || !isStartupTask && this.getIdeServices().getFeatureConfig().isTaskBasedUxEnabled()) {
            this.mySessionsManager.endCurrentSession();
            this.myProcess = process;
            this.changed(ProfilerAspect.PROCESSES);
            this.myIdeServices.getFeatureTracker().trackChangeProcess(this.myProcess);
            if (this.myProcess != null && this.myProcess.getState() == Common.Process.State.ALIVE) {
                this.mySessionsManager.beginSession(this.myDeviceToStreamIds.get(this.myDevice), this.myDevice, this.myProcess, taskType, isStartupTask);
            }
        }
    }

    public void registerSessionChangeListener(Common.SessionMetaData.SessionType sessionType, Runnable listener) {
        this.mySessionChangeListener.put(sessionType, listener);
    }

    private void selectedSessionChanged() {
        Common.Session newSession = this.mySessionsManager.getSelectedSession();
        if (this.mySelectedSession.getSessionId() == newSession.getSessionId() && SessionsManager.isSessionAlive(this.mySelectedSession) && !SessionsManager.isSessionAlive(newSession)) {
            this.mySelectedSession = newSession;
            this.myTimeline.setIsPaused(true);
            return;
        }
        this.mySelectedSession = newSession;
        this.myAgentData = this.getAgentData(this.mySelectedSession);
        if (Common.Session.getDefaultInstance().equals((Object)newSession)) {
            this.myTimeline.setIsPaused(true);
            this.setDefaultStage();
            return;
        }
        Common.SessionMetaData.SessionType sessionType = this.mySessionsManager.getSelectedSessionMetaData().getType();
        assert (this.mySessionChangeListener.containsKey(sessionType));
        if (!this.getIdeServices().getFeatureConfig().isTaskBasedUxEnabled() || !sessionType.equals((Object)Common.SessionMetaData.SessionType.CPU_CAPTURE) && !sessionType.equals((Object)Common.SessionMetaData.SessionType.MEMORY_CAPTURE)) {
            this.mySessionChangeListener.get(sessionType).run();
        }
        this.changed(ProfilerAspect.AGENT);
        if (this.getIdeServices().getFeatureConfig().isTaskBasedUxEnabled()) {
            ProfilerTaskType selectedTaskType = this.mySessionsManager.getCurrentTaskType();
            Map<Long, SessionItem> sessionIdToSessionItems = this.mySessionsManager.getSessionIdToSessionItems();
            boolean isStartupTask = this.mySessionsManager.isCurrentTaskStartup();
            if (isStartupTask) {
                this.myTaskHomeTabModel.resetSelectionStateAndClearStartupTaskConfigs();
            }
            if (isStartupTask && !this.startupProfilingStarted() && this.mySessionsManager.isSessionAlive()) {
                this.mySessionsManager.endSelectedSession();
                this.myIdeServices.showNotification(TaskNotifications.STARTUP_TASK_FAILURE);
                return;
            }
            ProfilerTaskLauncher.launchProfilerTask(selectedTaskType, isStartupTask, this.getTaskHandlers(), this.getSession(), sessionIdToSessionItems, this.myCreateTaskTab, this.myIdeServices);
        }
    }

    private void profilingSessionChanged() {
        Common.Session newSession = this.mySessionsManager.getProfilingSession();
        if (!Common.Session.getDefaultInstance().equals((Object)this.myProfilingSession)) {
            assert (SessionsManager.isSessionAlive(this.myProfilingSession));
            this.myProfilers.forEach(profiler -> profiler.stopProfiling(this.myProfilingSession));
        }
        this.myProfilingSession = newSession;
        if (!Common.Session.getDefaultInstance().equals((Object)this.myProfilingSession) && this.myDevice != null && this.myDevice.getDeviceId() == this.myProfilingSession.getStreamId()) {
            assert (SessionsManager.isSessionAlive(this.myProfilingSession));
            this.myProfilers.forEach(profiler -> profiler.startProfiling(this.myProfilingSession));
            this.myIdeServices.getFeatureTracker().trackProfilingStarted();
            if (this.getAgentData(this.myProfilingSession).getStatus() == Common.AgentData.Status.ATTACHED) {
                this.getIdeServices().getFeatureTracker().trackAdvancedProfilingStarted();
            }
        }
    }

    private boolean startupProfilingStarted() {
        return this.startupCpuProfilingStarted() || this.startupMemoryProfilingStarted();
    }

    private boolean startupMemoryProfilingStarted() {
        List<Common.Event> events = MemoryProfiler.getNativeHeapEventsForSessionSortedByTimestamp(this.myClient, this.mySelectedSession, new Range(-9.223372036854776E18, 9.223372036854776E18));
        if (events.isEmpty()) {
            return false;
        }
        Trace.TraceStartStatus lastStartStatus = events.get(events.size() - 1).getTraceStatus().getTraceStartStatus();
        return lastStartStatus.getStatus() == Trace.TraceStartStatus.Status.SUCCESS && lastStartStatus.getStartTimeNs() <= this.mySelectedSession.getStartTimestamp();
    }

    private boolean startupCpuProfilingStarted() {
        List<Trace.TraceInfo> traceInfoList = CpuProfiler.getTraceInfoFromSession(this.myClient, this.mySelectedSession);
        if (!traceInfoList.isEmpty()) {
            Trace.TraceInfo lastTraceInfo = traceInfoList.get(traceInfoList.size() - 1);
            return lastTraceInfo.getConfiguration().getInitiationType() == Trace.TraceInitiationType.INITIATED_BY_STARTUP;
        }
        return false;
    }

    @Nullable
    private Common.Process getPreferredProcess(List<Common.Process> processes) {
        if (processes == null || processes.isEmpty()) {
            return null;
        }
        if ((this.getIdeServices().getFeatureConfig().isTaskBasedUxEnabled() || this.myAutoProfilingEnabled) && this.myPreference.processName != null) {
            for (Common.Process process : processes) {
                if (!process.getName().equals(this.myPreference.processName) || process.getState() != Common.Process.State.ALIVE || !this.myPreference.processFilter.test(process)) continue;
                this.myIdeServices.getFeatureTracker().trackAutoProfilingSucceeded();
                this.myAutoProfilingEnabled = false;
                return process;
            }
        }
        if (this.myProcess != null) {
            for (Common.Process process : processes) {
                if (!StudioProfilers.isSameProcess(this.myProcess, process) || this.myProcess.getState() != process.getState() && (this.myProcess.getState() != Common.Process.State.ALIVE || process.getState() != Common.Process.State.DEAD)) continue;
                return process;
            }
        }
        return null;
    }

    @NotNull
    private Common.AgentData getAgentData(@NotNull Common.Session session) {
        Common.AgentData agentData = Common.AgentData.getDefaultInstance();
        if (Common.Session.getDefaultInstance().equals((Object)session)) {
            return agentData;
        }
        Transport.GetEventGroupsRequest request = Transport.GetEventGroupsRequest.newBuilder().setKind(Common.Event.Kind.AGENT).setStreamId(session.getStreamId()).setPid(session.getPid()).build();
        Transport.GetEventGroupsResponse response = this.myClient.getTransportClient().getEventGroups(request);
        for (Transport.EventGroup group : response.getGroupsList()) {
            agentData = group.getEvents(group.getEventsCount() - 1).getAgentData();
        }
        return agentData;
    }

    private static boolean isSameProcess(@Nullable Common.Process process1, @Nullable Common.Process process2) {
        return process1 != null && process2 != null && process1.getPid() == process2.getPid() && process1.getName().equals(process2.getName()) && process1.getStartTimestampNs() == process2.getStartTimestampNs();
    }

    public List<Common.Process> getProcesses() {
        List<Common.Process> processes = this.myProcesses.get(this.myDevice);
        return processes == null ? ImmutableList.of() : processes;
    }

    @NotNull
    public Stage getStage() {
        return this.myStage;
    }

    @NotNull
    public ProfilerClient getClient() {
        return this.myClient;
    }

    @NotNull
    public SessionsManager getSessionsManager() {
        return this.mySessionsManager;
    }

    @NotNull
    public Common.Session getSession() {
        return this.mySelectedSession;
    }

    public Map<ProfilerTaskType, ProfilerTaskHandler> getTaskHandlers() {
        return this.myTaskHandlers;
    }

    @Nullable
    public ProfilerTaskHandler getCurrentTaskHandler() {
        assert (this.myCurrentTaskHandlerFetcher != null);
        return (ProfilerTaskHandler)this.myCurrentTaskHandlerFetcher.invoke();
    }

    @NotNull
    public String getSelectedAppName() {
        String name = "";
        if (!this.getSession().equals((Object)Common.Session.getDefaultInstance())) {
            name = this.mySessionsManager.getSelectedSessionMetaData().getSessionName();
        } else if (this.myProcess != null) {
            name = this.myProcess.getName();
        }
        String[] nameSplit = name.split(" \\(", 2);
        return nameSplit.length > 0 ? nameSplit[0] : "";
    }

    public void setStage(@NotNull Stage stage) {
        this.myStage.exit();
        this.getTimeline().getSelectionRange().clear();
        this.myStage = stage;
        this.myStage.getStudioProfilers().getUpdater().reset();
        this.myStage.enter();
        this.changed(ProfilerAspect.STAGE);
    }

    @NotNull
    public StreamingTimeline getTimeline() {
        return this.myTimeline;
    }

    @Nullable
    public Common.Device getDevice() {
        return this.myDevice;
    }

    @Nullable
    public Common.Process getProcess() {
        return this.myProcess;
    }

    @NotNull
    public SupportLevel getLiveProcessSupportLevel(int pid) {
        return this.myProcesses.values().stream().flatMap(Collection::stream).filter(p -> p.getPid() == pid).findFirst().map(p -> SupportLevel.of(p.getExposureLevel())).orElse(SupportLevel.NONE);
    }

    @NotNull
    private Common.Process getProcessForStreamIdPidTimestamp(long streamId, int pid, long timestamp) {
        Common.Event processEvent;
        Transport.GetEventGroupsRequest request = Transport.GetEventGroupsRequest.newBuilder().setKind(Common.Event.Kind.PROCESS).setStreamId(streamId).setPid(pid).setToTimestamp(timestamp).build();
        Transport.GetEventGroupsResponse response = this.myClient.getTransportClient().getEventGroups(request);
        if (response.getGroupsCount() == 1 && (processEvent = StreamQueryUtils.getHighestExposureEventForLastProcess((Transport.EventGroup)response.getGroups(0))) != null) {
            return processEvent.getProcess().getProcessStarted().getProcess();
        }
        if (pid != 0) {
            StudioProfilers.getLogger().warn("Cannot find the unique process for the given criteria.");
        }
        return Common.Process.getDefaultInstance();
    }

    @NotNull
    public SupportLevel getSupportLevelForSession(Common.Session session) {
        Common.Process process = this.getProcessForStreamIdPidTimestamp(session.getStreamId(), session.getPid(), session.getStartTimestamp());
        if (!process.equals((Object)Common.Process.getDefaultInstance())) {
            return SupportLevel.of(process.getExposureLevel());
        }
        Common.SessionMetaData metaData = this.mySessionsManager.getSessionMetaData(session.getSessionId());
        if (metaData != null) {
            return SupportLevel.of(metaData.getExposureLevel());
        }
        return SupportLevel.NONE;
    }

    @NotNull
    public SupportLevel getSelectedSessionSupportLevel() {
        return this.getSupportLevelForSession(this.mySessionsManager.getSelectedSession());
    }

    public boolean isAgentAttached() {
        return this.myAgentData.getStatus() == Common.AgentData.Status.ATTACHED;
    }

    @NotNull
    public Common.AgentData getAgentData() {
        return this.myAgentData;
    }

    public List<StudioProfiler> getProfilers() {
        return this.myProfilers;
    }

    @NotNull
    public IdeProfilerServices getIdeServices() {
        return this.myIdeServices;
    }

    public Updater getUpdater() {
        return this.myUpdater;
    }

    public AxisComponentModel getViewAxis() {
        return this.myViewAxis;
    }

    public List<Class<? extends Stage>> getDirectStages() {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        listBuilder.add(CpuProfilerStage.class);
        listBuilder.add(MainMemoryProfilerStage.class);
        boolean isPowerProfilerDisabled = this.getIdeServices().getFeatureConfig().getSystemTracePowerProfilerDisplayMode() == PowerProfilerDisplayMode.HIDE;
        return listBuilder.build();
    }

    @NotNull
    public Class<? extends Stage> getStageClass() {
        return ((Object)((Object)this.myStage)).getClass();
    }

    @VisibleForTesting
    public void addTaskHandler(ProfilerTaskType taskType, ProfilerTaskHandler taskHandler) {
        this.myTaskHandlers.putIfAbsent(taskType, taskHandler);
    }

    @VisibleForTesting
    public void setCurrentTaskHandlerFetcher(@Nullable Function0<ProfilerTaskHandler> currentTaskHandlerFetcher) {
        this.myCurrentTaskHandlerFetcher = currentTaskHandlerFetcher;
    }

    public void setNewStage(Class<? extends Stage> clazz) {
        try {
            Constructor<? extends Stage> constructor = clazz.getConstructor(StudioProfilers.class);
            Stage stage = constructor.newInstance(new Object[]{this});
            this.setStage(stage);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    private StreamingStage createDefaultStage() {
        return new NullMonitorStage(this);
    }

    @NotNull
    public static String buildSessionName(@NotNull Common.Device device, @NotNull Common.Process process) {
        return String.format("%s (%s)", process.getName(), StudioProfilers.buildDeviceName(device));
    }

    public void openTaskTab() {
        this.myOpenTaskTab.run();
    }

    @NotNull
    public static String buildDeviceName(@NotNull Common.Device device) {
        String serial;
        String suffix;
        StringBuilder deviceNameBuilder = new StringBuilder();
        String manufacturer = device.getManufacturer();
        String model = device.getModel();
        if (model.endsWith(suffix = String.format("-%s", serial = device.getSerial()))) {
            model = model.substring(0, model.length() - suffix.length());
        }
        if (!StringUtil.isEmpty((String)manufacturer) && !model.toUpperCase(Locale.US).startsWith(manufacturer.toUpperCase(Locale.US))) {
            deviceNameBuilder.append(manufacturer);
            deviceNameBuilder.append(" ");
        }
        deviceNameBuilder.append(model);
        return deviceNameBuilder.toString();
    }

    public static Pair<Long, Long> computeImportedFileStartEndTimestampsNs(File file) {
        long rangeNs;
        long hash = StudioProfilers.normalizeHash(Hashing.sha256().hashString((CharSequence)file.getAbsolutePath(), StandardCharsets.UTF_8).asLong());
        if (hash == Long.MAX_VALUE || hash == Long.MIN_VALUE || hash == -9223372036854775807L) {
            hash /= 2L;
        }
        if (hash < 0L) {
            hash = -hash;
        }
        if (hash >= Long.MAX_VALUE - (rangeNs = TimeUnit.SECONDS.toNanos(1L))) {
            hash -= rangeNs;
        }
        return new Pair((Object)hash, (Object)(hash + rangeNs));
    }

    private static long normalizeHash(long originalHash) {
        double hashMs = TimeUnit.NANOSECONDS.toMicros(originalHash);
        return TimeUnit.MICROSECONDS.toNanos((long)hashMs);
    }

    private static final class Preference {
        public static final Preference NONE = new Preference(null, null, null);
        @Nullable
        public final String deviceName;
        @Nullable
        public final String processName;
        @NotNull
        public final Predicate<Common.Process> processFilter;

        public Preference(@Nullable String deviceName, @Nullable String processName, @Nullable Predicate<Common.Process> processFilter) {
            this.deviceName = deviceName;
            this.processName = processName;
            this.processFilter = processFilter == null ? process -> true : processFilter;
        }
    }
}

