/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.ExportableArtifact;
import com.android.tools.profilers.LiveStage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.sessions.SessionArtifact;
import com.android.tools.profilers.sessions.SessionsManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 )2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001)B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020%H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u0014\u0010\u0013\u001a\u00020\u0014X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001dR\u0014\u0010 \u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0016R\u0014\u0010\"\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0016\u00a8\u0006*"}, d2={"Lcom/android/tools/profilers/LiveViewSessionArtifact;", "Lcom/android/tools/profilers/sessions/SessionArtifact;", "Lcom/android/tools/profiler/proto/Common$Session;", "Lcom/android/tools/profilers/ExportableArtifact;", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "session", "sessionMetaData", "Lcom/android/tools/profiler/proto/Common$SessionMetaData;", "<init>", "(Lcom/android/tools/profilers/StudioProfilers;Lcom/android/tools/profiler/proto/Common$Session;Lcom/android/tools/profiler/proto/Common$SessionMetaData;)V", "getProfilers", "()Lcom/android/tools/profilers/StudioProfilers;", "getSession", "()Lcom/android/tools/profiler/proto/Common$Session;", "getSessionMetaData", "()Lcom/android/tools/profiler/proto/Common$SessionMetaData;", "artifactProto", "getArtifactProto", "name", "", "getName", "()Ljava/lang/String;", "timestampNs", "", "getTimestampNs", "()J", "isOngoing", "", "()Z", "canExport", "getCanExport", "exportableName", "getExportableName", "exportExtension", "getExportExtension", "export", "", "outputStream", "Ljava/io/OutputStream;", "doSelect", "Companion", "intellij.android.profilers"})
@SourceDebugExtension(value={"SMAP\nLiveViewSessionArtifact.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiveViewSessionArtifact.kt\ncom/android/tools/profilers/LiveViewSessionArtifact\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1#2:101\n*E\n"})
public final class LiveViewSessionArtifact
implements SessionArtifact<Common.Session>,
ExportableArtifact {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StudioProfilers profilers;
    @NotNull
    private final Common.Session session;
    @NotNull
    private final Common.SessionMetaData sessionMetaData;
    @NotNull
    private final String name;

    public LiveViewSessionArtifact(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Common.SessionMetaData sessionMetaData) {
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)sessionMetaData, (String)"sessionMetaData");
        this.profilers = profilers;
        this.session = session;
        this.sessionMetaData = sessionMetaData;
        this.name = "Live View";
    }

    @Override
    @NotNull
    public StudioProfilers getProfilers() {
        return this.profilers;
    }

    @Override
    @NotNull
    public Common.Session getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public Common.SessionMetaData getSessionMetaData() {
        return this.sessionMetaData;
    }

    @Override
    @NotNull
    public Common.Session getArtifactProto() {
        return this.getSession();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public long getTimestampNs() {
        return 0L;
    }

    @Override
    public boolean isOngoing() {
        return SessionsManager.isSessionAlive(this.getSession());
    }

    @Override
    public boolean getCanExport() {
        return !this.isOngoing();
    }

    @Override
    @NotNull
    public String getExportableName() {
        return "live-view-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss"));
    }

    @Override
    @NotNull
    public String getExportExtension() {
        return "asdb";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        boolean bl = this.getCanExport();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Transport.BytesRequest request = Transport.BytesRequest.newBuilder().setStreamId(this.getSession().getStreamId()).setId(String.valueOf(this.getSession().getStartTimestamp())).build();
        Transport.FileResponse response = this.getProfilers().getClient().getTransportClient().getFile(request);
        String string = response.getFilePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFilePath(...)");
        if (((CharSequence)string).length() > 0) {
            try {
                Closeable closeable = new FileInputStream(new File(response.getFilePath()));
                Throwable throwable = null;
                try {
                    FileInputStream it = (FileInputStream)closeable;
                    boolean bl2 = false;
                    Long l = ByteStreamsKt.copyTo$default((InputStream)it, (OutputStream)outputStream, (int)0, (int)2, null);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                Logger.getInstance(LiveViewSessionArtifact.class).warn("Failed to export Live View file", (Throwable)e);
            }
        }
    }

    @Override
    public void doSelect() {
        this.getProfilers().getSessionsManager().setSession(this.getSession());
        if (!(this.getProfilers().getStage() instanceof LiveStage)) {
            this.getProfilers().setStage(new LiveStage(this.getProfilers(), (Function0<Unit>)((Function0)() -> LiveViewSessionArtifact.doSelect$lambda$1(this))));
        }
        this.getProfilers().getIdeServices().getFeatureTracker().trackSessionArtifactSelected(this, this.getProfilers().getSessionsManager().isSessionAlive());
    }

    @Override
    public void onSelect() {
        SessionArtifact.super.onSelect();
    }

    @Override
    public void update(long elapsedNs) {
        SessionArtifact.super.update(elapsedNs);
    }

    @Override
    public boolean isTopLevelArtifact() {
        return SessionArtifact.super.isTopLevelArtifact();
    }

    @Override
    public boolean isInitiatedByApi() {
        return SessionArtifact.super.isInitiatedByApi();
    }

    public void postUpdate() {
        SessionArtifact.super.postUpdate();
    }

    public void reset() {
        SessionArtifact.super.reset();
    }

    private static final Unit doSelect$lambda$1(LiveViewSessionArtifact this$0) {
        this$0.getProfilers().getSessionsManager().endCurrentSession();
        return Unit.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final List<SessionArtifact<?>> getSessionArtifacts(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Common.SessionMetaData sessionMetaData) {
        return Companion.getSessionArtifacts(profilers, session, sessionMetaData);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\r"}, d2={"Lcom/android/tools/profilers/LiveViewSessionArtifact$Companion;", "", "<init>", "()V", "getSessionArtifacts", "", "Lcom/android/tools/profilers/sessions/SessionArtifact;", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "session", "Lcom/android/tools/profiler/proto/Common$Session;", "sessionMetaData", "Lcom/android/tools/profiler/proto/Common$SessionMetaData;", "intellij.android.profilers"})
    @SourceDebugExtension(value={"SMAP\nLiveViewSessionArtifact.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiveViewSessionArtifact.kt\ncom/android/tools/profilers/LiveViewSessionArtifact$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1761#2,3:101\n*S KotlinDebug\n*F\n+ 1 LiveViewSessionArtifact.kt\ncom/android/tools/profilers/LiveViewSessionArtifact$Companion\n*L\n92#1:101,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final List<SessionArtifact<?>> getSessionArtifacts(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Common.SessionMetaData sessionMetaData) {
            Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)sessionMetaData, (String)"sessionMetaData");
            if (sessionMetaData.getType() == Common.SessionMetaData.SessionType.FULL) {
                boolean hasLiveViewEvent;
                block5: {
                    List list = profilers.getClient().getTransportClient().getEventGroups(Transport.GetEventGroupsRequest.newBuilder().setStreamId(session.getStreamId()).setPid(session.getPid()).setKind(Common.Event.Kind.LIVE_VIEW_STATUS).setFromTimestamp(session.getStartTimestamp()).setToTimestamp(session.getEndTimestamp() == Long.MAX_VALUE ? Long.MAX_VALUE : session.getEndTimestamp()).build()).getGroupsList();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getGroupsList(...)");
                    Iterable $this$any$iv = list;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v1 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Transport.EventGroup it = (Transport.EventGroup)element$iv;
                            boolean bl = false;
                            if (!(it.getGroupId() == session.getSessionId())) continue;
                            v1 = true;
                            break block5;
                        }
                        v1 = hasLiveViewEvent = false;
                    }
                }
                if (hasLiveViewEvent) {
                    return CollectionsKt.listOf((Object)new LiveViewSessionArtifact(profilers, session, sessionMetaData));
                }
            }
            return CollectionsKt.emptyList();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

