/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.service;

import com.android.tools.datastore.DataStoreService;
import com.android.tools.datastore.ServicePassThrough;
import com.android.tools.datastore.TaskDatabaseManager;
import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.datastore.database.DeviceProcessTable;
import com.android.tools.datastore.database.UnifiedEventsTable;
import com.android.tools.datastore.poller.UnifiedEventsDataPoller;
import com.android.tools.idea.io.grpc.Channel;
import com.android.tools.idea.io.grpc.StatusRuntimeException;
import com.android.tools.idea.io.grpc.stub.StreamObserver;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.IOException;
import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class TransportService
extends TransportServiceGrpc.TransportServiceImplBase
implements ServicePassThrough {
    private static final Logger LOG = Logger.getInstance(TransportService.class);
    private static final Set<Common.Event.Kind> TASK_DB_EVENT_KINDS = ImmutableSet.of((Object)Common.Event.Kind.SESSION, (Object)Common.Event.Kind.CPU_USAGE, (Object)Common.Event.Kind.CPU_THREAD, (Object)Common.Event.Kind.CPU_TRACE, (Object)Common.Event.Kind.MEMORY_GC, (Object)Common.Event.Kind.MEMORY_ALLOC_SAMPLING, (Object[])new Common.Event.Kind[]{Common.Event.Kind.MEMORY_ALLOC_TRACKING, Common.Event.Kind.MEMORY_ALLOC_TRACKING_STATUS, Common.Event.Kind.MEMORY_ALLOC_CONTEXTS, Common.Event.Kind.MEMORY_ALLOC_EVENTS, Common.Event.Kind.MEMORY_JNI_REF_EVENTS, Common.Event.Kind.MEMORY_ALLOC_STATS, Common.Event.Kind.MEMORY_USAGE, Common.Event.Kind.VIEW, Common.Event.Kind.INTERACTION, Common.Event.Kind.LIVE_VIEW_STATUS});
    private static final Set<Common.Event.Kind> DUAL_WRITE_EVENT_KINDS = ImmutableSet.of((Object)Common.Event.Kind.SESSION, (Object)Common.Event.Kind.MEMORY_ALLOC_TRACKING, (Object)Common.Event.Kind.LIVE_VIEW_STATUS);
    private final Consumer<Runnable> myFetchExecutor;
    @NotNull
    private final UnifiedEventsTable myTable;
    @NotNull
    private final DeviceProcessTable myLegacyTable;
    @NotNull
    private final DataStoreService myService;
    private final Map<Channel, UnifiedEventsDataPoller> myUnifiedEventsPollers = Maps.newHashMap();
    private final Map<Channel, Common.Stream> myChannelToStream = Maps.newHashMap();
    @VisibleForTesting
    final AtomicInteger myNextCommandId = new AtomicInteger();

    public TransportService(@NotNull DataStoreService service, @NotNull UnifiedEventsTable unifiedTable, Consumer<Runnable> fetchExecutor) {
        this.myService = service;
        this.myFetchExecutor = fetchExecutor;
        this.myTable = unifiedTable;
        this.myLegacyTable = new DeviceProcessTable();
    }

    @Override
    @NotNull
    public List<DataStoreService.BackingNamespace> getBackingNamespaces() {
        return Collections.singletonList(DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE);
    }

    @Override
    public void setBackingStore(@NotNull DataStoreService.BackingNamespace namespace, @NotNull Connection connection) {
        assert (namespace == DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE);
        this.myTable.initialize(connection);
    }

    public void connectToChannel(Common.Stream stream, Channel channel) {
        long streamId = stream.getStreamId();
        TransportServiceGrpc.TransportServiceBlockingStub stub = this.myService.getTransportClient(streamId);
        assert (stub != null);
        this.streamConnected(stream);
        UnifiedEventsDataPoller unifiedPoller = new UnifiedEventsDataPoller(stream.getStreamId(), event -> this.insertEvent(stream.getStreamId(), (Common.Event)event), stub, this.myService);
        this.myUnifiedEventsPollers.put(channel, unifiedPoller);
        this.myChannelToStream.put(channel, stream);
        DataStoreTable.addDataStoreErrorCallback(unifiedPoller);
        this.myFetchExecutor.accept(unifiedPoller);
    }

    public void disconnectFromChannel(Channel channel) {
        if (this.myUnifiedEventsPollers.containsKey(channel)) {
            UnifiedEventsDataPoller poller = this.myUnifiedEventsPollers.remove(channel);
            poller.stop();
            DataStoreTable.removeDataStoreErrorCallback(poller);
            this.streamDisconnected(this.myChannelToStream.remove(channel));
        }
    }

    private void insertEvent(long streamId, @NotNull Common.Event event) {
        this.tryAutoStartTaskDb(streamId, event);
        UnifiedEventsTable taskTable = this.myService.getTaskEventsTable();
        if (taskTable != null && TASK_DB_EVENT_KINDS.contains(event.getKind())) {
            taskTable.insertUnifiedEvent(streamId, event);
            if (DUAL_WRITE_EVENT_KINDS.contains(event.getKind())) {
                this.myTable.insertUnifiedEvent(streamId, event);
            }
        } else {
            this.myTable.insertUnifiedEvent(streamId, event);
        }
    }

    private void tryAutoStartTaskDb(long streamId, @NotNull Common.Event event) {
        String dbPath;
        if (event.getKind() != Common.Event.Kind.SESSION || event.getIsEnded() || !event.hasSession() || !event.getSession().hasSessionStarted()) {
            return;
        }
        Common.SessionData.SessionStarted sessionStarted = event.getSession().getSessionStarted();
        Common.ProfilerTaskType taskType = sessionStarted.getTaskType();
        if (taskType != Common.ProfilerTaskType.JAVA_KOTLIN_ALLOCATIONS && taskType != Common.ProfilerTaskType.LIVE_VIEW) {
            return;
        }
        try {
            dbPath = FileUtil.createTempFile((String)this.getTaskDbPath(taskType, event.getTimestamp()), (String)".asdb", (boolean)true).getAbsolutePath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.myService.setTaskDb(sessionStarted.getSessionId(), dbPath, taskType, streamId, event.getPid());
        this.myTable.insertFile(streamId, Long.toString(event.getTimestamp()), Transport.FileResponse.newBuilder().setFilePath(dbPath).build());
    }

    private String getTaskDbPath(Common.ProfilerTaskType taskType, long timestamp) {
        String nameHint = "task";
        if (taskType == Common.ProfilerTaskType.JAVA_KOTLIN_ALLOCATIONS) {
            nameHint = "java-kotlin-allocs";
        } else if (taskType == Common.ProfilerTaskType.LIVE_VIEW) {
            nameHint = "live-view";
        }
        return nameHint + "-" + timestamp;
    }

    private void streamConnected(Common.Stream stream) {
        this.myTable.insertUnifiedEvent(-1L, Common.Event.newBuilder().setKind(Common.Event.Kind.STREAM).setGroupId(stream.getStreamId()).setTimestamp(System.nanoTime()).setStream(Common.StreamData.newBuilder().setStreamConnected(Common.StreamData.StreamConnected.newBuilder().setStream(stream))).build());
    }

    private void streamDisconnected(Common.Stream stream) {
        this.myTable.insertUnifiedEvent(-1L, Common.Event.newBuilder().setKind(Common.Event.Kind.STREAM).setGroupId(stream.getStreamId()).setIsEnded(true).setTimestamp(System.nanoTime()).build());
    }

    public void getCurrentTime(Transport.TimeRequest request, StreamObserver<Transport.TimeResponse> observer) {
        TransportServiceGrpc.TransportServiceBlockingStub client = this.myService.getTransportClient(request.getStreamId());
        if (client != null) {
            observer.onNext((Object)client.getCurrentTime(request));
        } else {
            observer.onNext((Object)Transport.TimeResponse.getDefaultInstance());
        }
        observer.onCompleted();
    }

    public void getVersion(Transport.VersionRequest request, StreamObserver<Transport.VersionResponse> observer) {
        TransportServiceGrpc.TransportServiceBlockingStub client = this.myService.getTransportClient(request.getStreamId());
        if (client != null) {
            observer.onNext((Object)client.getVersion(request));
        }
        observer.onCompleted();
    }

    public void getDevices(Transport.GetDevicesRequest request, StreamObserver<Transport.GetDevicesResponse> observer) {
        Transport.GetDevicesResponse response = this.myLegacyTable.getDevices();
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void getProcesses(Transport.GetProcessesRequest request, StreamObserver<Transport.GetProcessesResponse> observer) {
        Transport.GetProcessesResponse response = this.myLegacyTable.getProcesses(request);
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void getAgentStatus(Transport.AgentStatusRequest request, StreamObserver<Common.AgentData> observer) {
        observer.onNext((Object)this.myLegacyTable.getAgentStatus(request));
        observer.onCompleted();
    }

    public void getFile(Transport.BytesRequest request, StreamObserver<Transport.FileResponse> responseObserver) {
        Transport.FileResponse response = this.myTable.getFile(request);
        long streamId = request.getStreamId();
        TransportServiceGrpc.TransportServiceBlockingStub client = this.myService.getTransportClient(streamId);
        if (response == null && client != null) {
            try {
                response = client.getFile(request);
                if (!response.getFilePath().isEmpty()) {
                    this.myTable.insertFile(streamId, request.getId(), response);
                }
            }
            catch (StatusRuntimeException ex) {
                LOG.warn(String.format(Locale.US, "Failed to get bytes for stream %d, id %s", streamId, request.getId()), (Throwable)ex);
            }
        } else if (response == null) {
            response = Transport.FileResponse.getDefaultInstance();
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void execute(Transport.ExecuteRequest request, StreamObserver<Transport.ExecuteResponse> responseObserver) {
        long streamId = request.getCommand().getStreamId();
        TransportServiceGrpc.TransportServiceBlockingStub client = this.myService.getTransportClient(streamId);
        if (client != null) {
            Commands.Command command = request.getCommand();
            int commandId = this.myNextCommandId.incrementAndGet();
            request = request.toBuilder().setCommand(command.toBuilder().setCommandId(commandId)).build();
            responseObserver.onNext((Object)client.execute(request).toBuilder().setCommandId(commandId).build());
        } else {
            responseObserver.onNext((Object)Transport.ExecuteResponse.getDefaultInstance());
        }
        responseObserver.onCompleted();
    }

    public void getEventGroups(Transport.GetEventGroupsRequest request, StreamObserver<Transport.GetEventGroupsResponse> responseObserver) {
        Transport.GetEventGroupsResponse.Builder response = Transport.GetEventGroupsResponse.newBuilder();
        UnifiedEventsTable tableToQuery = this.myTable;
        UnifiedEventsTable taskTable = this.myService.getTaskEventsTable();
        if (taskTable != null && TASK_DB_EVENT_KINDS.contains(request.getKind()) && !DUAL_WRITE_EVENT_KINDS.contains(request.getKind())) {
            TaskDatabaseManager.ImportedSessionMapping mapping;
            tableToQuery = taskTable;
            if (request.getPid() == 0 && (mapping = this.myService.getImportedSessionMapping()) != null) {
                request = request.toBuilder().setStreamId(mapping.realStreamId()).setPid(mapping.realPid()).build();
            }
        }
        List<Transport.EventGroup> events = tableToQuery.queryUnifiedEventGroups(request);
        response.addAllGroups(events);
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void deleteEvents(Transport.DeleteEventsRequest request, StreamObserver<Transport.DeleteEventsResponse> responseObserver) {
        this.myTable.deleteEvents(request.getStreamId(), request.getPid(), request.getGroupId(), request.getKind(), request.getFromTimestamp(), request.getToTimestamp());
        responseObserver.onNext((Object)Transport.DeleteEventsResponse.getDefaultInstance());
        responseObserver.onCompleted();
    }

    public void setTaskDb(Transport.SetTaskDbRequest request, StreamObserver<Transport.SetTaskDbResponse> responseObserver) {
        this.myService.setTaskDb(request.getSessionId(), request.getDbPath(), null, 0L, 0);
        responseObserver.onNext((Object)Transport.SetTaskDbResponse.getDefaultInstance());
        responseObserver.onCompleted();
    }

    public void unsetTaskDb(Transport.UnsetTaskDbRequest request, StreamObserver<Transport.UnsetTaskDbResponse> responseObserver) {
        this.myService.unsetTaskDb(request.getSessionId());
        responseObserver.onNext((Object)Transport.UnsetTaskDbResponse.getDefaultInstance());
        responseObserver.onCompleted();
    }
}

