/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.lint.detector.api.Issue;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModCommandService;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0017\u001a\u00020\u0010H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/lint/common/ModCommandLintQuickFix;", "Lcom/android/tools/idea/lint/common/LintIdeQuickFix;", "quickFixAction", "Lcom/intellij/modcommand/ModCommandAction;", "<init>", "(Lcom/intellij/modcommand/ModCommandAction;)V", "priority", "Lcom/intellij/codeInsight/intention/PriorityAction$Priority;", "setPriority", "", "getPriority", "getName", "", "startInWriteAction", "", "asIntention", "Lcom/intellij/codeInsight/intention/IntentionAction;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "project", "Lcom/intellij/openapi/project/Project;", "asLocalQuickFix", "Lcom/intellij/codeInspection/LocalQuickFix;", "rawIntention", "ModCommandWrapper", "intellij.lint"})
public final class ModCommandLintQuickFix
implements LintIdeQuickFix {
    @NotNull
    private final ModCommandAction quickFixAction;
    @NotNull
    private PriorityAction.Priority priority;

    public ModCommandLintQuickFix(@NotNull ModCommandAction quickFixAction) {
        Intrinsics.checkNotNullParameter((Object)quickFixAction, (String)"quickFixAction");
        this.quickFixAction = quickFixAction;
        this.priority = PriorityAction.Priority.HIGH;
    }

    @Override
    public void setPriority(@NotNull PriorityAction.Priority priority) {
        Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
        this.priority = priority;
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        return this.priority;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.quickFixAction.getFamilyName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFamilyName(...)");
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public final IntentionAction asIntention(@NotNull Issue issue, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        IntentionAction intentionAction = new ModCommandWrapper(this.quickFixAction, this.priority, issue, project).asIntention();
        Intrinsics.checkNotNullExpressionValue((Object)intentionAction, (String)"asIntention(...)");
        return intentionAction;
    }

    @NotNull
    public final LocalQuickFix asLocalQuickFix(@NotNull Issue issue, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LocalQuickFix localQuickFix = ModCommandService.getInstance().wrapToQuickFix((ModCommandAction)new ModCommandWrapper(this.quickFixAction, this.priority, issue, project));
        Intrinsics.checkNotNullExpressionValue((Object)localQuickFix, (String)"wrapToQuickFix(...)");
        return localQuickFix;
    }

    @VisibleForTesting
    @NotNull
    public final IntentionAction rawIntention() {
        IntentionAction intentionAction = this.quickFixAction.asIntention();
        Intrinsics.checkNotNullExpressionValue((Object)intentionAction, (String)"asIntention(...)");
        return intentionAction;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u000b\u001a\f0\f\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/lint/common/ModCommandLintQuickFix$ModCommandWrapper;", "Lcom/intellij/modcommand/ModCommandAction;", "action", "priority", "Lcom/intellij/codeInsight/intention/PriorityAction$Priority;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/modcommand/ModCommandAction;Lcom/intellij/codeInsight/intention/PriorityAction$Priority;Lcom/android/tools/lint/detector/api/Issue;Lcom/intellij/openapi/project/Project;)V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "perform", "Lcom/intellij/modcommand/ModCommand;", "intellij.lint"})
    private static final class ModCommandWrapper
    implements ModCommandAction {
        @NotNull
        private final ModCommandAction action;
        @NotNull
        private final PriorityAction.Priority priority;
        @NotNull
        private final Issue issue;
        @NotNull
        private final Project project;

        public ModCommandWrapper(@NotNull ModCommandAction action, @NotNull PriorityAction.Priority priority, @NotNull Issue issue, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
            Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.action = action;
            this.priority = priority;
            this.issue = issue;
            this.project = project;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.action.getFamilyName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFamilyName(...)");
            return string;
        }

        @Nullable
        public Presentation getPresentation(@NotNull ActionContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Presentation presentation = this.action.getPresentation(context);
            return presentation != null ? presentation.withPriority(this.priority) : null;
        }

        @NotNull
        public ModCommand perform(@NotNull ActionContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Presentation presentation = this.getPresentation(context);
            if (presentation == null) {
                ModCommand modCommand = ModCommand.nop();
                Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"nop(...)");
                return modCommand;
            }
            Presentation presentation2 = presentation;
            if (!IntentionPreviewUtils.isIntentionPreviewActive()) {
                LintIdeSupport lintIdeSupport = LintIdeSupport.Companion.get();
                String string = presentation2.name();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
                lintIdeSupport.logQuickFixInvocation(this.project, this.issue, string);
            }
            ModCommand modCommand = this.action.perform(context);
            Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"perform(...)");
            return modCommand;
        }
    }
}

