/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u001b\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\"\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0002RJ\u0010\u0006\u001a>\u0012\u0014\u0012\u0012 \t*\b\u0018\u00010\bR\u00020\u00000\bR\u00020\u0000 \t*\u001d\u0012\u0014\u0012\u0012 \t*\b\u0018\u00010\bR\u00020\u00000\bR\u00020\u00000\u000b\u00a2\u0006\u0002\b\n0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/android/util/MultiParentDisposable;", "Lcom/intellij/openapi/Disposable;", "parents", "", "<init>", "([Lcom/intellij/openapi/Disposable;)V", "parentAdapters", "", "Lorg/jetbrains/android/util/MultiParentDisposable$ParentAdapter;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "disposing", "Ljava/util/concurrent/atomic/AtomicBoolean;", "dispose", "", "triggerDisposal", "ParentAdapter", "Cleaner", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nDisposableUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisposableUtils.kt\norg/jetbrains/android/util/MultiParentDisposable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
public class MultiParentDisposable
implements Disposable {
    @NotNull
    private final List<ParentAdapter> parentAdapters;
    @NotNull
    private final AtomicBoolean disposing;

    public MultiParentDisposable(Disposable ... parents) {
        Intrinsics.checkNotNullParameter((Object)parents, (String)"parents");
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createLockFreeCopyOnWriteList(...)");
        this.parentAdapters = list;
        this.disposing = new AtomicBoolean();
        if (!(parents.length >= 2)) {
            boolean bl = false;
            String string = "Use of this class with less than two disposable parents is a waste of resources";
            throw new IllegalArgumentException(string.toString());
        }
        Disposer.register((Disposable)this, (Disposable)new Cleaner(this.parentAdapters));
        for (Disposable parent : parents) {
            this.parentAdapters.add(new ParentAdapter(parent));
        }
    }

    public void dispose() {
    }

    private final void triggerDisposal() {
        if (!this.disposing.getAndSet(true)) {
            Disposer.dispose((Disposable)this);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/android/util/MultiParentDisposable$Cleaner;", "Lcom/intellij/openapi/Disposable;", "disposables", "", "<init>", "(Ljava/util/List;)V", "getDisposables", "()Ljava/util/List;", "dispose", "", "intellij.android.core"})
    private static final class Cleaner
    implements Disposable {
        @NotNull
        private final List<Disposable> disposables;

        public Cleaner(@NotNull List<? extends Disposable> disposables) {
            Intrinsics.checkNotNullParameter(disposables, (String)"disposables");
            this.disposables = disposables;
        }

        @NotNull
        public final List<Disposable> getDisposables() {
            return this.disposables;
        }

        public void dispose() {
            for (Disposable disposable : this.disposables) {
                Disposer.dispose((Disposable)disposable);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/android/util/MultiParentDisposable$ParentAdapter;", "Lcom/intellij/openapi/Disposable;", "parent", "<init>", "(Lorg/jetbrains/android/util/MultiParentDisposable;Lcom/intellij/openapi/Disposable;)V", "dispose", "", "intellij.android.core"})
    private final class ParentAdapter
    implements Disposable {
        public ParentAdapter(Disposable parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Disposer.register((Disposable)parent, (Disposable)this);
        }

        public void dispose() {
            MultiParentDisposable.this.parentAdapters.remove(this);
            MultiParentDisposable.this.triggerDisposal();
        }
    }
}

