/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.android.tools.idea.rendering.RenderUtils;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.android.tools.rendering.HtmlLinkManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiFile;
import java.lang.ref.WeakReference;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinkHandler
implements HyperlinkListener {
    private static final Logger LOG = Logger.getInstance(LinkHandler.class);
    private final WeakReference<EditorDesignSurface> myEditorDesignSurfaceReference;
    private final WeakReference<Module> myModuleReference;
    private final WeakReference<PsiFile> mySourceFileReference;
    private final WeakReference<HtmlLinkManager> myLinkManagerReference;

    public LinkHandler(@NotNull HtmlLinkManager linkManager, @Nullable EditorDesignSurface surface, @NotNull Module module, @NotNull PsiFile sourceFile) {
        this.myLinkManagerReference = new WeakReference<HtmlLinkManager>(linkManager);
        this.myEditorDesignSurfaceReference = new WeakReference<EditorDesignSurface>(surface);
        this.myModuleReference = new WeakReference<Module>(module);
        this.mySourceFileReference = new WeakReference<PsiFile>(sourceFile);
    }

    public void forceUserRequestedRefresh() {
        EditorDesignSurface surface = (EditorDesignSurface)((Object)this.myEditorDesignSurfaceReference.get());
        if (surface != null) {
            RenderUtils.clearCache(surface.getConfigurations());
            surface.forceUserRequestedRefresh();
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        JEditorPane pane = (JEditorPane)e.getSource();
        if (e instanceof HTMLFrameHyperlinkEvent) {
            HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
            HTMLDocument doc = (HTMLDocument)pane.getDocument();
            doc.processHTMLFrameHyperlinkEvent(evt);
            return;
        }
        HtmlLinkManager linkManager = (HtmlLinkManager)this.myLinkManagerReference.get();
        if (linkManager == null) {
            LOG.warn("HtmlLinkManager has been collected. Click will be ignored");
            return;
        }
        Module module = (Module)this.myModuleReference.get();
        if (module == null) {
            LOG.warn("Module has been collected. Click will be ignored");
            return;
        }
        if (module.isDisposed()) {
            LOG.warn("Module has been disposed. Click will be ignored");
            return;
        }
        PsiFile sourceFile = (PsiFile)this.mySourceFileReference.get();
        if (sourceFile == null) {
            LOG.warn("PsiFile has been collected. Click will be ignored");
            return;
        }
        linkManager.handleUrl(e.getDescription(), module, sourceFile, true, new HtmlLinkManager.RefreshableSurface(){

            @Override
            public void handleRefreshRenderUrl() {
                LinkHandler.this.forceUserRequestedRefresh();
            }

            @Override
            public void requestRender() {
                LinkHandler.this.forceUserRequestedRefresh();
            }
        });
    }
}

