/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.ide.common.resources.LocaleManager;
import com.android.ide.common.resources.configuration.CountryCodeQualifier;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.KeyboardStateQualifier;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.resources.configuration.NavigationMethodQualifier;
import com.android.ide.common.resources.configuration.NavigationStateQualifier;
import com.android.ide.common.resources.configuration.NetworkCodeQualifier;
import com.android.ide.common.resources.configuration.NightModeQualifier;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.ide.common.resources.configuration.ScreenDimensionQualifier;
import com.android.ide.common.resources.configuration.ScreenHeightQualifier;
import com.android.ide.common.resources.configuration.ScreenOrientationQualifier;
import com.android.ide.common.resources.configuration.ScreenRatioQualifier;
import com.android.ide.common.resources.configuration.ScreenRoundQualifier;
import com.android.ide.common.resources.configuration.ScreenSizeQualifier;
import com.android.ide.common.resources.configuration.ScreenWidthQualifier;
import com.android.ide.common.resources.configuration.SmallestScreenWidthQualifier;
import com.android.ide.common.resources.configuration.TextInputMethodQualifier;
import com.android.ide.common.resources.configuration.TouchScreenQualifier;
import com.android.ide.common.resources.configuration.UiModeQualifier;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.Density;
import com.android.resources.Keyboard;
import com.android.resources.KeyboardState;
import com.android.resources.LayoutDirection;
import com.android.resources.Navigation;
import com.android.resources.NavigationState;
import com.android.resources.NightMode;
import com.android.resources.ResourceEnum;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenRatio;
import com.android.resources.ScreenRound;
import com.android.resources.ScreenSize;
import com.android.resources.TouchScreen;
import com.android.resources.UiMode;
import com.android.tools.idea.rendering.FlagManager;
import com.google.common.collect.ImmutableMap;
import com.google.common.math.IntMath;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.android.uipreview.InvalidOptionValueException;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeviceConfiguratorPanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance(DeviceConfiguratorPanel.class);
    private JBList<ResourceQualifier> myAvailableQualifiersList;
    private JButton myAddQualifierButton;
    private JButton myRemoveQualifierButton;
    private JPanel myQualifierOptionsPanel;
    private final Map<String, MyQualifierEditor<? extends ResourceQualifier>> myEditors = new HashMap<String, MyQualifierEditor<? extends ResourceQualifier>>();
    private final FolderConfiguration myAvailableQualifiersConfig = FolderConfiguration.createDefault();
    private final FolderConfiguration myChosenQualifiersConfig = new FolderConfiguration();
    private FolderConfiguration myActualQualifiersConfig = new FolderConfiguration();
    private JBList<ResourceQualifier> myChosenQualifiersList;
    private final DocumentListener myUpdatingDocumentListener = new DocumentAdapter(){

        protected void textChanged(@NotNull DocumentEvent e) {
            DeviceConfiguratorPanel.this.applyEditors();
        }
    };
    public final ListSelectionListener myUpdatingListListener = listSelectionEvent -> this.applyEditors();
    private static final ImmutableMap<String, Icon> OUR_ICONS = ImmutableMap.builder().put((Object)"UI Mode", (Object)StudioIcons.DeviceConfiguration.UI_MODE).put((Object)"Night Mode", (Object)StudioIcons.DeviceConfiguration.NIGHT_MODE).put((Object)"Screen Dimension", (Object)StudioIcons.DeviceConfiguration.DIMENSION).put((Object)"Density", (Object)StudioIcons.DeviceConfiguration.DENSITY).put((Object)"Screen Height", (Object)StudioIcons.DeviceConfiguration.SCREEN_HEIGHT).put((Object)"Keyboard State", (Object)StudioIcons.DeviceConfiguration.KEYBOARD).put((Object)"Locale", (Object)StudioIcons.DeviceConfiguration.LOCALE).put((Object)"Mobile Country Code", (Object)StudioIcons.DeviceConfiguration.COUNTRY_CODE).put((Object)"Mobile Network Code", (Object)StudioIcons.DeviceConfiguration.NETWORK_CODE).put((Object)"Navigation State", (Object)StudioIcons.DeviceConfiguration.NAVIGATION_STATE).put((Object)"Navigation Method", (Object)StudioIcons.DeviceConfiguration.NAVIGATION_METHOD).put((Object)"Screen Orientation", (Object)StudioIcons.DeviceConfiguration.ORIENTATION).put((Object)"Screen Ratio", (Object)StudioIcons.DeviceConfiguration.SCREEN_RATIO).put((Object)"Screen Size", (Object)StudioIcons.DeviceConfiguration.SCREEN_SIZE).put((Object)"Smallest Screen Width", (Object)StudioIcons.DeviceConfiguration.SMALLEST_SCREEN_SIZE).put((Object)"Screen Width", (Object)StudioIcons.DeviceConfiguration.SCREEN_WIDTH).put((Object)"Text Input Method", (Object)StudioIcons.DeviceConfiguration.TEXT_INPUT).put((Object)"Touch Screen", (Object)StudioIcons.DeviceConfiguration.TOUCH_SCREEN).put((Object)"Layout Direction", (Object)StudioIcons.DeviceConfiguration.LAYOUT_DIRECTION).put((Object)"Screen Roundness", (Object)StudioIcons.DeviceConfiguration.SCREEN_ROUNDNESS).put((Object)"Platform Version", (Object)StudioIcons.DeviceConfiguration.VERSION).build();

    public DeviceConfiguratorPanel() {
        super(new BorderLayout());
        this.createUIComponents();
        this.myChosenQualifiersConfig.reset();
        for (ResourceQualifier qualifier : this.myAvailableQualifiersConfig.getQualifiers()) {
            String name2 = qualifier.getShortName();
            if (qualifier instanceof CountryCodeQualifier) {
                this.myEditors.put(name2, new MyCountryCodeEditor());
                continue;
            }
            if (qualifier instanceof NetworkCodeQualifier) {
                this.myEditors.put(name2, new MyNetworkCodeEditor());
                continue;
            }
            if (qualifier instanceof KeyboardStateQualifier) {
                this.myEditors.put(name2, new MyKeyboardStateEditor(this));
                continue;
            }
            if (qualifier instanceof NavigationMethodQualifier) {
                this.myEditors.put(name2, new MyNavigationMethodEditor(this));
                continue;
            }
            if (qualifier instanceof NavigationStateQualifier) {
                this.myEditors.put(name2, new MyNavigationStateEditor(this));
                continue;
            }
            if (qualifier instanceof DensityQualifier) {
                this.myEditors.put(name2, new MyDensityEditor(this));
                continue;
            }
            if (qualifier instanceof ScreenDimensionQualifier) {
                this.myEditors.put(name2, new MyScreenDimensionEditor());
                continue;
            }
            if (qualifier instanceof ScreenOrientationQualifier) {
                this.myEditors.put(name2, new MyScreenOrientationEditor(this));
                continue;
            }
            if (qualifier instanceof ScreenRatioQualifier) {
                this.myEditors.put(name2, new MyScreenRatioEditor(this));
                continue;
            }
            if (qualifier instanceof ScreenSizeQualifier) {
                this.myEditors.put(name2, new MyScreenSizeEditor(this));
                continue;
            }
            if (qualifier instanceof TextInputMethodQualifier) {
                this.myEditors.put(name2, new MyTextInputMethodEditor(this));
                continue;
            }
            if (qualifier instanceof TouchScreenQualifier) {
                this.myEditors.put(name2, new MyTouchScreenEditor(this));
                continue;
            }
            if (qualifier instanceof VersionQualifier) {
                this.myEditors.put(name2, new MyVersionEditor());
                continue;
            }
            if (qualifier instanceof NightModeQualifier) {
                this.myEditors.put(name2, new MyNightModeEditor(this));
                continue;
            }
            if (qualifier instanceof UiModeQualifier) {
                this.myEditors.put(name2, new MyUiModeEditor(this));
                continue;
            }
            if (qualifier instanceof LocaleQualifier) {
                this.myEditors.put(name2, new MyLocaleEditor());
                continue;
            }
            if (qualifier instanceof SmallestScreenWidthQualifier) {
                this.myEditors.put(name2, new MySmallestScreenWidthEditor(this));
                continue;
            }
            if (qualifier instanceof ScreenWidthQualifier) {
                this.myEditors.put(name2, new MyScreenWidthEditor(this));
                continue;
            }
            if (qualifier instanceof ScreenHeightQualifier) {
                this.myEditors.put(name2, new MyScreenHeightEditor(this));
                continue;
            }
            if (qualifier instanceof LayoutDirectionQualifier) {
                this.myEditors.put(name2, new MyLayoutDirectionEditor(this));
                continue;
            }
            if (qualifier instanceof ScreenRoundQualifier) {
                this.myEditors.put(name2, new MyScreenRoundEditor(this));
                continue;
            }
            LOG.info("Missing editor for qualifier " + String.valueOf(qualifier));
        }
        for (String name3 : this.myEditors.keySet()) {
            this.myQualifierOptionsPanel.add((Component)this.myEditors.get(name3).getComponent(), name3);
        }
        this.myAvailableQualifiersList.setCellRenderer((ListCellRenderer)SimpleListCellRenderer.create((label2, value2, index) -> {
            if (value2 == null) {
                return;
            }
            label2.setText(value2.getShortName());
            label2.setIcon(DeviceConfiguratorPanel.getResourceIcon(value2));
        }));
        this.myChosenQualifiersList.setCellRenderer((ListCellRenderer)SimpleListCellRenderer.create((label2, value2, index) -> {
            if (value2 == null) {
                return;
            }
            ResourceQualifier qualifier = this.getActualQualifier((ResourceQualifier)value2);
            String shortDisplayValue = qualifier.getShortDisplayValue();
            label2.setText((String)(shortDisplayValue != null && !shortDisplayValue.isEmpty() ? shortDisplayValue : qualifier.getShortName() + " (?)"));
            label2.setIcon(DeviceConfiguratorPanel.getResourceIcon(qualifier));
        }));
        this.myAddQualifierButton.addActionListener(e -> {
            ResourceQualifier selectedQualifier = (ResourceQualifier)this.myAvailableQualifiersList.getSelectedValue();
            if (selectedQualifier == null) {
                return;
            }
            int index = this.myAvailableQualifiersList.getSelectedIndex();
            this.myAvailableQualifiersConfig.removeQualifier(selectedQualifier);
            this.myChosenQualifiersConfig.addQualifier(selectedQualifier);
            this.updateLists();
            this.applyEditors();
            if (index >= 0) {
                this.myAvailableQualifiersList.setSelectedIndex(Math.min(index, this.myAvailableQualifiersList.getItemsCount() - 1));
            }
            this.myChosenQualifiersList.setSelectedValue((Object)selectedQualifier, true);
        });
        this.myRemoveQualifierButton.addActionListener(e -> {
            ResourceQualifier selectedQualifier = (ResourceQualifier)this.myChosenQualifiersList.getSelectedValue();
            if (selectedQualifier == null) {
                return;
            }
            int index = this.myChosenQualifiersList.getSelectedIndex();
            this.myChosenQualifiersConfig.removeQualifier(selectedQualifier);
            this.myAvailableQualifiersConfig.addQualifier(selectedQualifier);
            this.updateLists();
            this.applyEditors();
            if (index >= 0) {
                this.myChosenQualifiersList.setSelectedIndex(Math.min(index, this.myChosenQualifiersList.getItemsCount() - 1));
            }
        });
        this.myAvailableQualifiersList.addListSelectionListener(e -> this.updateButtons());
        this.myChosenQualifiersList.addListSelectionListener(e -> {
            this.updateButtons();
            this.updateQualifierEditor();
        });
    }

    @Nullable
    private static Icon getResourceIcon(ResourceQualifier qualifier) {
        return (Icon)OUR_ICONS.get((Object)qualifier.getName());
    }

    public void init(@NotNull FolderConfiguration config) {
        this.myChosenQualifiersConfig.set(config);
        this.myAvailableQualifiersConfig.substract(config);
        for (ResourceQualifier qualifier : config.getQualifiers()) {
            MyQualifierEditor<? extends ResourceQualifier> editor = this.myEditors.get(qualifier.getShortName());
            if (editor == null) continue;
            editor.reset((ResourceQualifier)qualifier);
        }
    }

    public abstract void applyEditors();

    public void updateAll() {
        this.updateLists();
        this.updateButtons();
        this.updateQualifierEditor();
        this.applyEditors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doApplyEditors() throws InvalidOptionValueException {
        try {
            FolderConfiguration newConfig = new FolderConfiguration();
            for (ResourceQualifier qualifier : this.myChosenQualifiersConfig.getQualifiers()) {
                MyQualifierEditor<? extends ResourceQualifier> editor = this.myEditors.get(qualifier.getShortName());
                if (editor == null) continue;
                newConfig.addQualifier(editor.apply());
            }
            this.myActualQualifiersConfig = newConfig;
        }
        finally {
            this.myAvailableQualifiersList.repaint();
            this.myChosenQualifiersList.repaint();
        }
    }

    private ResourceQualifier getActualQualifier(ResourceQualifier qualifier) {
        for (ResourceQualifier qualifier1 : this.myActualQualifiersConfig.getQualifiers()) {
            if (!Objects.equals(qualifier1.getShortName(), qualifier.getShortName())) continue;
            return qualifier1;
        }
        return qualifier;
    }

    private void updateQualifierEditor() {
        ResourceQualifier selectedQualifier = (ResourceQualifier)this.myChosenQualifiersList.getSelectedValue();
        if (selectedQualifier != null && this.myEditors.containsKey(selectedQualifier.getShortName())) {
            CardLayout layout = (CardLayout)this.myQualifierOptionsPanel.getLayout();
            layout.show(this.myQualifierOptionsPanel, selectedQualifier.getShortName());
            this.myQualifierOptionsPanel.setVisible(true);
        } else {
            this.myQualifierOptionsPanel.setVisible(false);
        }
    }

    private void updateButtons() {
        this.myAddQualifierButton.setEnabled(this.myAvailableQualifiersList.getSelectedIndex() >= 0);
        this.myRemoveQualifierButton.setEnabled(this.myChosenQualifiersList.getSelectedIndex() >= 0);
    }

    private void updateLists() {
        Object qualifier = this.myAvailableQualifiersList.getSelectedValue();
        Object[] availableQualifiers = this.filterUnsupportedQualifiers(this.myAvailableQualifiersConfig.getQualifiers());
        this.myAvailableQualifiersList.setModel((ListModel)new CollectionListModel(availableQualifiers));
        this.myAvailableQualifiersList.setSelectedValue(qualifier, true);
        if (this.myAvailableQualifiersList.getSelectedValue() == null && this.myAvailableQualifiersList.getItemsCount() > 0) {
            this.myAvailableQualifiersList.setSelectedIndex(0);
        }
        qualifier = this.myChosenQualifiersList.getSelectedValue();
        Object[] chosenQualifiers = this.filterUnsupportedQualifiers(this.myChosenQualifiersConfig.getQualifiers());
        this.myChosenQualifiersList.setModel((ListModel)new CollectionListModel(chosenQualifiers));
        this.myChosenQualifiersList.setSelectedValue(qualifier, true);
        if (this.myChosenQualifiersList.getSelectedValue() == null && this.myChosenQualifiersList.getItemsCount() > 0) {
            this.myChosenQualifiersList.setSelectedIndex(0);
        }
    }

    private ResourceQualifier[] filterUnsupportedQualifiers(ResourceQualifier[] qualifiers) {
        return (ResourceQualifier[])Arrays.stream(qualifiers).filter(q -> this.myEditors.containsKey(q.getShortName())).toArray(ResourceQualifier[]::new);
    }

    public FolderConfiguration getConfiguration() {
        return this.myActualQualifiersConfig;
    }

    private void createUIComponents() {
        this.myQualifierOptionsPanel = new JPanel(new CardLayout()){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(this.getParent().getWidth() / 2, -1);
            }
        };
        JPanel leftPanel = new JPanel(new BorderLayout(JBUI.scale((int)5), JBUI.scale((int)5)));
        this.myAvailableQualifiersList = new JBList();
        this.myAvailableQualifiersList.setMinimumSize((Dimension)JBUI.size((int)10, (int)10));
        JBLabel label2 = new JBLabel(AndroidBundle.message("android.layout.preview.edit.configuration.available.qualifiers.label", new Object[0]));
        label2.setLabelFor(this.myAvailableQualifiersList);
        leftPanel.add((Component)label2, "North");
        leftPanel.add((Component)new JBScrollPane(this.myAvailableQualifiersList, 20, 31), "Center");
        JPanel rightPanel = new JPanel(new BorderLayout(JBUI.scale((int)5), JBUI.scale((int)5)));
        this.myChosenQualifiersList = new JBList();
        this.myChosenQualifiersList.setMinimumSize((Dimension)JBUI.size((int)10, (int)10));
        label2 = new JBLabel(AndroidBundle.message("android.layout.preview.edit.configuration.chosen.qualifiers.label", new Object[0]));
        label2.setLabelFor(this.myChosenQualifiersList);
        rightPanel.add((Component)label2, "North");
        rightPanel.add((Component)new JBScrollPane(this.myChosenQualifiersList, 20, 31), "Center");
        JPanel buttonsPanel = new JPanel((LayoutManager)new VerticalFlowLayout(1, 0, 0, true, false));
        this.myAddQualifierButton = new JButton(">>");
        buttonsPanel.add(this.myAddQualifierButton);
        this.myRemoveQualifierButton = new JButton("<<");
        buttonsPanel.add(this.myRemoveQualifierButton);
        this.add((Component)DeviceConfiguratorPanel.getListsPanel(buttonsPanel, leftPanel, rightPanel), "Center");
        this.add((Component)this.myQualifierOptionsPanel, "East");
    }

    @NotNull
    private static JPanel getListsPanel(final JPanel buttonsPanel, final JPanel leftPanel, final JPanel rightPanel) {
        int gap = 5;
        JPanel listsPanel = new JPanel((LayoutManager)new AbstractLayoutManager(){

            public Dimension preferredLayoutSize(Container target2) {
                return new Dimension(-1, -1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void layoutContainer(Container target2) {
                Object object = target2.getTreeLock();
                synchronized (object) {
                    Insets insets = target2.getInsets();
                    int top = insets.top;
                    int bottom = target2.getHeight() - insets.bottom;
                    int left2 = insets.left;
                    int right = target2.getWidth() - insets.right;
                    int middleWidth = buttonsPanel.getPreferredSize().width + 10;
                    int listWidth = (right - left2 - middleWidth) / 2;
                    int height = bottom - top;
                    leftPanel.setSize(listWidth, height);
                    rightPanel.setSize(listWidth, height);
                    buttonsPanel.setSize(middleWidth, height);
                    leftPanel.setBounds(left2, top, listWidth, height);
                    rightPanel.setBounds(right - listWidth, top, listWidth, height);
                    buttonsPanel.setBounds(left2 + listWidth + 5, top, middleWidth - 10, height);
                }
            }
        });
        listsPanel.add(leftPanel);
        listsPanel.add(buttonsPanel);
        listsPanel.add(rightPanel);
        return listsPanel;
    }

    private class MyCountryCodeEditor
    extends MyQualifierEditor<CountryCodeQualifier> {
        private static final int NUM_DIGITS = 3;
        private static final int MIN_VALUE = IntMath.pow((int)10, (int)2);
        private static final int MAX_VALUE = IntMath.pow((int)10, (int)3) - 1;
        private final JTextField myTextField = new JTextField(3);

        private MyCountryCodeEditor() {
        }

        @Override
        JComponent getComponent() {
            JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout());
            JBLabel label2 = new JBLabel("<html><body>Mobile country code<br>(3 digits):</body></html>");
            label2.setLabelFor((Component)this.myTextField);
            this.myTextField.setColumns(3);
            this.myTextField.getDocument().addDocumentListener(DeviceConfiguratorPanel.this.myUpdatingDocumentListener);
            panel2.add((Component)label2);
            panel2.add(this.myTextField);
            return panel2;
        }

        @Override
        void reset(@NotNull CountryCodeQualifier qualifier) {
            this.myTextField.setText(Integer.toString(qualifier.getCode()));
        }

        @Override
        @NotNull
        CountryCodeQualifier apply() throws InvalidOptionValueException {
            if (this.myTextField.getText().length() != 3) {
                throw new InvalidOptionValueException("Country code must contain 3 digits");
            }
            try {
                int code = Integer.parseInt(this.myTextField.getText());
                if (code < MIN_VALUE || code > MAX_VALUE) {
                    throw new InvalidOptionValueException("Incorrect country code");
                }
                return new CountryCodeQualifier(code);
            }
            catch (NumberFormatException e) {
                throw new InvalidOptionValueException("Country code must be a number");
            }
        }
    }

    private class MyNetworkCodeEditor
    extends MyQualifierEditor<NetworkCodeQualifier> {
        private static final int MAX_DIGITS = 3;
        private static final int MAX_VALUE = IntMath.pow((int)10, (int)3) - 1;
        private final JTextField myTextField = new JTextField(3);

        private MyNetworkCodeEditor() {
        }

        @Override
        JComponent getComponent() {
            JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout());
            JBLabel label2 = new JBLabel("<html><body>Mobile network code<br>(1-3 digits):</body></html>");
            panel2.add((Component)label2);
            label2.setLabelFor((Component)this.myTextField);
            this.myTextField.getDocument().addDocumentListener(DeviceConfiguratorPanel.this.myUpdatingDocumentListener);
            panel2.add(this.myTextField);
            return panel2;
        }

        @Override
        void reset(@NotNull NetworkCodeQualifier qualifier) {
            this.myTextField.setText(Integer.toString(qualifier.getCode()));
        }

        @Override
        @NotNull
        NetworkCodeQualifier apply() throws InvalidOptionValueException {
            try {
                int code = Integer.parseInt(this.myTextField.getText());
                if (code <= 0 || code > MAX_VALUE) {
                    throw new InvalidOptionValueException("Incorrect network code");
                }
                return new NetworkCodeQualifier(code);
            }
            catch (NumberFormatException e) {
                throw new InvalidOptionValueException("Network code must be a number");
            }
        }
    }

    private class MyKeyboardStateEditor
    extends MyEnumBasedEditor<KeyboardStateQualifier, KeyboardState> {
        private MyKeyboardStateEditor(DeviceConfiguratorPanel deviceConfiguratorPanel) {
            super(deviceConfiguratorPanel, KeyboardState.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            return "Keyboard state:";
        }

        @Override
        @NotNull
        protected KeyboardState getValue(@NotNull KeyboardStateQualifier qualifier) {
            return qualifier.getValue();
        }

        @Override
        @NotNull
        protected KeyboardStateQualifier getQualifier(@NotNull KeyboardState value2) {
            return new KeyboardStateQualifier(value2);
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            return "Specify keyboard state";
        }
    }

    private class MyNavigationMethodEditor
    extends MyEnumBasedEditor<NavigationMethodQualifier, Navigation> {
        private MyNavigationMethodEditor(DeviceConfiguratorPanel deviceConfiguratorPanel) {
            super(deviceConfiguratorPanel, Navigation.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            return "Navigation method:";
        }

        @Override
        @NotNull
        protected Navigation getValue(@NotNull NavigationMethodQualifier qualifier) {
            return qualifier.getValue();
        }

        @Override
        @NotNull
        protected NavigationMethodQualifier getQualifier(@NotNull Navigation value2) {
            return new NavigationMethodQualifier(value2);
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            return "Specify navigation method";
        }
    }

    private class MyNavigationStateEditor
    extends MyEnumBasedEditor<NavigationStateQualifier, NavigationState> {
        private MyNavigationStateEditor(DeviceConfiguratorPanel deviceConfiguratorPanel) {
            super(deviceConfiguratorPanel, NavigationState.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            return "Navigation state:";
        }

        @Override
        @NotNull
        protected NavigationState getValue(@NotNull NavigationStateQualifier qualifier) {
            return qualifier.getValue();
        }

        @Override
        @NotNull
        protected NavigationStateQualifier getQualifier(@NotNull NavigationState value2) {
            return new NavigationStateQualifier(value2);
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            return "Specify navigation state";
        }
    }

    private class MyDensityEditor
    extends MyComboBoxEditor<DensityQualifier, Density> {
        private MyDensityEditor(DeviceConfiguratorPanel deviceConfiguratorPanel) {
            super(new DensityComboBoxModel());
        }

        @Override
        @NotNull
        protected String getCaption() {
            return "Density:";
        }

        @Override
        @NotNull
        protected Density getValue(@NotNull DensityQualifier qualifier) {
            return qualifier.getValue();
        }

        @Override
        @NotNull
        protected DensityQualifier getQualifier(@NotNull Density value2) {
            return new DensityQualifier(value2);
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            return "Specify density";
        }
    }

    private class MyScreenDimensionEditor
    extends MyQualifierEditor<ScreenDimensionQualifier> {
        private final JTextField mySizeField1 = new JTextField();
        private final JTextField mySizeField2 = new JTextField();

        private MyScreenDimensionEditor() {
        }

        @Override
        JComponent getComponent() {
            JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout());
            JBLabel label2 = new JBLabel("Screen dimension in dp:");
            label2.setLabelFor((Component)this.mySizeField1);
            panel2.add((Component)label2);
            panel2.add(this.mySizeField1);
            panel2.add(this.mySizeField2);
            this.mySizeField1.getDocument().addDocumentListener(DeviceConfiguratorPanel.this.myUpdatingDocumentListener);
            this.mySizeField2.getDocument().addDocumentListener(DeviceConfiguratorPanel.this.myUpdatingDocumentListener);
            return panel2;
        }

        @Override
        void reset(@NotNull ScreenDimensionQualifier qualifier) {
            int value2;
            int value1 = qualifier.getValue1();
            if (value1 >= 0) {
                this.mySizeField1.setText(Integer.toString(value1));
            }
            if ((value2 = qualifier.getValue2()) >= 0) {
                this.mySizeField2.setText(Integer.toString(value2));
            }
        }

        @Override
        @NotNull
        ScreenDimensionQualifier apply() throws InvalidOptionValueException {
            try {
                int size1 = Integer.parseInt(this.mySizeField1.getText());
                int size2 = Integer.parseInt(this.mySizeField2.getText());
                if (size1 <= 0 || size2 <= 0) {
                    throw new InvalidOptionValueException("Incorrect screen dimension");
                }
                return new ScreenDimensionQualifier(size1, size2);
            }
            catch (NumberFormatException e) {
                LOG.debug((Throwable)e);
                throw new InvalidOptionValueException("Incorrect screen dimension");
            }
        }
    }

    private class MyScreenOrientationEditor
    extends MyEnumBasedEditor<ScreenOrientationQualifier, ScreenOrientation> {
        private MyScreenOrientationEditor(DeviceConfiguratorPanel deviceConfiguratorPanel) {
            super(deviceConfiguratorPanel, ScreenOrientation.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            return "Screen orientation:";
        }

        @Override
        @NotNull
        protected ScreenOrientation getValue(@NotNull ScreenOrientationQualifier qualifier) {
            return qualifier.getValue();
        }

        @Override
        @NotNull
        protected ScreenOrientationQualifier getQualifier(@NotNull ScreenOrientation value2) {
            return new ScreenOrientationQualifier(value2);
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            return "Specify screen orientation";
        }
    }

    private class MyScreenRatioEditor
    extends MyEnumBasedEditor<ScreenRatioQualifier, ScreenRatio> {
        private MyScreenRatioEditor(DeviceConfiguratorPanel deviceConfiguratorPanel) {
            super(deviceConfiguratorPanel, ScreenRatio.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            return "Screen ratio:";
        }

        @Override
        @NotNull
        protected ScreenRatio getValue(@NotNull ScreenRatioQualifier qualifier) {
            return qualifier.getValue();
        }

        @Override
        @NotNull
        protected ScreenRatioQualifier getQualifier(@NotNull ScreenRatio value2) {
            return new ScreenRatioQualifier(value2);
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            return "Specify screen ratio";
        }
    }

    private class MyScreenSizeEditor
    extends MyEnumBasedEditor<ScreenSizeQualifier, ScreenSize> {
        private MyScreenSizeEditor(DeviceConfiguratorPanel deviceConfiguratorPanel) {
            super(deviceConfiguratorPanel, ScreenSize.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            return "Screen size:";
        }

        @Override
        @NotNull
        protected ScreenSize getValue(@NotNull ScreenSizeQualifier qualifier) {
            return qualifier.getValue();
        }

        @Override
        @NotNull
        protected ScreenSizeQualifier getQualifier(@NotNull ScreenSize value2) {
            return new ScreenSizeQualifier(value2);
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            return "Specify screen size";
        }
    }

    private class MyTextInputMethodEditor
    extends MyEnumBasedEditor<TextInputMethodQualifier, Keyboard> {
        private MyTextInputMethodEditor(DeviceConfiguratorPanel deviceConfiguratorPanel) {
            super(deviceConfiguratorPanel, Keyboard.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            return "Text input method:";
        }

        @Override
        @NotNull
        protected Keyboard getValue(@NotNull TextInputMethodQualifier qualifier) {
            return qualifier.getValue();
        }

        @Override
        @NotNull
        protected TextInputMethodQualifier getQualifier(@NotNull Keyboard value2) {
            return new TextInputMethodQualifier(value2);
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            return "Specify text input method";
        }
    }

    private class MyTouchScreenEditor
    extends MyEnumBasedEditor<TouchScreenQualifier, TouchScreen> {
        private MyTouchScreenEditor(DeviceConfiguratorPanel deviceConfiguratorPanel) {
            super(deviceConfiguratorPanel, TouchScreen.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            return "Touch screen:";
        }

        @Override
        @NotNull
        protected TouchScreen getValue(@NotNull TouchScreenQualifier qualifier) {
            return qualifier.getValue();
        }

        @Override
        @NotNull
        protected TouchScreenQualifier getQualifier(@NotNull TouchScreen value2) {
            return new TouchScreenQualifier(value2);
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            return "Specify touch screen";
        }
    }

    private class MyVersionEditor
    extends MyQualifierEditor<VersionQualifier> {
        private final JTextField myTextField = new JTextField(3);

        private MyVersionEditor() {
        }

        @Override
        JComponent getComponent() {
            JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout());
            JBLabel label2 = new JBLabel("Platform API level");
            panel2.add((Component)label2);
            label2.setLabelFor((Component)this.myTextField);
            this.myTextField.getDocument().addDocumentListener(DeviceConfiguratorPanel.this.myUpdatingDocumentListener);
            panel2.add(this.myTextField);
            return panel2;
        }

        @Override
        void reset(@NotNull VersionQualifier qualifier) {
            this.myTextField.setText(Integer.toString(qualifier.getVersion()));
        }

        @Override
        @NotNull
        VersionQualifier apply() throws InvalidOptionValueException {
            VersionQualifier qualifier;
            Object text2 = this.myTextField.getText().trim();
            if (!((String)text2).isEmpty() && Character.isDigit(((String)text2).charAt(0))) {
                text2 = "v" + (String)text2;
            }
            if ((qualifier = VersionQualifier.getQualifier((String)text2)) == null || qualifier.getVersion() < 0) {
                throw new InvalidOptionValueException("Incorrect API level");
            }
            return qualifier;
        }
    }

    private class MyNightModeEditor
    extends MyEnumBasedEditor<NightModeQualifier, NightMode> {
        protected MyNightModeEditor(DeviceConfiguratorPanel deviceConfiguratorPanel) {
            super(deviceConfiguratorPanel, NightMode.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            return "Night mode:";
        }

        @Override
        protected NightMode getValue(@NotNull NightModeQualifier qualifier) {
            return qualifier.getValue();
        }

        @Override
        @NotNull
        protected NightModeQualifier getQualifier(@NotNull NightMode value2) {
            return new NightModeQualifier(value2);
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            return "Specify night mode";
        }
    }

    private class MyUiModeEditor
    extends MyEnumBasedEditor<UiModeQualifier, UiMode> {
        private MyUiModeEditor(DeviceConfiguratorPanel deviceConfiguratorPanel) {
            super(deviceConfiguratorPanel, UiMode.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            return "UI mode:";
        }

        @Override
        protected UiMode getValue(@NotNull UiModeQualifier qualifier) {
            return qualifier.getValue();
        }

        @Override
        @NotNull
        protected UiModeQualifier getQualifier(@NotNull UiMode value2) {
            return new UiModeQualifier(value2);
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            return "Specify UI mode";
        }
    }

    private class MyLocaleEditor
    extends MyQualifierEditor<LocaleQualifier> {
        private final JBList<String> myLanguageList = new JBList();
        private final JBList<String> myRegionList = new JBList();
        private JBCheckBox myShowAllRegions;
        private JBLabel myWarningsLabel;
        private static final Comparator<String> LOCALE_COMPARATOR = Comparator.comparingInt(String::length).thenComparing(String.CASE_INSENSITIVE_ORDER);

        private MyLocaleEditor() {
        }

        @Override
        JComponent getComponent() {
            JPanel pane = new JPanel(new GridBagLayout());
            pane.setBorder((Border)JBUI.Borders.emptyLeft((int)20));
            this.myShowAllRegions = new JBCheckBox("Show All Regions", false);
            this.myWarningsLabel = new JBLabel("BCP 47 tags (3-letter languages or regions) will only match on API 21");
            this.myWarningsLabel.setIcon(AllIcons.General.BalloonWarning);
            this.myWarningsLabel.setVisible(false);
            JBLabel languageLabel = new JBLabel("Language:");
            JBLabel languageTip = new JBLabel("Tip: Type in list to filter");
            JBLabel regionLabel = new JBLabel("Specific Region Only:");
            SortedListModel languageModel = new SortedListModel(LOCALE_COMPARATOR);
            languageModel.addAll((Collection)LocaleManager.getLanguageCodes((boolean)true));
            this.myLanguageList.setModel((ListModel)languageModel);
            this.myLanguageList.setSelectionMode(0);
            this.myLanguageList.setCellRenderer(FlagManager.get().getLanguageCodeCellRenderer());
            JBScrollPane scroll = new JBScrollPane(this.myLanguageList);
            JComponent languagePane = ListWithFilter.wrap(this.myLanguageList, (JScrollPane)scroll, FlagManager.getLanguageNameMapper());
            languageLabel.setLabelFor(this.myLanguageList);
            languageTip.setFont((Font)JBUI.Fonts.miniFont());
            this.myRegionList.setSelectionMode(0);
            this.myRegionList.setCellRenderer(FlagManager.get().getRegionCodeCellRenderer());
            this.updateRegionList(null);
            JBScrollPane regionPane = new JBScrollPane(this.myRegionList);
            JBInsets insets = JBUI.insetsLeft((int)20);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            pane.add((Component)languageLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = insets;
            pane.add((Component)regionLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            pane.add((Component)languagePane, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = insets;
            pane.add((Component)regionPane, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            pane.add((Component)languageTip, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = insets;
            pane.add((Component)this.myShowAllRegions, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 21;
            pane.add((Component)this.myWarningsLabel, gridBagConstraints);
            this.myLanguageList.addListSelectionListener(DeviceConfiguratorPanel.this.myUpdatingListListener);
            this.myRegionList.addListSelectionListener(DeviceConfiguratorPanel.this.myUpdatingListListener);
            this.myLanguageList.addListSelectionListener(listSelectionEvent -> this.updateRegionList((String)this.myLanguageList.getSelectedValue()));
            this.myShowAllRegions.addItemListener(e -> this.updateRegionList((String)this.myLanguageList.getSelectedValue()));
            return pane;
        }

        private void updateRegionList(@Nullable String languageCode) {
            SortedListModel regionModel = new SortedListModel(Comparator.comparing("__"::equals).reversed().thenComparing(LOCALE_COMPARATOR));
            regionModel.add((Object)"__");
            if (!this.myShowAllRegions.isSelected() && languageCode != null) {
                regionModel.addAll((Collection)LocaleManager.getRelevantRegions((String)languageCode));
            } else {
                regionModel.addAll((Collection)LocaleManager.getRegionCodes((boolean)true));
            }
            this.myRegionList.setModel((ListModel)regionModel);
            if (languageCode != null && regionModel.getSize() > 0) {
                this.myRegionList.setSelectedIndex(0);
            }
        }

        @Override
        void reset(@NotNull LocaleQualifier qualifier) {
            if (qualifier.isValid() && !qualifier.hasFakeValue()) {
                String language = qualifier.getLanguage();
                String region = qualifier.getRegion();
                ListModel languageModel = this.myLanguageList.getModel();
                ListModel regionModel = this.myRegionList.getModel();
                if (language != null) {
                    int n = languageModel.getSize();
                    for (int i = 0; i < n; ++i) {
                        if (!language.equals(languageModel.getElementAt(i))) continue;
                        this.myLanguageList.setSelectedIndex(i);
                        break;
                    }
                }
                if (region != null) {
                    int i;
                    boolean found = false;
                    int n = regionModel.getSize();
                    for (i = 0; i < n; ++i) {
                        if (!region.equals(regionModel.getElementAt(i))) continue;
                        this.myRegionList.setSelectedIndex(i);
                        found = true;
                        break;
                    }
                    if (!found && !this.myShowAllRegions.isSelected()) {
                        this.myShowAllRegions.setSelected(true);
                        n = regionModel.getSize();
                        for (i = 0; i < n; ++i) {
                            if (!region.equals(regionModel.getElementAt(i))) continue;
                            this.myRegionList.setSelectedIndex(i);
                            break;
                        }
                    }
                } else {
                    this.myRegionList.setSelectedIndex(-1);
                }
            } else {
                this.myLanguageList.setSelectedIndex(-1);
                this.myRegionList.setSelectedIndex(-1);
            }
        }

        @Override
        @NotNull
        LocaleQualifier apply() throws InvalidOptionValueException {
            String selectedLanguage = (String)this.myLanguageList.getSelectedValue();
            if (selectedLanguage == null) {
                throw new InvalidOptionValueException("Select a language tag");
            }
            String selectedRegion = (String)this.myRegionList.getSelectedValue();
            if ("__".equals(selectedRegion)) {
                selectedRegion = null;
            }
            this.myWarningsLabel.setVisible(selectedLanguage.length() > 2 || selectedRegion != null && selectedRegion.length() > 2);
            return new LocaleQualifier(null, selectedLanguage, selectedRegion, null);
        }
    }

    private class MySmallestScreenWidthEditor
    extends MySizeEditorBase<SmallestScreenWidthQualifier> {
        private MySmallestScreenWidthEditor(DeviceConfiguratorPanel deviceConfiguratorPanel) {
            super("Smallest screen width:");
        }

        @Override
        protected int getValue(@NotNull SmallestScreenWidthQualifier qualifier) {
            return qualifier.getValue();
        }

        @Override
        @NotNull
        protected SmallestScreenWidthQualifier createQualifier(int value2) {
            return new SmallestScreenWidthQualifier(value2);
        }

        @Override
        protected String getErrorMessage() {
            return "Incorrect smallest screen width";
        }
    }

    private class MyScreenWidthEditor
    extends MySizeEditorBase<ScreenWidthQualifier> {
        private MyScreenWidthEditor(DeviceConfiguratorPanel deviceConfiguratorPanel) {
            super("Screen width:");
        }

        @Override
        protected int getValue(@NotNull ScreenWidthQualifier qualifier) {
            return qualifier.getValue();
        }

        @Override
        @NotNull
        protected ScreenWidthQualifier createQualifier(int value2) {
            return new ScreenWidthQualifier(value2);
        }

        @Override
        protected String getErrorMessage() {
            return "Incorrect screen width";
        }
    }

    private class MyScreenHeightEditor
    extends MySizeEditorBase<ScreenHeightQualifier> {
        private MyScreenHeightEditor(DeviceConfiguratorPanel deviceConfiguratorPanel) {
            super("Screen height:");
        }

        @Override
        protected int getValue(@NotNull ScreenHeightQualifier qualifier) {
            return qualifier.getValue();
        }

        @Override
        @NotNull
        protected ScreenHeightQualifier createQualifier(int value2) {
            return new ScreenHeightQualifier(value2);
        }

        @Override
        protected String getErrorMessage() {
            return "Incorrect screen height";
        }
    }

    private class MyLayoutDirectionEditor
    extends MyEnumBasedEditor<LayoutDirectionQualifier, LayoutDirection> {
        private MyLayoutDirectionEditor(DeviceConfiguratorPanel deviceConfiguratorPanel) {
            super(deviceConfiguratorPanel, LayoutDirection.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            return "Layout direction:";
        }

        @Override
        @NotNull
        protected LayoutDirection getValue(@NotNull LayoutDirectionQualifier qualifier) {
            return qualifier.getValue();
        }

        @Override
        @NotNull
        protected LayoutDirectionQualifier getQualifier(@NotNull LayoutDirection value2) {
            return new LayoutDirectionQualifier(value2);
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            return "Specify layout direction";
        }
    }

    private class MyScreenRoundEditor
    extends MyEnumBasedEditor<ScreenRoundQualifier, ScreenRound> {
        private MyScreenRoundEditor(DeviceConfiguratorPanel deviceConfiguratorPanel) {
            super(deviceConfiguratorPanel, ScreenRound.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            return "Screen roundness:";
        }

        @Override
        protected ScreenRound getValue(@NotNull ScreenRoundQualifier qualifier) {
            return qualifier.getValue();
        }

        @Override
        @NotNull
        protected ScreenRoundQualifier getQualifier(@NotNull ScreenRound value2) {
            return new ScreenRoundQualifier(value2);
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            return "Specify the screen shape";
        }
    }

    private static abstract class MyQualifierEditor<T extends ResourceQualifier> {
        private MyQualifierEditor() {
        }

        abstract JComponent getComponent();

        abstract void reset(@NotNull T var1);

        @NotNull
        abstract T apply() throws InvalidOptionValueException;
    }

    private abstract class MySizeEditorBase<T extends ResourceQualifier>
    extends MyQualifierEditor<T> {
        private final JTextField myTextField = new JTextField(3);
        private final String myLabelText;

        protected MySizeEditorBase(String labelText) {
            this.myLabelText = labelText;
        }

        @Override
        JComponent getComponent() {
            JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout());
            JBLabel label2 = new JBLabel(this.myLabelText);
            panel2.add((Component)label2);
            label2.setLabelFor((Component)this.myTextField);
            this.myTextField.getDocument().addDocumentListener(DeviceConfiguratorPanel.this.myUpdatingDocumentListener);
            panel2.add(this.myTextField);
            return panel2;
        }

        @Override
        void reset(@NotNull T qualifier) {
            this.myTextField.setText(Integer.toString(this.getValue(qualifier)));
        }

        protected abstract int getValue(@NotNull T var1);

        @NotNull
        protected abstract T createQualifier(int var1);

        protected abstract String getErrorMessage();

        @Override
        @NotNull
        T apply() throws InvalidOptionValueException {
            try {
                int value2 = Integer.parseInt(this.myTextField.getText().trim());
                if (value2 < 0) {
                    throw new InvalidOptionValueException(this.getErrorMessage());
                }
                return this.createQualifier(value2);
            }
            catch (NumberFormatException e) {
                throw new InvalidOptionValueException(this.getErrorMessage());
            }
        }
    }

    private static class DensityComboBoxModel
    extends AbstractListModel<Density>
    implements ComboBoxModel<Density> {
        private final List<Density> myList = new ArrayList<Density>();
        private Density mySelected;

        private DensityComboBoxModel() {
            for (Density density : Density.values()) {
                if (!density.isRecommended()) continue;
                this.myList.add(density);
            }
            this.mySelected = this.myList.get(0);
        }

        @Override
        public int getSize() {
            return this.myList.size();
        }

        @Override
        public Density getElementAt(int index) {
            return this.myList.get(index);
        }

        @Override
        public void setSelectedItem(Object item) {
            Density e = (Density)item;
            this.setSelectedItem(e);
        }

        public void setSelectedItem(Density item) {
            this.mySelected = item;
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public Density getSelectedItem() {
            return this.mySelected;
        }
    }

    private abstract class MyEnumBasedEditor<T extends ResourceQualifier, U extends Enum<U>>
    extends MyComboBoxEditor<T, U> {
        private final ComboBox<U> myComboBox = new ComboBox();

        protected MyEnumBasedEditor(@NotNull DeviceConfiguratorPanel deviceConfiguratorPanel, Class<U> enumClass) {
            super(new EnumComboBoxModel(enumClass));
        }

        @Override
        void reset(@NotNull T qualifier) {
            Enum value2 = (Enum)this.getValue(qualifier);
            if (value2 != null) {
                this.myComboBox.setSelectedItem((Object)value2);
            } else if (this.myComboBox.getItemCount() > 0) {
                this.myComboBox.setSelectedIndex(0);
            }
        }
    }

    private abstract class MyComboBoxEditor<T extends ResourceQualifier, U extends ResourceEnum>
    extends MyQualifierEditor<T> {
        private final ComboBoxModel<U> myModel;
        private final ComboBox<U> myComboBox = new ComboBox();

        protected MyComboBoxEditor(ComboBoxModel<U> model) {
            this.myModel = model;
        }

        @Override
        JComponent getComponent() {
            this.myComboBox.addActionListener(e -> DeviceConfiguratorPanel.this.applyEditors());
            this.myComboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label2, value2, index) -> label2.setText(value2.getShortDisplayValue())));
            JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout());
            JBLabel label3 = new JBLabel(this.getCaption());
            label3.setLabelFor(this.myComboBox);
            this.myComboBox.setModel(this.myModel);
            panel2.add((Component)label3);
            panel2.add((Component)this.myComboBox);
            return panel2;
        }

        @NotNull
        protected abstract String getCaption();

        @Override
        void reset(@NotNull T qualifier) {
            U value2 = this.getValue(qualifier);
            if (value2 != null) {
                this.myComboBox.setSelectedItem(value2);
            } else if (this.myComboBox.getItemCount() > 0) {
                this.myComboBox.setSelectedIndex(0);
            }
        }

        protected abstract U getValue(@NotNull T var1);

        @NotNull
        protected abstract T getQualifier(@NotNull U var1);

        @NotNull
        protected abstract String getErrorMessage();

        @Override
        @NotNull
        T apply() throws InvalidOptionValueException {
            ResourceEnum selectedItem = (ResourceEnum)this.myComboBox.getSelectedItem();
            if (selectedItem == null) {
                throw new InvalidOptionValueException(this.getErrorMessage());
            }
            return this.getQualifier(selectedItem);
        }
    }
}

