/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.SdkConstants;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.AndroidVersionUtils;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.sdk.AndroidPlatform;
import com.android.tools.sdk.AndroidSdkData;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.CommonBundle;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatforms;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.android.util.AndroidBuildCommonUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidSdkUtils {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.sdk.AndroidSdkUtils");
    public static final String ADB_PATH_PROPERTY = "android.adb.path";
    @NonNls
    private static final String ANDROID_SDK_FOLDER_NAME = "sdk";
    private static final String[] ANDROID_SDK_RELATIVE_PATHS = new String[]{"sdk", File.separator + ".." + File.separator + "sdk"};

    @NonNls
    private static String getAndroidSdkDefaultInstallDir() {
        if (!((String)StudioFlags.NPW_CUSTOM_LOCAL_APP_DATA.get()).isEmpty() && SystemInfo.isWindows) {
            return FileUtil.join((String[])new String[]{(String)StudioFlags.NPW_CUSTOM_LOCAL_APP_DATA.get(), "Android", "Sdk"});
        }
        return SystemInfo.isWindows ? FileUtil.join((String[])new String[]{System.getenv("LOCALAPPDATA"), "Android", "Sdk"}) : (SystemInfo.isMac ? FileUtil.join((String[])new String[]{SystemProperties.getUserHome(), "Library", "Android", ANDROID_SDK_FOLDER_NAME}) : FileUtil.join((String[])new String[]{SystemProperties.getUserHome(), "Android", "Sdk"}));
    }

    private AndroidSdkUtils() {
    }

    public static void createNewAndroidPlatform(@NotNull String sdkPath) {
        IAndroidTarget target2 = AndroidSdkUtils.findBestTarget(sdkPath = FileUtil.toSystemIndependentName((String)sdkPath));
        if (target2 != null) {
            AndroidSdks.getInstance().create(target2, new File(sdkPath), AndroidSdks.getInstance().chooseNameForNewLibrary(target2), true);
        }
    }

    @Nullable
    private static IAndroidTarget findBestTarget(@NotNull String sdkPath) {
        AndroidSdkData sdkData = AndroidSdkData.getSdkData(sdkPath);
        if (sdkData != null) {
            IAndroidTarget[] targets = sdkData.getTargets();
            if (targets.length == 1) {
                return targets[0];
            }
            return AndroidSdkUtils.findBestTarget(targets);
        }
        return null;
    }

    @Nullable
    private static IAndroidTarget findBestTarget(@NotNull IAndroidTarget[] targets) {
        int androidPlatformToAutocreate = (Integer)StudioFlags.ANDROID_PLATFORM_TO_AUTOCREATE.get();
        IAndroidTarget bestTarget = null;
        int maxApiLevel = -1;
        for (IAndroidTarget target2 : targets) {
            AndroidVersion version2 = target2.getVersion();
            if (!target2.isPlatform() || version2.isPreview() || version2.getApiLevel() <= maxApiLevel) continue;
            bestTarget = target2;
            maxApiLevel = version2.getApiLevel();
            if (maxApiLevel == androidPlatformToAutocreate) break;
        }
        return bestTarget;
    }

    public static String getTargetPresentableName(@NotNull IAndroidTarget target2) {
        return target2.isPlatform() ? target2.getName() : target2.getName() + " (" + target2.getVersionName() + ")";
    }

    public static void updateSdkSourceRoot(@NotNull Sdk sdk) {
        AndroidPlatform platform = AndroidPlatforms.getInstance(sdk);
        if (platform != null) {
            IAndroidTarget target2 = platform.getTarget();
            SdkModificator sdkModificator = sdk.getSdkModificator();
            sdkModificator.removeRoots(OrderRootType.SOURCES);
            AndroidSdks.getInstance().findAndSetPlatformSources(target2, sdkModificator);
            WriteAction.run(() -> ((SdkModificator)sdkModificator).commitChanges());
        }
    }

    public static void openModuleDependenciesConfigurable(@NotNull Module module) {
        ProjectSettingsService.getInstance((Project)module.getProject()).openModuleDependenciesSettings(module, null);
    }

    @Deprecated
    @Nullable
    public static File getAdb(@Nullable Project project) {
        return AndroidSdkUtils.findAdb((Project)project).adbPath;
    }

    @NotNull
    public static AdbSearchResult findAdb(@Nullable Project project) {
        String pathProperty;
        File sdkPath;
        Path adb;
        ArrayList<String> searchedPaths = new ArrayList<String>(3);
        String path = System.getProperty(ADB_PATH_PROPERTY);
        searchedPaths.add(String.format("ADB_PATH_PROPERTY (%s): '%s'", ADB_PATH_PROPERTY, Strings.isNullOrEmpty((String)path) ? "<not set>" : path));
        if (path != null && Files.exists(adb = Paths.get(path, new String[0]), new LinkOption[0])) {
            return new AdbSearchResult(adb, searchedPaths);
        }
        if (project != null) {
            Path adb2;
            AndroidSdkData data2 = AndroidSdkUtils.getProjectSdkData(project);
            if (data2 == null) {
                data2 = AndroidSdkUtils.getFirstAndroidModuleSdkData(project);
                searchedPaths.add(String.format("Android SDK location from first Android Module in Project: %s", data2 == null ? "<not present>" : String.format("'%s'", data2.getLocation())));
            } else {
                searchedPaths.add(String.format("Android SDK location from Project: '%s'", data2.getLocation()));
            }
            if (data2 != null && Files.exists(adb2 = data2.getLocation().resolve(AndroidBuildCommonUtils.platformToolPath((String)SdkConstants.FN_ADB)), new LinkOption[0])) {
                return new AdbSearchResult(adb2, searchedPaths);
            }
        }
        if ((sdkPath = IdeSdks.getInstance().getAndroidSdkPath()) != null) {
            Path dir = sdkPath.toPath();
            searchedPaths.add(String.format("Android SDK location from global settings: '%s'", dir));
            Path adb3 = dir.resolve(AndroidBuildCommonUtils.platformToolPath((String)SdkConstants.FN_ADB));
            if (Files.exists(adb3, new LinkOption[0])) {
                return new AdbSearchResult(adb3, searchedPaths);
            }
        }
        if ((pathProperty = EnvironmentUtil.getValue((String)"PATH")) != null) {
            for (String dir : pathProperty.split(System.getProperty("path.separator"))) {
                searchedPaths.add(String.format("From the PATH environment variable: '%s'", dir));
                Path adb4 = Paths.get(dir, SdkConstants.FN_ADB);
                if (!Files.exists(adb4, new LinkOption[0])) continue;
                return new AdbSearchResult(adb4, searchedPaths);
            }
        }
        return new AdbSearchResult(null, searchedPaths);
    }

    @Nullable
    public static AndroidSdkData getFirstAndroidModuleSdkData(Project project) {
        List facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID);
        for (AndroidFacet facet : facets) {
            AndroidPlatform androidPlatform = AndroidPlatforms.getInstance(facet.getModule());
            if (androidPlatform == null) continue;
            return androidPlatform.getSdkData();
        }
        return null;
    }

    @Nullable
    public static AndroidSdkData getProjectSdkData(Project project) {
        Sdk projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        if (projectSdk != null) {
            AndroidPlatform platform = AndroidPlatforms.getInstance(projectSdk);
            return platform != null ? platform.getSdkData() : null;
        }
        return null;
    }

    public static boolean isAndroidSdkAvailable() {
        return AndroidSdks.getInstance().tryToChooseAndroidSdk() != null;
    }

    @NotNull
    public static String getTargetLabel(@NotNull IAndroidTarget target2) {
        if (!target2.isPlatform()) {
            return String.format("%1$s (API %2$s)", target2.getFullName(), target2.getVersion().getApiString());
        }
        AndroidVersion version2 = target2.getVersion();
        return AndroidVersionUtils.getFullApiName((AndroidVersion)version2, (boolean)true, (boolean)true);
    }

    @Nullable
    public static AndroidDebugBridge getDebugBridge(@NotNull Project project) {
        boolean retry;
        ApplicationManager.getApplication().assertIsDispatchThread();
        AndroidSdkData data2 = AndroidSdkUtils.getProjectSdkData(project);
        if (data2 == null) {
            data2 = AndroidSdkUtils.getFirstAndroidModuleSdkData(project);
        }
        if (data2 == null) {
            LOG.warn("Fail to find project SDK data.");
        }
        AndroidDebugBridge bridge = null;
        do {
            AdbSearchResult searchResult = AndroidSdkUtils.findAdb(project);
            if (searchResult.adbPath == null) {
                NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Android Debug Bridge (adb)");
                if (notificationGroup != null) {
                    notificationGroup.createNotification("Unable to locate adb in project/module settings. Locations searched:<br>" + String.join((CharSequence)"<br>", searchResult.searchedPaths), NotificationType.ERROR).setImportant(true).notify(project);
                }
                LOG.warn("Unable to locate adb.");
                return null;
            }
            ListenableFuture<AndroidDebugBridge> future2 = AdbService.getInstance().getDebugBridge(searchResult.adbPath);
            MyMonitorBridgeConnectionTask task2 = new MyMonitorBridgeConnectionTask(project, (Future<AndroidDebugBridge>)future2);
            ProgressManager.getInstance().run((Task)task2);
            if (task2.wasCanceled()) {
                return null;
            }
            retry = false;
            try {
                bridge = (AndroidDebugBridge)future2.get();
            }
            catch (InterruptedException e) {
                break;
            }
            catch (ExecutionException e) {
                String message = "ADB not responding. If you'd like to retry, then please manually kill \"" + SdkConstants.FN_ADB + "\" and click 'Restart'";
                boolean bl = retry = Messages.showYesNoDialog((Project)project, (String)message, (String)CommonBundle.getErrorTitle(), (String)"&Restart", (String)"&Cancel", (Icon)Messages.getErrorIcon()) == 0;
            }
        } while (retry);
        return bridge;
    }

    public static boolean isAndroidSdkManagerEnabled() {
        boolean sdkManagerDisabled = SystemProperties.getBooleanProperty((String)"android.studio.sdk.manager.disabled", (boolean)false);
        return !sdkManagerDisabled;
    }

    @Nullable
    public static File findValidAndroidSdkPath() {
        File candidate = AndroidSdkUtils.getAndroidSdkPathOrDefault();
        return AndroidSdkType.getInstance().isValidSdkHome(candidate.getPath()) ? candidate : null;
    }

    @NotNull
    public static File getAndroidSdkPathOrDefault() {
        String studioHome = PathManager.getHomePath();
        if (StringUtil.isEmpty((String)studioHome)) {
            LOG.info("Unable to find Studio home directory");
        } else {
            LOG.info(String.format("Found Studio home directory at: '%1$s'", studioHome));
            for (String path : ANDROID_SDK_RELATIVE_PATHS) {
                File dir = new File(studioHome, path);
                String absolutePath = FileUtil.toCanonicalPath((String)dir.getAbsolutePath());
                LOG.info(String.format("Looking for Android SDK at '%1$s'", absolutePath));
                if (!AndroidSdkType.getInstance().isValidSdkHome(absolutePath)) continue;
                LOG.info(String.format("Found Android SDK at '%1$s'", absolutePath));
                return new File(absolutePath);
            }
        }
        LOG.info("Unable to locate SDK within the Android studio installation.");
        return AndroidSdkUtils.getAndroidSdkOrDefault(System.getenv(), AndroidSdkType.getInstance());
    }

    @NotNull
    private static File getAndroidSdkOrDefault(Map<String, String> env, AndroidSdkType instance) {
        return AndroidSdkUtils.getAndroidSdkOrDefault(env, instance, IdeInfo.getInstance());
    }

    @VisibleForTesting
    @NotNull
    static File getAndroidSdkOrDefault(Map<String, String> env, AndroidSdkType instance, IdeInfo ideInfo) {
        LinkedHashMap<String, Callable<String>> sdkLocationCandidates = new LinkedHashMap<String, Callable<String>>();
        sdkLocationCandidates.put("ANDROID_HOME environment variable", () -> (String)env.get("ANDROID_HOME"));
        sdkLocationCandidates.put("ANDROID_SDK_ROOT environment variable", () -> (String)env.get("ANDROID_SDK_ROOT"));
        for (Map.Entry locationCandidate : sdkLocationCandidates.entrySet()) {
            try {
                String msg;
                String pathDescription = (String)locationCandidate.getKey();
                String sdkPath = (String)((Callable)locationCandidate.getValue()).call();
                if (!StringUtil.isEmpty((String)sdkPath) && (instance.isValidSdkHome(sdkPath) || ideInfo.isGameTools())) {
                    msg = String.format("%1$s: '%2$s'", pathDescription, sdkPath);
                } else {
                    msg = String.format("Examined and not found a valid Android SDK path: %1$s", pathDescription);
                    sdkPath = null;
                }
                LOG.info(msg);
                if (sdkPath == null) continue;
                return FilePaths.stringToFile((String)sdkPath);
            }
            catch (Exception e) {
                LOG.info("Exception during SDK lookup", (Throwable)e);
            }
        }
        String defaultDir = AndroidSdkUtils.getAndroidSdkDefaultInstallDir();
        LOG.info("Using default SDK path: " + defaultDir);
        return FilePaths.stringToFile((String)defaultDir);
    }

    public static class AdbSearchResult {
        @Nullable
        public final File adbPath;
        @NotNull
        public final List<String> searchedPaths;

        public AdbSearchResult(@Nullable Path adbPath, @NotNull List<String> searchedPaths) {
            this.adbPath = adbPath == null ? null : adbPath.toFile();
            this.searchedPaths = searchedPaths;
        }
    }

    private static class MyMonitorBridgeConnectionTask
    extends Task.Modal {
        private final Future<AndroidDebugBridge> myFuture;
        private boolean myCancelled;

        public MyMonitorBridgeConnectionTask(@Nullable Project project, Future<AndroidDebugBridge> future2) {
            super(project, "Waiting for adb", true);
            this.myFuture = future2;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            indicator.setIndeterminate(true);
            while (!this.myFuture.isDone()) {
                try {
                    this.myFuture.get(200L, TimeUnit.MILLISECONDS);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!indicator.isCanceled()) continue;
                return;
            }
        }

        public void onCancel() {
            this.myCancelled = true;
        }

        public boolean wasCanceled() {
            return this.myCancelled;
        }
    }
}

