/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring.namespaces;

import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.StyleableResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.resources.ResourceType;
import com.android.tools.idea.kotlin.AndroidKtPsiUtilsKt;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.android.tools.res.LocalResourceRepository;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.augment.AndroidLightField;
import org.jetbrains.android.augment.ResourceLightField;
import org.jetbrains.android.augment.StyleableAttrFieldUrl;
import org.jetbrains.android.augment.StyleableAttrLightField;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.namespaces.CodeUsageInfo;
import org.jetbrains.android.refactoring.namespaces.NonGeneratedSearchScope;
import org.jetbrains.android.refactoring.namespaces.ResourceUsageInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a \u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"NON_TRANSITIVE_R_CLASSES_PROPERTY", "", "NON_TRANSITIVE_APP_R_CLASSES_PROPERTY", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "LOG$delegate", "Lkotlin/Lazy;", "findUsagesOfRClassesFromModule", "", "Lorg/jetbrains/android/refactoring/namespaces/CodeUsageInfo;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "extractResourceFieldFromNameElement", "Lorg/jetbrains/android/augment/AndroidLightField;", "resourceNameElement", "Lcom/intellij/psi/PsiElement;", "inferPackageNames", "", "result", "Lorg/jetbrains/android/refactoring/namespaces/ResourceUsageInfo;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nNamespacesRefactoringsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NamespacesRefactoringsUtil.kt\norg/jetbrains/android/refactoring/namespaces/NamespacesRefactoringsUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,283:1\n1563#2:284\n1634#2,3:285\n808#2,11:288\n1374#2:299\n1460#2,5:300\n1761#2,3:305\n1878#2,3:308\n*S KotlinDebug\n*F\n+ 1 NamespacesRefactoringsUtil.kt\norg/jetbrains/android/refactoring/namespaces/NamespacesRefactoringsUtilKt\n*L\n209#1:284\n209#1:285,3\n210#1:288,11\n211#1:299\n211#1:300,5\n212#1:305,3\n254#1:308,3\n*E\n"})
public final class NamespacesRefactoringsUtilKt {
    @NotNull
    public static final String NON_TRANSITIVE_R_CLASSES_PROPERTY = "android.nonTransitiveRClass";
    @NotNull
    public static final String NON_TRANSITIVE_APP_R_CLASSES_PROPERTY = "android.experimental.nonTransitiveAppRClass";
    @NotNull
    private static final Lazy LOG$delegate = LazyKt.lazy(NamespacesRefactoringsUtilKt::LOG_delegate$lambda$0);

    private static final Logger getLOG() {
        Lazy lazy = LOG$delegate;
        return (Logger)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<CodeUsageInfo> findUsagesOfRClassesFromModule(@NotNull AndroidFacet facet) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        List result2 = new ArrayList();
        Module module = facet.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"getModule(...)");
        Module module2 = module;
        LocalResourceRepository<VirtualFile> localResourceRepository = StudioResourceRepositoryManager.getModuleResources(facet);
        Intrinsics.checkNotNullExpressionValue(localResourceRepository, (String)"getModuleResources(...)");
        LocalResourceRepository<VirtualFile> moduleRepo = localResourceRepository;
        Project project = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Collection<? extends PsiClass> collection2 = ProjectSystemUtil.getProjectSystem(project2).getLightResourceClassService().getLightRClassesDefinedByModule(module2);
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"getLightRClassesDefinedByModule(...)");
        Collection<? extends PsiClass> rClasses = collection2;
        for (PsiClass psiClass : rClasses) {
            SearchScope searchScope;
            SearchScope useScopeSearchScope;
            Intrinsics.checkNotNullExpressionValue((Object)psiClass.getUseScope(), (String)"getUseScope(...)");
            if (useScopeSearchScope instanceof GlobalSearchScope) {
                searchScope = (SearchScope)new NonGeneratedSearchScope(project2, (GlobalSearchScope)useScopeSearchScope);
            } else {
                if (NamespacesRefactoringsUtilKt.getLOG().isDebugEnabled()) {
                    NamespacesRefactoringsUtilKt.getLOG().debug("GlobalSearchScope expected, instead got: " + useScopeSearchScope.getClass().getSimpleName() + " for light class type: " + psiClass.getClass().getSimpleName());
                }
                searchScope = useScopeSearchScope;
            }
            SearchScope searchScope2 = searchScope;
            for (PsiReference psiReference : ReferencesSearch.search((PsiElement)((PsiElement)psiClass), (SearchScope)searchScope2)) {
                AndroidLightField resourceField;
                Pair pair;
                Object resolvedResource;
                PsiElement element;
                Intrinsics.checkNotNullExpressionValue((Object)psiReference.getElement(), (String)"getElement(...)");
                Language language = element.getLanguage();
                if (Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE)) {
                    PsiElement psiElement;
                    ResourceType resourceType;
                    ResourceNamespace resourceNamespace;
                    PsiReferenceExpression psiReferenceExpression = element instanceof PsiReferenceExpression ? (PsiReferenceExpression)element : null;
                    if (psiReferenceExpression == null) continue;
                    classRef = psiReferenceExpression;
                    PsiElement psiElement2 = classRef.getParent();
                    PsiReferenceExpression psiReferenceExpression2 = psiElement2 instanceof PsiReferenceExpression ? (PsiReferenceExpression)psiElement2 : null;
                    if (psiReferenceExpression2 == null || (typeRef = psiReferenceExpression2).getReferenceName() == null) continue;
                    var20_20 = typeRef.getParent();
                    PsiReferenceExpression psiReferenceExpression3 = var20_20 instanceof PsiReferenceExpression ? (PsiReferenceExpression)var20_20 : null;
                    if (psiReferenceExpression3 == null || !Intrinsics.areEqual((Object)(nameRef = psiReferenceExpression3).getQualifierExpression(), (Object)typeRef) || !Intrinsics.areEqual((Object)typeRef.getQualifierExpression(), (Object)classRef)) continue;
                    var20_20 = NamespacesRefactoringsUtilKt.extractResourceFieldFromNameElement((PsiElement)nameRef);
                    ResourceLightField resourceLightField = resolvedResource = var20_20 instanceof ResourceLightField ? (ResourceLightField)((Object)var20_20) : null;
                    if (ResourceType.fromClassName((String)typeName) == null) {
                        PsiElement cfr_ignored_0 = (PsiElement)nameRef;
                        continue;
                    }
                    Object object = resolvedResource;
                    if ((object == null || (object = object.getResourceName()) == null) && (object = nameRef.getReferenceName()) == null) continue;
                    Object object2 = object;
                    ResourceReference resourceReference = new ResourceReference(resourceNamespace, resourceType, (String)object2);
                    pair = new Pair((Object)psiElement, (Object)resourceReference);
                } else {
                    PsiElement psiElement;
                    ResourceType resourceType;
                    ResourceNamespace resourceNamespace;
                    if (!Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE)) continue;
                    KtExpression ktExpression = element instanceof KtExpression ? (KtExpression)element : null;
                    if (ktExpression == null || ((nameRef = AndroidKtPsiUtilsKt.getNextInQualifiedChain((KtExpression)(classRef = ktExpression))) instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)nameRef : null) == null) continue;
                    typeRef = typeRef;
                    typeName = typeRef.getReferencedName();
                    var20_20 = AndroidKtPsiUtilsKt.getNextInQualifiedChain((KtExpression)((KtExpression)typeRef));
                    KtNameReferenceExpression ktNameReferenceExpression = var20_20 instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)var20_20 : null;
                    if (ktNameReferenceExpression == null) continue;
                    nameRef = ktNameReferenceExpression;
                    var20_20 = NamespacesRefactoringsUtilKt.extractResourceFieldFromNameElement((PsiElement)nameRef);
                    ResourceLightField resourceLightField = resolvedResource = var20_20 instanceof ResourceLightField ? (ResourceLightField)((Object)var20_20) : null;
                    if (ResourceType.fromClassName((String)typeName) == null) {
                        PsiElement cfr_ignored_1 = (PsiElement)nameRef;
                        continue;
                    }
                    Object object = resolvedResource;
                    if (object == null || (object = object.getResourceName()) == null) {
                        object = nameRef.getReferencedName();
                    }
                    Object object3 = object;
                    ResourceReference resourceReference = new ResourceReference(resourceNamespace, resourceType, (String)object3);
                    pair = new Pair((Object)psiElement, (Object)resourceReference);
                }
                Pair pair2 = pair;
                PsiElement nameRef = (PsiElement)pair2.component1();
                ResourceReference resource = (ResourceReference)pair2.component2();
                if (resource.getResourceType() == ResourceType.STYLEABLE && (resourceField = NamespacesRefactoringsUtilKt.extractResourceFieldFromNameElement(nameRef)) instanceof StyleableAttrLightField) {
                    boolean bl;
                    StyleableAttrFieldUrl styleableAttrFieldUrl;
                    block17: {
                        void $this$any$iv;
                        void $this$flatMapTo$iv$iv;
                        Iterable $this$flatMap$iv;
                        void $this$filterIsInstanceTo$iv$iv;
                        Iterable $this$filterIsInstance$iv;
                        StyleableResourceValue it;
                        void $this$mapTo$iv$iv;
                        Iterable $this$map$iv;
                        styleableAttrFieldUrl = ((StyleableAttrLightField)resourceField).getStyleableAttrFieldUrl();
                        List resources = moduleRepo.getResources(styleableAttrFieldUrl.getStyleable());
                        Intrinsics.checkNotNull((Object)resources);
                        resolvedResource = resources;
                        boolean $i$f$map = false;
                        Iterator iterator2 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            ResourceItem resourceItem = (ResourceItem)item$iv$iv;
                            Collection collection3 = destination$iv$iv;
                            boolean bl2 = false;
                            collection3.add(it.getResourceValue());
                        }
                        $this$map$iv = (List)destination$iv$iv;
                        boolean $i$f$filterIsInstance = false;
                        $this$mapTo$iv$iv = $this$filterIsInstance$iv;
                        destination$iv$iv = new ArrayList();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv instanceof StyleableResourceValue)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filterIsInstance$iv = (List)destination$iv$iv;
                        boolean $i$f$flatMap = false;
                        $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
                        destination$iv$iv = new ArrayList();
                        boolean $i$f$flatMapTo = false;
                        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                            it = (StyleableResourceValue)element$iv$iv;
                            boolean bl3 = false;
                            List list = it.getAllAttributes();
                            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllAttributes(...)");
                            Iterable list$iv$iv = list;
                            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                        }
                        $this$flatMap$iv = (List)destination$iv$iv;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                AttrResourceValue it2 = (AttrResourceValue)element$iv;
                                boolean bl4 = false;
                                if (!Intrinsics.areEqual((Object)it2.getName(), (Object)styleableAttrFieldUrl.getAttr().getName())) continue;
                                bl = true;
                                break block17;
                            }
                            bl = false;
                        }
                    }
                    if (bl) continue;
                    Collection collection4 = result2;
                    Intrinsics.checkNotNull((Object)psiReference);
                    ResourceType resourceType = resource.getResourceType();
                    Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"getResourceType(...)");
                    String string = styleableAttrFieldUrl.getStyleable().getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    collection4.add(new CodeUsageInfo(nameRef, psiReference, resourceType, string));
                    continue;
                }
                if (moduleRepo.hasResources(resource.getNamespace(), resource.getResourceType(), resource.getName())) continue;
                Collection collection5 = result2;
                Intrinsics.checkNotNull((Object)psiReference);
                ResourceType resourceType = resource.getResourceType();
                Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"getResourceType(...)");
                String string = resource.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                collection5.add(new CodeUsageInfo(nameRef, psiReference, resourceType, string));
            }
        }
        return result2;
    }

    private static final AndroidLightField extractResourceFieldFromNameElement(PsiElement resourceNameElement) {
        PsiReference[] psiReferenceArray = resourceNameElement.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
        PsiReference[] references = psiReferenceArray;
        PsiElement psiElement = new PsiMultiReference(references, references[references.length - 1].getElement()).resolve();
        return psiElement instanceof AndroidLightField ? (AndroidLightField)psiElement : null;
    }

    /*
     * WARNING - void declaration
     */
    public static final void inferPackageNames(@NotNull Collection<? extends ResourceUsageInfo> result2, @Nullable ProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        Table table2 = Tables.newCustomTable((Map)Maps.newEnumMap(ResourceType.class), NamespacesRefactoringsUtilKt::inferPackageNames$lambda$4);
        Intrinsics.checkNotNullExpressionValue((Object)table2, (String)"newCustomTable(...)");
        Table inferredNamespaces = table2;
        double total = result2.size();
        Iterable $this$forEachIndexed$iv = result2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void resourceUsageInfo;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ResourceUsageInfo resourceUsageInfo2 = (ResourceUsageInfo)((Object)item$iv);
            int index = n;
            boolean bl = false;
            ProgressManager.checkCanceled();
            PsiElement psiElement = resourceUsageInfo.getElement();
            if (psiElement == null || (psiElement = ModuleExtensionsKt.getAndroidFacet((PsiElement)psiElement)) == null) continue;
            PsiElement facet = psiElement;
            Collection leafRepos = StudioResourceRepositoryManager.getAppResources((AndroidFacet)facet).getLeafResourceRepositories();
            resourceUsageInfo.setInferredPackage(inferredNamespaces.row((Object)resourceUsageInfo.getResourceType()).computeIfAbsent(resourceUsageInfo.getName(), arg_0 -> NamespacesRefactoringsUtilKt.inferPackageNames$lambda$7$lambda$6(arg_0 -> NamespacesRefactoringsUtilKt.inferPackageNames$lambda$7$lambda$5(leafRepos, (ResourceUsageInfo)resourceUsageInfo, arg_0), arg_0)));
            ProgressIndicator progressIndicator2 = progressIndicator;
            if (progressIndicator2 == null) continue;
            progressIndicator2.setFraction((double)(index + 1) / total);
        }
    }

    private static final Logger LOG_delegate$lambda$0() {
        Logger logger = Logger.getInstance((String)"NamespaceRefactoringsUtil.kt");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    private static final Map inferPackageNames$lambda$4() {
        return new LinkedHashMap();
    }

    private static final String inferPackageNames$lambda$7$lambda$5(Collection $leafRepos, ResourceUsageInfo $resourceUsageInfo, String it) {
        for (SingleNamespaceResourceRepository repo : $leafRepos) {
            if (!repo.hasResources(ResourceNamespace.RES_AUTO, $resourceUsageInfo.getResourceType(), $resourceUsageInfo.getName())) continue;
            Intrinsics.checkNotNull((Object)repo, (String)"null cannot be cast to non-null type com.android.ide.common.resources.SingleNamespaceResourceRepository");
            return repo.getPackageName();
        }
        return null;
    }

    private static final String inferPackageNames$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }
}

