/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.gradle.dsl.android.model.android.AndroidModelUtilsKt;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.BuildTypeModel;
import com.android.tools.idea.gradle.dsl.api.android.FlavorTypeModel;
import com.android.tools.idea.gradle.dsl.api.android.ProductFlavorModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.dsl.api.util.GradleDslContextModel;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.project.DefaultModuleSystemKt;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.gradle.LinkedAndroidModuleGroupUtilsKt;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Query;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.MigrateBuildConfigFromGradlePropertiesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0005 !\"#$B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0014J\u001d\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017H\u0014\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017H\u0014\u00a2\u0006\u0002\u0010\u001bJ\u001d\u0010\u001c\u001a\u00020\u001d2\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017H\u0014\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020\u001dH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/android/refactoring/MigrateBuildConfigFromGradlePropertiesRefactoringProcessor;", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "agpVersion", "Lcom/android/ide/common/repository/AgpVersion;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/ide/common/repository/AgpVersion;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "projectBuildModel", "Lcom/android/tools/idea/gradle/dsl/api/ProjectBuildModel;", "targets", "Ljava/util/ArrayList;", "Lcom/intellij/psi/PsiElement;", "Lkotlin/collections/ArrayList;", "gradlePropertiesFile", "Lcom/intellij/lang/properties/psi/impl/PropertiesFileImpl;", "getCommandName", "", "createUsageViewDescriptor", "Lcom/intellij/refactoring/ui/UsageViewDescriptorAdapter;", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "([Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/refactoring/ui/UsageViewDescriptorAdapter;", "findUsages", "()[Lcom/intellij/usageView/UsageInfo;", "performRefactoring", "", "([Lcom/intellij/usageView/UsageInfo;)V", "performPsiSpoilingRefactoring", "MigrateBuildPropertiesUsageInfo", "ExistingGradlePropertiesUsageInfo", "NewGradlePropertiesUsageInfo", "ModuleWithBuildConfigUsageInfo", "ModuleWithoutBuildConfigButWithBuildConfigDslUsageInfo", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nMigrateBuildConfigFromGradleProperties.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrateBuildConfigFromGradleProperties.kt\norg/jetbrains/android/refactoring/MigrateBuildConfigFromGradlePropertiesRefactoringProcessor\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,326:1\n37#2:327\n36#2,3:328\n37#2:331\n36#2,3:332\n37#2:335\n36#2,3:336\n37#2:351\n36#2,3:352\n1#3:339\n13472#4:340\n13473#4:350\n13472#4,2:355\n1761#5,3:341\n1761#5,3:344\n1761#5,3:347\n*S KotlinDebug\n*F\n+ 1 MigrateBuildConfigFromGradleProperties.kt\norg/jetbrains/android/refactoring/MigrateBuildConfigFromGradlePropertiesRefactoringProcessor\n*L\n177#1:327\n177#1:328,3\n178#1:331\n178#1:332,3\n185#1:335\n185#1:336,3\n245#1:351\n245#1:352,3\n197#1:340\n197#1:350\n250#1:355,2\n201#1:341,3\n227#1:344,3\n228#1:347,3\n*E\n"})
public final class MigrateBuildConfigFromGradlePropertiesRefactoringProcessor
extends BaseRefactoringProcessor {
    @NotNull
    private final AgpVersion agpVersion;
    @NotNull
    private final ProjectBuildModel projectBuildModel;
    @NotNull
    private final ArrayList<PsiElement> targets;
    @Nullable
    private PropertiesFileImpl gradlePropertiesFile;

    public MigrateBuildConfigFromGradlePropertiesRefactoringProcessor(@NotNull Project project, @NotNull AgpVersion agpVersion, @Nullable ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)agpVersion, (String)"agpVersion");
        super(project);
        this.agpVersion = agpVersion;
        this.targets = new ArrayList();
        ProjectBuildModel projectBuildModel = ProjectBuildModel.get(project);
        Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel, (String)"get(...)");
        this.projectBuildModel = projectBuildModel;
        this.projectBuildModel.getAllIncludedBuildModels((arg_0, arg_1) -> MigrateBuildConfigFromGradlePropertiesRefactoringProcessor._init_$lambda$2(indicator, arg_0, arg_1));
    }

    @NotNull
    protected String getCommandName() {
        return "Migrate buildConfig setting from gradle.properties to build Dsl";
    }

    @NotNull
    protected UsageViewDescriptorAdapter createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        return new UsageViewDescriptorAdapter(this){
            final /* synthetic */ MigrateBuildConfigFromGradlePropertiesRefactoringProcessor this$0;
            {
                this.this$0 = $receiver;
            }

            public PsiElement[] getElements() {
                Collection $this$toTypedArray$iv = MigrateBuildConfigFromGradlePropertiesRefactoringProcessor.access$getTargets$p(this.this$0);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                return thisCollection$iv.toArray(new PsiElement[0]);
            }

            public String getProcessedElementsHeader() {
                return "Migrate buildConfig setting to build Dsl";
            }
        };
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        int n;
        List usages = new ArrayList();
        VirtualFile virtualFile = this.myProject.getBaseDir();
        if (virtualFile == null) {
            Collection $this$toTypedArray$iv = usages;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new UsageInfo[0]);
        }
        VirtualFile baseDir2 = virtualFile;
        if (!baseDir2.exists()) {
            Collection $this$toTypedArray$iv = usages;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new UsageInfo[0]);
        }
        VirtualFile virtualFile2 = baseDir2.findChild("gradle.properties");
        if (virtualFile2 != null) {
            VirtualFile gradlePropertiesVirtualFile = virtualFile2;
            n = 0;
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(gradlePropertiesVirtualFile);
            this.gradlePropertiesFile = psiFile instanceof PropertiesFileImpl ? (PropertiesFileImpl)psiFile : null;
        }
        Boolean newSetting = this.agpVersion.compareTo(MigrateBuildConfigFromGradlePropertiesKt.access$getCHANGED_DEFAULT_VERSION$p()) > 0 ? null : Boolean.valueOf(false);
        PropertiesFileImpl propertiesFile = this.gradlePropertiesFile;
        if (propertiesFile == null) {
            PsiDirectory psiDirectory = PsiManager.getInstance((Project)this.myProject).findDirectory(baseDir2);
            if (psiDirectory == null) {
                Collection $this$toTypedArray$iv = usages;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                return thisCollection$iv.toArray(new UsageInfo[0]);
            }
            PsiDirectory directory = psiDirectory;
            if (newSetting != null) {
                usages.add(new NewGradlePropertiesUsageInfo(directory, newSetting));
            }
            this.targets.add((PsiElement)directory);
        } else {
            usages.add(new ExistingGradlePropertiesUsageInfo(propertiesFile, newSetting));
            IProperty iProperty = propertiesFile.findPropertyByKey("android.defaults.buildfeatures.buildconfig");
            if (iProperty != null && (iProperty = iProperty.getPsiElement()) != null) {
                IProperty it = iProperty;
                boolean bl = false;
                this.targets.add((PsiElement)it);
            }
        }
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        Module[] $this$forEach$iv = ProjectUtil.getModules((Project)project);
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            PsiFile it;
            Query references;
            ResolvedPropertyModel buildConfigModel;
            GradleBuildModel buildModel;
            boolean bl;
            AndroidFacet facet;
            Module module;
            block23: {
                Object object;
                Module element$iv;
                module = element$iv = $this$forEach$iv[n];
                boolean bl2 = false;
                if (ModuleExtensionsKt.getAndroidFacet((Module)module) == null || !LinkedAndroidModuleGroupUtilsKt.isMainModule(module) || (object = GradleAndroidModel.Companion.get(facet)) == null || (object = object.getMainArtifact()) == null || (object = object.getGeneratedSourceFolders()) == null) continue;
                Object generatedSourceFolders = object;
                Iterable $this$any$iv = (Iterable)generatedSourceFolders;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        File it2 = (File)element$iv2;
                        boolean bl3 = false;
                        if (!StringsKt.contains$default((CharSequence)FileUtilKt.getSystemIndependentPath((File)it2), (CharSequence)"generated/source/buildConfig", (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block23;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            if (this.projectBuildModel.getModuleBuildModel(module) == null) continue;
            boolean bl4 = false;
            Intrinsics.checkNotNullExpressionValue((Object)AndroidModelUtilsKt.android(buildModel).buildFeatures().buildConfig(), (String)"buildConfig(...)");
            Boolean buildConfigEnabled = buildConfigModel.getValue(GradlePropertyModel.BOOLEAN_TYPE);
            if (buildConfigEnabled != null) continue;
            Object object = GradleAndroidModel.Companion.get(facet);
            if (object == null || (object = object.getAndroidProject()) == null || (object = object.getNamespace()) == null) {
                object = DefaultModuleSystemKt.getPackageName(module);
            }
            Object namespace = object;
            String className = (String)namespace + ".BuildConfig";
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.myProject);
            PsiClass buildConfigClass = psiFacade.findClass(className, module.getModuleContentScope());
            if (buildConfigClass == null) {
                MigrateBuildConfigFromGradlePropertiesKt.access$getLOG$p().warn("BuildConfig class not found: \"" + className + "\"");
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ReferencesSearch.search((PsiElement)((PsiElement)buildConfigClass), (SearchScope)((SearchScope)GlobalSearchScope.projectScope((Project)this.myProject))), (String)"search(...)");
            if (references.findAll().isEmpty()) {
                List<FlavorTypeModel.BuildConfigField> list = AndroidModelUtilsKt.android(buildModel).defaultConfig().buildConfigFields();
                Intrinsics.checkNotNullExpressionValue(list, (String)"buildConfigFields(...)");
                if (!(!((Collection)list).isEmpty())) {
                    FlavorTypeModel it3;
                    boolean bl5;
                    boolean $i$f$any;
                    Iterable $this$any$iv;
                    block24: {
                        List<BuildTypeModel> list2 = AndroidModelUtilsKt.android(buildModel).buildTypes();
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"buildTypes(...)");
                        $this$any$iv = list2;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl5 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it3 = (BuildTypeModel)element$iv;
                                boolean bl6 = false;
                                List<FlavorTypeModel.BuildConfigField> list3 = it3.buildConfigFields();
                                Intrinsics.checkNotNullExpressionValue(list3, (String)"buildConfigFields(...)");
                                boolean bl7 = !((Collection)list3).isEmpty();
                                if (!bl7) continue;
                                bl5 = true;
                                break block24;
                            }
                            bl5 = false;
                        }
                    }
                    if (!bl5) {
                        boolean bl8;
                        block25: {
                            List<ProductFlavorModel> list4 = AndroidModelUtilsKt.android(buildModel).productFlavors();
                            Intrinsics.checkNotNullExpressionValue(list4, (String)"productFlavors(...)");
                            $this$any$iv = list4;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl8 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    it3 = (ProductFlavorModel)element$iv;
                                    boolean bl9 = false;
                                    List<FlavorTypeModel.BuildConfigField> list5 = it3.buildConfigFields();
                                    Intrinsics.checkNotNullExpressionValue(list5, (String)"buildConfigFields(...)");
                                    boolean bl10 = !((Collection)list5).isEmpty();
                                    if (!bl10) continue;
                                    bl8 = true;
                                    break block25;
                                }
                                bl8 = false;
                            }
                        }
                        if (!bl8) continue;
                    }
                }
                if (buildModel.getPsiFile() == null) continue;
                boolean bl11 = false;
                usages.add(new ModuleWithoutBuildConfigButWithBuildConfigDslUsageInfo((PsiElement)it, this.projectBuildModel, module));
                continue;
            }
            if (buildModel.getPsiFile() == null) continue;
            boolean bl12 = false;
            usages.add(new ModuleWithBuildConfigUsageInfo((PsiElement)it, this.projectBuildModel, module));
        }
        Collection $this$toTypedArray$iv = usages;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new UsageInfo[0]);
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        CommandProcessor.getInstance().markCurrentCommandAsGlobal(this.myProject);
        UsageInfo[] $this$forEach$iv = usages;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            UsageInfo element$iv;
            UsageInfo it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            MigrateBuildPropertiesUsageInfo migrateBuildPropertiesUsageInfo = it instanceof MigrateBuildPropertiesUsageInfo ? (MigrateBuildPropertiesUsageInfo)it : null;
            if (migrateBuildPropertiesUsageInfo == null) continue;
            migrateBuildPropertiesUsageInfo.doIt();
        }
    }

    protected void performPsiSpoilingRefactoring() {
        this.projectBuildModel.applyChanges();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        PropertiesFileImpl propertiesFileImpl = this.gradlePropertiesFile;
        if (propertiesFileImpl != null) {
            PropertiesFileImpl it = propertiesFileImpl;
            boolean bl = false;
            Document document = documentManager.getDocument((PsiFile)it);
            if (document != null) {
                Document document2 = document;
                if (documentManager.isDocumentBlockedByPsi(document2)) {
                    documentManager.doPostponedOperationsAndUnblockDocument(document2);
                }
                FileDocumentManager.getInstance().saveDocument(document2);
                if (!documentManager.isCommitted(document2)) {
                    documentManager.commitDocument(document2);
                }
            }
        }
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        ProjectSystemUtil.getSyncManager(project).requestSyncProject(ProjectSystemSyncUtil.toReason(GradleSyncStats.Trigger.TRIGGER_REFACTOR_MIGRATE_BUILD_CONFIG_FROM_GRADLE_PROPERTIES));
        UndoManager.getInstance((Project)this.myProject).undoableActionPerformed((UndoableAction)new BasicUndoableAction(this){
            final /* synthetic */ MigrateBuildConfigFromGradlePropertiesRefactoringProcessor this$0;
            {
                this.this$0 = $receiver;
            }

            public void undo() {
                Project project = MigrateBuildConfigFromGradlePropertiesRefactoringProcessor.access$getMyProject$p$s-584213573(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"access$getMyProject$p$s-584213573(...)");
                ProjectSystemUtil.getSyncManager(project).requestSyncProject(ProjectSystemSyncUtil.toReason(GradleSyncStats.Trigger.TRIGGER_MODIFIER_ACTION_UNDONE));
            }

            public void redo() {
                Project project = MigrateBuildConfigFromGradlePropertiesRefactoringProcessor.access$getMyProject$p$s-584213573(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"access$getMyProject$p$s-584213573(...)");
                ProjectSystemUtil.getSyncManager(project).requestSyncProject(ProjectSystemSyncUtil.toReason(GradleSyncStats.Trigger.TRIGGER_MODIFIER_ACTION_REDONE));
            }
        });
    }

    private static final void _init_$lambda$2(ProgressIndicator $indicator, Integer seen, Integer total) {
        block1: {
            ProgressIndicator progressIndicator = $indicator;
            if (progressIndicator == null) break block1;
            ProgressIndicator it = progressIndicator;
            boolean bl = false;
            $indicator.checkCanceled();
            Integer n = total;
            $indicator.setText("Parsing file " + seen + (String)(n != null ? " of " + n : ""));
            $indicator.setIndeterminate(total == null);
            Integer n2 = total;
            if (n2 != null) {
                int it2 = ((Number)n2).intValue();
                boolean bl2 = false;
                $indicator.setFraction((double)seen.intValue() / (double)total.intValue());
            }
        }
    }

    public static final /* synthetic */ ArrayList access$getTargets$p(MigrateBuildConfigFromGradlePropertiesRefactoringProcessor $this) {
        return $this.targets;
    }

    public static final /* synthetic */ Project access$getMyProject$p$s-584213573(MigrateBuildConfigFromGradlePropertiesRefactoringProcessor $this) {
        return $this.myProject;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/android/refactoring/MigrateBuildConfigFromGradlePropertiesRefactoringProcessor$ExistingGradlePropertiesUsageInfo;", "Lorg/jetbrains/android/refactoring/MigrateBuildConfigFromGradlePropertiesRefactoringProcessor$MigrateBuildPropertiesUsageInfo;", "element", "Lcom/intellij/lang/properties/psi/impl/PropertiesFileImpl;", "newSetting", "", "<init>", "(Lcom/intellij/lang/properties/psi/impl/PropertiesFileImpl;Ljava/lang/Boolean;)V", "getElement", "()Lcom/intellij/lang/properties/psi/impl/PropertiesFileImpl;", "getNewSetting", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "doIt", "", "intellij.android.projectSystem.gradle"})
    public static final class ExistingGradlePropertiesUsageInfo
    extends MigrateBuildPropertiesUsageInfo {
        @NotNull
        private final PropertiesFileImpl element;
        @Nullable
        private final Boolean newSetting;

        public ExistingGradlePropertiesUsageInfo(@NotNull PropertiesFileImpl element, @Nullable Boolean newSetting) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            super((PsiElement)element);
            this.element = element;
            this.newSetting = newSetting;
        }

        @NotNull
        public final PropertiesFileImpl getElement() {
            return this.element;
        }

        @Nullable
        public final Boolean getNewSetting() {
            return this.newSetting;
        }

        @Override
        public void doIt() {
            block1: {
                block0: {
                    if (this.newSetting != null) break block0;
                    IProperty iProperty = this.element.findPropertyByKey("android.defaults.buildfeatures.buildconfig");
                    if (iProperty == null || (iProperty = iProperty.getPsiElement()) == null) break block1;
                    iProperty.delete();
                    break block1;
                }
                IProperty iProperty = this.element.findPropertyByKey("android.defaults.buildfeatures.buildconfig");
                if (iProperty == null) break block1;
                iProperty.setValue(String.valueOf(this.newSetting));
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lorg/jetbrains/android/refactoring/MigrateBuildConfigFromGradlePropertiesRefactoringProcessor$MigrateBuildPropertiesUsageInfo;", "Lcom/intellij/usageView/UsageInfo;", "element", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "doIt", "", "intellij.android.projectSystem.gradle"})
    public static abstract class MigrateBuildPropertiesUsageInfo
    extends UsageInfo {
        public MigrateBuildPropertiesUsageInfo(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            super(element);
        }

        public abstract void doIt();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/android/refactoring/MigrateBuildConfigFromGradlePropertiesRefactoringProcessor$ModuleWithBuildConfigUsageInfo;", "Lorg/jetbrains/android/refactoring/MigrateBuildConfigFromGradlePropertiesRefactoringProcessor$MigrateBuildPropertiesUsageInfo;", "element", "Lcom/intellij/psi/PsiElement;", "buildModel", "Lcom/android/tools/idea/gradle/dsl/api/ProjectBuildModel;", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/android/tools/idea/gradle/dsl/api/ProjectBuildModel;Lcom/intellij/openapi/module/Module;)V", "getBuildModel", "()Lcom/android/tools/idea/gradle/dsl/api/ProjectBuildModel;", "getModule", "()Lcom/intellij/openapi/module/Module;", "doIt", "", "intellij.android.projectSystem.gradle"})
    public static final class ModuleWithBuildConfigUsageInfo
    extends MigrateBuildPropertiesUsageInfo {
        @NotNull
        private final ProjectBuildModel buildModel;
        @NotNull
        private final Module module;

        public ModuleWithBuildConfigUsageInfo(@NotNull PsiElement element, @NotNull ProjectBuildModel buildModel, @NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)buildModel, (String)"buildModel");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            super(element);
            this.buildModel = buildModel;
            this.module = module;
        }

        @NotNull
        public final ProjectBuildModel getBuildModel() {
            return this.buildModel;
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @Override
        public void doIt() {
            block0: {
                GradleDslContextModel gradleDslContextModel = this.buildModel.getModuleBuildModel(this.module);
                if (gradleDslContextModel == null || (gradleDslContextModel = AndroidModelUtilsKt.android((GradleBuildModel)gradleDslContextModel)) == null || (gradleDslContextModel = gradleDslContextModel.buildFeatures()) == null || (gradleDslContextModel = gradleDslContextModel.buildConfig()) == null) break block0;
                gradleDslContextModel.setValue(true);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/android/refactoring/MigrateBuildConfigFromGradlePropertiesRefactoringProcessor$ModuleWithoutBuildConfigButWithBuildConfigDslUsageInfo;", "Lorg/jetbrains/android/refactoring/MigrateBuildConfigFromGradlePropertiesRefactoringProcessor$MigrateBuildPropertiesUsageInfo;", "element", "Lcom/intellij/psi/PsiElement;", "buildModel", "Lcom/android/tools/idea/gradle/dsl/api/ProjectBuildModel;", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/android/tools/idea/gradle/dsl/api/ProjectBuildModel;Lcom/intellij/openapi/module/Module;)V", "getBuildModel", "()Lcom/android/tools/idea/gradle/dsl/api/ProjectBuildModel;", "getModule", "()Lcom/intellij/openapi/module/Module;", "doIt", "", "intellij.android.projectSystem.gradle"})
    @SourceDebugExtension(value={"SMAP\nMigrateBuildConfigFromGradleProperties.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrateBuildConfigFromGradleProperties.kt\norg/jetbrains/android/refactoring/MigrateBuildConfigFromGradlePropertiesRefactoringProcessor$ModuleWithoutBuildConfigButWithBuildConfigDslUsageInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,326:1\n1869#2,2:327\n1869#2,2:329\n*S KotlinDebug\n*F\n+ 1 MigrateBuildConfigFromGradleProperties.kt\norg/jetbrains/android/refactoring/MigrateBuildConfigFromGradlePropertiesRefactoringProcessor$ModuleWithoutBuildConfigButWithBuildConfigDslUsageInfo\n*L\n320#1:327,2\n321#1:329,2\n*E\n"})
    public static final class ModuleWithoutBuildConfigButWithBuildConfigDslUsageInfo
    extends MigrateBuildPropertiesUsageInfo {
        @NotNull
        private final ProjectBuildModel buildModel;
        @NotNull
        private final Module module;

        public ModuleWithoutBuildConfigButWithBuildConfigDslUsageInfo(@NotNull PsiElement element, @NotNull ProjectBuildModel buildModel, @NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)buildModel, (String)"buildModel");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            super(element);
            this.buildModel = buildModel;
            this.module = module;
        }

        @NotNull
        public final ProjectBuildModel getBuildModel() {
            return this.buildModel;
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @Override
        public void doIt() {
            block2: {
                FlavorTypeModel it;
                GradleDslContextModel gradleDslContextModel = this.buildModel.getModuleBuildModel(this.module);
                if (gradleDslContextModel == null || (gradleDslContextModel = AndroidModelUtilsKt.android((GradleBuildModel)gradleDslContextModel)) == null) break block2;
                GradleDslContextModel $this$doIt_u24lambda_u242 = gradleDslContextModel;
                boolean bl = false;
                List<ProductFlavorModel> list = $this$doIt_u24lambda_u242.productFlavors();
                Intrinsics.checkNotNullExpressionValue(list, (String)"productFlavors(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (ProductFlavorModel)element$iv;
                    boolean bl2 = false;
                    it.removeAllBuildConfigFields();
                }
                List<BuildTypeModel> list2 = $this$doIt_u24lambda_u242.buildTypes();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"buildTypes(...)");
                $this$forEach$iv = list2;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (BuildTypeModel)element$iv;
                    boolean bl3 = false;
                    it.removeAllBuildConfigFields();
                }
                $this$doIt_u24lambda_u242.defaultConfig().removeAllBuildConfigFields();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/android/refactoring/MigrateBuildConfigFromGradlePropertiesRefactoringProcessor$NewGradlePropertiesUsageInfo;", "Lorg/jetbrains/android/refactoring/MigrateBuildConfigFromGradlePropertiesRefactoringProcessor$MigrateBuildPropertiesUsageInfo;", "element", "Lcom/intellij/psi/PsiDirectory;", "newSetting", "", "<init>", "(Lcom/intellij/psi/PsiDirectory;Z)V", "getElement", "()Lcom/intellij/psi/PsiDirectory;", "getNewSetting", "()Z", "doIt", "", "intellij.android.projectSystem.gradle"})
    public static final class NewGradlePropertiesUsageInfo
    extends MigrateBuildPropertiesUsageInfo {
        @NotNull
        private final PsiDirectory element;
        private final boolean newSetting;

        public NewGradlePropertiesUsageInfo(@NotNull PsiDirectory element, boolean newSetting) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            super((PsiElement)element);
            this.element = element;
            this.newSetting = newSetting;
        }

        @NotNull
        public final PsiDirectory getElement() {
            return this.element;
        }

        public final boolean getNewSetting() {
            return this.newSetting;
        }

        @Override
        public void doIt() {
            block0: {
                PropertiesFileImpl propertiesFile;
                PsiFile psiFile = this.element.createFile("gradle.properties");
                PropertiesFileImpl propertiesFileImpl = propertiesFile = psiFile instanceof PropertiesFileImpl ? (PropertiesFileImpl)psiFile : null;
                if (propertiesFileImpl == null) break block0;
                propertiesFileImpl.addProperty("android.defaults.buildfeatures.buildconfig", String.valueOf(this.newSetting));
            }
        }
    }
}

