/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.resources.ResourceFolderType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomManager;
import org.jetbrains.android.dom.AndroidResourceDomFileDescription;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.dom.resources.ResourcesDomFileDescription;
import org.jetbrains.android.dom.resources.Style;
import org.jetbrains.android.refactoring.AndroidBaseXmlRefactoringAction;
import org.jetbrains.android.refactoring.AndroidInlineTestConfig;
import org.jetbrains.android.refactoring.AndroidInlineUtil;
import org.jetbrains.android.refactoring.StyleUsageData;
import org.jetbrains.android.refactoring.errorreporter.ProjectBasedErrorReporter;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class AndroidInlineStyleReferenceAction
extends AndroidBaseXmlRefactoringAction {
    public static final String ACTION_ID = "AndroidInlineStyleReferenceAction";
    private final AndroidInlineTestConfig myTestConfig;

    @TestOnly
    AndroidInlineStyleReferenceAction(AndroidInlineTestConfig testConfig) {
        this.myTestConfig = testConfig;
    }

    public AndroidInlineStyleReferenceAction() {
        this.myTestConfig = null;
    }

    @Override
    protected void doRefactorForTags(@NotNull Project project, @NotNull XmlTag[] tags) {
        DomElement domElement;
        assert (tags.length == 1);
        XmlTag tag = tags[0];
        PsiFile file = tag.getContainingFile();
        if (file == null) {
            return;
        }
        StyleUsageData usageData = AndroidInlineUtil.getStyleUsageData(tag);
        if (usageData == null) {
            return;
        }
        AndroidResourceReferenceBase reference = usageData.getReference();
        String title2 = AndroidBundle.message("android.inline.style.title", new Object[0]);
        PsiElement[] styleElements = reference.computeTargetElements();
        if (styleElements.length == 0) {
            AndroidUtils.reportError(project, "Cannot find style by reference '" + reference.getValue() + "'", title2);
            return;
        }
        if (styleElements.length > 1) {
            AndroidUtils.reportError(project, RefactoringBundle.getCannotRefactorMessage((String)"Ambiguous style reference."), title2);
            return;
        }
        PsiElement styleElement = styleElements[0];
        XmlTag styleTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)styleElement, XmlTag.class);
        DomElement domElement2 = domElement = styleTag != null ? DomManager.getDomManager((Project)project).getDomElement(styleTag) : null;
        if (!(domElement instanceof Style)) {
            AndroidUtils.reportError(project, "Cannot find style by reference '" + reference.getValue() + "'", title2);
            return;
        }
        Style style = (Style)domElement;
        String styleName = style.getName().getStringValue();
        if (styleName == null) {
            AndroidUtils.reportError(project, RefactoringBundle.getCannotRefactorMessage((String)"Style name is not specified."), title2);
            return;
        }
        AndroidInlineUtil.doInlineStyleDeclaration(project, new AndroidInlineUtil.MyStyleData(styleName, style, styleElement), usageData, new ProjectBasedErrorReporter(project), this.myTestConfig);
    }

    @Override
    protected boolean isEnabledForTags(@NotNull XmlTag[] tags) {
        return tags.length == 1 && AndroidInlineUtil.getStyleUsageData(tags[0]) != null;
    }

    @Override
    protected boolean isMyFile(PsiFile file) {
        DomFileDescription description2 = DomManager.getDomManager((Project)file.getProject()).getDomFileDescription((XmlFile)file);
        return AndroidResourceDomFileDescription.isFileInResourceFolderType((XmlFile)file, ResourceFolderType.LAYOUT) || description2 instanceof ResourcesDomFileDescription;
    }
}

