/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.ReferredResourceFieldInfo;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.CreateFileResourceQuickFix;
import org.jetbrains.android.inspections.CreateValueResourceQuickFix;
import org.jetbrains.annotations.NotNull;

public class AndroidResourceQuickFixProvider
extends UnresolvedReferenceQuickFixProvider<PsiReferenceExpression> {
    public void registerFixes(@NotNull PsiReferenceExpression exp, @NotNull QuickFixActionRegistrar registrar) {
        ResourceFolderType folderType;
        ResourceType resourceType;
        AndroidFacet resolvedFacet;
        PsiElement parent;
        Module contextModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)exp);
        if (contextModule == null) {
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance((Module)contextModule);
        if (facet == null) {
            return;
        }
        PsiFile contextFile = exp.getContainingFile();
        if (contextFile == null) {
            return;
        }
        ReferredResourceFieldInfo info = IdeResourcesUtil.getReferredResourceOrManifestField(facet, exp, true);
        if (info == null && (parent = exp.getParent()) instanceof PsiReferenceExpression) {
            info = IdeResourcesUtil.getReferredResourceOrManifestField(facet, (PsiReferenceExpression)parent, true);
        }
        if (info == null || info.isFromManifest()) {
            return;
        }
        String resClassName = info.getClassName();
        String resFieldName = info.getFieldName();
        Module resolvedModule = info.getResolvedModule();
        if (resolvedModule != null && resolvedModule != contextModule && (resolvedFacet = AndroidFacet.getInstance((Module)resolvedModule)) != null) {
            facet = resolvedFacet;
        }
        if (IdeResourcesUtil.ALL_VALUE_RESOURCE_TYPES.contains(resourceType = ResourceType.fromClassName((String)resClassName))) {
            registrar.register((IntentionAction)new CreateValueResourceQuickFix(facet, resourceType, resFieldName, contextFile));
        }
        if ((folderType = FolderTypeRelationship.getNonValuesRelatedFolder((ResourceType)resourceType)) != null) {
            registrar.register((IntentionAction)new CreateFileResourceQuickFix(facet, folderType, resFieldName, contextFile, true));
        }
    }

    @NotNull
    public Class<PsiReferenceExpression> getReferenceClass() {
        return PsiReferenceExpression.class;
    }
}

