/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.formatter;

import com.android.xml.AttrNameSplitter;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.NameAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.std.CustomArrangementOrderToken;
import java.util.Comparator;
import org.jetbrains.android.formatter.AttributeComparator;
import org.jetbrains.annotations.NotNull;

final class AndroidAttributeOrder
extends CustomArrangementOrderToken {
    static final String ID = "ANDROID_ATTRIBUTE_ORDER";
    static final AndroidAttributeOrder INSTANCE = new AndroidAttributeOrder();

    private AndroidAttributeOrder() {
        super(ID, "Android attribute order");
    }

    @NotNull
    public Comparator<ArrangementEntry> getEntryComparator() {
        return new AttributeComparator<ArrangementEntry>(AndroidAttributeOrder::getLocalPart);
    }

    @NotNull
    private static String getLocalPart(@NotNull ArrangementEntry attribute2) {
        if (!(attribute2 instanceof NameAwareArrangementEntry)) {
            throw new IllegalArgumentException(attribute2.getClass().toString());
        }
        String qualifiedName = ((NameAwareArrangementEntry)attribute2).getName();
        assert (qualifiedName != null);
        return AttrNameSplitter.findLocalName((String)qualifiedName);
    }
}

