/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.tools.idea.projectsystem.AndroidProjectRootUtil;
import com.android.tools.idea.projectsystem.SourceProviderManager;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.sdk.AndroidPlatform;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.OrderedSet;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.sdk.AndroidPlatforms;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public class AndroidRootUtil {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.facet.AndroidRootUtil");

    private AndroidRootUtil() {
    }

    @Nullable
    public static VirtualFile getPrimaryManifestFile(@NotNull AndroidFacet facet) {
        if (facet.isDisposed()) {
            return null;
        }
        return SourceProviderManager.getInstance(facet).getMainManifestFile();
    }

    @Deprecated
    @Nullable
    public static VirtualFile getResourceDir(@NotNull AndroidFacet facet) {
        return ResourceFolderManager.getInstance(facet).getPrimaryFolder();
    }

    @Nullable
    public static VirtualFile getFileByRelativeModulePath(Module module, String relativePath, boolean lookInContentRoot) {
        return AndroidProjectRootUtil.getFileByRelativeModulePath(module, relativePath, lookInContentRoot);
    }

    @Deprecated
    @Nullable
    public static VirtualFile getAssetsDir(@NotNull AndroidFacet facet) {
        return AndroidProjectRootUtil.getAssetsDir(facet);
    }

    @Deprecated
    @Nullable
    public static VirtualFile getLibsDir(@NotNull AndroidFacet facet) {
        return AndroidRootUtil.getFileByRelativeModulePath(facet.getModule(), facet.getProperties().LIBS_FOLDER_RELATIVE_PATH, false);
    }

    private static void collectClassFilesAndJars(@NotNull VirtualFile root, @NotNull Set<VirtualFile> result2, @NotNull Set<VirtualFile> visited) {
        if (!visited.add(root)) {
            return;
        }
        for (VirtualFile child : root.getChildren()) {
            if (!child.exists()) continue;
            if (child.isDirectory()) {
                AndroidRootUtil.collectClassFilesAndJars(child, result2, visited);
                continue;
            }
            if (!"jar".equals(child.getExtension()) && !"class".equals(child.getExtension())) continue;
            if (child.getFileSystem() instanceof JarFileSystem) {
                VirtualFile localFile = JarFileSystem.getInstance().getVirtualFileForJar(child);
                if (localFile == null) continue;
                result2.add(localFile);
                continue;
            }
            result2.add(child);
        }
    }

    private static void fillExternalLibrariesAndModules(@NotNull Module module, @NotNull Set<VirtualFile> outputDirs, @NotNull Set<Module> visited, @Nullable Set<VirtualFile> libraries, boolean exportedLibrariesOnly, boolean recursive) {
        if (!visited.add(module)) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            ModuleRootManager manager = ModuleRootManager.getInstance((Module)module);
            for (OrderEntry entry : manager.getOrderEntries()) {
                Module depModule;
                if (!(entry instanceof ExportableOrderEntry) || ((ExportableOrderEntry)entry).getScope() != DependencyScope.COMPILE) continue;
                if (libraries != null && entry instanceof LibraryOrderEntry) {
                    LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)entry;
                    Library library = libraryOrderEntry.getLibrary();
                    if (library == null || exportedLibrariesOnly && !libraryOrderEntry.isExported()) continue;
                    for (VirtualFile file : library.getFiles(OrderRootType.CLASSES)) {
                        if (!file.exists()) continue;
                        if (file.getFileType() instanceof ArchiveFileType) {
                            if (file.getFileSystem() instanceof JarFileSystem) {
                                VirtualFile localFile = JarFileSystem.getInstance().getVirtualFileForJar(file);
                                if (localFile == null) continue;
                                libraries.add(localFile);
                                continue;
                            }
                            libraries.add(file);
                            continue;
                        }
                        if (!file.isDirectory() || file.getFileSystem() instanceof JarFileSystem) continue;
                        AndroidRootUtil.collectClassFilesAndJars(file, libraries, new HashSet<VirtualFile>());
                    }
                    continue;
                }
                if (!(entry instanceof ModuleOrderEntry) || (depModule = ((ModuleOrderEntry)entry).getModule()) == null) continue;
                AndroidFacet facet = AndroidFacet.getInstance((Module)depModule);
                boolean libraryProject = facet != null && ((AndroidFacetConfiguration)facet.getConfiguration()).isLibraryProject();
                CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)depModule);
                if (extension != null) {
                    VirtualFile classDir = extension.getCompilerOutputPath();
                    if (libraryProject) {
                        VirtualFile packedClassesJar;
                        VirtualFile tmpArtifactsDir = CompilerModuleExtension.getInstance((Module)depModule).getCompilerOutputPath();
                        if (tmpArtifactsDir != null && (packedClassesJar = tmpArtifactsDir.findChild("classes.jar")) != null) {
                            outputDirs.add(packedClassesJar);
                        }
                    } else if (facet == null && !outputDirs.contains(classDir) && classDir != null && classDir.exists()) {
                        outputDirs.add(classDir);
                    }
                }
                if (!recursive) continue;
                AndroidRootUtil.fillExternalLibrariesAndModules(depModule, outputDirs, visited, libraries, !libraryProject || exportedLibrariesOnly, true);
            }
        });
    }

    @NotNull
    public static List<VirtualFile> getExternalLibraries(Module module) {
        HashSet<VirtualFile> files2 = new HashSet<VirtualFile>();
        OrderedSet libs = new OrderedSet();
        AndroidRootUtil.fillExternalLibrariesAndModules(module, files2, new HashSet<Module>(), (Set<VirtualFile>)libs, false, true);
        AndroidRootUtil.addAnnotationsJar(module, (OrderedSet<VirtualFile>)libs);
        return libs;
    }

    private static void addAnnotationsJar(@NotNull Module module, @NotNull OrderedSet<VirtualFile> libs) {
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk == null || !AndroidSdks.getInstance().isAndroidSdk(sdk)) {
            return;
        }
        String sdkHomePath = sdk.getHomePath();
        if (sdkHomePath == null) {
            return;
        }
        AndroidPlatform platform = AndroidPlatforms.getInstance(module);
        if (platform != null && platform.needToAddAnnotationsJarToClasspath()) {
            String annotationsJarPath = FileUtil.toSystemIndependentName((String)sdkHomePath) + "/tools/support/annotations.jar";
            VirtualFile annotationsJar = LocalFileSystem.getInstance().findFileByPath(annotationsJarPath);
            if (annotationsJar != null) {
                libs.add((Object)annotationsJar);
            }
        }
    }

    @NotNull
    public static VirtualFile[] getResourceOverlayDirs(@NotNull AndroidFacet facet) {
        List overlayFolders = facet.getProperties().RES_OVERLAY_FOLDERS;
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (String overlayFolder : overlayFolders) {
            VirtualFile overlayDir = AndroidRootUtil.getFileByRelativeModulePath(facet.getModule(), overlayFolder, true);
            if (overlayDir == null) continue;
            result2.add(overlayDir);
        }
        return VfsUtilCore.toVirtualFileArray(result2);
    }

    @Nullable
    public static @SystemIndependent String getModuleDirPath(@NotNull Module module) {
        return AndroidProjectRootUtil.getModuleDirPath(module);
    }

    @Nullable
    public static File findModuleRootFolderPath(@NotNull Module module) {
        @SystemIndependent String path = AndroidRootUtil.getModuleDirPath(module);
        if (path == null) {
            return null;
        }
        return new File(PathUtil.toSystemDependentName((String)path));
    }

    @Nullable
    public static VirtualFile getMainContentRoot(@NotNull AndroidFacet facet) {
        Module module = facet.getModule();
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (contentRoots.length == 0) {
            return null;
        }
        if (contentRoots.length == 1) {
            return contentRoots[0];
        }
        VirtualFile manifestFile = AndroidRootUtil.getPrimaryManifestFile(facet);
        if (manifestFile != null) {
            for (VirtualFile root : contentRoots) {
                if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)manifestFile, (boolean)true)) continue;
                return root;
            }
        }
        return contentRoots[0];
    }

    @Deprecated
    @Nullable
    public static @SystemIndependent String getAptGenSourceRootPath(@NotNull AndroidFacet facet) {
        return AndroidProjectRootUtil.getAptGenSourceRootPath(facet);
    }

    @Deprecated
    @Nullable
    public static @SystemIndependent String getAidlGenSourceRootPath(@NotNull AndroidFacet facet) {
        return AndroidProjectRootUtil.getAidlGenSourceRootPath(facet);
    }

    @Nullable
    public static @SystemIndependent String getPathRelativeToModuleDir(@NotNull Module module, @NotNull String path) {
        @SystemIndependent String moduleDirPath = AndroidRootUtil.getModuleDirPath(module);
        if (moduleDirPath == null) {
            return null;
        }
        if (moduleDirPath.equals(path)) {
            return "";
        }
        return FileUtil.getRelativePath((String)moduleDirPath, (String)path, (char)'/');
    }
}

